# 画面設計書 25-フィールド機能

## 概要

本ドキュメントは、OpenSearchのField Capabilities API（`_field_caps`）エンドポイントに関する画面設計書である。Field Capabilities APIは、複数インデックス間でフィールドの型や機能（searchable、aggregatable等）の情報を横断的に取得する。

### 本画面の処理概要

Field Capabilities APIは、1つまたは複数のインデックスにまたがるフィールドの機能情報（データ型、検索可否、集計可否など）を返却するAPIである。

**業務上の目的・背景**：複数のインデックスにまたがるクエリを構築する際、各インデックスでフィールドがどのような型で定義されているかを事前に確認するために使用される。特に、同じフィールド名が異なるインデックスで異なる型にマッピングされている場合の検出や、動的マッピングにより予期しない型が割り当てられていないかの確認に有用である。Kibana/OpenSearch DashboardsのUI構築時にフィールド一覧を取得するためにも使用される。

**画面へのアクセス方法**：HTTPクライアントから `GET/POST /_field_caps` または `GET/POST /{index}/_field_caps` エンドポイントにリクエストを送信する。`fields`パラメータでフィールド名を指定する。

**主要な操作・処理内容**：
1. 対象インデックスとフィールド名を特定する
2. 各インデックスのマッピング情報からフィールドの型と機能を取得する
3. インデックス横断でフィールド情報を集約して返却する
4. index_filterが指定されている場合は、条件に一致するインデックスのみを対象にする

**画面遷移**：マッピング取得API（No.50）と補完的な関係にある。フィールドの機能情報はSearch API（No.21）のクエリ構築の事前確認に使用される。

**権限による表示制御**：対象インデックスへの読み取り権限が必要である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 26 | フィールドキャパビリティ | 主機能 | 複数インデックス間のフィールド機能情報を返す処理 |

## 画面種別

API（フィールド情報参照）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET/POST | `/_field_caps` | 全インデックスのフィールド機能を返す |
| GET/POST | `/{index}/_field_caps` | 指定インデックスのフィールド機能を返す |

## 入出力項目

### URLパスパラメータ

| パラメータ | 型 | 必須 | 説明 |
|-----------|------|------|------|
| index | list | No | 対象インデックス名（カンマ区切り）。`_all`または省略で全インデックス |

### クエリパラメータ

| パラメータ | 型 | デフォルト | 説明 |
|-----------|------|-----------|------|
| fields | list | - | フィールド名（カンマ区切り） |
| ignore_unavailable | boolean | false | 利用不可のインデックスを無視するか |
| allow_no_indices | boolean | - | ワイルドカード式が解決されない場合に無視するか |
| expand_wildcards | enum | open | ワイルドカード展開対象（open/closed/hidden/none/all） |
| include_unmapped | boolean | false | マッピングされていないフィールドも含めるか |

### リクエストボディ（任意）

| フィールド | 型 | 説明 |
|-----------|------|------|
| index_filter | object | 対象インデックスをフィルタリングするQuery DSL |

## 表示項目

### レスポンスボディ

| フィールド | 型 | 説明 |
|-----------|------|------|
| indices | array | 対象インデックスの一覧 |
| fields | object | フィールドごとの機能情報 |
| fields.{field_name} | object | 各フィールドの型別情報 |
| fields.{field_name}.{type} | object | 型ごとの機能詳細 |
| fields.{field_name}.{type}.type | string | フィールドの型名 |
| fields.{field_name}.{type}.searchable | boolean | 検索可能か |
| fields.{field_name}.{type}.aggregatable | boolean | 集計可能か |
| fields.{field_name}.{type}.indices | array | この型を持つインデックスの一覧 |
| fields.{field_name}.{type}.non_searchable_indices | array | 検索不可のインデックス一覧 |
| fields.{field_name}.{type}.non_aggregatable_indices | array | 集計不可のインデックス一覧 |

## イベント仕様

### 1-フィールド機能取得リクエスト実行

1. `RestFieldCapabilitiesAction.prepareRequest()`がリクエストを受信（行75）
2. `FieldCapabilitiesRequest`を構築（fields、indices指定、行77-79）
3. `indicesOptions`、`includeUnmapped`を設定（行81-82）
4. リクエストボディからindex_filterを解析（行83-87）
5. `client.fieldCaps()`でFieldCapabilitiesアクションを実行（行88）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| フィールド機能取得 | クラスタメタデータ | SELECT | インデックスマッピングからフィールドの型と機能情報を取得 |

### テーブル別更新項目詳細

#### クラスタメタデータ（読み取り専用）

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| SELECT | マッピング情報 | 指定インデックス・フィールドの型と機能 | 書き込み操作は発生しない |

## メッセージ仕様

| 種別 | メッセージ | 発生条件 |
|------|----------|----------|
| 成功 | HTTPステータス200 + フィールド機能JSON | 正常にフィールド機能情報が取得できた場合 |

## 例外処理

| 例外 | HTTPステータス | 説明 |
|------|--------------|------|
| IndexNotFoundException | 404 | 指定されたインデックスが存在しない場合 |
| IllegalArgumentException | 400 | 不正なパラメータが指定された場合 |

## 備考

- `include_unmapped`をtrueに設定すると、指定されたフィールドがマッピングに存在しないインデックスについても`unmapped`型として結果に含まれる
- `index_filter`を使用すると、条件に一致するインデックスのみを対象にでき、大量のインデックスがある環境でパフォーマンスを改善できる（RestFieldCapabilitiesAction 行83-87）
- 同名フィールドが異なるインデックスで異なる型を持つ場合、型ごとに分けて情報が返却される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | FieldCapabilitiesRequest.java | `server/src/main/java/org/opensearch/action/fieldcaps/FieldCapabilitiesRequest.java` | フィールド機能リクエストの構造 |
| 1-2 | FieldCapabilitiesResponse.java | `server/src/main/java/org/opensearch/action/fieldcaps/FieldCapabilitiesResponse.java` | フィールド機能レスポンスの構造 |
| 1-3 | FieldCapabilities.java | `server/src/main/java/org/opensearch/action/fieldcaps/FieldCapabilities.java` | 個別フィールドの機能情報（type, searchable, aggregatable等） |

**読解のコツ**: `FieldCapabilities`クラスがフィールドの型、検索可否、集計可否を保持する。レスポンスはフィールド名→型名→機能情報の入れ子構造。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestFieldCapabilitiesAction.java | `server/src/main/java/org/opensearch/rest/action/RestFieldCapabilitiesAction.java` | RESTハンドラ全体（90行のコンパクトな実装） |

**主要処理フロー**:
1. **行58-67**: `routes()`で4パターンのルートを登録
2. **行76-79**: `FieldCapabilitiesRequest`構築（fields、indices設定）
3. **行81-82**: IndicesOptions、includeUnmapped設定
4. **行83-87**: index_filterの解析（Query DSL）
5. **行88**: `client.fieldCaps()`でアクション実行

### プログラム呼び出し階層図

```
RestFieldCapabilitiesAction.prepareRequest()
    |
    +-- FieldCapabilitiesRequest構築 (fields, indices)
    |
    +-- RestActions.getQueryContent("index_filter", parser)
    |
    +-- client.fieldCaps()
            +-- TransportFieldCapabilitiesAction.doExecute()
                    +-- 各シャードのマッピング情報収集
                    +-- フィールド機能情報の集約
```

### データフロー図

```
[入力]                        [処理]                              [出力]

HTTP Request        -->  RestFieldCapabilitiesAction        -->  HTTP Response (JSON)
  - fields パラメータ       |                                      { "indices": [...],
  - index_filter            +-- FieldCapabilitiesRequest構築          "fields": {
                            +-- TransportFieldCapabilities              "field1": {
                                    各インデックスのマッピング             "text": {...}
                                    情報を収集・集約                     }
                                                                      }
                                                                    }
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestFieldCapabilitiesAction.java | `server/src/main/java/org/opensearch/rest/action/RestFieldCapabilitiesAction.java` | ソース | RESTエンドポイントハンドラ |
| FieldCapabilitiesRequest.java | `server/src/main/java/org/opensearch/action/fieldcaps/FieldCapabilitiesRequest.java` | ソース | リクエストデータモデル |
| FieldCapabilitiesResponse.java | `server/src/main/java/org/opensearch/action/fieldcaps/FieldCapabilitiesResponse.java` | ソース | レスポンスデータモデル |
| FieldCapabilities.java | `server/src/main/java/org/opensearch/action/fieldcaps/FieldCapabilities.java` | ソース | フィールド機能情報モデル |
| field_caps.json | `rest-api-spec/src/main/resources/rest-api-spec/api/field_caps.json` | 設定 | REST API仕様定義 |
