# 画面設計書 26-検索テンプレート

## 概要

本ドキュメントは、OpenSearchのSearch Template API（`_search/template`）エンドポイントに関する画面設計書である。Mustache言語を使用して事前定義された検索テンプレートに動的パラメータを適用し、検索を実行する。

### 本画面の処理概要

Search Template APIは、Mustacheテンプレート言語を使用して検索クエリをパラメータ化し、テンプレートとパラメータの組み合わせで検索を実行するAPIである。

**業務上の目的・背景**：検索クエリのロジックとパラメータを分離することで、クエリの再利用性を高め、クライアント側のコードを簡素化するために使用される。定型的な検索パターンをテンプレートとして保存しておくことで、アプリケーション開発者はクエリの詳細を意識せずに検索機能を利用できる。また、テンプレートの一元管理により、クエリの変更をアプリケーションのデプロイなしに実施できる。

**画面へのアクセス方法**：HTTPクライアントから `GET/POST /_search/template` または `GET/POST /{index}/_search/template` エンドポイントにリクエストを送信する。リクエストボディにテンプレート定義とパラメータを含める。

**主要な操作・処理内容**：
1. リクエストボディからMustacheテンプレートとパラメータを解析する
2. テンプレートをパラメータで展開し、検索クエリを生成する
3. 生成された検索クエリをSearch APIと同じパスで実行する
4. 検索パイプラインが指定されている場合は適用する
5. 検索結果を返却する

**画面遷移**：保存済みテンプレートはScript API（No.140）で管理される。テンプレートのレンダリング確認にはRender Search Template API（No.28）を使用する。複数テンプレートの一括実行にはMulti Search Template API（No.27）を使用する。

**権限による表示制御**：Search APIと同様にインデックスレベルの権限チェックが行われる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 20 | 検索API | 主機能 | Mustache言語で事前レンダリングされた検索定義を使用する処理 |
| 80 | Mustacheテンプレート | 補助機能 | Mustacheテンプレートのレンダリング処理 |

## 画面種別

API（テンプレート検索実行・結果返却）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET/POST | `/_search/template` | 全インデックスを対象にテンプレート検索 |
| GET/POST | `/{index}/_search/template` | 指定インデックスを対象にテンプレート検索 |

## 入出力項目

### URLパスパラメータ

| パラメータ | 型 | 必須 | 説明 |
|-----------|------|------|------|
| index | list | No | 検索対象のインデックス名（カンマ区切り） |

### クエリパラメータ

| パラメータ | 型 | デフォルト | 説明 |
|-----------|------|-----------|------|
| ignore_unavailable | boolean | false | 利用不可のインデックスを無視するか |
| ignore_throttled | boolean | false | スロットルされたインデックスを無視するか |
| allow_no_indices | boolean | - | ワイルドカード式が解決されない場合に無視するか |
| expand_wildcards | enum | open | ワイルドカード展開対象 |
| preference | string | random | 操作を実行するノード/シャードの優先設定 |
| routing | list | - | ルーティング値 |
| scroll | time | - | スクロール検索のコンテキスト維持時間 |
| search_type | enum | query_then_fetch | 検索操作タイプ |
| explain | boolean | false | スコア計算の詳細情報を返却するか |
| profile | boolean | false | クエリ実行のプロファイリングを行うか |
| typed_keys | boolean | false | 集計・サジェスタ名にタイプをプレフィックスするか |
| rest_total_hits_as_int | boolean | false | hits.totalを整数として返却するか |
| ccs_minimize_roundtrips | boolean | true | クロスクラスタ検索のラウンドトリップを最小化するか |

### リクエストボディ（必須）

| フィールド | 型 | 説明 |
|-----------|------|------|
| source / id | string | テンプレートソース（インライン）または保存済みテンプレートID |
| params | object | テンプレートに渡すパラメータ |
| search_pipeline | string | 使用する検索パイプライン名 |

## 表示項目

### レスポンスボディ

Search API（No.21）と同じレスポンス形式。

## イベント仕様

### 1-検索テンプレートリクエスト実行

1. `RestSearchTemplateAction.prepareRequest()`がリクエストを受信（行82）
2. `SearchRequest`を構築し、Search APIの`parseSearchRequest`で共通パラメータを解析（行84-91）
3. リクエストボディから`SearchTemplateRequest`を構築（行94-97）
4. 検索パイプラインが指定されている場合はSearchRequestに設定（行99-102）
5. `SearchTemplateAction`を実行（行105）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| テンプレート検索実行 | Luceneインデックス | SELECT | テンプレートから生成されたクエリに一致するドキュメントを検索 |
| テンプレート取得 | クラスタメタデータ | SELECT | 保存済みテンプレート（Stored Script）の取得 |

### テーブル別更新項目詳細

#### Luceneインデックス（読み取り専用）

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| SELECT | ドキュメント全体 | テンプレートから生成されたQuery DSL条件に基づく | 書き込み操作は発生しない |

## メッセージ仕様

| 種別 | メッセージ | 発生条件 |
|------|----------|----------|
| 成功 | HTTPステータス200 + 検索結果JSON | 正常にテンプレート検索が完了した場合 |
| エラー | テンプレートパース失敗 | Mustacheテンプレートの構文が不正な場合 |
| エラー | スクリプトが見つからない | idで指定した保存済みテンプレートが存在しない場合 |

## 例外処理

| 例外 | HTTPステータス | 説明 |
|------|--------------|------|
| ResourceNotFoundException | 404 | 保存済みテンプレートが見つからない場合 |
| ScriptException | 400 | テンプレートのレンダリングに失敗した場合 |
| IndexNotFoundException | 404 | 指定されたインデックスが存在しない場合 |

## 備考

- テンプレートはMustache言語で記述される（lang-mustacheモジュールで提供）
- インラインテンプレート（`source`フィールド）と保存済みテンプレート（`id`フィールド）の両方をサポート
- `search_pipeline`はテンプレートリクエストレベルで指定可能（RestSearchTemplateAction 行99-102）
- 本APIは`RestSearchAction.parseSearchRequest()`を内部的に呼び出してSearch APIの共通パラメータを処理する（行85-91）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SearchTemplateRequest.java | `modules/lang-mustache/src/main/java/org/opensearch/script/mustache/SearchTemplateRequest.java` | テンプレートリクエストの構造（source/id, params, simulate等） |

**読解のコツ**: `SearchTemplateRequest.fromXContent()`がリクエストボディのパース処理。`simulate`フラグでRender Template APIとの共用がある。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestSearchTemplateAction.java | `modules/lang-mustache/src/main/java/org/opensearch/script/mustache/RestSearchTemplateAction.java` | RESTハンドラ全体 |

**主要処理フロー**:
1. **行65-73**: `routes()`で4パターンのルートを登録
2. **行82-91**: SearchRequest構築とSearch API共通パラメータ解析
3. **行94-97**: SearchTemplateRequestの構築（テンプレート+パラメータ）
4. **行99-102**: 検索パイプラインの設定
5. **行105**: `SearchTemplateAction`実行

#### Step 3: テンプレートレンダリング処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportSearchTemplateAction.java | `modules/lang-mustache/src/main/java/org/opensearch/script/mustache/TransportSearchTemplateAction.java` | Mustacheテンプレートの展開と検索実行 |

### プログラム呼び出し階層図

```
RestSearchTemplateAction.prepareRequest()
    |
    +-- RestSearchAction.parseSearchRequest() [共通パラメータ]
    |
    +-- SearchTemplateRequest.fromXContent() [テンプレート解析]
    |
    +-- client.execute(SearchTemplateAction)
            +-- TransportSearchTemplateAction.doExecute()
                    +-- MustacheScriptEngine.compile() [テンプレート展開]
                    +-- SearchAction [生成されたクエリで検索実行]
```

### データフロー図

```
[入力]                        [処理]                              [出力]

HTTP Request        -->  RestSearchTemplateAction           -->  HTTP Response (JSON)
  - Mustacheテンプレート    |                                      (Search APIと同じ)
  - パラメータ              +-- SearchRequest構築
                            +-- Mustacheテンプレート展開
                            +-- 生成されたQuery DSLで検索実行
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestSearchTemplateAction.java | `modules/lang-mustache/src/main/java/org/opensearch/script/mustache/RestSearchTemplateAction.java` | ソース | RESTエンドポイントハンドラ |
| SearchTemplateRequest.java | `modules/lang-mustache/src/main/java/org/opensearch/script/mustache/SearchTemplateRequest.java` | ソース | テンプレートリクエストデータモデル |
| TransportSearchTemplateAction.java | `modules/lang-mustache/src/main/java/org/opensearch/script/mustache/TransportSearchTemplateAction.java` | ソース | テンプレート展開と検索実行 |
| search_template.json | `rest-api-spec/src/main/resources/rest-api-spec/api/search_template.json` | 設定 | REST API仕様定義 |
