# 画面設計書 28-検索テンプレートレンダリング

## 概要

本ドキュメントは、OpenSearchのRender Search Template API（`_render/template`）エンドポイントに関する画面設計書である。Mustacheテンプレートをパラメータで展開した結果（生成されるJSON）を、実際に検索を実行せずにプレビューする。

### 本画面の処理概要

Render Search Template APIは、Mustacheテンプレートにパラメータを適用した結果のJSONをプレビュー表示するAPIである。実際の検索は実行されない。

**業務上の目的・背景**：検索テンプレートの開発・デバッグ時に、テンプレートがパラメータでどのように展開されるかを事前に確認するために使用される。テンプレートの構文エラーや、期待通りのクエリが生成されるかの確認に有用である。テンプレートを本番環境にデプロイする前の検証ステップとして重要。

**画面へのアクセス方法**：HTTPクライアントから `GET/POST /_render/template` または `GET/POST /_render/template/{id}` エンドポイントにリクエストを送信する。

**主要な操作・処理内容**：
1. リクエストボディからMustacheテンプレートとパラメータを解析する
2. URLパスにidが指定された場合は保存済みテンプレートを参照する
3. テンプレートをパラメータで展開する（simualteモード）
4. 展開結果のJSONを返却する（検索は実行しない）

**画面遷移**：Search Template API（No.26）の開発補助ツール。保存済みテンプレートはScript API（No.140）で管理される。

**権限による表示制御**：保存済みテンプレートへのアクセス権限が必要。検索は実行しないためインデックスへの権限は不要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 80 | Mustacheテンプレート | 主機能 | Mustache言語で検索定義を事前レンダリングする処理 |

## 画面種別

API（テンプレートレンダリング・プレビュー）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET/POST | `/_render/template` | インラインテンプレートをレンダリング |
| GET/POST | `/_render/template/{id}` | 保存済みテンプレートをレンダリング |

## 入出力項目

### URLパスパラメータ

| パラメータ | 型 | 必須 | 説明 |
|-----------|------|------|------|
| id | string | No | 保存済みテンプレートのID |

### クエリパラメータ

なし。

### リクエストボディ（任意）

| フィールド | 型 | 説明 |
|-----------|------|------|
| source | object/string | インラインのMustacheテンプレート |
| id | string | 保存済みテンプレートID（URLパスのidと同等） |
| params | object | テンプレートに渡すパラメータ |

## 表示項目

### レスポンスボディ

| フィールド | 型 | 説明 |
|-----------|------|------|
| template_output | object | テンプレート展開結果のJSON |

## イベント仕様

### 1-テンプレートレンダリングリクエスト実行

1. `RestRenderSearchTemplateAction.prepareRequest()`がリクエストを受信（行70）
2. リクエストボディから`SearchTemplateRequest`を構築（行72-75）
3. `renderRequest.setSimulate(true)`でシミュレートモードに設定（行76）
4. URLパスにidが指定されている場合、ScriptType.STOREDとscriptを設定（行78-82）
5. `RenderSearchTemplateAction`を実行（行84）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| テンプレートレンダリング | クラスタメタデータ | SELECT | 保存済みテンプレート（Stored Script）の取得（id指定時のみ） |

### テーブル別更新項目詳細

#### クラスタメタデータ（読み取り専用）

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| SELECT | Stored Script | 指定idのテンプレート定義 | id指定時のみ。インラインテンプレートの場合はアクセスしない |

## メッセージ仕様

| 種別 | メッセージ | 発生条件 |
|------|----------|----------|
| 成功 | HTTPステータス200 + テンプレート展開結果JSON | 正常にレンダリングが完了した場合 |
| エラー | テンプレートパース失敗 | Mustacheテンプレートの構文が不正な場合 |
| エラー | スクリプトが見つからない | idで指定した保存済みテンプレートが存在しない場合 |

## 例外処理

| 例外 | HTTPステータス | 説明 |
|------|--------------|------|
| ResourceNotFoundException | 404 | 保存済みテンプレートが見つからない場合 |
| ScriptException | 400 | テンプレートのレンダリングに失敗した場合 |

## 備考

- `setSimulate(true)`により検索は実行されず、テンプレート展開結果のみが返却される（RestRenderSearchTemplateAction 行76）
- URLパスの`id`パラメータがリクエストボディの`id`/`source`より優先される（行78-82）
- URLパスにidが指定された場合、ScriptType.STOREDが自動設定される
- クエリパラメータは存在しない軽量なAPI

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SearchTemplateRequest.java | `modules/lang-mustache/src/main/java/org/opensearch/script/mustache/SearchTemplateRequest.java` | simulateフラグの役割を理解する |

**読解のコツ**: `simulate=true`の場合、テンプレート展開のみが実行され、検索は行われない。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestRenderSearchTemplateAction.java | `modules/lang-mustache/src/main/java/org/opensearch/script/mustache/RestRenderSearchTemplateAction.java` | RESTハンドラ全体（86行の極めてコンパクトな実装） |

**主要処理フロー**:
1. **行53-61**: `routes()`で4パターンのルートを登録
2. **行72-75**: SearchTemplateRequestの構築
3. **行76**: `setSimulate(true)`でシミュレートモード設定
4. **行78-82**: URLパスのid処理（ScriptType.STORED設定）
5. **行84**: `RenderSearchTemplateAction`実行

### プログラム呼び出し階層図

```
RestRenderSearchTemplateAction.prepareRequest()
    |
    +-- SearchTemplateRequest.fromXContent() [テンプレート解析]
    |
    +-- setSimulate(true) [シミュレートモード]
    |
    +-- id設定 (URLパスから) [ScriptType.STORED]
    |
    +-- client.execute(RenderSearchTemplateAction)
            +-- TransportRenderSearchTemplateAction.doExecute()
                    +-- MustacheScriptEngine.compile() [テンプレート展開のみ]
```

### データフロー図

```
[入力]                        [処理]                              [出力]

HTTP Request        -->  RestRenderSearchTemplateAction     -->  HTTP Response (JSON)
  - Mustacheテンプレート    |                                      { "template_output":
  - パラメータ              +-- SearchTemplateRequest構築             { ... } }
  - (id)                    +-- simulate=true設定
                            +-- Mustacheテンプレート展開
                            (検索は実行しない)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestRenderSearchTemplateAction.java | `modules/lang-mustache/src/main/java/org/opensearch/script/mustache/RestRenderSearchTemplateAction.java` | ソース | RESTエンドポイントハンドラ |
| SearchTemplateRequest.java | `modules/lang-mustache/src/main/java/org/opensearch/script/mustache/SearchTemplateRequest.java` | ソース | テンプレートリクエストデータモデル |
| render_search_template.json | `rest-api-spec/src/main/resources/rest-api-spec/api/render_search_template.json` | 設定 | REST API仕様定義 |
