# 画面設計書 29-ランク評価

## 概要

本ドキュメントは、OpenSearchのRank Eval API（`_rank_eval`）エンドポイントに関する画面設計書である。Rank Eval APIは、ランク付き検索結果の品質を、事前に定義した評価基準（Precision、Recall、DCG等）に基づいて定量的に評価する。

### 本画面の処理概要

Rank Eval APIは、テスト用のクエリセットとその期待される文書レーティングを受け取り、実際の検索結果と比較して品質スコアを算出するAPIである。

**業務上の目的・背景**：検索品質の定量的な評価と改善のために使用される。マッピングの変更、アナライザの調整、クエリロジックの変更などが検索品質にどのような影響を与えるかを、客観的な指標で測定できる。A/Bテストやリリース前の品質検証に有用であり、検索エンジニアがチューニング作業を効率的に進めるための重要なツールである。

**画面へのアクセス方法**：HTTPクライアントから `GET/POST /_rank_eval` または `GET/POST /{index}/_rank_eval` エンドポイントにリクエストを送信する。リクエストボディに評価対象のクエリセット、ドキュメントレーティング、評価メトリクスを含める。

**主要な操作・処理内容**：
1. リクエストボディから評価対象のクエリセット（requests）と評価メトリクス（metric）を解析する
2. 各テストクエリを実行し、検索結果を取得する
3. 検索結果と期待されるレーティングを比較して品質スコアを算出する
4. 各クエリのスコアと全体の品質指標を返却する

**画面遷移**：Search API（No.21）を内部的に使用して検索を実行する。評価結果を基にクエリのチューニングを行い、再度Search APIで検証する流れが一般的である。

**権限による表示制御**：対象インデックスへの検索権限が必要である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 111 | ランク評価API | 主機能 | ランク付き検索結果の品質を評価する処理 |
| 20 | 検索API | 補助機能 | ランク評価対象の検索を実行する処理 |

## 画面種別

API（検索品質評価）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET/POST | `/_rank_eval` | 全インデックスを対象にランク評価 |
| GET/POST | `/{index}/_rank_eval` | 指定インデックスを対象にランク評価 |

## 入出力項目

### URLパスパラメータ

| パラメータ | 型 | 必須 | 説明 |
|-----------|------|------|------|
| index | list | No | 検索対象のインデックス名（カンマ区切り） |

### クエリパラメータ

| パラメータ | 型 | デフォルト | 説明 |
|-----------|------|-----------|------|
| ignore_unavailable | boolean | false | 利用不可のインデックスを無視するか |
| allow_no_indices | boolean | - | ワイルドカード式が解決されない場合に無視するか |
| expand_wildcards | enum | open | ワイルドカード展開対象 |
| search_type | enum | query_then_fetch | 検索操作タイプ（query_then_fetch/dfs_query_then_fetch） |

### リクエストボディ（必須）

| フィールド | 型 | 説明 |
|-----------|------|------|
| requests | array | 評価対象のクエリセット |
| requests[].id | string | テストクエリの識別子 |
| requests[].request | object | 検索リクエスト（Query DSL） |
| requests[].ratings | array | ドキュメントレーティング |
| requests[].ratings[]._index | string | ドキュメントのインデックス |
| requests[].ratings[]._id | string | ドキュメントID |
| requests[].ratings[].rating | number | 関連度スコア（0=無関連、1=関連、等） |
| metric | object | 評価メトリクス（precision, recall, dcg等） |

## 表示項目

### レスポンスボディ

| フィールド | 型 | 説明 |
|-----------|------|------|
| metric_score | number | 全体の品質スコア |
| details | object | 各テストクエリの詳細スコア |
| details.{query_id} | object | 個別クエリの評価結果 |
| details.{query_id}.metric_score | number | 個別クエリのスコア |
| details.{query_id}.unrated_docs | array | レーティングされていないヒットドキュメント |
| details.{query_id}.hits | array | 検索結果のヒット情報 |
| failures | object | 評価失敗したクエリの情報 |

## イベント仕様

### 1-ランク評価リクエスト実行

1. `RestRankEvalAction.prepareRequest()`がリクエストを受信（行121）
2. `RankEvalRequest`を構築（行122）
3. リクエストボディからクエリセットと評価メトリクスを解析（`parseRankEvalRequest`、行123-125）
4. インデックス、IndicesOptions、searchTypeを設定（行133-138）
5. `RankEvalSpec.parse(parser)`で評価仕様を解析（行139）
6. `RankEvalAction`をローカル実行（行126-131）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ランク評価実行 | Luceneインデックス | SELECT | 各テストクエリで検索を実行し結果をレーティングと比較 |

### テーブル別更新項目詳細

#### Luceneインデックス（読み取り専用）

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| SELECT | ドキュメント全体 | 各テストクエリのQuery DSL条件に基づく | 書き込み操作は発生しない |

## メッセージ仕様

| 種別 | メッセージ | 発生条件 |
|------|----------|----------|
| 成功 | HTTPステータス200 + 評価結果JSON | 正常に評価が完了した場合 |
| エラー | 評価失敗 | テストクエリの実行に失敗した場合（failuresに含まれる） |

## 例外処理

| 例外 | HTTPステータス | 説明 |
|------|--------------|------|
| IndexNotFoundException | 404 | 指定されたインデックスが存在しない場合 |
| IllegalArgumentException | 400 | リクエストボディの形式が不正な場合 |

## 備考

- 本APIはstability: "experimental"であり、将来のバージョンで変更される可能性がある（rank_eval.json）
- サポートされる評価メトリクスには以下がある：
  - `precision`: 適合率（Precision at K）
  - `recall`: 再現率（Recall at K）
  - `mean_reciprocal_rank`: 平均逆順位
  - `dcg`: Discounted Cumulative Gain
  - `expected_reciprocal_rank`: Expected Reciprocal Rank
- `executeLocally`で実行されるため、クラスタ内の他のノードに転送されない（RestRankEvalAction 行126）
- rank-evalモジュールとして提供されており、本体とは別モジュール

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | RankEvalRequest.java | `modules/rank-eval/src/main/java/org/opensearch/index/rankeval/RankEvalRequest.java` | ランク評価リクエストの構造 |
| 1-2 | RankEvalSpec.java | `modules/rank-eval/src/main/java/org/opensearch/index/rankeval/RankEvalSpec.java` | 評価仕様（クエリセット+メトリクス）の構造 |
| 1-3 | RankEvalResponse.java | `modules/rank-eval/src/main/java/org/opensearch/index/rankeval/RankEvalResponse.java` | 評価結果の構造 |

**読解のコツ**: `RankEvalSpec`が評価のコア構造。`requests`（RatedRequest配列）と`metric`（EvaluationMetric）を保持する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestRankEvalAction.java | `modules/rank-eval/src/main/java/org/opensearch/index/rankeval/RestRankEvalAction.java` | RESTハンドラ全体 |

**主要処理フロー**:
1. **行109-117**: `routes()`で4パターンのルートを登録
2. **行121-131**: `prepareRequest()`でリクエスト解析とアクション実行
3. **行133-141**: `parseRankEvalRequest()`でインデックス、searchType、評価仕様を設定
4. **行139**: `RankEvalSpec.parse(parser)`で評価仕様の完全パース

### プログラム呼び出し階層図

```
RestRankEvalAction.prepareRequest()
    |
    +-- parseRankEvalRequest()
    |       +-- RankEvalSpec.parse() [評価仕様解析]
    |       +-- IndicesOptions.fromRequest()
    |       +-- SearchType.fromString()
    |
    +-- client.executeLocally(RankEvalAction)
            +-- TransportRankEvalAction.doExecute()
                    +-- SearchAction [各テストクエリ実行]
                    +-- EvaluationMetric.evaluate() [品質スコア算出]
```

### データフロー図

```
[入力]                        [処理]                              [出力]

HTTP Request        -->  RestRankEvalAction                 -->  HTTP Response (JSON)
  - テストクエリセット       |                                      { "metric_score": 0.8,
  - ドキュメントレーティング  +-- RankEvalSpec解析                      "details": {...} }
  - 評価メトリクス           +-- 各クエリで検索実行
                            +-- 検索結果とレーティング比較
                            +-- 品質スコア算出
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestRankEvalAction.java | `modules/rank-eval/src/main/java/org/opensearch/index/rankeval/RestRankEvalAction.java` | ソース | RESTエンドポイントハンドラ |
| RankEvalRequest.java | `modules/rank-eval/src/main/java/org/opensearch/index/rankeval/RankEvalRequest.java` | ソース | リクエストデータモデル |
| RankEvalSpec.java | `modules/rank-eval/src/main/java/org/opensearch/index/rankeval/RankEvalSpec.java` | ソース | 評価仕様モデル |
| RankEvalResponse.java | `modules/rank-eval/src/main/java/org/opensearch/index/rankeval/RankEvalResponse.java` | ソース | レスポンスデータモデル |
| rank_eval.json | `rest-api-spec/src/main/resources/rest-api-spec/api/rank_eval.json` | 設定 | REST API仕様定義 |
