# 画面設計書 30-検索シャード情報

## 概要

本ドキュメントは、OpenSearchのSearch Shards API（`_search_shards`）エンドポイントに関する画面設計書である。Search Shards APIは、検索リクエストが実行される対象のインデックスとシャードの情報を返す。

### 本画面の処理概要

Search Shards APIは、指定されたインデックスに対して検索リクエストが実行される場合に、どのノードのどのシャードが対象になるかを事前に確認するためのAPIである。

**業務上の目的・背景**：検索のパフォーマンスデバッグやルーティングの確認に使用される。特定のルーティング値がどのシャードに割り当てられるか、検索リクエストがどのノードに分散されるかを事前に把握することで、パフォーマンスの問題分析やクラスタ設計の検証に役立つ。また、カスタムルーティングの動作確認にも有用である。

**画面へのアクセス方法**：HTTPクライアントから `GET/POST /_search_shards` または `GET/POST /{index}/_search_shards` エンドポイントにリクエストを送信する。

**主要な操作・処理内容**：
1. 対象インデックスを特定する
2. ルーティング値やプリファレンスに基づいて対象シャードを決定する
3. シャードが配置されているノード情報を収集する
4. スライス（slice）パラメータが指定されている場合はスライス情報を適用する
5. シャード・ノード情報を返却する

**画面遷移**：Search API（No.21）の補助ツールとして、検索が実行される前にシャードの分散状況を確認する用途で使用される。クラスタヘルスAPI（No.90）やアロケーション説明API（No.95）と組み合わせてクラスタの状態分析に使用されることが多い。

**権限による表示制御**：対象インデックスへの読み取り権限が必要である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 57 | シャードルーティング | 主機能 | 検索リクエストが実行されるインデックスとシャード情報を返す処理 |

## 画面種別

API（シャード情報参照）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET/POST | `/_search_shards` | 全インデックスの検索シャード情報を返す |
| GET/POST | `/{index}/_search_shards` | 指定インデックスの検索シャード情報を返す |

## 入出力項目

### URLパスパラメータ

| パラメータ | 型 | 必須 | 説明 |
|-----------|------|------|------|
| index | list | No | 対象インデックス名（カンマ区切り） |

### クエリパラメータ

| パラメータ | 型 | デフォルト | 説明 |
|-----------|------|-----------|------|
| preference | string | random | 操作を実行するノード/シャードの優先設定 |
| routing | string | - | ルーティング値 |
| local | boolean | false | マスターノードから状態を取得せずローカル情報を返すか |
| ignore_unavailable | boolean | false | 利用不可のインデックスを無視するか |
| allow_no_indices | boolean | - | ワイルドカード式が解決されない場合に無視するか |
| expand_wildcards | enum | open | ワイルドカード展開対象（open/closed/hidden/none/all） |

### リクエストボディ（任意）

| フィールド | 型 | 説明 |
|-----------|------|------|
| slice | object | スライスパラメータ（並列処理のためのシャード分割指定） |

## 表示項目

### レスポンスボディ

| フィールド | 型 | 説明 |
|-----------|------|------|
| nodes | object | シャードが配置されているノード情報 |
| nodes.{node_id} | object | 各ノードの詳細情報 |
| nodes.{node_id}.name | string | ノード名 |
| nodes.{node_id}.transport_address | string | トランスポートアドレス |
| nodes.{node_id}.attributes | object | ノード属性 |
| indices | object | インデックス情報 |
| shards | array | シャード情報の配列 |
| shards[][] | object | 各シャードの詳細（プライマリ/レプリカ、ノード、シャードID等） |

## イベント仕様

### 1-検索シャード情報リクエスト実行

1. `RestClusterSearchShardsAction.prepareRequest()`がリクエストを受信（行78）
2. インデックス名の解析と`ClusterSearchShardsRequest`の構築（行79-80）
3. `local`、`routing`、`preference`を設定（行81-83）
4. `IndicesOptions`を設定（行84）
5. リクエストボディにsliceパラメータが含まれる場合はSearchSourceBuilderでパースして設定（行85-91）
6. `client.admin().cluster().searchShards()`でアクション実行（行92）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| シャード情報取得 | クラスタメタデータ | SELECT | クラスタ状態からシャード配置情報を取得 |

### テーブル別更新項目詳細

#### クラスタメタデータ（読み取り専用）

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| SELECT | シャード配置情報 | 指定インデックスのシャードとノードの対応関係 | 書き込み操作は発生しない |

## メッセージ仕様

| 種別 | メッセージ | 発生条件 |
|------|----------|----------|
| 成功 | HTTPステータス200 + シャード情報JSON | 正常にシャード情報が取得できた場合 |

## 例外処理

| 例外 | HTTPステータス | 説明 |
|------|--------------|------|
| IndexNotFoundException | 404 | 指定されたインデックスが存在しない場合 |
| IllegalArgumentException | 400 | 不正なパラメータが指定された場合 |

## 備考

- リクエストボディのsliceパラメータはSearchSourceBuilderを使ってパースされる（RestClusterSearchShardsAction 行86-89）
- `local`パラメータをtrueに設定すると、マスターノードから最新状態を取得せずにローカルノードの情報を返す
- 本APIは検索を実行せず、メタデータのみを返す軽量なAPI
- `Requests.clusterSearchShardsRequest()`ファクトリメソッドでリクエストを構築（行80）
- `client.admin().cluster().searchShards()`で管理者クラスタAPIとして実行される（行92）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ClusterSearchShardsRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/shards/ClusterSearchShardsRequest.java` | 検索シャードリクエストの構造（indices, routing, preference, local） |
| 1-2 | ClusterSearchShardsResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/shards/ClusterSearchShardsResponse.java` | レスポンスの構造（nodes, shards, indices） |

**読解のコツ**: レスポンスの`shards`は二次元配列で、最初の次元がシャードグループ、第二の次元がプライマリ/レプリカを表す。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestClusterSearchShardsAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestClusterSearchShardsAction.java` | RESTハンドラ全体（94行のコンパクトな実装） |

**主要処理フロー**:
1. **行61-68**: `routes()`で4パターンのルートを登録
2. **行79-80**: インデックス名解析と`ClusterSearchShardsRequest`構築
3. **行81-84**: local, routing, preference, indicesOptionsの設定
4. **行85-91**: リクエストボディのsliceパラメータ処理
5. **行92**: `client.admin().cluster().searchShards()`でアクション実行

### プログラム呼び出し階層図

```
RestClusterSearchShardsAction.prepareRequest()
    |
    +-- Requests.clusterSearchShardsRequest() [リクエスト構築]
    |
    +-- SearchSourceBuilder.parseXContent() [sliceパラメータ解析]
    |
    +-- client.admin().cluster().searchShards()
            +-- TransportClusterSearchShardsAction.doExecute()
                    +-- ClusterState読み取り
                    +-- RoutingTable参照
                    +-- シャード配置情報収集
```

### データフロー図

```
[入力]                        [処理]                              [出力]

HTTP Request        -->  RestClusterSearchShardsAction      -->  HTTP Response (JSON)
  - index                   |                                      { "nodes": {...},
  - routing                 +-- ClusterSearchShardsRequest構築        "shards": [[...]],
  - preference              +-- ClusterState参照                      "indices": {...} }
  - (slice)                 +-- RoutingTable参照
                            +-- シャード・ノード情報収集
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestClusterSearchShardsAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestClusterSearchShardsAction.java` | ソース | RESTエンドポイントハンドラ |
| ClusterSearchShardsRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/shards/ClusterSearchShardsRequest.java` | ソース | リクエストデータモデル |
| ClusterSearchShardsResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/shards/ClusterSearchShardsResponse.java` | ソース | レスポンスデータモデル |
| TransportClusterSearchShardsAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/shards/TransportClusterSearchShardsAction.java` | ソース | シャード情報取得のトランスポート層実行 |
| search_shards.json | `rest-api-spec/src/main/resources/rest-api-spec/api/search_shards.json` | 設定 | REST API仕様定義 |
