# 画面設計書 33-スクロールクリア

## 概要

本ドキュメントは、OpenSearchのClear Scroll APIエンドポイントに関する画面設計書である。スクロール検索の検索コンテキストを明示的にクリアし、クラスタリソースを解放するためのREST APIインターフェースを定義する。

### 本画面の処理概要

本APIは、スクロール検索で使用した検索コンテキスト（SearchContext）を明示的に削除し、メモリ等のクラスタリソースを早期に解放する機能を提供する。

**業務上の目的・背景**：スクロール検索（No.32）ではSearchContextがクラスタのメモリ上に保持されるため、大量のスクロールコンテキストが存在するとクラスタのパフォーマンスに悪影響を及ぼす。スクロール処理が完了したら、自動タイムアウトを待たずに即座にコンテキストを解放することで、クラスタリソースの効率的な運用が可能となる。

**画面へのアクセス方法**：HTTPクライアントから `DELETE /_search/scroll` エンドポイントにリクエストを送信する。リクエストボディまたはURLパスでクリア対象の`scroll_id`を指定する。

**主要な操作・処理内容**：
1. 特定のscroll_idを指定してスクロールコンテキストをクリアする
2. 複数のscroll_idをカンマ区切りで指定して一括クリアする
3. リクエストボディでscroll_idリストを指定する

**画面遷移**：スクロール検索API（No.32）で全結果を取得した後に本APIを呼び出す。本APIの実行後はスクロールコンテキストが無効化される。

**権限による表示制御**：スクロールコンテキストの所有者であれば、特別な追加権限なしにクリア操作が可能である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 22 | スクロール検索 | 主機能 | スクロールの検索コンテキストを明示的にクリアする処理 |

## 画面種別

API実行（リソース解放）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| DELETE | `/_search/scroll` | スクロールコンテキストのクリア |
| DELETE | `/_search/scroll/{scroll_id}` | スクロールコンテキストのクリア（非推奨） |

## 入出力項目

### パスパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|------|------|------|
| scroll_id | list | いいえ | カンマ区切りのスクロールIDリスト（非推奨、ボディで指定を推奨） |

### クエリパラメータ

本APIにはクエリパラメータは存在しない。

### リクエストボディ

| フィールド名 | 型 | 必須 | 説明 |
|-------------|------|------|------|
| scroll_id | string/array | いいえ | クリア対象のスクロールIDまたはIDリスト |

## 表示項目

### レスポンス

| フィールド名 | 型 | 説明 |
|-------------|------|------|
| succeeded | boolean | クリア操作が成功したか |
| num_freed | integer | 解放されたスクロールコンテキスト数 |

## イベント仕様

### 1-スクロールクリア実行

1. `RestClearScrollAction.prepareRequest()`がDELETEリクエストを受け取る（行67）
2. URLパスまたはパラメータからscroll_idを取得し、ClearScrollRequestに設定する（行68-70）
3. リクエストボディがある場合は`fromXContent()`でパースし、ボディの値が優先される（行71-80）
4. `client.clearScroll()`でTransport層に委譲する（行82）
5. TransportClearScrollActionが各ノードのSearchContextを削除する

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| スクロールクリア | SearchContext（メモリ） | DELETE | スクロール検索コンテキストをメモリから削除 |

### テーブル別更新項目詳細

本APIはインデックスデータへの変更は行わない。クラスタメモリ上のSearchContextオブジェクトを削除する。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|--------------|---------|
| - | 成功 | `{"succeeded": true, "num_freed": N}` | スクロールコンテキストが正常にクリアされた場合 |
| - | エラー | IllegalArgumentException | リクエストボディのパースに失敗した場合 |

## 例外処理

| 例外 | HTTPステータス | 説明 |
|------|--------------|------|
| IllegalArgumentException | 400 | リクエストボディのパースエラー |
| 無効なscroll_id | 404 | 指定されたscroll_idが存在しないまたは期限切れの場合 |

## 備考

- URLパスでのscroll_id指定は7.0.0で非推奨。scroll_idはサイズが大きくなる可能性があるため、ボディでの指定を推奨
- 存在しないscroll_idを指定してもエラーにはならず、num_freed=0で成功レスポンスが返る場合がある
- `_all`をscroll_idとして指定すると全てのスクロールコンテキストをクリアできる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ClearScrollRequest.java | `server/src/main/java/org/opensearch/action/search/ClearScrollRequest.java` | scroll_idリストの保持、fromXContent()メソッド |
| 1-2 | ClearScrollResponse.java | `server/src/main/java/org/opensearch/action/search/ClearScrollResponse.java` | succeeded, num_freedフィールド |

**読解のコツ**: ClearScrollRequestはscroll_idのリストを保持するシンプルな構造。パスパラメータとボディの両方からIDを受け取れる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestClearScrollAction.java | `server/src/main/java/org/opensearch/rest/action/search/RestClearScrollAction.java` | DELETEメソッドのハンドリング |

**主要処理フロー**:
1. **行57-59**: ルーティング定義（2つのDELETEエンドポイント）
2. **行67-70**: scroll_idパラメータの取得とClearScrollRequest生成
3. **行71-80**: ボディからのパース処理
4. **行82**: client.clearScroll()呼び出し

#### Step 3: トランスポート層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportClearScrollAction.java | `server/src/main/java/org/opensearch/action/search/TransportClearScrollAction.java` | 各ノードのSearchContext削除処理 |

### プログラム呼び出し階層図

```
RestClearScrollAction.prepareRequest()
    |
    +-- ClearScrollRequest生成
    |      +-- Strings.splitStringByCommaToArray() -- scroll_id解析
    |      +-- fromXContent() -- ボディからのパース
    |
    +-- client.clearScroll()
           +-- TransportClearScrollAction
                  +-- 各ノードのSearchContext削除
                  +-- ClearScrollResponse返却
```

### データフロー図

```
[入力]                        [処理]                              [出力]

HTTPリクエスト ──────> RestClearScrollAction ──────> JSON レスポンス
(DELETE)             ├─ scroll_id解析                ├─ succeeded
├─ scroll_id         └─> TransportClearScrollAction  └─ num_freed
  (パスまたはボディ)       └─ SearchContext削除
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestClearScrollAction.java | `server/src/main/java/org/opensearch/rest/action/search/RestClearScrollAction.java` | ソース | RESTエンドポイントハンドラ |
| TransportClearScrollAction.java | `server/src/main/java/org/opensearch/action/search/TransportClearScrollAction.java` | ソース | トランスポート層アクション |
| ClearScrollRequest.java | `server/src/main/java/org/opensearch/action/search/ClearScrollRequest.java` | ソース | リクエストデータ構造 |
| ClearScrollResponse.java | `server/src/main/java/org/opensearch/action/search/ClearScrollResponse.java` | ソース | レスポンスデータ構造 |
| clear_scroll.json | `rest-api-spec/src/main/resources/rest-api-spec/api/clear_scroll.json` | 設定 | REST API仕様定義 |
| RestClearScrollActionTests.java | `server/src/test/java/org/opensearch/search/scroll/RestClearScrollActionTests.java` | テスト | RESTハンドラのユニットテスト |
