# 画面設計書 34-PIT作成

## 概要

本ドキュメントは、OpenSearchのCreate Point in Time (PIT) APIエンドポイントに関する画面設計書である。Point in Timeコンテキストを作成し、特定時点のインデックス状態に対して一貫した検索を実行するためのREST APIインターフェースを定義する。

### 本画面の処理概要

本APIは、指定したインデックスに対してPoint in Time（PIT）コンテキストを作成する機能を提供する。PITは検索時点のインデックス状態のスナップショットを保持し、後続の検索リクエストでそのスナップショットに対して一貫した検索を実行可能にする。

**業務上の目的・背景**：スクロール検索の代替として導入されたPITは、より柔軟な検索パターンを実現する。スクロール検索ではリクエスト間でソート順の変更ができないが、PITではsearch_afterと組み合わせることで、任意のソート順での深いページネーションが可能となる。また、PIT IDは複数の検索リクエスト間で共有でき、並列検索にも対応する。

**画面へのアクセス方法**：HTTPクライアントから `POST /{index}/_search/point_in_time` エンドポイントにリクエストを送信する。`keep_alive`パラメータでPITコンテキストの存続時間を指定する。

**主要な操作・処理内容**：
1. 対象インデックスを指定してPITコンテキストを作成する
2. `keep_alive`パラメータでPITの存続時間を設定する
3. `allow_partial_pit_creation`パラメータで部分的な失敗を許容するか指定する
4. 作成されたPIT IDを取得し、後続の検索リクエストで使用する

**画面遷移**：本APIで取得したPIT IDを使用して検索API（No.21）で`pit`パラメータ付きの検索を実行する。使用後はPIT削除API（No.35）またはPIT一括削除API（No.36）でリソースを解放する。

**権限による表示制御**：対象インデックスに対する読み取り権限が必要である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 23 | Point in Time（PIT） | 主機能 | Point in Timeコンテキストを作成する処理 |

## 画面種別

API実行（コンテキスト作成）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| POST | `/{index}/_search/point_in_time` | PITコンテキストの作成 |

## 入出力項目

### パスパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|------|------|------|
| index | list | はい | カンマ区切りのインデックス名リスト。`_all`または空文字で全インデックス対象 |

### クエリパラメータ

| パラメータ名 | 型 | デフォルト値 | 説明 |
|-------------|------|------------|------|
| allow_partial_pit_creation | boolean | true | 部分的な失敗時にもPITを作成するか |
| keep_alive | string | - | PITコンテキストの存続時間（例："5m", "1h"） |
| preference | string | random | 操作を実行するノードまたはシャードの指定 |
| routing | list | - | カンマ区切りのルーティング値リスト |

### リクエストボディ

本APIにはリクエストボディは不要である。

## 表示項目

### レスポンス

| フィールド名 | 型 | 説明 |
|-------------|------|------|
| pit_id | string | 作成されたPIT ID（後続の検索で使用） |
| _shards | object | シャード統計情報（total/successful/skipped/failed） |
| creation_time | long | PIT作成時刻（エポックミリ秒） |

## イベント仕様

### 1-PIT作成実行

1. `RestCreatePitAction.prepareRequest()`がPOSTリクエストを受け取る（行40）
2. `allow_partial_pit_creation`パラメータを取得する（行41、デフォルトtrue）
3. インデックス名をカンマ区切りで分割する（行42）
4. `keep_alive`パラメータをTimeValueとして取得する（行43）
5. `CreatePitRequest`を生成し、IndicesOptions、preference、routingを設定する（行44-47）
6. `client.createPit()`でTransport層に委譲する（行49）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| PIT作成 | SearchContext（メモリ） | INSERT | 各シャードにPITコンテキストを作成 |

### テーブル別更新項目詳細

本APIはインデックスデータの変更は行わない。各関連シャードにSearchContextを作成し、クラスタメモリ上に保持する。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|--------------|---------|
| - | 成功 | `{"pit_id": "...", "_shards": {...}}` | PITが正常に作成された場合 |
| - | 部分成功 | PIT IDと_shards.failedが0以外 | 一部シャードで失敗しallow_partial_pit_creation=trueの場合 |
| - | エラー | IndexNotFoundException | 指定インデックスが存在しない場合 |

## 例外処理

| 例外 | HTTPステータス | 説明 |
|------|--------------|------|
| IndexNotFoundException | 404 | 指定されたインデックスが存在しない場合 |
| IllegalArgumentException | 400 | keep_aliveが未指定の場合 |
| 権限不足 | 403 | 対象インデックスへのアクセス権限がない場合 |

## 備考

- PITはスクロール検索の代替として推奨される検索パターン
- PITコンテキストはメモリを消費するため、使用後は必ず削除APIで解放すること
- `keep_alive`で指定した時間が経過すると自動的に削除される
- PITではsearch_afterパラメータと組み合わせた深いページネーションが可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CreatePitRequest.java | `server/src/main/java/org/opensearch/action/search/CreatePitRequest.java` | keepAlive, allowPartialPitCreation, indices等のフィールド |
| 1-2 | CreatePitResponse.java | `server/src/main/java/org/opensearch/action/search/CreatePitResponse.java` | pit_id, _shardsのレスポンス構造 |

**読解のコツ**: `CreatePitRequest`はkeepAlive（TimeValue）とallowPartialPitCreation（boolean）が主要なフィールドである。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestCreatePitAction.java | `server/src/main/java/org/opensearch/rest/action/search/RestCreatePitAction.java` | POSTハンドラの処理フロー |

**主要処理フロー**:
1. **行31**: ALLOW_PARTIAL_PIT_CREATION定数定義
2. **行32**: KEEP_ALIVE定数定義
3. **行40-49**: prepareRequest()でパラメータ解析とリクエスト生成
4. **行41**: allow_partial_pit_creationのデフォルト値true
5. **行43**: keep_aliveのTimeValueパース
6. **行44-47**: CreatePitRequest生成とオプション設定
7. **行49**: client.createPit()呼び出し

#### Step 3: トランスポート層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportCreatePitAction.java | `server/src/main/java/org/opensearch/action/search/TransportCreatePitAction.java` | PIT作成の実行と各シャードへのコンテキスト生成 |

### プログラム呼び出し階層図

```
RestCreatePitAction.prepareRequest()
    |
    +-- CreatePitRequest生成
    |      +-- TimeValue解析（keep_alive）
    |      +-- IndicesOptions設定
    |      +-- preference/routing設定
    |
    +-- client.createPit()
           +-- TransportCreatePitAction
                  +-- 対象シャード特定
                  +-- 各シャードにSearchContext作成
                  +-- PIT ID生成
                  +-- CreatePitResponse返却
```

### データフロー図

```
[入力]                        [処理]                              [出力]

HTTPリクエスト ──────> RestCreatePitAction ──────> JSON レスポンス
(POST)               ├─ パラメータ解析                ├─ pit_id
├─ index             ├─ CreatePitRequest生成          ├─ _shards
├─ keep_alive        └─> TransportCreatePitAction     └─ creation_time
├─ preference              ├─ シャード特定
└─ routing                 └─ SearchContext作成
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestCreatePitAction.java | `server/src/main/java/org/opensearch/rest/action/search/RestCreatePitAction.java` | ソース | RESTエンドポイントハンドラ |
| TransportCreatePitAction.java | `server/src/main/java/org/opensearch/action/search/TransportCreatePitAction.java` | ソース | トランスポート層アクション |
| CreatePitRequest.java | `server/src/main/java/org/opensearch/action/search/CreatePitRequest.java` | ソース | リクエストデータ構造 |
| CreatePitResponse.java | `server/src/main/java/org/opensearch/action/search/CreatePitResponse.java` | ソース | レスポンスデータ構造 |
| create_pit.json | `rest-api-spec/src/main/resources/rest-api-spec/api/create_pit.json` | 設定 | REST API仕様定義 |
| RestCreatePitActionTests.java | `server/src/test/java/org/opensearch/search/pit/RestCreatePitActionTests.java` | テスト | RESTハンドラのユニットテスト |
