# 画面設計書 35-PIT削除

## 概要

本ドキュメントは、OpenSearchのDelete Point in Time (PIT) APIエンドポイントに関する画面設計書である。指定したPIT IDに基づいてPoint in Timeコンテキストを削除し、クラスタリソースを解放するためのREST APIインターフェースを定義する。

### 本画面の処理概要

本APIは、PIT IDを指定して1つ以上のPoint in Timeコンテキストを削除する機能を提供する。

**業務上の目的・背景**：PIT作成API（No.34）で作成されたPITコンテキストは、keep_aliveで指定した時間が経過するまでクラスタのメモリリソースを消費し続ける。検索処理が完了した後、自動タイムアウトを待たずにPITコンテキストを即座に削除することで、クラスタリソースを効率的に運用できる。

**画面へのアクセス方法**：HTTPクライアントから `DELETE /_search/point_in_time` エンドポイントにリクエストを送信する。リクエストボディで削除対象のPIT IDを指定する。

**主要な操作・処理内容**：
1. リクエストボディで1つ以上のPIT IDを指定して削除する
2. 各ノードの対応するSearchContextを削除しリソースを解放する

**画面遷移**：PIT作成API（No.34）でPITを作成し、検索API（No.21）でPIT付き検索を実行した後に本APIを呼び出す。

**権限による表示制御**：PITコンテキストの所有者であれば削除が可能である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 23 | Point in Time（PIT） | 主機能 | IDベースでPoint in Time検索コンテキストを削除する処理 |

## 画面種別

API実行（リソース解放）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| DELETE | `/_search/point_in_time` | 指定PIT IDのコンテキスト削除 |

## 入出力項目

### パスパラメータ

本APIにはパスパラメータは存在しない。

### クエリパラメータ

本APIにはクエリパラメータは存在しない。

### リクエストボディ

| フィールド名 | 型 | 必須 | 説明 |
|-------------|------|------|------|
| pit_id | string/array | はい | 削除対象のPIT IDまたはIDリスト |

## 表示項目

### レスポンス

| フィールド名 | 型 | 説明 |
|-------------|------|------|
| pits | array | 削除されたPITの情報リスト |
| pits[].pit_id | string | 削除されたPIT ID |
| pits[].successful | boolean | 削除が成功したか |

## イベント仕様

### 1-PIT削除実行

1. `RestDeletePitAction.prepareRequest()`がDELETEリクエストを受け取る（行35）
2. リクエストパスに`_all`が含まれるかチェックする（行38）
3. `_all`でない場合、リクエストボディから`DeletePitRequest`を生成する（行41-50）
4. ボディの`fromXContent()`でPIT IDリストをパースする（行44-46）
5. `client.deletePits()`でTransport層に委譲する（行52）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| PIT削除 | SearchContext（メモリ） | DELETE | 指定PIT IDのSearchContextをメモリから削除 |

### テーブル別更新項目詳細

本APIはインデックスデータの変更は行わない。クラスタメモリ上のSearchContextオブジェクトを削除する。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|--------------|---------|
| - | 成功 | `{"pits": [{"pit_id": "...", "successful": true}]}` | PITが正常に削除された場合 |
| - | エラー | IllegalArgumentException | リクエストボディのパースに失敗した場合 |

## 例外処理

| 例外 | HTTPステータス | 説明 |
|------|--------------|------|
| IllegalArgumentException | 400 | リクエストボディのパースエラー |
| 無効なPIT ID | - | 存在しないPIT IDを指定した場合、successful=falseで返却 |

## 備考

- リクエストボディは必須であり、削除対象のPIT IDを指定する必要がある
- `RestDeletePitAction`は`DELETE /_search/point_in_time/_all`のルートも処理するが、`_all`を含むパスの場合は全PIT削除（No.36）として機能する
- 存在しないPIT IDを指定した場合でもHTTPエラーにはならず、pitsレスポンスのsuccessful=falseで結果が返される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DeletePitRequest.java | `server/src/main/java/org/opensearch/action/search/DeletePitRequest.java` | pit_idリストの保持、fromXContent()メソッド |
| 1-2 | DeletePitResponse.java | `server/src/main/java/org/opensearch/action/search/DeletePitResponse.java` | pitsリストとsuccessfulフラグの構造 |

**読解のコツ**: `DeletePitRequest`はコンストラクタでPIT IDリストを受け取る。`_all`の場合は特殊なリスト`["_all"]`が渡される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestDeletePitAction.java | `server/src/main/java/org/opensearch/rest/action/search/RestDeletePitAction.java` | DELETEハンドラの分岐処理（_allと個別ID） |

**主要処理フロー**:
1. **行56-58**: ルーティング定義（2つのDELETEエンドポイント）
2. **行36**: `_all`修飾子の定義
3. **行38**: パスに`_all`が含まれるかの分岐判定
4. **行39**: `_all`の場合、全PITを削除するDeletePitRequestを生成
5. **行41-50**: 通常の場合、ボディからPIT IDリストをパース
6. **行52**: client.deletePits()呼び出し

#### Step 3: トランスポート層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportDeletePitAction.java | `server/src/main/java/org/opensearch/action/search/TransportDeletePitAction.java` | PIT削除の実行と結果集約 |

### プログラム呼び出し階層図

```
RestDeletePitAction.prepareRequest()
    |
    +-- パス判定（_all含む?）
    |      +-- Yes: DeletePitRequest(["_all"])
    |      +-- No: ボディからDeletePitRequest生成
    |             +-- fromXContent() -- PIT IDリストパース
    |
    +-- client.deletePits()
           +-- TransportDeletePitAction
                  +-- 各ノードのSearchContext削除
                  +-- DeletePitResponse返却
```

### データフロー図

```
[入力]                        [処理]                              [出力]

HTTPリクエスト ──────> RestDeletePitAction ──────> JSON レスポンス
(DELETE)             ├─ _all判定                     ├─ pits[]
├─ pit_id (ボディ)   ├─ DeletePitRequest生成          │  ├─ pit_id
                     └─> TransportDeletePitAction     │  └─ successful
                          └─ SearchContext削除
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestDeletePitAction.java | `server/src/main/java/org/opensearch/rest/action/search/RestDeletePitAction.java` | ソース | RESTエンドポイントハンドラ |
| TransportDeletePitAction.java | `server/src/main/java/org/opensearch/action/search/TransportDeletePitAction.java` | ソース | トランスポート層アクション |
| DeletePitRequest.java | `server/src/main/java/org/opensearch/action/search/DeletePitRequest.java` | ソース | リクエストデータ構造 |
| DeletePitResponse.java | `server/src/main/java/org/opensearch/action/search/DeletePitResponse.java` | ソース | レスポンスデータ構造 |
| delete_pit.json | `rest-api-spec/src/main/resources/rest-api-spec/api/delete_pit.json` | 設定 | REST API仕様定義 |
| RestDeletePitActionTests.java | `server/src/test/java/org/opensearch/search/pit/RestDeletePitActionTests.java` | テスト | RESTハンドラのユニットテスト |
