# 画面設計書 36-全PIT削除

## 概要

本ドキュメントは、OpenSearchのDelete All PITs APIエンドポイントに関する画面設計書である。全てのアクティブなPoint in Timeコンテキストを一括削除し、クラスタリソースを解放するためのREST APIインターフェースを定義する。

### 本画面の処理概要

本APIは、クラスタ内の全ノードに存在する全てのアクティブなPITコンテキストを一括で削除する機能を提供する。

**業務上の目的・背景**：複数のPITコンテキストが蓄積してクラスタリソースを圧迫している場合や、メンテナンス作業前に全てのPITを一括クリアしたい場合に使用する。個別のPIT削除API（No.35）では対応しきれない大量のPITコンテキストを効率的に解放できる。

**画面へのアクセス方法**：HTTPクライアントから `DELETE /_search/point_in_time/_all` エンドポイントにリクエストを送信する。パラメータやリクエストボディは不要。

**主要な操作・処理内容**：
1. 全ノードの全アクティブPITコンテキストを一括削除する
2. 削除結果（成功/失敗）をレスポンスとして返却する

**画面遷移**：本APIは独立した運用操作として使用される。全PIT取得API（No.37）で現在のPIT一覧を確認した後に実行することが多い。

**権限による表示制御**：クラスタレベルの管理権限が必要である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 23 | Point in Time（PIT） | 主機能 | すべてのアクティブなPoint in Time検索コンテキストを削除する処理 |

## 画面種別

API実行（一括リソース解放）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| DELETE | `/_search/point_in_time/_all` | 全PITコンテキストの一括削除 |

## 入出力項目

### パスパラメータ

本APIにはパスパラメータは存在しない。

### クエリパラメータ

本APIにはクエリパラメータは存在しない。

### リクエストボディ

本APIにはリクエストボディは不要である。

## 表示項目

### レスポンス

| フィールド名 | 型 | 説明 |
|-------------|------|------|
| pits | array | 削除されたPITの情報リスト |
| pits[].pit_id | string | 削除されたPIT ID |
| pits[].successful | boolean | 削除が成功したか |

## イベント仕様

### 1-全PIT削除実行

1. `RestDeletePitAction.prepareRequest()`がDELETEリクエストを受け取る（行35）
2. リクエストパスに`_all`が含まれていることを検出する（行38）
3. `_all`を含むリストで`DeletePitRequest`を生成する（行39）
4. `client.deletePits()`でTransport層に委譲する（行52）
5. TransportDeletePitActionが全ノードの全PITコンテキストを削除する

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 全PIT削除 | SearchContext（メモリ） | DELETE | 全ノードの全PITコンテキストをメモリから削除 |

### テーブル別更新項目詳細

本APIはインデックスデータの変更は行わない。クラスタ全ノードのメモリ上にある全てのPIT SearchContextオブジェクトを削除する。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|--------------|---------|
| - | 成功 | `{"pits": [...]}` | 全PITが正常に削除された場合 |
| - | 部分成功 | 一部のpitsでsuccessful=false | 一部ノードで削除に失敗した場合 |

## 例外処理

| 例外 | HTTPステータス | 説明 |
|------|--------------|------|
| 権限不足 | 403 | クラスタ管理権限がない場合 |
| 内部エラー | 500 | ノード間通信エラーが発生した場合 |

## 備考

- 本APIはRestDeletePitActionの内部で`_all`パスの判定により処理が分岐する
- 全PITの削除は運用上の影響が大きいため、実行前に全PIT取得API（No.37）で現在のPIT一覧を確認することを推奨
- アクティブなPITが存在しない場合でもエラーにはならず、空のpitsリストで成功レスポンスが返る

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DeletePitRequest.java | `server/src/main/java/org/opensearch/action/search/DeletePitRequest.java` | _allリストを使用した全PIT削除のリクエスト構造 |
| 1-2 | DeletePitResponse.java | `server/src/main/java/org/opensearch/action/search/DeletePitResponse.java` | pitsリストのレスポンス構造 |

**読解のコツ**: 全PIT削除はPIT削除（No.35）と同じRestDeletePitActionとDeletePitRequest/Responseを共有する。`_all`をPIT IDとして指定することで全削除の振る舞いになる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestDeletePitAction.java | `server/src/main/java/org/opensearch/rest/action/search/RestDeletePitAction.java` | _all判定分岐とDeletePitRequest生成 |

**主要処理フロー**:
1. **行56-58**: ルーティング定義にDELETE `/_search/point_in_time/_all`が含まれる
2. **行36**: `allPitIdsQualifier = "_all"` 定数定義
3. **行38**: パスに`_all`が含まれるかの判定
4. **行39**: `_all`リストでDeletePitRequestを直接生成（ボディ不要）
5. **行52**: client.deletePits()呼び出し

#### Step 3: トランスポート層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportDeletePitAction.java | `server/src/main/java/org/opensearch/action/search/TransportDeletePitAction.java` | _all指定時の全ノード一括削除処理 |

### プログラム呼び出し階層図

```
RestDeletePitAction.prepareRequest()
    |
    +-- パス判定（_all含む → Yes）
    |      +-- DeletePitRequest(["_all"])生成
    |
    +-- client.deletePits()
           +-- TransportDeletePitAction
                  +-- 全ノードの全PITコンテキスト削除
                  +-- DeletePitResponse返却
```

### データフロー図

```
[入力]                        [処理]                              [出力]

HTTPリクエスト ──────> RestDeletePitAction ──────> JSON レスポンス
(DELETE)             ├─ _allパス判定                  ├─ pits[]
/_search/            ├─ DeletePitRequest(["_all"])    │  ├─ pit_id
point_in_time/_all   └─> TransportDeletePitAction     │  └─ successful
                          └─ 全SearchContext削除
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestDeletePitAction.java | `server/src/main/java/org/opensearch/rest/action/search/RestDeletePitAction.java` | ソース | RESTエンドポイントハンドラ（PIT削除と共有） |
| TransportDeletePitAction.java | `server/src/main/java/org/opensearch/action/search/TransportDeletePitAction.java` | ソース | トランスポート層アクション |
| DeletePitRequest.java | `server/src/main/java/org/opensearch/action/search/DeletePitRequest.java` | ソース | リクエストデータ構造 |
| DeletePitResponse.java | `server/src/main/java/org/opensearch/action/search/DeletePitResponse.java` | ソース | レスポンスデータ構造 |
| delete_all_pits.json | `rest-api-spec/src/main/resources/rest-api-spec/api/delete_all_pits.json` | 設定 | REST API仕様定義 |
