# 画面設計書 37-全PIT取得

## 概要

本ドキュメントは、OpenSearchのGet All PITs APIエンドポイントに関する画面設計書である。クラスタ内の全ノードで保持されている全てのアクティブなPoint in Timeコンテキストの一覧を取得するためのREST APIインターフェースを定義する。

### 本画面の処理概要

本APIは、全ノードに分散して保持されている全てのアクティブなPITコンテキストの情報を収集し、一覧として返却する機能を提供する。

**業務上の目的・背景**：クラスタ運用において、現在どのようなPITコンテキストがアクティブであるかを把握することは、リソース管理の観点から重要である。本APIにより、PITの一覧を確認し、不要なPITの削除判断やリソース使用状況のモニタリングが可能となる。

**画面へのアクセス方法**：HTTPクライアントから `GET /_search/point_in_time/_all` エンドポイントにリクエストを送信する。

**主要な操作・処理内容**：
1. クラスタ内の全ノードからアクティブなPIT情報を収集する
2. 収集結果をpitsリストとして返却する
3. 一部ノードで失敗した場合はfailuresリストも返却する

**画面遷移**：本APIで確認した後、不要なPITをPIT削除API（No.35）または全PIT削除API（No.36）で削除する流れが一般的である。

**権限による表示制御**：クラスタレベルの読み取り権限が必要である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 23 | Point in Time（PIT） | 主機能 | すべてのアクティブなPoint in Time検索コンテキストを一覧表示する処理 |

## 画面種別

API実行（一覧取得）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_search/point_in_time/_all` | 全アクティブPITの一覧取得 |

## 入出力項目

### パスパラメータ

本APIにはパスパラメータは存在しない。

### クエリパラメータ

本APIにはクエリパラメータは存在しない。

### リクエストボディ

本APIにはリクエストボディは不要である。

## 表示項目

### レスポンス

| フィールド名 | 型 | 説明 |
|-------------|------|------|
| pits | array | アクティブなPITの情報リスト |
| pits[].pit_id | string | PIT ID |
| pits[].creation_time | long | PIT作成時刻 |
| pits[].keep_alive | long | PIT存続時間（ミリ秒） |
| failures | array | 取得に失敗したノードの情報（エラー発生時のみ） |

## イベント仕様

### 1-全PIT取得実行

1. `RestGetAllPitsAction.prepareRequest()`がGETリクエストを受け取る（行52）
2. クラスタ内の全DiscoveryNodeを取得する（行53-56）
3. DiscoveryNodeリストから`GetAllPitNodesRequest`を生成する（行57-58）
4. `client.getAllPits()`でTransport層に委譲する（行59）
5. レスポンスビルダーで結果を構築する（行60-83）
6. 失敗がある場合はfailuresリストを追加する（行64-75）
7. pits情報をレスポンスに追加する（行76）
8. 全て失敗かつPITが空の場合は500、それ以外は200を返す（行78-81）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 全PIT取得 | なし | SELECT（読み取りのみ） | 全ノードからPIT情報を収集 |

### テーブル別更新項目詳細

本APIはデータの変更を行わない。全ノードのメモリ上のPITコンテキスト情報を読み取り専用で取得する。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|--------------|---------|
| - | 成功 | `{"pits": [...]}` | 全ノードからPIT情報を正常に取得した場合 |
| - | 部分成功 | `{"failures": [...], "pits": [...]}` | 一部ノードで取得に失敗した場合 |
| - | エラー | `{"failures": [...], "pits": []}` | 全ノードで失敗かつPITが空の場合（HTTP 500） |

## 例外処理

| 例外 | HTTPステータス | 説明 |
|------|--------------|------|
| 全ノード失敗+PIT空 | 500 | 全ノードからの取得に失敗しPIT情報が空の場合 |
| 部分失敗 | 200 | 一部ノードで失敗したがPIT情報は取得できた場合 |

## 備考

- 本APIは全ノードに対してブロードキャストリクエストを送信するため、大規模クラスタではレスポンスタイムが増加する可能性がある
- DiscoveryNodesからクラスタ全ノードを取得し、各ノードにリクエストを送信するNodes間通信パターンを使用する
- 失敗レスポンスにはノードIDとエラーの詳細メッセージが含まれる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | GetAllPitNodesRequest.java | `server/src/main/java/org/opensearch/action/search/GetAllPitNodesRequest.java` | 全ノードへのリクエスト構造（DiscoveryNode配列） |
| 1-2 | GetAllPitNodesResponse.java | `server/src/main/java/org/opensearch/action/search/GetAllPitNodesResponse.java` | PITInfo一覧とfailures一覧のレスポンス構造 |

**読解のコツ**: `GetAllPitNodesRequest`はBaseNodesRequestを継承し、全ノードに対してブロードキャストされるリクエストパターンである。レスポンスは各ノードの結果を集約する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestGetAllPitsAction.java | `server/src/main/java/org/opensearch/rest/action/search/RestGetAllPitsAction.java` | GETハンドラとレスポンス構築 |

**主要処理フロー**:
1. **行37-44**: コンストラクタでDiscoveryNodesサプライヤを受け取る
2. **行52-84**: prepareRequest()で全ノードリクエスト生成とレスポンスビルダー
3. **行53-57**: クラスタ全DiscoveryNodeの収集とDiscoveryNode配列の生成
4. **行58**: GetAllPitNodesRequest生成
5. **行59-83**: RestBuilderListenerで非同期レスポンス構築
6. **行64-75**: failuresがある場合のエラー情報追加
7. **行76**: PITInfo一覧の追加
8. **行78-81**: HTTP ステータスコードの判定（全失敗+空→500、それ以外→200）

#### Step 3: トランスポート層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportGetAllPitsAction.java | `server/src/main/java/org/opensearch/action/search/TransportGetAllPitsAction.java` | 各ノードからのPIT情報収集 |

### プログラム呼び出し階層図

```
RestGetAllPitsAction.prepareRequest()
    |
    +-- DiscoveryNodes取得
    |      +-- nodesInCluster.get() -- 全ノード列挙
    |      +-- DiscoveryNode[] 配列生成
    |
    +-- GetAllPitNodesRequest生成
    |
    +-- client.getAllPits()
    |      +-- TransportGetAllPitsAction
    |             +-- 各ノードからPIT情報収集
    |             +-- GetAllPitNodesResponse集約
    |
    +-- RestBuilderListener
           +-- failures情報追加（エラー時）
           +-- pits情報追加
           +-- HTTPステータス判定
```

### データフロー図

```
[入力]                        [処理]                              [出力]

HTTPリクエスト ──────> RestGetAllPitsAction ──────> JSON レスポンス
(GET)                ├─ DiscoveryNodes取得           ├─ pits[]
/_search/            ├─ GetAllPitNodesRequest生成    │  ├─ pit_id
point_in_time/_all   └─> TransportGetAllPitsAction   │  ├─ creation_time
                          ├─ 各ノードにリクエスト      │  └─ keep_alive
                          └─ PITInfo集約              └─ failures[]（エラー時）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestGetAllPitsAction.java | `server/src/main/java/org/opensearch/rest/action/search/RestGetAllPitsAction.java` | ソース | RESTエンドポイントハンドラ |
| TransportGetAllPitsAction.java | `server/src/main/java/org/opensearch/action/search/TransportGetAllPitsAction.java` | ソース | トランスポート層アクション |
| GetAllPitNodesRequest.java | `server/src/main/java/org/opensearch/action/search/GetAllPitNodesRequest.java` | ソース | リクエストデータ構造 |
| GetAllPitNodesResponse.java | `server/src/main/java/org/opensearch/action/search/GetAllPitNodesResponse.java` | ソース | レスポンスデータ構造 |
| get_all_pits.json | `rest-api-spec/src/main/resources/rest-api-spec/api/get_all_pits.json` | 設定 | REST API仕様定義 |
