# 画面設計書 38-インデックス作成

## 概要

本ドキュメントは、OpenSearchのCreate Index APIエンドポイントに関する画面設計書である。オプションの設定（settings）とマッピング（mappings）を指定してインデックスを作成するためのREST APIインターフェースを定義する。

### 本画面の処理概要

本APIは、OpenSearchクラスタに新しいインデックスを作成する機能を提供する。インデックスの設定（シャード数、レプリカ数等）、マッピング（フィールドの型定義）、エイリアスをリクエストボディで指定できる。

**業務上の目的・背景**：インデックスはOpenSearchにおけるデータ格納の基本単位であり、ドキュメントの登録・検索を行うためにまずインデックスを作成する必要がある。インデックス作成時に適切なシャード数、レプリカ数、マッピング定義を設定することで、データモデルに最適化されたパフォーマンスと可用性を実現する。テンプレート（No.62-74）が設定されている場合、テンプレートの設定が自動的に適用される。

**画面へのアクセス方法**：HTTPクライアントから `PUT /{index}` エンドポイントにリクエストを送信する。インデックス名はURLパスで指定する。

**主要な操作・処理内容**：
1. インデックス名を指定してPUTリクエストを送信する
2. リクエストボディで`settings`（シャード数、レプリカ数等）を指定する
3. リクエストボディで`mappings`（フィールドの型定義）を指定する
4. リクエストボディで`aliases`（エイリアス）を指定する
5. `wait_for_active_shards`で応答前に待機するアクティブシャード数を指定する

**画面遷移**：インデックス作成後、ドキュメント登録API（No.3）でドキュメントを登録する。マッピング更新API（No.51）でマッピングを変更する。設定更新API（No.54）で設定を変更する。エイリアス作成API（No.57）でエイリアスを追加する。インデックスクローン（No.45）、縮小（No.46）、分割（No.47）、ロールオーバー（No.48）の操作で新インデックスが作成される場合もある。

**権限による表示制御**：インデックス作成権限（indices:admin/create）が必要である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | インデックス作成 | 主機能 | オプションの設定とマッピングでインデックスを作成する主処理 |
| 17 | マッピング管理 | 補助機能 | インデックス作成時のマッピング定義適用処理 |
| 18 | インデックス設定管理 | 補助機能 | インデックス作成時の設定適用処理 |
| 7 | インデックステンプレート | 補助機能 | インデックス作成時のテンプレート自動適用処理 |

## 画面種別

API実行（リソース作成）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| PUT | `/{index}` | インデックスの作成 |

## 入出力項目

### パスパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|------|------|------|
| index | string | はい | 作成するインデックスの名前 |

### クエリパラメータ

| パラメータ名 | 型 | デフォルト値 | 説明 |
|-------------|------|------------|------|
| wait_for_active_shards | string | - | 応答前に待機するアクティブシャード数 |
| timeout | time | 30s | 操作のタイムアウト時間 |
| master_timeout | time | 30s | マスターノード接続のタイムアウト（非推奨、cluster_manager_timeout推奨） |
| cluster_manager_timeout | time | 30s | クラスタマネージャーノード接続のタイムアウト |

### リクエストボディ

| フィールド名 | 型 | 必須 | 説明 |
|-------------|------|------|------|
| settings | object | いいえ | インデックス設定（number_of_shards, number_of_replicas等） |
| mappings | object | いいえ | フィールドマッピング定義（properties内にフィールドの型定義） |
| aliases | object | いいえ | エイリアス定義 |

## 表示項目

### レスポンス

| フィールド名 | 型 | 説明 |
|-------------|------|------|
| acknowledged | boolean | クラスタマネージャーがリクエストを受理したか |
| shards_acknowledged | boolean | 必要なシャードが開始されたか |
| index | string | 作成されたインデックス名 |

## イベント仕様

### 1-インデックス作成実行

1. `RestCreateIndexAction.prepareRequest()`がPUTリクエストを受け取る（行75）
2. URLパスから`index`パラメータを取得し、`CreateIndexRequest`を生成する（行76）
3. リクエストボディがある場合、`XContentHelper.convertToMap()`でマップに変換する（行78-79）
4. `prepareMappings()`でマッピング定義を正規化する（行80）
5. `CreateIndexRequest.source()`でソースを設定する（行81）
6. タイムアウトパラメータを設定する（行84-88）
7. `wait_for_active_shards`を設定する（行89）
8. `client.admin().indices().create()`でTransport層に委譲する（行90）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| インデックス作成 | クラスタステート | INSERT | クラスタメタデータにインデックス情報を追加 |
| インデックス作成 | シャード | INSERT | プライマリシャードとレプリカシャードを割り当て |

### テーブル別更新項目詳細

#### クラスタステート（ClusterState）

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| INSERT | IndexMetadata | settings, mappings, aliasesを含むメタデータ | クラスタマネージャーが管理 |
| INSERT | IndexRoutingTable | シャードルーティング情報 | プライマリ/レプリカの配置情報 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|--------------|---------|
| - | 成功 | `{"acknowledged": true, "shards_acknowledged": true, "index": "..."}` | インデックスが正常に作成された場合 |
| - | エラー | ResourceAlreadyExistsException | 同名インデックスが既に存在する場合 |
| - | エラー | IllegalArgumentException | マッピング定義がネストされたtype定義の場合 |
| - | エラー | InvalidIndexNameException | インデックス名が無効な場合 |

## 例外処理

| 例外 | HTTPステータス | 説明 |
|------|--------------|------|
| ResourceAlreadyExistsException | 400 | 同名インデックスが既に存在する |
| InvalidIndexNameException | 400 | インデックス名が命名規則に違反している |
| IllegalArgumentException | 400 | マッピング定義がtype下にネストされている |
| ClusterManagerNotDiscoveredException | 503 | クラスタマネージャーが利用不可 |
| タイムアウト | 408 | 操作がタイムアウト時間内に完了しなかった |

## 備考

- インデックス名は小文字で始まり、特殊文字（`\`, `/`, `*`, `?`, `"`, `<`, `>`, `|`, ` `, `,`, `#`）を含んではならない
- `master_timeout`パラメータはOpenSearch 2.0.0で非推奨。`cluster_manager_timeout`の使用を推奨
- マッピング定義でtype名（`_doc`等）の下にネストする形式は許可されない（`prepareMappings()`でチェック）
- インデックステンプレートが存在する場合、テンプレートの設定が自動的にマージされる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CreateIndexRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/create/CreateIndexRequest.java` | settings, mappings, aliases, source()メソッド |
| 1-2 | CreateIndexResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/create/CreateIndexResponse.java` | acknowledged, shards_acknowledged, indexフィールド |

**読解のコツ**: `CreateIndexRequest`は`AcknowledgedRequest`を継承し、クラスタマネージャーへの要求パターンを使用する。`source()`メソッドでsettings/mappings/aliasesを一括設定可能。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestCreateIndexAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestCreateIndexAction.java` | PUTハンドラとマッピング正規化処理 |

**主要処理フロー**:
1. **行65-67**: ルーティング定義（PUT `/{index}`）
2. **行75-91**: prepareRequest()でリクエスト解析
3. **行76**: CreateIndexRequest生成（インデックス名取得）
4. **行78-81**: リクエストボディのマップ変換とマッピング正規化
5. **行84-88**: タイムアウトパラメータ設定
6. **行89**: wait_for_active_shards設定
7. **行90**: client.admin().indices().create()呼び出し
8. **行93-108**: prepareMappings()静的メソッド（type定義チェック）

#### Step 3: トランスポート層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportCreateIndexAction.java | `server/src/main/java/org/opensearch/action/admin/indices/create/TransportCreateIndexAction.java` | クラスタマネージャーへのインデックス作成要求とClusterState更新 |

### プログラム呼び出し階層図

```
RestCreateIndexAction.prepareRequest()
    |
    +-- CreateIndexRequest生成
    |      +-- XContentHelper.convertToMap() -- ボディ変換
    |      +-- prepareMappings() -- マッピング正規化
    |      +-- source() -- settings/mappings/aliases設定
    |      +-- ActiveShardCount.parseString() -- wait_for設定
    |
    +-- client.admin().indices().create()
           +-- TransportCreateIndexAction
                  +-- クラスタマネージャーにリクエスト転送
                  +-- MetadataCreateIndexService
                  |      +-- テンプレート適用
                  |      +-- マッピング検証
                  |      +-- インデックスメタデータ作成
                  +-- ClusterState更新
                  +-- シャード割り当て
```

### データフロー図

```
[入力]                        [処理]                              [出力]

HTTPリクエスト ──────> RestCreateIndexAction ──────> JSON レスポンス
(PUT)                ├─ ボディ解析                    ├─ acknowledged
├─ index (パス)      ├─ マッピング正規化              ├─ shards_acknowledged
├─ settings          ├─ CreateIndexRequest生成        └─ index
├─ mappings          └─> TransportCreateIndexAction
├─ aliases                ├─ クラスタマネージャ転送
└─ wait_for_active_shards ├─ テンプレート適用
                          ├─ ClusterState更新
                          └─ シャード割り当て
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestCreateIndexAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestCreateIndexAction.java` | ソース | RESTエンドポイントハンドラ |
| TransportCreateIndexAction.java | `server/src/main/java/org/opensearch/action/admin/indices/create/TransportCreateIndexAction.java` | ソース | トランスポート層アクション |
| CreateIndexRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/create/CreateIndexRequest.java` | ソース | リクエストデータ構造 |
| CreateIndexResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/create/CreateIndexResponse.java` | ソース | レスポンスデータ構造 |
| MetadataCreateIndexService.java | `server/src/main/java/org/opensearch/cluster/metadata/MetadataCreateIndexService.java` | ソース | インデックス作成のコアロジック |
| MapperService.java | `server/src/main/java/org/opensearch/index/mapper/MapperService.java` | ソース | マッピング管理サービス |
| indices.create.json | `rest-api-spec/src/main/resources/rest-api-spec/api/indices.create.json` | 設定 | REST API仕様定義 |
| RestCreateIndexActionTests.java | `server/src/test/java/org/opensearch/rest/action/admin/indices/RestCreateIndexActionTests.java` | テスト | RESTハンドラのユニットテスト |
