# 画面設計書 39-インデックス削除

## 概要

本ドキュメントは、OpenSearchのDelete Index APIエンドポイントに関する画面設計書である。指定したインデックスを削除するためのREST APIインターフェースを定義する。

### 本画面の処理概要

本APIは、1つ以上のインデックスを削除する機能を提供する。インデックスの削除は不可逆操作であり、インデックスに格納された全てのドキュメントとメタデータが完全に削除される。

**業務上の目的・背景**：不要になったインデックスや期限切れのログインデックス、テスト用インデックスを削除してディスク領域を解放する。インデックスライフサイクル管理において、データ保持期間を超えたインデックスの定期的な削除は運用上重要な作業である。また、データの再インデックスや構造変更を行う際に、古いインデックスを削除する場面でも使用される。

**画面へのアクセス方法**：HTTPクライアントから `DELETE /{index}` エンドポイントにリクエストを送信する。インデックス名はカンマ区切りで複数指定可能。

**主要な操作・処理内容**：
1. 削除対象のインデックス名を指定してDELETEリクエストを送信する
2. カンマ区切りで複数インデックスを一括削除する
3. ワイルドカード（`*`）を使用してパターンマッチで削除する
4. `_all`を指定して全インデックスを削除する（危険な操作）

**画面遷移**：本APIはインデックスライフサイクルの最終段階で使用される。インデックス情報取得API（No.40）で状態を確認した後に削除を実行する流れが一般的である。

**権限による表示制御**：インデックス削除権限（indices:admin/delete）が必要である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | インデックス削除 | 主機能 | 指定したインデックスを削除する主処理 |

## 画面種別

API実行（リソース削除）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| DELETE | `/` | 全インデックスの削除（`_all`相当） |
| DELETE | `/{index}` | 指定インデックスの削除 |

## 入出力項目

### パスパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|------|------|------|
| index | list | いいえ | カンマ区切りのインデックス名リスト。`_all`または`*`で全インデックス |

### クエリパラメータ

| パラメータ名 | 型 | デフォルト値 | 説明 |
|-------------|------|------------|------|
| timeout | time | 30s | 操作のタイムアウト時間 |
| master_timeout | time | 30s | マスターノード接続のタイムアウト（非推奨） |
| ignore_unavailable | boolean | false | 利用不可のインデックスを無視するか |
| allow_no_indices | boolean | false | ワイルドカードが解決されない場合に無視するか |
| expand_wildcards | enum | open | ワイルドカード展開の対象（open/closed/hidden/none/all） |

### リクエストボディ

本APIにはリクエストボディは不要である。

## 表示項目

### レスポンス

| フィールド名 | 型 | 説明 |
|-------------|------|------|
| acknowledged | boolean | クラスタマネージャーがリクエストを受理したか |

## イベント仕様

### 1-インデックス削除実行

1. `RestDeleteIndexAction.prepareRequest()`がDELETEリクエストを受け取る（行71）
2. URLパスから`index`パラメータを取得し、カンマ区切りで分割する（行72）
3. `DeleteIndexRequest`を生成する（行72）
4. タイムアウトパラメータを設定する（行73-77）
5. `IndicesOptions.fromRequest()`でインデックスオプションを設定する（行78）
6. `client.admin().indices().delete()`でTransport層に委譲する（行79）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| インデックス削除 | クラスタステート | DELETE | クラスタメタデータからインデックス情報を削除 |
| インデックス削除 | シャード | DELETE | プライマリシャードとレプリカシャードのデータを削除 |
| インデックス削除 | エイリアス | DELETE | インデックスに関連するエイリアスを削除 |

### テーブル別更新項目詳細

#### クラスタステート（ClusterState）

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| DELETE | IndexMetadata | 対象インデックスのメタデータを完全削除 | 不可逆操作 |
| DELETE | IndexRoutingTable | 対象インデックスのルーティング情報を削除 | シャード配置情報も削除 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|--------------|---------|
| - | 成功 | `{"acknowledged": true}` | インデックスが正常に削除された場合 |
| - | エラー | IndexNotFoundException | 指定インデックスが存在しない場合 |
| - | エラー | IllegalArgumentException | ワイルドカードで解決されるインデックスがない場合（allow_no_indices=false） |

## 例外処理

| 例外 | HTTPステータス | 説明 |
|------|--------------|------|
| IndexNotFoundException | 404 | 指定されたインデックスが存在しない |
| IllegalArgumentException | 400 | パラメータが不正 |
| ClusterManagerNotDiscoveredException | 503 | クラスタマネージャーが利用不可 |
| タイムアウト | 408 | 操作がタイムアウト時間内に完了しなかった |

## 備考

- インデックス削除は不可逆操作であるため、実行前にインデックス情報を確認すること
- `DELETE /` はルートパスへのDELETEで全インデックス削除となるため、`action.destructive_requires_name`設定でワイルドカード削除を無効化することを推奨
- `master_timeout`パラメータはOpenSearch 2.0.0で非推奨。`cluster_manager_timeout`の使用を推奨
- クローズ状態のインデックスも`expand_wildcards=closed`で削除対象にできる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DeleteIndexRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/delete/DeleteIndexRequest.java` | indices配列、timeout、indicesOptionsフィールド |
| 1-2 | AcknowledgedResponse.java | `server/src/main/java/org/opensearch/action/support/master/AcknowledgedResponse.java` | acknowledgedフラグのレスポンス基底クラス |

**読解のコツ**: `DeleteIndexRequest`は`AcknowledgedRequest`を継承し、`IndicesRequest.Replaceable`インターフェースを実装している。インデックス名はカンマ区切り文字列を配列に変換して保持する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestDeleteIndexAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestDeleteIndexAction.java` | DELETEハンドラの処理フロー |

**主要処理フロー**:
1. **行61-63**: ルーティング定義（DELETE `/`とDELETE `/{index}`の2パス）
2. **行71-79**: prepareRequest()でリクエスト解析
3. **行72**: Strings.splitStringByCommaToArrayでインデックス名分割とDeleteIndexRequest生成
4. **行73-77**: タイムアウト設定とDeprecationLogger
5. **行78**: IndicesOptions設定
6. **行79**: client.admin().indices().delete()呼び出し

#### Step 3: トランスポート層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportDeleteIndexAction.java | `server/src/main/java/org/opensearch/action/admin/indices/delete/TransportDeleteIndexAction.java` | クラスタマネージャーへの削除要求とClusterState更新 |

### プログラム呼び出し階層図

```
RestDeleteIndexAction.prepareRequest()
    |
    +-- DeleteIndexRequest生成
    |      +-- Strings.splitStringByCommaToArray() -- インデックス名分割
    |      +-- timeout設定
    |      +-- cluster_manager_timeout設定
    |      +-- IndicesOptions設定
    |
    +-- client.admin().indices().delete()
           +-- TransportDeleteIndexAction
                  +-- クラスタマネージャーにリクエスト転送
                  +-- MetadataDeleteIndexService
                  |      +-- インデックスメタデータ削除
                  |      +-- シャードデータ削除
                  +-- ClusterState更新
```

### データフロー図

```
[入力]                        [処理]                              [出力]

HTTPリクエスト ──────> RestDeleteIndexAction ──────> JSON レスポンス
(DELETE)             ├─ インデックス名解析             └─ acknowledged
├─ index (パス)      ├─ タイムアウト設定
├─ timeout           ├─ IndicesOptions設定
├─ ignore_unavailable└─> TransportDeleteIndexAction
└─ expand_wildcards       ├─ クラスタマネージャ転送
                          ├─ メタデータ削除
                          └─ シャードデータ削除
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestDeleteIndexAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestDeleteIndexAction.java` | ソース | RESTエンドポイントハンドラ |
| TransportDeleteIndexAction.java | `server/src/main/java/org/opensearch/action/admin/indices/delete/TransportDeleteIndexAction.java` | ソース | トランスポート層アクション |
| DeleteIndexRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/delete/DeleteIndexRequest.java` | ソース | リクエストデータ構造 |
| MetadataDeleteIndexService.java | `server/src/main/java/org/opensearch/cluster/metadata/MetadataDeleteIndexService.java` | ソース | インデックス削除のコアロジック |
| indices.delete.json | `rest-api-spec/src/main/resources/rest-api-spec/api/indices.delete.json` | 設定 | REST API仕様定義 |
