# 画面設計書 40-インデックス情報取得

## 概要

本ドキュメントは、OpenSearchのGet Index APIエンドポイントに関する画面設計書である。1つ以上のインデックスの設定（settings）、マッピング（mappings）、エイリアス（aliases）を含む詳細情報を取得するためのREST APIインターフェースを定義する。

### 本画面の処理概要

本APIは、指定したインデックスの設定、マッピング、エイリアスを含む包括的な情報を返却する機能を提供する。

**業務上の目的・背景**：インデックスの現在の状態（シャード数、レプリカ数、マッピング定義、エイリアス設定等）を確認することは、運用管理・トラブルシューティング・設計変更の検討において必要不可欠である。マッピング更新（No.51）や設定更新（No.54）を行う前の現状確認、またはインデックス削除（No.39）前の最終確認に使用される。

**画面へのアクセス方法**：HTTPクライアントから `GET /{index}` エンドポイントにリクエストを送信する。インデックス名はカンマ区切りで複数指定可能。

**主要な操作・処理内容**：
1. 指定インデックスの設定（settings）を取得する
2. 指定インデックスのマッピング（mappings）を取得する
3. 指定インデックスのエイリアス（aliases）を取得する
4. `include_defaults`パラメータでデフォルト設定値も含めて取得する
5. `flat_settings`パラメータでフラットなキー形式の設定を取得する

**画面遷移**：インデックス作成API（No.38）でインデックスを作成した後に本APIで情報を確認する。本APIの結果を元に、マッピング更新API（No.51）や設定更新API（No.54）での変更を行う。

**権限による表示制御**：対象インデックスに対する読み取り権限が必要である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | インデックス作成 | 主機能 | 1つ以上のインデックスの情報（設定・マッピング・エイリアス）を返す処理 |
| 17 | マッピング管理 | 補助機能 | インデックスのマッピング情報を取得する処理 |
| 18 | インデックス設定管理 | 補助機能 | インデックスの設定情報を取得する処理 |

## 画面種別

API実行（情報取得）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/{index}` | インデックス情報の取得 |
| HEAD | `/{index}` | インデックスの存在確認（No.41と共有） |

## 入出力項目

### パスパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|------|------|------|
| index | list | はい | カンマ区切りのインデックス名リスト |

### クエリパラメータ

| パラメータ名 | 型 | デフォルト値 | 説明 |
|-------------|------|------------|------|
| local | boolean | false | ローカルノードから情報を返すか（マスターノードに問い合わせない） |
| ignore_unavailable | boolean | false | 利用不可のインデックスを無視するか |
| allow_no_indices | boolean | false | ワイルドカードが解決されない場合に無視するか |
| expand_wildcards | enum | open | ワイルドカード展開の対象（open/closed/hidden/none/all） |
| flat_settings | boolean | false | フラットなキー形式で設定を返すか |
| include_defaults | boolean | false | デフォルト設定値も含めて返すか |
| master_timeout | time | 30s | マスターノード接続のタイムアウト（非推奨） |
| cluster_manager_timeout | time | 30s | クラスタマネージャーノード接続のタイムアウト |

### リクエストボディ

本APIにはリクエストボディは不要である。

## 表示項目

### レスポンス

| フィールド名 | 型 | 説明 |
|-------------|------|------|
| {index_name} | object | インデックス名をキーとするオブジェクト |
| {index_name}.aliases | object | エイリアス定義 |
| {index_name}.mappings | object | マッピング定義（properties内にフィールド型） |
| {index_name}.settings | object | インデックス設定（number_of_shards, number_of_replicas等） |
| {index_name}.settings.index.number_of_shards | string | プライマリシャード数 |
| {index_name}.settings.index.number_of_replicas | string | レプリカ数 |
| {index_name}.settings.index.creation_date | string | 作成日時（エポックミリ秒） |
| {index_name}.settings.index.uuid | string | インデックスUUID |

## イベント仕様

### 1-インデックス情報取得実行

1. `RestGetIndicesAction.prepareRequest()`がGETリクエストを受け取る（行74）
2. URLパスから`index`パラメータを取得し、カンマ区切りで分割する（行75）
3. `GetIndexRequest`を生成し、インデックス名を設定する（行76-77）
4. `IndicesOptions.fromRequest()`でインデックスオプションを設定する（行78）
5. `local`パラメータを設定する（行79）
6. `cluster_manager_timeout`パラメータを設定する（行80-83）
7. `human`パラメータと`include_defaults`パラメータを設定する（行84-85）
8. `client.admin().indices().getIndex()`でTransport層に委譲する（行86）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| インデックス情報取得 | なし | SELECT（読み取りのみ） | クラスタステートからインデックスメタデータを取得 |

### テーブル別更新項目詳細

本APIはデータの変更を行わない。クラスタステートに保持されているインデックスのメタデータ（settings, mappings, aliases）を読み取り専用で取得する。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|--------------|---------|
| - | 成功 | インデックスごとのaliases/mappings/settings情報 | インデックス情報が正常に取得された場合 |
| - | エラー | IndexNotFoundException | 指定インデックスが存在しない場合 |

## 例外処理

| 例外 | HTTPステータス | 説明 |
|------|--------------|------|
| IndexNotFoundException | 404 | 指定されたインデックスが存在しない |
| ClusterManagerNotDiscoveredException | 503 | クラスタマネージャーが利用不可（local=falseの場合） |

## 備考

- HEADメソッドはインデックスの存在確認（No.41）として機能し、レスポンスボディを返さない
- `local=true`の場合、ローカルノードのクラスタステートから情報を取得するため高速だが、最新でない可能性がある
- `include_defaults=true`で全デフォルト設定を含む詳細な情報が返るが、レスポンスサイズが大幅に増加する
- `flat_settings=true`で`index.number_of_shards`形式のフラットキーが返り、ネストされたJSON構造ではなくなる
- `master_timeout`パラメータはOpenSearch 2.0.0で非推奨。`cluster_manager_timeout`の使用を推奨
- `responseParams()`で`Settings.FORMAT_PARAMS`が返されるため、`format`パラメータ（yaml/json等）もサポートされる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | GetIndexRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/get/GetIndexRequest.java` | indices, features, includeDefaults, local等のフィールド |
| 1-2 | GetIndexResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/get/GetIndexResponse.java` | インデックスごとのaliases, mappings, settingsのレスポンス構造 |

**読解のコツ**: `GetIndexRequest`は`ClusterInfoRequest`を継承しており、クラスタステートからの情報取得パターンを使用する。`includeDefaults`フラグでデフォルト設定の含有を制御する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestGetIndicesAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestGetIndicesAction.java` | GET/HEADハンドラと各パラメータの設定処理 |

**主要処理フロー**:
1. **行64-66**: ルーティング定義（GET `/{index}`とHEAD `/{index}`）
2. **行74-86**: prepareRequest()でリクエスト解析
3. **行75**: Strings.splitStringByCommaToArrayでインデックス名分割
4. **行76-77**: GetIndexRequest生成とインデックス名設定
5. **行78**: IndicesOptions設定
6. **行79**: local設定
7. **行80-83**: cluster_manager_timeout設定とDeprecationLogger
8. **行84**: human設定
9. **行85**: includeDefaults設定
10. **行86**: client.admin().indices().getIndex()呼び出し
11. **行94-96**: responseParams()でSettings.FORMAT_PARAMSを返却

#### Step 3: トランスポート層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportGetIndexAction.java | `server/src/main/java/org/opensearch/action/admin/indices/get/TransportGetIndexAction.java` | クラスタステートからのインデックスメタデータ取得 |

### プログラム呼び出し階層図

```
RestGetIndicesAction.prepareRequest()
    |
    +-- GetIndexRequest生成
    |      +-- Strings.splitStringByCommaToArray() -- インデックス名分割
    |      +-- IndicesOptions設定
    |      +-- local設定
    |      +-- cluster_manager_timeout設定
    |      +-- includeDefaults設定
    |
    +-- client.admin().indices().getIndex()
           +-- TransportGetIndexAction
                  +-- ClusterState参照
                  +-- IndexMetadata取得
                  |      +-- settings取得
                  |      +-- mappings取得
                  |      +-- aliases取得
                  +-- GetIndexResponse返却
```

### データフロー図

```
[入力]                        [処理]                              [出力]

HTTPリクエスト ──────> RestGetIndicesAction ──────> JSON レスポンス
(GET)                ├─ インデックス名解析             ├─ {index_name}
├─ index (パス)      ├─ パラメータ設定                │  ├─ aliases
├─ local             ├─ GetIndexRequest生成           │  ├─ mappings
├─ flat_settings     └─> TransportGetIndexAction      │  └─ settings
├─ include_defaults       ├─ ClusterState参照
└─ expand_wildcards       └─ IndexMetadata取得
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestGetIndicesAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestGetIndicesAction.java` | ソース | RESTエンドポイントハンドラ |
| TransportGetIndexAction.java | `server/src/main/java/org/opensearch/action/admin/indices/get/TransportGetIndexAction.java` | ソース | トランスポート層アクション |
| GetIndexRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/get/GetIndexRequest.java` | ソース | リクエストデータ構造 |
| GetIndexResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/get/GetIndexResponse.java` | ソース | レスポンスデータ構造 |
| indices.get.json | `rest-api-spec/src/main/resources/rest-api-spec/api/indices.get.json` | 設定 | REST API仕様定義 |
