# 画面設計書 41-インデックス存在確認

## 概要

本ドキュメントは、OpenSearchのインデックス存在確認API（HEAD /{index}）の設計仕様を記述する。

### 本画面の処理概要

本APIは、指定したインデックスが存在するかどうかをHEADリクエストで確認するためのエンドポイントである。レスポンスボディを返さず、HTTPステータスコードのみで存在の有無を判定する。

**業務上の目的・背景**：インデックスの作成・削除・更新などの操作を行う前に、対象インデックスが存在するかどうかを事前確認する必要がある。本APIは軽量なHEADリクエストで高速にインデックスの存在を確認でき、ドキュメント登録やマッピング更新の前提条件チェック、自動化スクリプトにおけるインデックスの有無判定等に利用される。GETリクエストによるインデックス情報取得と異なり、レスポンスボディを含まないため、ネットワーク帯域を節約できる。

**画面へのアクセス方法**：`HEAD /{index}` エンドポイントにHTTPリクエストを送信する。カンマ区切りで複数のインデックス名を指定でき、ワイルドカード式も利用可能。

**主要な操作・処理内容**：
1. クライアントがHEADリクエストで対象インデックス名を指定して送信する
2. クラスタマネージャノードでインデックス名の解決を行う
3. IndexNameExpressionResolverがクラスタ状態からインデックスの存在を確認する
4. 存在する場合は200 OK、存在しない場合は404 Not Foundを返す

**画面遷移**：本APIは単独で利用されるほか、インデックス作成（PUT /{index}）前のチェック、インデックス削除（DELETE /{index}）前の確認、ドキュメント登録・更新の前提確認に利用される。

**権限による表示制御**：クラスタのメタデータ読み取り権限（METADATA_READ）が必要。権限がない場合はブロック例外が返される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | インデックス作成 | 主機能 | インデックスが存在するかをHEADリクエストで確認する処理 |

## 画面種別

参照（存在確認）

## URL/ルーティング

| メソッド | パス | 説明 |
|----------|------|------|
| HEAD | `/{index}` | 指定インデックスの存在確認 |

## 入出力項目

### パスパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|------|------|------|
| index | list(string) | はい | カンマ区切りのインデックス名リスト |

### クエリパラメータ

| パラメータ名 | 型 | デフォルト | 説明 |
|-------------|------|-----------|------|
| local | boolean | false | ローカル情報を返す（マスターノードから状態を取得しない） |
| ignore_unavailable | boolean | false | 利用不可能なインデックスを無視する |
| allow_no_indices | boolean | false | ワイルドカードが具象インデックスに解決されない場合に無視する |
| expand_wildcards | enum (open, closed, hidden, none, all) | open | ワイルドカード式の展開対象 |
| flat_settings | boolean | false | 設定をフラット形式で返す |
| include_defaults | boolean | false | デフォルト設定を含めるかどうか |

## 表示項目

本APIはHEADメソッドのため、レスポンスボディは返さない。HTTPステータスコードのみが返される。

| ステータスコード | 意味 |
|----------------|------|
| 200 OK | インデックスが存在する |
| 404 Not Found | インデックスが存在しない |

## イベント仕様

### 1-インデックス存在確認リクエスト送信

HEADリクエスト受信時、RestGetIndicesAction がリクエストを処理する。内部的には GetIndexRequest を構築し、クラスタ状態からインデックス名を解決する。TransportIndicesExistsAction では IndexNameExpressionResolver.concreteIndexNames() を呼び出し、IndexNotFoundException が発生しなければ存在と判定する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| HEAD /{index} | ClusterState（メモリ） | SELECT | クラスタ状態のメタデータからインデックスの存在を確認（データ変更なし） |

### テーブル別更新項目詳細

本APIは参照のみであり、データベースの更新は発生しない。

## メッセージ仕様

| メッセージ種別 | 条件 | HTTPステータス | 内容 |
|--------------|------|---------------|------|
| 成功 | インデックスが存在する | 200 | レスポンスボディなし |
| エラー | インデックスが存在しない | 404 | レスポンスボディなし |
| エラー | メタデータ読み取りブロック | 403/409 | クラスタブロックエラー |

## 例外処理

| 例外 | 条件 | 動作 |
|------|------|------|
| IndexNotFoundException | 指定インデックスが存在しない | 404 Not Found を返す |
| ClusterBlockException | メタデータ読み取りがブロックされている | 適切なエラーステータスを返す |

## 備考

- `RestGetIndicesAction` がHEAD /{index} とGET /{index} の両方を処理する。HEADリクエストの場合、内部的にはTransportIndicesExistsActionが使用される。
- 軽量なメモリ内チェックであり、SAMEスレッドプールで実行される（ThreadPool.Names.SAME）。
- ワイルドカード（例: `my-index-*`）やカンマ区切り（例: `index1,index2`）での複数指定が可能。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、リクエスト・レスポンスのデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | IndicesExistsRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/exists/indices/IndicesExistsRequest.java` | インデックス存在確認リクエストのフィールド構成（indices, indicesOptions）を確認 |
| 1-2 | IndicesExistsResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/exists/indices/IndicesExistsResponse.java` | exists フラグのみのシンプルなレスポンス構造を確認 |

**読解のコツ**: IndicesExistsRequest は IndicesRequest.Replaceable を実装しており、インデックス名の解決後に内部的にインデックス名が置換される。

#### Step 2: エントリーポイントを理解する

処理の起点となるRESTハンドラを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestGetIndicesAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestGetIndicesAction.java` | 65行目: HEAD /{index} のルーティング登録。HEADリクエストとGETリクエストの両方を処理する |

**主要処理フロー**:
1. **65行目**: `new Route(HEAD, "/{index}")` でHEADメソッドのルートを登録
2. **prepareRequest()**: リクエストパラメータを解析しGetIndexRequestを構築

#### Step 3: Transport層の処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportIndicesExistsAction.java | `server/src/main/java/org/opensearch/action/admin/indices/exists/indices/TransportIndicesExistsAction.java` | クラスタマネージャノード上での存在確認ロジック |

**主要処理フロー**:
- **84-87行目**: SAMEスレッドプールで実行（軽量なメモリ内チェック）
- **95-108行目**: checkBlock()でメタデータ読み取りブロックを確認
- **111-125行目**: clusterManagerOperation()でIndexNameExpressionResolver.concreteIndexNames()を呼び出し、IndexNotFoundExceptionの有無で存在を判定

#### Step 4: インデックス名解決を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | IndexNameExpressionResolver.java | `server/src/main/java/org/opensearch/cluster/metadata/IndexNameExpressionResolver.java` | ワイルドカード展開、エイリアス解決を含むインデックス名の解決ロジック |

### プログラム呼び出し階層図

```
RestGetIndicesAction (HEAD /{index})
    |
    +-- TransportIndicesExistsAction.clusterManagerOperation()
           |
           +-- IndexNameExpressionResolver.concreteIndexNames()
           |       |
           |       +-- ClusterState.metadata() から Index 情報を検索
           |
           +-- IndicesExistsResponse(exists=true/false)
```

### データフロー図

```
[入力]                      [処理]                              [出力]

HEAD /{index}         RestGetIndicesAction                HTTPステータスコード
  +                         |                                200 (存在する)
  index名             TransportIndicesExistsAction             or
  クエリパラメータ           |                                404 (存在しない)
                    IndexNameExpressionResolver
                           |
                    ClusterState.metadata()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| indices.exists.json | `rest-api-spec/src/main/resources/rest-api-spec/api/indices.exists.json` | API定義 | REST APIスペック定義 |
| RestGetIndicesAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestGetIndicesAction.java` | ソース | RESTハンドラ（HEAD /{index}を処理） |
| TransportIndicesExistsAction.java | `server/src/main/java/org/opensearch/action/admin/indices/exists/indices/TransportIndicesExistsAction.java` | ソース | 存在確認のTransportアクション |
| IndicesExistsRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/exists/indices/IndicesExistsRequest.java` | ソース | リクエストデータ構造 |
| IndicesExistsResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/exists/indices/IndicesExistsResponse.java` | ソース | レスポンスデータ構造 |
| IndicesExistsAction.java | `server/src/main/java/org/opensearch/action/admin/indices/exists/indices/IndicesExistsAction.java` | ソース | アクション定義 |
| IndexNameExpressionResolver.java | `server/src/main/java/org/opensearch/cluster/metadata/IndexNameExpressionResolver.java` | ソース | インデックス名解決ロジック |
| ActionModule.java | `server/src/main/java/org/opensearch/action/ActionModule.java` | ソース | アクション登録（695行目） |
