# 画面設計書 42-インデックスオープン

## 概要

本ドキュメントは、OpenSearchのインデックスオープンAPI（POST /{index}/_open）の設計仕様を記述する。

### 本画面の処理概要

本APIは、クローズ状態のインデックスをオープンし、検索・書き込みが可能な状態に復帰させるためのエンドポイントである。

**業務上の目的・背景**：インデックスクローズ（POST /{index}/_close）でリソース消費を抑制していたインデックスを、再度利用可能にする必要がある場合に使用する。一時的に不要なインデックスをクローズしてリソースを節約し、必要になった時点でオープンするというインデックスライフサイクル管理の中核を担うAPIである。データの参照や書き込みを再開するためには必ずオープン操作が必要となる。

**画面へのアクセス方法**：`POST /{index}/_open` エンドポイントにHTTPリクエストを送信する。カンマ区切りで複数のインデックス名を指定可能。

**主要な操作・処理内容**：
1. クライアントがPOSTリクエストでオープン対象のインデックス名を指定して送信する
2. RestOpenIndexActionがリクエストパラメータを解析しOpenIndexRequestを構築する
3. クラスタマネージャノードでクラスタ状態の更新（インデックスのオープン）が実行される
4. 指定された数のアクティブシャードが利用可能になるまで待機（wait_for_active_shards指定時）
5. 非同期実行（wait_for_completion=false）の場合、タスクIDが即時返却される
6. 処理結果（acknowledged, shards_acknowledged）をレスポンスとして返す

**画面遷移**：インデックスクローズ（POST /{index}/_close）でクローズしたインデックスを再開する。オープン後は検索（GET /{index}/_search）やドキュメント登録（PUT /{index}/_doc/{id}）が可能になる。

**権限による表示制御**：インデックスの管理権限が必要。クラスタブロックが設定されている場合は操作が拒否される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 3 | インデックスオープン/クローズ | 主機能 | インデックスをオープンして検索・書き込み可能にする処理 |

## 画面種別

実行（インデックス状態変更）

## URL/ルーティング

| メソッド | パス | 説明 |
|----------|------|------|
| POST | `/_open` | 全インデックスのオープン |
| POST | `/{index}/_open` | 指定インデックスのオープン |

## 入出力項目

### パスパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|------|------|------|
| index | list(string) | はい | カンマ区切りのインデックス名リスト |

### クエリパラメータ

| パラメータ名 | 型 | デフォルト | 説明 |
|-------------|------|-----------|------|
| timeout | time | 30s | 操作タイムアウト |
| cluster_manager_timeout | time | 30s | クラスタマネージャノードへの接続タイムアウト |
| master_timeout | time | - | 非推奨（cluster_manager_timeoutを使用） |
| ignore_unavailable | boolean | false | 利用不可能なインデックスを無視する |
| allow_no_indices | boolean | false | ワイルドカードが解決されない場合に無視する |
| expand_wildcards | enum (open, closed, hidden, none, all) | closed | ワイルドカード式の展開対象 |
| wait_for_active_shards | string | - | アクティブシャードの待機数 |
| wait_for_completion | boolean | true | falseの場合、タスクを即時返却しバックグラウンド実行 |
| task_execution_timeout | time | 1h | タスク実行タイムアウト（wait_for_completion=false時のみ有効） |

## 表示項目

### 同期レスポンス（wait_for_completion=true）

| 項目名 | 型 | 説明 |
|--------|------|------|
| acknowledged | boolean | クラスタ状態の更新が認識されたか |
| shards_acknowledged | boolean | 指定数のシャードコピーが開始されたか |

### 非同期レスポンス（wait_for_completion=false）

| 項目名 | 型 | 説明 |
|--------|------|------|
| task | string | タスクID（ノードID:タスクID形式） |

## イベント仕様

### 1-インデックスオープンリクエスト送信（同期）

RestOpenIndexAction.prepareRequest()（76-89行目）がリクエストを処理する。OpenIndexRequestを構築し、パラメータ（timeout、cluster_manager_timeout、indicesOptions、wait_for_active_shards）を設定する。wait_for_completionがtrue（デフォルト）の場合、client.admin().indices().open()を呼び出して同期的に結果を待つ。

### 2-インデックスオープンリクエスト送信（非同期）

wait_for_completion=falseの場合（90-110行目）、setShouldStoreResult(true)を設定してタスクとして非同期実行する。task_execution_timeout（デフォルト1h）がタイムアウトとして設定される。タスクIDが即座にレスポンスとして返却される。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| POST /{index}/_open | ClusterState（メモリ） | UPDATE | クラスタ状態のインデックスメタデータを更新（state: close -> open） |

### テーブル別更新項目詳細

#### ClusterState.metadata.indices

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | IndexMetadata.state | State.OPEN | インデックスの状態をクローズからオープンに変更 |

## メッセージ仕様

| メッセージ種別 | 条件 | HTTPステータス | 内容 |
|--------------|------|---------------|------|
| 成功 | インデックスのオープンが完了 | 200 | {"acknowledged": true, "shards_acknowledged": true} |
| 成功（タスク） | 非同期実行開始 | 200 | {"task": "node_id:task_id"} |
| エラー | インデックスが見つからない | 404 | index_not_found_exception |
| エラー | タイムアウト | 408 | acknowledged=falseまたはshards_acknowledged=false |

## 例外処理

| 例外 | 条件 | 動作 |
|------|------|------|
| IndexNotFoundException | 指定インデックスが存在しない | 404エラーを返す |
| ClusterBlockException | クラスタブロックが設定されている | 409エラーを返す |
| ActionRequestValidationException | リクエストバリデーション失敗（非同期時） | 400エラーを返す |

## 備考

- expand_wildcardsのデフォルト値がclosedに設定されている点に注意。これはオープン操作の対象がクローズ済みインデックスであることを反映している。
- master_timeoutパラメータはOpenSearch 2.0.0で非推奨となり、cluster_manager_timeoutの使用が推奨される。
- 非同期実行時のtask_execution_timeoutのデフォルトは1時間。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | OpenIndexRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/open/OpenIndexRequest.java` | timeout、indicesOptions、waitForActiveShards等のリクエストフィールドを確認 |
| 1-2 | OpenIndexResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/open/OpenIndexResponse.java` | acknowledged、shards_acknowledgedのレスポンス構造を確認 |

**読解のコツ**: OpenIndexRequestはAcknowledgedRequestを継承しており、timeout等の共通パラメータはスーパークラスで定義されている。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestOpenIndexAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestOpenIndexAction.java` | 67行目: ルーティング定義、76行目: prepareRequest()の処理開始 |

**主要処理フロー**:
1. **67行目**: `POST /_open` と `POST /{index}/_open` のルート登録
2. **77行目**: OpenIndexRequestの構築（indexパラメータのパース）
3. **78-86行目**: timeout、cluster_manager_timeout、indicesOptions、waitForActiveShardsの設定
4. **88行目**: wait_for_completionの判定による同期/非同期分岐
5. **89行目**: 同期実行パス
6. **92-109行目**: 非同期実行パス（タスクとして実行）

#### Step 3: Transport層の処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportOpenIndexAction.java | `server/src/main/java/org/opensearch/action/admin/indices/open/TransportOpenIndexAction.java` | クラスタ状態を更新してインデックスをオープンする処理 |

### プログラム呼び出し階層図

```
RestOpenIndexAction.prepareRequest()
    |
    +-- [wait_for_completion=true]
    |       +-- NodeClient.admin().indices().open()
    |               +-- TransportOpenIndexAction
    |                       +-- MetadataIndexStateService.openIndex()
    |
    +-- [wait_for_completion=false]
            +-- NodeClient.executeLocally(OpenIndexAction.INSTANCE, ...)
                    +-- TransportOpenIndexAction（タスクとして実行）
                            +-- MetadataIndexStateService.openIndex()
```

### データフロー図

```
[入力]                      [処理]                              [出力]

POST /{index}/_open    RestOpenIndexAction                 JSON レスポンス
  +                         |                              {acknowledged: true,
  index名              OpenIndexRequest構築                  shards_acknowledged: true}
  timeout                   |                                    or
  wait_for_active_shards   TransportOpenIndexAction          {task: "id"}
                           |
                    MetadataIndexStateService.openIndex()
                           |
                    ClusterState更新（state: CLOSE -> OPEN）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| indices.open.json | `rest-api-spec/src/main/resources/rest-api-spec/api/indices.open.json` | API定義 | REST APIスペック定義 |
| RestOpenIndexAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestOpenIndexAction.java` | ソース | RESTハンドラ |
| OpenIndexRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/open/OpenIndexRequest.java` | ソース | リクエストデータ構造 |
| OpenIndexResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/open/OpenIndexResponse.java` | ソース | レスポンスデータ構造 |
| OpenIndexAction.java | `server/src/main/java/org/opensearch/action/admin/indices/open/OpenIndexAction.java` | ソース | アクション定義 |
| TransportOpenIndexAction.java | `server/src/main/java/org/opensearch/action/admin/indices/open/TransportOpenIndexAction.java` | ソース | Transport層処理 |
| MetadataIndexStateService.java | `server/src/main/java/org/opensearch/cluster/metadata/MetadataIndexStateService.java` | ソース | クラスタ状態更新ロジック |
