# 画面設計書 43-インデックスクローズ

## 概要

本ドキュメントは、OpenSearchのインデックスクローズAPI（POST /{index}/_close）の設計仕様を記述する。

### 本画面の処理概要

本APIは、インデックスをクローズし、検索・書き込みを停止してリソース消費を抑制するためのエンドポイントである。

**業務上の目的・背景**：長期間使用しないインデックスや過去のログデータインデックスなど、当面参照する必要がないインデックスをクローズすることで、ヒープメモリやファイルディスクリプタなどのクラスタリソースを節約できる。データ自体は保持されるため、必要時にオープン操作で復帰可能である。インデックスのライフサイクル管理において、削除ではなく一時的に無効化する中間手段として重要な役割を持つ。

**画面へのアクセス方法**：`POST /{index}/_close` エンドポイントにHTTPリクエストを送信する。カンマ区切りで複数のインデックス名を指定可能。

**主要な操作・処理内容**：
1. クライアントがPOSTリクエストでクローズ対象のインデックス名を指定して送信する
2. RestCloseIndexActionがリクエストパラメータを解析しCloseIndexRequestを構築する
3. クラスタマネージャノードでクラスタ状態の更新（インデックスのクローズ）が実行される
4. 指定された数のアクティブシャードが確認されるまで待機（wait_for_active_shards指定時）
5. 処理結果（acknowledged, shards_acknowledged, indices）をレスポンスとして返す

**画面遷移**：インデックスオープン（POST /{index}/_open）と対になる操作。クローズ後はインデックスへの検索・書き込みが不可になる。再度利用する場合はオープン操作が必要。

**権限による表示制御**：インデックスの管理権限が必要。クラスタブロックが設定されている場合は操作が拒否される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 3 | インデックスオープン/クローズ | 主機能 | インデックスをクローズしてリソース消費を抑制する処理 |

## 画面種別

実行（インデックス状態変更）

## URL/ルーティング

| メソッド | パス | 説明 |
|----------|------|------|
| POST | `/_close` | 全インデックスのクローズ |
| POST | `/{index}/_close` | 指定インデックスのクローズ |

## 入出力項目

### パスパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|------|------|------|
| index | list(string) | はい | カンマ区切りのインデックス名リスト |

### クエリパラメータ

| パラメータ名 | 型 | デフォルト | 説明 |
|-------------|------|-----------|------|
| timeout | time | 30s | 操作タイムアウト |
| cluster_manager_timeout | time | 30s | クラスタマネージャノードへの接続タイムアウト |
| master_timeout | time | - | 非推奨（cluster_manager_timeoutを使用） |
| ignore_unavailable | boolean | false | 利用不可能なインデックスを無視する |
| allow_no_indices | boolean | false | ワイルドカードが解決されない場合に無視する |
| expand_wildcards | enum (open, closed, hidden, none, all) | open | ワイルドカード式の展開対象 |
| wait_for_active_shards | string | - | アクティブシャードの待機数 |

## 表示項目

### レスポンス

| 項目名 | 型 | 説明 |
|--------|------|------|
| acknowledged | boolean | クラスタ状態の更新が認識されたか |
| shards_acknowledged | boolean | 指定数のシャードコピーが開始されたか |
| indices | object | インデックスごとのクローズ結果 |

## イベント仕様

### 1-インデックスクローズリクエスト送信

RestCloseIndexAction.prepareRequest()（72-85行目）がリクエストを処理する。CloseIndexRequestを構築し、パラメータ（cluster_manager_timeout、timeout、indicesOptions、wait_for_active_shards）を設定する。client.admin().indices().close()を呼び出して同期的に結果を待つ。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| POST /{index}/_close | ClusterState（メモリ） | UPDATE | クラスタ状態のインデックスメタデータを更新（state: open -> close） |

### テーブル別更新項目詳細

#### ClusterState.metadata.indices

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | IndexMetadata.state | State.CLOSE | インデックスの状態をオープンからクローズに変更 |

## メッセージ仕様

| メッセージ種別 | 条件 | HTTPステータス | 内容 |
|--------------|------|---------------|------|
| 成功 | インデックスのクローズが完了 | 200 | {"acknowledged": true, "shards_acknowledged": true, "indices": {...}} |
| エラー | インデックスが見つからない | 404 | index_not_found_exception |
| エラー | タイムアウト | 408 | acknowledged=false |

## 例外処理

| 例外 | 条件 | 動作 |
|------|------|------|
| IndexNotFoundException | 指定インデックスが存在しない | 404エラーを返す |
| ClusterBlockException | クラスタブロックが設定されている | 409エラーを返す |

## 備考

- expand_wildcardsのデフォルト値がopenに設定されている。これはクローズ操作の対象がオープン中のインデックスであることを反映している。
- master_timeoutパラメータはOpenSearch 2.0.0で非推奨。
- インデックスクローズ後もデータは保持されるが、クローズされたインデックスへの読み書きはエラーとなる。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CloseIndexRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/close/CloseIndexRequest.java` | timeout、indicesOptions、waitForActiveShards等のリクエストフィールドを確認 |
| 1-2 | CloseIndexResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/close/CloseIndexResponse.java` | acknowledged、shards_acknowledged、indicesのレスポンス構造を確認 |

**読解のコツ**: CloseIndexResponseにはインデックスごとの結果が含まれ、個別のシャード情報も返却される場合がある。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestCloseIndexAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestCloseIndexAction.java` | 63行目: ルーティング定義、72行目: prepareRequest()の処理開始 |

**主要処理フロー**:
1. **63行目**: `POST /_close` と `POST /{index}/_close` のルート登録
2. **73行目**: CloseIndexRequestの構築
3. **74-83行目**: cluster_manager_timeout、timeout、indicesOptions、waitForActiveShardsの設定
4. **84行目**: client.admin().indices().close()の呼び出し

#### Step 3: Transport層の処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportCloseIndexAction.java | `server/src/main/java/org/opensearch/action/admin/indices/close/TransportCloseIndexAction.java` | クラスタ状態を更新してインデックスをクローズする処理 |

### プログラム呼び出し階層図

```
RestCloseIndexAction.prepareRequest()
    |
    +-- NodeClient.admin().indices().close()
            +-- TransportCloseIndexAction
                    +-- MetadataIndexStateService.closeIndices()
                            +-- ClusterState更新
```

### データフロー図

```
[入力]                      [処理]                              [出力]

POST /{index}/_close   RestCloseIndexAction                JSON レスポンス
  +                         |                              {acknowledged: true,
  index名              CloseIndexRequest構築                 shards_acknowledged: true,
  timeout                   |                               indices: {...}}
  wait_for_active_shards   TransportCloseIndexAction
                           |
                    MetadataIndexStateService.closeIndices()
                           |
                    ClusterState更新（state: OPEN -> CLOSE）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| indices.close.json | `rest-api-spec/src/main/resources/rest-api-spec/api/indices.close.json` | API定義 | REST APIスペック定義 |
| RestCloseIndexAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestCloseIndexAction.java` | ソース | RESTハンドラ |
| CloseIndexRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/close/CloseIndexRequest.java` | ソース | リクエストデータ構造 |
| CloseIndexResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/close/CloseIndexResponse.java` | ソース | レスポンスデータ構造 |
| TransportCloseIndexAction.java | `server/src/main/java/org/opensearch/action/admin/indices/close/TransportCloseIndexAction.java` | ソース | Transport層処理 |
| MetadataIndexStateService.java | `server/src/main/java/org/opensearch/cluster/metadata/MetadataIndexStateService.java` | ソース | クラスタ状態更新ロジック |
