# 画面設計書 49-インデックス解決

## 概要

本ドキュメントは、OpenSearchのインデックス解決API（GET /_resolve/index/{name}）の設計仕様を記述する。

### 本画面の処理概要

本APIは、名前やワイルドカード式に一致するインデックス、エイリアス、データストリームの情報を解決して返すためのエンドポイントである。

**業務上の目的・背景**：複数のインデックス、エイリアス、データストリームが存在する環境において、特定の名前パターンに一致するリソースの種別と詳細を一括で確認する必要がある。例えば、`logs-*` というパターンで検索した際に、それがインデックスなのかエイリアスなのかデータストリームなのかを判別する場合に有用である。特にクロスクラスタ検索の設定確認やリソースのディスカバリーに使用される。

**画面へのアクセス方法**：`GET /_resolve/index/{name}` エンドポイントにHTTPリクエストを送信する。nameにはカンマ区切りの名前リストやワイルドカード式を指定可能。

**主要な操作・処理内容**：
1. クライアントがGETリクエストで名前パターンを指定して送信する
2. RestResolveIndexActionがリクエストパラメータを解析しResolveIndexAction.Requestを構築する
3. 指定パターンに一致するインデックス、エイリアス、データストリームを解決する
4. 各リソースの種別と属性情報をレスポンスとして返す

**画面遷移**：本APIは単独で利用される参照系APIである。インデックス作成（PUT /{index}）、エイリアス作成（PUT /{index}/_alias/{name}）、データストリーム作成（PUT /_data_stream/{name}）で作成されたリソースを一括で確認できる。

**権限による表示制御**：インデックスの読み取り権限が必要。アクセス可能なインデックスのみ結果に含まれる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | インデックスエイリアス | 主機能 | 一致するインデックス・エイリアス・データストリーム情報を返す処理 |
| 8 | データストリーム | 補助機能 | データストリームの解決処理 |

## 画面種別

参照（リソース解決）

## URL/ルーティング

| メソッド | パス | 説明 |
|----------|------|------|
| GET | `/_resolve/index/{name}` | 名前パターンに一致するリソースの解決 |

## 入出力項目

### パスパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|------|------|------|
| name | list(string) | はい | カンマ区切りの名前リストまたはワイルドカード式 |

### クエリパラメータ

| パラメータ名 | 型 | デフォルト | 説明 |
|-------------|------|-----------|------|
| expand_wildcards | enum (open, closed, hidden, none, all) | open | ワイルドカード式の展開対象 |

## 表示項目

### レスポンス

| 項目名 | 型 | 説明 |
|--------|------|------|
| indices | array | 一致するインデックスのリスト |
| indices[].name | string | インデックス名 |
| indices[].aliases | array | インデックスに関連付けられたエイリアスリスト |
| indices[].attributes | array | インデックスの属性（open/closed等） |
| aliases | array | 一致するエイリアスのリスト |
| aliases[].name | string | エイリアス名 |
| aliases[].indices | array | エイリアスが指すインデックスのリスト |
| data_streams | array | 一致するデータストリームのリスト |
| data_streams[].name | string | データストリーム名 |
| data_streams[].backing_indices | array | バッキングインデックスのリスト |
| data_streams[].timestamp_field | string | タイムスタンプフィールド名 |

## イベント仕様

### 1-インデックス解決リクエスト送信

RestResolveIndexAction.prepareRequest()（64-71行目）がリクエストを処理する。ResolveIndexAction.Requestを構築し、nameパラメータをカンマ区切りで分割してインデックス名の配列とする。IndicesOptionsをリクエストから取得し、client.admin().indices().resolveIndex()を呼び出す。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| GET /_resolve/index/{name} | ClusterState（メモリ） | SELECT | クラスタ状態からインデックス・エイリアス・データストリーム情報を検索（データ変更なし） |

### テーブル別更新項目詳細

本APIは参照のみであり、データベースの更新は発生しない。

## メッセージ仕様

| メッセージ種別 | 条件 | HTTPステータス | 内容 |
|--------------|------|---------------|------|
| 成功 | リソースの解決が完了 | 200 | {"indices": [...], "aliases": [...], "data_streams": [...]} |
| 成功（空結果） | 一致するリソースがない | 200 | {"indices": [], "aliases": [], "data_streams": []} |

## 例外処理

| 例外 | 条件 | 動作 |
|------|------|------|
| IndexNotFoundException | allow_no_indices=falseで一致なし | 404エラーを返す |

## 備考

- 本APIの安定性は「experimental」（実験的）に分類されている。
- クロスクラスタ検索のインデックス解決にも対応している。
- レスポンスにはインデックス、エイリアス、データストリームの3種類のリソースが含まれる。
- パスパラメータのnameにワイルドカード式を使用できる（例: `logs-*`）。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ResolveIndexAction.java | `server/src/main/java/org/opensearch/action/admin/indices/resolve/ResolveIndexAction.java` | Request/Response内部クラス、ResolvedIndex/ResolvedAlias/ResolvedDataStreamの構造を確認 |

**読解のコツ**: ResolveIndexActionは単一のファイルにRequest、Response、ResolvedIndex、ResolvedAlias、ResolvedDataStreamの全データ構造が定義されている。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestResolveIndexAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestResolveIndexAction.java` | 60行目: ルーティング定義、64行目: prepareRequest()の処理開始 |

**主要処理フロー**:
1. **60行目**: `GET /_resolve/index/{name}` のルート登録
2. **65行目**: nameパラメータをカンマ区切りで分割
3. **66-69行目**: ResolveIndexAction.Requestの構築（indices、IndicesOptions）
4. **70行目**: client.admin().indices().resolveIndex()の呼び出し

#### Step 3: Transport層の処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportResolveIndexAction.java | `server/src/main/java/org/opensearch/action/admin/indices/resolve/TransportResolveIndexAction.java` | インデックス・エイリアス・データストリームの解決ロジック |

### プログラム呼び出し階層図

```
RestResolveIndexAction.prepareRequest()
    |
    +-- ResolveIndexAction.Request(indices, indicesOptions)
    |
    +-- NodeClient.admin().indices().resolveIndex()
            +-- TransportResolveIndexAction
                    |
                    +-- ClusterState.metadata() からインデックス解決
                    +-- ClusterState.metadata().aliases() からエイリアス解決
                    +-- ClusterState.metadata().dataStreams() からデータストリーム解決
                    |
                    +-- ResolveIndexAction.Response(indices, aliases, dataStreams)
```

### データフロー図

```
[入力]                          [処理]                              [出力]

GET /_resolve/index/{name}  RestResolveIndexAction              JSON レスポンス
  +                               |                            {indices: [...],
  名前パターン            ResolveIndexAction.Request              aliases: [...],
  expand_wildcards               |                              data_streams: [...]}
                         TransportResolveIndexAction
                               |
                    ClusterState.metadata()
                    ├── indices解決
                    ├── aliases解決
                    └── dataStreams解決
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| indices.resolve_index.json | `rest-api-spec/src/main/resources/rest-api-spec/api/indices.resolve_index.json` | API定義 | REST APIスペック定義 |
| RestResolveIndexAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestResolveIndexAction.java` | ソース | RESTハンドラ |
| ResolveIndexAction.java | `server/src/main/java/org/opensearch/action/admin/indices/resolve/ResolveIndexAction.java` | ソース | アクション定義、Request/Response/解決結果データ構造 |
| TransportResolveIndexAction.java | `server/src/main/java/org/opensearch/action/admin/indices/resolve/TransportResolveIndexAction.java` | ソース | Transport層処理 |
