# 画面設計書 5-ドキュメント取得

## 概要

OpenSearchインデックスからドキュメントを取得するREST APIエンドポイント（GET /{index}/_doc/{id}）の設計書である。指定したインデックスとIDに対応するドキュメントのメタデータおよびソースデータをJSON形式で返却する。

### 本画面の処理概要

本APIは、ドキュメントIDを指定してインデックスからドキュメントを取得する機能を提供する。

**業務上の目的・背景**：検索エンジンに格納されたデータを個別に取得する基本的な操作である。特定のドキュメントの内容を確認したり、アプリケーションからIDベースでデータを参照する際に使用する。検索APIと異なり、IDを直接指定するためリアルタイム性が高く、リフレッシュを待たずにデータを取得可能である。

**画面へのアクセス方法**：HTTPクライアントからGETメソッドで `/{index}/_doc/{id}` にリクエストを送信する。

**主要な操作・処理内容**：
1. クライアントからGETリクエストを受信する
2. インデックス名、ドキュメントIDを解析する
3. リアルタイムまたは検索モードでドキュメントを取得する
4. ドキュメントのメタデータ（_index, _id, _version等）とソースデータをJSON形式で返却する
5. ドキュメントが存在しない場合は404を返す

**画面遷移**：ドキュメント登録・更新API（PUT/POST /{index}/_doc/{id}）で登録されたドキュメントを本APIで取得できる。取得後はドキュメント更新API（POST /{index}/_update/{id}）で部分更新が可能。

**権限による表示制御**：インデックスへの読み取り権限が必要。セキュリティプラグイン使用時はインデックス単位のアクセス制御が適用される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 11 | ドキュメント取得 | 主機能 | IDを指定してドキュメントを取得する主処理 |

## 画面種別

詳細（参照系API）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/{index}/_doc/{id}` | ドキュメントを取得する |

## 入出力項目

### パスパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|-----|------|------|
| index | string | はい | インデックス名 |
| id | string | はい | ドキュメントID |

### クエリパラメータ

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
|-------------|-----|------|----------|------|
| stored_fields | list | いいえ | - | 返却するストアドフィールドのカンマ区切りリスト |
| preference | string | いいえ | random | 操作を実行するノードまたはシャードの指定 |
| realtime | boolean | いいえ | true | リアルタイムモードで取得するか（trueの場合リフレッシュ不要） |
| refresh | boolean | いいえ | false | 取得前にシャードをリフレッシュする |
| routing | string | いいえ | - | ルーティング値 |
| _source | list | いいえ | true | _sourceフィールドの返却制御（true/false/フィールドリスト） |
| _source_excludes | list | いいえ | - | _sourceから除外するフィールドリスト |
| _source_includes | list | いいえ | - | _sourceから抽出するフィールドリスト |
| version | number | いいえ | - | 楽観的排他制御用バージョン番号 |
| version_type | enum (internal, external, external_gte, force) | いいえ | internal | バージョンタイプ |

### レスポンスボディ

| フィールド名 | 型 | 説明 |
|-------------|-----|------|
| _index | string | インデックス名 |
| _id | string | ドキュメントID |
| _version | number | ドキュメントバージョン |
| _seq_no | number | シーケンス番号 |
| _primary_term | number | プライマリターム |
| found | boolean | ドキュメントが見つかったか |
| _source | object | ドキュメントのソースデータ |

## 表示項目

レスポンスのJSON全フィールドが表示項目となる。`_source` パラメータにより返却されるフィールドを制御可能。

## イベント仕様

### 1-ドキュメント取得

1. GET `/{index}/_doc/{id}` リクエストを受信する
2. `RestGetAction.prepareRequest()` がリクエストパラメータを解析する（75-98行目）
3. `GetRequest` オブジェクトを構築する
4. `FetchSourceContext.parseFromRestRequest()` でソースフィルタリングを設定する（98行目）
5. `client.get()` でドキュメント取得を実行する（100行目）
6. ドキュメントが存在する場合はHTTP 200で返却、存在しない場合はHTTP 404で返却する（102-103行目）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| GET /{index}/_doc/{id} | 指定インデックス | SELECT | ドキュメントを取得する（更新なし） |

### テーブル別更新項目詳細

本APIはデータベース（インデックス）の更新を行わない。読み取り専用の操作である。

## メッセージ仕様

| メッセージ種別 | HTTPステータス | 条件 | メッセージ内容 |
|--------------|--------------|------|-------------|
| 成功（存在） | 200 OK | ドキュメントが見つかった場合 | found: true とドキュメントデータ |
| 成功（未存在） | 404 Not Found | ドキュメントが見つからない場合 | found: false |

## 例外処理

| 例外 | HTTPステータス | 条件 | レスポンス |
|------|--------------|------|----------|
| IndexNotFoundException | 404 | インデックスが存在しない場合 | index_not_found_exception |
| IllegalArgumentException | 400 | fieldsパラメータが使用された場合（非推奨） | "the parameter [fields] is no longer supported" |

## 備考

- `realtime` パラメータがデフォルトでtrueであるため、リフレッシュを待たずにドキュメントの最新バージョンを取得可能。
- `fields` パラメータは非推奨であり、代わりに `stored_fields` または `_source` を使用する必要がある（RestGetAction 81-86行目でチェック）。
- HEAD /{index}/_doc/{id}（ドキュメント存在確認API）もRestGetActionで処理される（71行目でHEADルートが登録）。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | GetRequest.java | `server/src/main/java/org/opensearch/action/get/GetRequest.java` | リクエストフィールド（index, id, routing, preference, realtime, storedFields等）を理解する |
| 1-2 | GetResponse.java | `server/src/main/java/org/opensearch/action/get/GetResponse.java` | レスポンス構造（index, id, version, found, source等）とisExists()メソッドを理解する |
| 1-3 | FetchSourceContext.java | `server/src/main/java/org/opensearch/search/fetch/subphase/FetchSourceContext.java` | _sourceフィルタリングの仕組みを理解する |

**読解のコツ**: GetResponseの `isExists()` メソッドの返り値がHTTPステータスの分岐（200 or 404）に直結する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestGetAction.java | `server/src/main/java/org/opensearch/rest/action/document/RestGetAction.java` | ルーティング（71行目）、パラメータ解析（75-98行目）、レスポンスのステータス判定（102-103行目）を確認する |

**主要処理フロー**:
1. **71行目**: GETとHEAD両方のルーティングを `/{index}/_doc/{id}` で登録
2. **76行目**: GetRequestをindex, idで初期化
3. **77-80行目**: refresh, routing, preference, realtimeパラメータの設定
4. **81-86行目**: 非推奨fieldsパラメータのチェック
5. **87-93行目**: stored_fieldsパラメータの処理
6. **95-96行目**: version, versionTypeの設定
7. **98行目**: FetchSourceContextの設定
8. **100-105行目**: client.get()の実行とレスポンスのステータス判定

#### Step 3: トランスポート層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportGetAction.java | `server/src/main/java/org/opensearch/action/get/TransportGetAction.java` | シャードへのルーティングとドキュメント取得処理を確認する |

### プログラム呼び出し階層図

```
RestGetAction.prepareRequest()
    |
    +-- GetRequest 構築（パラメータ解析）
    +-- FetchSourceContext 設定
    |
    +-- client.get(getRequest, listener)
            |
            +-- TransportGetAction
                    |
                    +-- ShardGetService.get()
                            |
                            +-- InternalEngine.get()
                                    |
                                    +-- Lucene IndexSearcher / TranslogReader
```

### データフロー図

```
[入力]                      [処理]                         [出力]

GET /{index}/_doc/{id}  --> RestGetAction               --> HTTP 200 (found)
                              |                              {
                              v                                "_index": "...",
                        GetRequest構築                         "_id": "...",
                              |                                "found": true,
                              v                                "_source": {...}
                        TransportGetAction                   }
                              |
                              v                          --> HTTP 404 (not found)
                        ShardGetService                      {
                              |                                "_index": "...",
                              v                                "_id": "...",
                        InternalEngine.get()                    "found": false
                        (Lucene/Translog)                    }
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestGetAction.java | `server/src/main/java/org/opensearch/rest/action/document/RestGetAction.java` | ソース | RESTハンドラ（エントリーポイント） |
| GetRequest.java | `server/src/main/java/org/opensearch/action/get/GetRequest.java` | ソース | リクエストオブジェクト |
| GetResponse.java | `server/src/main/java/org/opensearch/action/get/GetResponse.java` | ソース | レスポンスオブジェクト |
| TransportGetAction.java | `server/src/main/java/org/opensearch/action/get/TransportGetAction.java` | ソース | トランスポートアクション |
| FetchSourceContext.java | `server/src/main/java/org/opensearch/search/fetch/subphase/FetchSourceContext.java` | ソース | ソースフィルタリングコンテキスト |
| get.json | `rest-api-spec/src/main/resources/rest-api-spec/api/get.json` | 設定 | REST API仕様定義 |
