# 画面設計書 50-マッピング取得

## 概要

本ドキュメントは、OpenSearchのマッピング取得API（GET /{index}/_mapping）の設計仕様を記述する。

### 本画面の処理概要

本APIは、1つ以上のインデックスのマッピング定義を取得するためのエンドポイントである。マッピングはインデックス内のドキュメントのフィールド構造と型を定義するものである。

**業務上の目的・背景**：インデックスのスキーマ（フィールド名、データ型、アナライザー設定等）を確認する必要がある場合に使用する。マッピング更新前の現状確認、複数インデックス間のスキーマ差異の比較、トラブルシューティング時のフィールドマッピング確認などのユースケースがある。動的マッピングによって自動作成されたフィールドの型を確認する際にも重要である。

**画面へのアクセス方法**：`GET /{index}/_mapping` または `GET /_mapping` エンドポイントにHTTPリクエストを送信する。カンマ区切りで複数のインデックスを指定可能。

**主要な操作・処理内容**：
1. クライアントがGETリクエストで対象インデックス名を指定して送信する
2. RestGetMappingActionがリクエストパラメータを解析しGetMappingsRequestを構築する
3. クラスタマネージャノードからマッピング情報を取得する
4. MANAGEMENTスレッドプールでレスポンスのシリアライゼーションを実行する
5. マッピング定義をJSONとしてレスポンスに返す

**画面遷移**：インデックス作成（PUT /{index}）やマッピング更新（PUT /{index}/_mapping）後に、現在のマッピングを確認するために使用される。フィールドマッピング取得（GET /{index}/_mapping/field/{fields}）は個別フィールドの確認に使用する。

**権限による表示制御**：インデックスのメタデータ読み取り権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 17 | マッピング管理 | 主機能 | 1つ以上のインデックスのマッピングを返す処理 |

## 画面種別

参照（マッピング情報取得）

## URL/ルーティング

| メソッド | パス | 説明 |
|----------|------|------|
| GET | `/_mapping` | 全インデックスのマッピング取得 |
| GET | `/_mappings` | 全インデックスのマッピング取得（エイリアス） |
| GET | `/{index}/_mapping` | 指定インデックスのマッピング取得 |
| GET | `/{index}/_mappings` | 指定インデックスのマッピング取得（エイリアス） |

## 入出力項目

### パスパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|------|------|------|
| index | list(string) | いいえ | カンマ区切りのインデックス名リスト（省略時は全インデックス） |

### クエリパラメータ

| パラメータ名 | 型 | デフォルト | 説明 |
|-------------|------|-----------|------|
| ignore_unavailable | boolean | false | 利用不可能なインデックスを無視する |
| allow_no_indices | boolean | false | ワイルドカードが解決されない場合に無視する |
| expand_wildcards | enum (open, closed, hidden, none, all) | open | ワイルドカード式の展開対象 |
| cluster_manager_timeout | time | 30s | クラスタマネージャノードへの接続タイムアウト |
| master_timeout | time | - | 非推奨（cluster_manager_timeoutを使用、7.8.0以降はno-op） |
| local | boolean | false | 非推奨（7.8.0以降はno-op。マッピングは常にローカルから取得） |

## 表示項目

### レスポンス

レスポンスはインデックス名をキーとしたオブジェクトで、各インデックスのマッピング定義を含む。

```json
{
  "index_name": {
    "mappings": {
      "properties": {
        "field_name": {
          "type": "text",
          "analyzer": "standard"
        }
      }
    }
  }
}
```

| 項目名 | 型 | 説明 |
|--------|------|------|
| {index_name} | object | インデックス名をキーとしたマッピング情報 |
| {index_name}.mappings | object | マッピング定義 |
| {index_name}.mappings.properties | object | フィールドマッピングの一覧 |
| {index_name}.mappings.properties.{field} | object | 個々のフィールドの型情報 |
| {index_name}.mappings.properties.{field}.type | string | フィールドのデータ型 |

## イベント仕様

### 1-マッピング取得リクエスト送信

RestGetMappingAction.prepareRequest()（99-140行目）がリクエストを処理する。GetMappingsRequestを構築し、パラメータ（indices、indicesOptions、cluster_manager_timeout、local）を設定する。レスポンスの処理では、マッピングのXContentシリアライゼーションが重いため、MANAGEMENTスレッドプール（124行目: ThreadPool.Names.MANAGEMENT）で実行する。タイムアウト超過時はOpenSearchTimeoutExceptionをスローする（129-130行目）。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| GET /{index}/_mapping | ClusterState（メモリ） | SELECT | クラスタ状態からマッピング情報を取得（データ変更なし） |

### テーブル別更新項目詳細

本APIは参照のみであり、データベースの更新は発生しない。

## メッセージ仕様

| メッセージ種別 | 条件 | HTTPステータス | 内容 |
|--------------|------|---------------|------|
| 成功 | マッピング取得が完了 | 200 | {"index_name": {"mappings": {...}}} |
| エラー | インデックスが見つからない | 404 | index_not_found_exception |
| エラー | タイムアウト | 408 | OpenSearchTimeoutException |

## 例外処理

| 例外 | 条件 | 動作 |
|------|------|------|
| IndexNotFoundException | 指定インデックスが存在しない | 404エラーを返す |
| OpenSearchTimeoutException | レスポンスのシリアライゼーションがタイムアウト | 408エラーを返す |
| OpenSearchParseException | master_timeoutとcluster_manager_timeoutの両方が指定された | 400エラーを返す |

## 備考

- `_mapping` と `_mappings`（複数形）は同一のエンドポイントとして扱われる。
- master_timeoutパラメータは非推奨で、3.0.0で削除予定（70-71行目）。
- localパラメータは7.8.0以降はno-opとなり、マッピングは常にローカルから取得される。
- マッピングのXContentシリアライゼーションはIOスレッドでは重すぎるため、MANAGEMENTスレッドプールで実行される（122-137行目）。
- master_timeoutとcluster_manager_timeoutの両方を指定するとパースエラーとなる（109-111行目）。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | GetMappingsRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/mapping/get/GetMappingsRequest.java` | indices、indicesOptions、clusterManagerNodeTimeout、localのフィールドを確認 |
| 1-2 | GetMappingsResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/mapping/get/GetMappingsResponse.java` | インデックス名をキーとしたMappingMetadataのマッピング構造を確認 |
| 1-3 | MappingMetadata.java | `server/src/main/java/org/opensearch/cluster/metadata/MappingMetadata.java` | マッピング定義のデータ構造（source、type等）を確認 |

**読解のコツ**: GetMappingsResponseは ImmutableOpenMap<String, MappingMetadata> を保持しており、キーがインデックス名、値がそのインデックスのMappingMetadataとなる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestGetMappingAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestGetMappingAction.java` | 82-91行目: ルーティング定義、99行目: prepareRequest()の処理開始 |

**主要処理フロー**:
1. **83-89行目**: 4つのルート（`/_mapping`, `/_mappings`, `/{index}/_mapping`, `/{index}/_mappings`）を登録
2. **100行目**: indexパラメータのパース
3. **102-116行目**: GetMappingsRequestの構築（indices、indicesOptions、clusterManagerTimeout、local）
4. **107-113行目**: master_timeout/cluster_manager_timeout の排他チェック
5. **117行目**: client.admin().indices().getMappings()の呼び出し
6. **120-137行目**: RestActionListenerでレスポンスを処理（MANAGEMENTプールでシリアライズ）
7. **129-130行目**: タイムアウトチェック

#### Step 3: Transport層の処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportGetMappingsAction.java | `server/src/main/java/org/opensearch/action/admin/indices/mapping/get/TransportGetMappingsAction.java` | クラスタ状態からマッピング情報を取得するロジック |

### プログラム呼び出し階層図

```
RestGetMappingAction.prepareRequest()
    |
    +-- GetMappingsRequest(indices, indicesOptions, timeout)
    |
    +-- NodeClient.admin().indices().getMappings()
            +-- TransportGetMappingsAction
                    |
                    +-- ClusterState.metadata().findMappings()
                    |
                    +-- GetMappingsResponse(mappings)
    |
    +-- RestActionListener.processResponse()
            +-- ThreadPool(MANAGEMENT).execute()
                    +-- XContentBuilder でレスポンス構築
                    +-- タイムアウトチェック
```

### データフロー図

```
[入力]                          [処理]                              [出力]

GET /{index}/_mapping      RestGetMappingAction                JSON レスポンス
  +                              |                              {"index_name":
  index名(任意)          GetMappingsRequest構築                    {"mappings":
  cluster_manager_timeout        |                                  {"properties":
  expand_wildcards       TransportGetMappingsAction                    {...}}}}
                                |
                    ClusterState.metadata().findMappings()
                                |
                    [MANAGEMENTスレッドプール]
                    XContentシリアライゼーション
                                |
                    タイムアウトチェック
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| indices.get_mapping.json | `rest-api-spec/src/main/resources/rest-api-spec/api/indices.get_mapping.json` | API定義 | REST APIスペック定義 |
| RestGetMappingAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestGetMappingAction.java` | ソース | RESTハンドラ |
| GetMappingsRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/mapping/get/GetMappingsRequest.java` | ソース | リクエストデータ構造 |
| GetMappingsResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/mapping/get/GetMappingsResponse.java` | ソース | レスポンスデータ構造 |
| TransportGetMappingsAction.java | `server/src/main/java/org/opensearch/action/admin/indices/mapping/get/TransportGetMappingsAction.java` | ソース | Transport層処理 |
| MappingMetadata.java | `server/src/main/java/org/opensearch/cluster/metadata/MappingMetadata.java` | ソース | マッピングメタデータ |
