# 画面設計書 52-フィールドマッピング取得

## 概要

本ドキュメントは、OpenSearchのGet Field Mapping API（`GET /{index}/_mapping/field/{fields}`）に関する画面設計書である。特定フィールドのマッピング情報を取得するためのREST APIエンドポイントの仕様を定義する。

### 本画面の処理概要

本APIは、1つ以上のインデックスにおける指定フィールドのマッピング定義を返すエンドポイントである。

**業務上の目的・背景**：インデックス全体のマッピングではなく、特定フィールドのマッピング情報のみを効率的に取得したい場合に使用する。フィールド数が多いインデックスでは全マッピング取得よりも軽量であり、特定フィールドの型やアナライザ設定を素早く確認できる。開発時のデバッグや運用監視において、特定フィールドの設定確認に活用される。

**画面へのアクセス方法**：REST APIクライアントから `GET /_mapping/field/{fields}` または `GET /{index}/_mapping/field/{fields}` エンドポイントにリクエストを送信する。

**主要な操作・処理内容**：
1. 指定されたフィールドのマッピング定義をインデックスごとに取得して返却する
2. カンマ区切りで複数フィールドを指定可能
3. インデックス未指定の場合は全インデックスが対象となる
4. `include_defaults` オプションでデフォルトマッピング値も取得可能

**画面遷移**：マッピング取得（No.50）で全体マッピングを確認した後、特定フィールドの詳細を確認する場合に呼び出される。マッピング更新（No.51）の前後確認にも使用される。

**権限による表示制御**：Security Pluginが有効な場合、対象インデックスへの `indices:admin/mappings/fields/get` アクション権限が必要である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 17 | マッピング管理 | 主機能 | 1つ以上のフィールドのマッピングを返す処理 |

## 画面種別

API実行（参照系）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_mapping/field/{fields}` | 全インデックスの指定フィールドマッピングを取得 |
| GET | `/{index}/_mapping/field/{fields}` | 指定インデックスの指定フィールドマッピングを取得 |

## 入出力項目

### パスパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|------|------|------|
| index | list(string) | No | 対象インデックス名（カンマ区切りリスト） |
| fields | list(string) | Yes | 対象フィールド名（カンマ区切りリスト） |

### クエリパラメータ

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
|-------------|------|------|-----------|------|
| include_defaults | boolean | No | false | デフォルトマッピング値を含めるか |
| ignore_unavailable | boolean | No | false | 利用不可なインデックスを無視するか |
| allow_no_indices | boolean | No | false | ワイルドカードが何にもマッチしない場合にエラーにしないか |
| expand_wildcards | enum | No | open | ワイルドカード展開対象（open/closed/hidden/none/all） |
| local | boolean | No | false | ローカルノードの情報のみを返すか（非推奨） |

## 表示項目

### レスポンスボディ

| 項目 | 型 | 説明 |
|------|------|------|
| {index_name} | object | インデックス名をキーとしたマッピング情報 |
| {index_name}.mappings | object | マッピング情報 |
| {index_name}.mappings.{field_name} | object | フィールドのマッピング詳細 |
| {index_name}.mappings.{field_name}.full_name | string | フィールドの完全名 |
| {index_name}.mappings.{field_name}.mapping | object | フィールドのマッピング定義 |

## イベント仕様

### 1-フィールドマッピング取得リクエスト

1. クライアントがGETリクエストを送信
2. `RestGetFieldMappingAction.prepareRequest()` がリクエストを解析し、`GetFieldMappingsRequest` オブジェクトを生成
3. インデックス名とフィールド名をカンマ区切りで分割
4. `include_defaults`、`IndicesOptions`、`local` パラメータを設定
5. `TransportGetFieldMappingsAction` が指定インデックスのフィールドマッピングを取得
6. マッピングが見つからない場合は404ステータスを返却、見つかった場合は200ステータスで返却

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| フィールドマッピング取得 | クラスタメタデータ（IndexMetadata） | SELECT | インデックスのマッピング定義からフィールド情報を取得 |

### テーブル別更新項目詳細

本APIは参照系のため、データの更新は発生しない。

## メッセージ仕様

| メッセージ種別 | HTTPステータス | メッセージ内容 | 発生条件 |
|-------------|--------------|--------------|---------|
| 成功 | 200 | フィールドマッピング情報のJSON | マッピング取得が正常に完了 |
| 成功（該当なし） | 404 | 空のマッピング結果 | 指定フィールドが存在しない場合 |
| エラー | 404 | `no such index` | 指定インデックスが存在しない場合 |

## 例外処理

| 例外 | 条件 | 動作 |
|------|------|------|
| IndexNotFoundException | 指定したインデックスが存在しない | 404エラーを返却 |
| FieldMappingNotFound | 指定フィールドが存在しない | 404ステータスで空結果を返却 |

## 備考

- `local` パラメータは非推奨であり、将来のメジャーバージョンで削除予定。
- フィールド名にはワイルドカードが利用可能（例: `user.*`）。
- ネストされたフィールドも `parent.child` 形式で指定可能。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | GetFieldMappingsRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/mapping/get/GetFieldMappingsRequest.java` | リクエストモデル。indices、fields、includeDefaultsフィールドを確認 |
| 1-2 | GetFieldMappingsResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/mapping/get/GetFieldMappingsResponse.java` | レスポンスモデル。FieldMappingMetadata内部クラスを確認 |

**読解のコツ**: `FieldMappingMetadata` はフィールドの完全名（full_name）とマッピング定義（source）を保持する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestGetFieldMappingAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestGetFieldMappingAction.java` | RESTリクエストの解析とレスポンス構築 |

**主要処理フロー**:
1. **行73**: ルーティング定義（GET `/_mapping/field/{fields}` および `/{index}/_mapping/field/{fields}`）
2. **行83-84**: インデックス名とフィールド名をカンマ区切りで分割
3. **行87**: `include_defaults` パラメータの設定
4. **行90-95**: `local` パラメータの非推奨警告
5. **行97-111**: レスポンス構築。マッピングが空でフィールド指定がある場合はNOT_FOUNDステータス

#### Step 3: トランスポート層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportGetFieldMappingsAction.java | `server/src/main/java/org/opensearch/action/admin/indices/mapping/get/TransportGetFieldMappingsAction.java` | フィールドマッピングの取得処理 |

### プログラム呼び出し階層図

```
RestGetFieldMappingAction.prepareRequest() [行82-112]
    │
    ├─ Strings.splitStringByCommaToArray() [行83-84] - パラメータ分割
    │
    └─ NodeClient.admin().indices().getFieldMappings() [行97]
           │
           └─ TransportGetFieldMappingsAction.doExecute()
                  │
                  └─ MapperService.fieldMappings() - フィールドマッピング取得
```

### データフロー図

```
[入力]                                    [処理]                              [出力]

GET /{index}/_mapping/field/{fields} ───▶ RestGetFieldMappingAction         ───▶ フィールドマッピングJSON
                                            │                                    (インデックス別)
                                            ├─ パラメータ解析
                                            └─ TransportGetFieldMappingsAction
                                                  │
                                                  └─ クラスタ状態から
                                                     マッピング情報を抽出
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestGetFieldMappingAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestGetFieldMappingAction.java` | ソース | RESTエンドポイントハンドラ |
| TransportGetFieldMappingsAction.java | `server/src/main/java/org/opensearch/action/admin/indices/mapping/get/TransportGetFieldMappingsAction.java` | ソース | トランスポートアクション |
| GetFieldMappingsRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/mapping/get/GetFieldMappingsRequest.java` | ソース | リクエストモデル |
| GetFieldMappingsResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/mapping/get/GetFieldMappingsResponse.java` | ソース | レスポンスモデル |
| indices.get_field_mapping.json | `rest-api-spec/src/main/resources/rest-api-spec/api/indices.get_field_mapping.json` | 設定 | REST API仕様定義 |
