# 画面設計書 53-設定取得

## 概要

本ドキュメントは、OpenSearchのGet Settings API（`GET /{index}/_settings`）に関する画面設計書である。インデックスの設定情報を取得するためのREST APIエンドポイントの仕様を定義する。

### 本画面の処理概要

本APIは、1つ以上のインデックスの設定（シャード数、レプリカ数、リフレッシュ間隔等）を返すエンドポイントである。

**業務上の目的・背景**：インデックスの動作を制御する設定値（number_of_shards、number_of_replicas、refresh_interval等）を確認するために使用する。運用監視、トラブルシューティング、設定変更前の現状確認など多様な場面で必要となる。特定の設定名を指定して絞り込み取得することも可能であり、大規模クラスタでの効率的な設定確認に活用される。

**画面へのアクセス方法**：REST APIクライアントから `GET /_settings`、`GET /{index}/_settings`、または `GET /{index}/_settings/{name}` エンドポイントにリクエストを送信する。

**主要な操作・処理内容**：
1. 指定されたインデックスの設定情報をクラスタ状態から取得して返却する
2. 設定名のフィルタリングにより特定の設定のみを取得可能
3. `flat_settings` オプションでフラット形式（ドット区切り）での出力が可能
4. `include_defaults` オプションでデフォルト設定値も取得可能

**画面遷移**：インデックス作成（No.38）やインデックス情報取得（No.40）の後に、設定の詳細確認のために呼び出される。設定更新（No.54）の前後確認にも使用される。

**権限による表示制御**：Security Pluginが有効な場合、対象インデックスへの `indices:monitor/settings/get` アクション権限が必要である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 18 | インデックス設定管理 | 主機能 | 1つ以上のインデックスの設定を返す処理 |

## 画面種別

API実行（参照系）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_settings` | 全インデックスの設定を取得 |
| GET | `/_settings/{name}` | 全インデックスの指定設定を取得 |
| GET | `/{index}/_settings` | 指定インデックスの設定を取得 |
| GET | `/{index}/_settings/{name}` | 指定インデックスの指定設定を取得 |
| GET | `/{index}/_setting/{name}` | 指定インデックスの指定設定を取得（単数形パス） |

## 入出力項目

### パスパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|------|------|------|
| index | list(string) | No | 対象インデックス名（カンマ区切り、`_all`で全インデックス） |
| name | list(string) | No | 取得する設定名（カンマ区切り） |

### クエリパラメータ

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
|-------------|------|------|-----------|------|
| cluster_manager_timeout | time | No | 30s | クラスタマネージャノードへの接続タイムアウト |
| master_timeout | time | No | 30s | クラスタマネージャノードへの接続タイムアウト（非推奨） |
| ignore_unavailable | boolean | No | false | 利用不可なインデックスを無視するか |
| allow_no_indices | boolean | No | false | ワイルドカードが何にもマッチしない場合にエラーにしないか |
| expand_wildcards | enum | No | all | ワイルドカード展開対象（open/closed/hidden/none/all） |
| flat_settings | boolean | No | false | フラット形式で設定を返すか |
| local | boolean | No | false | ローカルノードの情報のみを返すか |
| include_defaults | boolean | No | false | デフォルト設定値を含めるか |

## 表示項目

### レスポンスボディ

| 項目 | 型 | 説明 |
|------|------|------|
| {index_name} | object | インデックス名をキーとした設定情報 |
| {index_name}.settings | object | インデックスの設定 |
| {index_name}.settings.index | object | インデックス固有の設定 |
| {index_name}.defaults | object | デフォルト設定（include_defaults=trueの場合のみ） |

## イベント仕様

### 1-設定取得リクエスト

1. クライアントがGETリクエストを送信
2. `RestGetSettingsAction.prepareRequest()` がリクエストを解析し、`GetSettingsRequest` オブジェクトを生成
3. インデックス名と設定名のフィルタリング条件を設定
4. `IndicesOptions.strictExpandOpen()` をデフォルトとして `IndicesOptions` を解決
5. `TransportGetSettingsAction` がクラスタ状態からインデックス設定を取得
6. 設定情報をJSON形式で返却

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 設定取得 | クラスタメタデータ（IndexMetadata） | SELECT | インデックスの設定情報を取得 |

### テーブル別更新項目詳細

本APIは参照系のため、データの更新は発生しない。

## メッセージ仕様

| メッセージ種別 | HTTPステータス | メッセージ内容 | 発生条件 |
|-------------|--------------|--------------|---------|
| 成功 | 200 | インデックス設定情報のJSON | 設定取得が正常に完了 |
| エラー | 404 | `no such index` | 指定インデックスが存在しない場合 |

## 例外処理

| 例外 | 条件 | 動作 |
|------|------|------|
| IndexNotFoundException | 指定したインデックスが存在しない | 404エラーを返却 |

## 備考

- `expand_wildcards` のデフォルト値は `all`（open、closedインデックスの両方を含む）。
- `flat_settings=true` の場合、設定はドット区切りのフラットなキー形式で返却される（例: `index.number_of_replicas`）。
- `/_setting/{name}` パス（単数形）もサポートされている。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | GetSettingsRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/settings/get/GetSettingsRequest.java` | リクエストモデル。indices、names、includeDefaultsフィールドを確認 |
| 1-2 | GetSettingsResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/settings/get/GetSettingsResponse.java` | レスポンスモデル。インデックス別のSettings情報を確認 |

**読解のコツ**: OpenSearchの `Settings` クラスは階層的なキーバリューストアであり、`flat_settings` パラメータによって出力形式が変わる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestGetSettingsAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestGetSettingsAction.java` | RESTリクエストの解析 |

**主要処理フロー**:
1. **行62-70**: ルーティング定義（5つのパス）
2. **行80**: 設定名フィルタの取得
3. **行81**: `include_defaults` パラメータの解析
4. **行83**: `flat_settings` パラメータの消費（レスポンス時に使用）
5. **行84-88**: `GetSettingsRequest` の構築（indices、IndicesOptions、humanReadable、includeDefaults、names）
6. **行89**: `local` パラメータの設定
7. **行90-93**: `cluster_manager_timeout` の設定と非推奨 `master_timeout` の処理

#### Step 3: トランスポート層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportGetSettingsAction.java | `server/src/main/java/org/opensearch/action/admin/indices/settings/get/TransportGetSettingsAction.java` | クラスタ状態からインデックス設定を取得する処理 |

### プログラム呼び出し階層図

```
RestGetSettingsAction.prepareRequest() [行79-95]
    │
    ├─ request.paramAsStringArrayOrEmptyIfAll("name") [行80]
    │
    ├─ GetSettingsRequest構築 [行84-88]
    │      ├─ .indices() - インデックス指定
    │      ├─ .indicesOptions() - IndicesOptions設定
    │      ├─ .includeDefaults() - デフォルト値含有設定
    │      └─ .names() - 設定名フィルタ
    │
    └─ NodeClient.admin().indices().getSettings() [行94]
           │
           └─ TransportGetSettingsAction.masterOperation()
                  │
                  └─ ClusterState.metadata().index().getSettings()
```

### データフロー図

```
[入力]                         [処理]                              [出力]

GET /{index}/_settings    ───▶ RestGetSettingsAction              ───▶ 設定情報JSON
  ?flat_settings=true          │                                      (flat/階層形式)
  &include_defaults=true       ├─ パラメータ解析
                               └─ TransportGetSettingsAction
                                     │
                                     └─ クラスタ状態から設定取得
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestGetSettingsAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestGetSettingsAction.java` | ソース | RESTエンドポイントハンドラ |
| TransportGetSettingsAction.java | `server/src/main/java/org/opensearch/action/admin/indices/settings/get/TransportGetSettingsAction.java` | ソース | トランスポートアクション |
| GetSettingsRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/settings/get/GetSettingsRequest.java` | ソース | リクエストモデル |
| GetSettingsResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/settings/get/GetSettingsResponse.java` | ソース | レスポンスモデル |
| indices.get_settings.json | `rest-api-spec/src/main/resources/rest-api-spec/api/indices.get_settings.json` | 設定 | REST API仕様定義 |
