# 画面設計書 54-設定更新

## 概要

本ドキュメントは、OpenSearchのUpdate Settings API（`PUT /{index}/_settings`）に関する画面設計書である。インデックスの動的設定を更新するためのREST APIエンドポイントの仕様を定義する。

### 本画面の処理概要

本APIは、1つ以上のインデックスの動的設定（dynamic settings）を更新するエンドポイントである。

**業務上の目的・背景**：インデックスの動作パラメータ（レプリカ数、リフレッシュ間隔、マージポリシー等）を運用中に変更する必要がある場合に使用する。インデックスの再作成なしに設定を変更できるため、ダウンタイムなしでのパフォーマンスチューニングや運用調整が可能である。ただし、変更可能な設定は動的設定に限られ、静的設定（number_of_shardsなど）はインデックス作成時にのみ指定可能である。

**画面へのアクセス方法**：REST APIクライアントから `PUT /_settings` または `PUT /{index}/_settings` エンドポイントにリクエストを送信する。

**主要な操作・処理内容**：
1. リクエストボディに含まれる設定値を解析し、対象インデックスの設定を更新する
2. 複数インデックスを一括指定して設定変更可能
3. `preserve_existing` オプションで既存設定の上書きを防止可能
4. `flat_settings` オプションでフラット形式のレスポンスを取得可能

**画面遷移**：設定取得（No.53）で現在の設定を確認した後に呼び出される。更新後は設定取得（No.53）で変更結果を確認する。

**権限による表示制御**：Security Pluginが有効な場合、対象インデックスへの `indices:admin/settings/update` アクション権限が必要である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 18 | インデックス設定管理 | 主機能 | インデックス設定を動的に更新する処理 |

## 画面種別

API実行（更新系）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| PUT | `/_settings` | 全インデックスの設定を更新 |
| PUT | `/{index}/_settings` | 指定インデックスの設定を更新 |

## 入出力項目

### パスパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|------|------|------|
| index | list(string) | No | 対象インデックス名（カンマ区切り、`_all`で全インデックス） |

### クエリパラメータ

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
|-------------|------|------|-----------|------|
| timeout | time | No | 30s | 操作タイムアウト |
| cluster_manager_timeout | time | No | 30s | クラスタマネージャノードへの接続タイムアウト |
| master_timeout | time | No | 30s | クラスタマネージャノードへの接続タイムアウト（非推奨） |
| preserve_existing | boolean | No | false | 既存の設定を保持するか（trueの場合は既存設定を上書きしない） |
| ignore_unavailable | boolean | No | false | 利用不可なインデックスを無視するか |
| allow_no_indices | boolean | No | false | ワイルドカードが何にもマッチしない場合にエラーにしないか |
| expand_wildcards | enum | No | open | ワイルドカード展開対象（open/closed/hidden/none/all） |
| flat_settings | boolean | No | false | フラット形式で設定を返すか |

### リクエストボディ

| 項目 | 型 | 必須 | 説明 |
|------|------|------|------|
| (settings) | object | Yes | 更新する設定のキーバリュー |

## 表示項目

### レスポンスボディ

| 項目 | 型 | 説明 |
|------|------|------|
| acknowledged | boolean | リクエストが受理されたか |

## イベント仕様

### 1-設定更新リクエスト

1. クライアントがPUTリクエストを送信
2. `RestUpdateSettingsAction.prepareRequest()` がリクエストを解析し、`UpdateSettingsRequest` オブジェクトを生成
3. タイムアウト、preserve_existing、IndicesOptions を設定
4. リクエストボディから設定内容を `fromXContent()` で解析
5. `TransportUpdateSettingsAction` がクラスタマネージャノードに設定更新リクエストを転送
6. `MetadataUpdateSettingsService` がインデックス設定を更新
7. クラスタ状態が更新され、成功レスポンスを返却

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 設定更新リクエスト | クラスタメタデータ（IndexMetadata.settings） | UPDATE | インデックスの設定を更新 |

### テーブル別更新項目詳細

#### クラスタメタデータ（IndexMetadata.settings）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | Settings | リクエストボディで指定された設定値 | 動的設定のみ変更可能。preserve_existing=trueの場合は既存値を保持 |

## メッセージ仕様

| メッセージ種別 | HTTPステータス | メッセージ内容 | 発生条件 |
|-------------|--------------|--------------|---------|
| 成功 | 200 | `{"acknowledged": true}` | 設定更新が正常に完了 |
| エラー | 400 | `Can't update non dynamic settings` | 静的設定を変更しようとした場合 |
| エラー | 404 | `no such index` | 指定インデックスが存在しない場合 |
| エラー | 403 | アクセス拒否 | 権限不足の場合 |

## 例外処理

| 例外 | 条件 | 動作 |
|------|------|------|
| IndexNotFoundException | 指定したインデックスが存在しない | 404エラーを返却 |
| IllegalArgumentException | 静的設定を変更しようとした、不正な設定値 | 400エラーを返却 |
| ClusterManagerNotDiscoveredException | クラスタマネージャノードに接続不可 | 503エラーを返却 |

## 備考

- 静的設定（例: `index.number_of_shards`）はこのAPIでは変更できない。
- `preserve_existing=true` は、テンプレートから設定を適用する際に既存のカスタム設定を保持する場合に有用。
- `master_timeout` パラメータはバージョン2.0.0で非推奨。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | UpdateSettingsRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/settings/put/UpdateSettingsRequest.java` | リクエストモデル。settings、preserveExistingフィールドを確認 |

**読解のコツ**: `UpdateSettingsRequest` は `fromXContent()` メソッドでリクエストボディを解析する。Settings オブジェクトの構築方法を理解することが重要。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestUpdateSettingsAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestUpdateSettingsAction.java` | RESTリクエストの解析 |

**主要処理フロー**:
1. **行65**: ルーティング定義（PUT `/{index}/_settings` および `/_settings`）
2. **行75**: インデックス名の分割と `UpdateSettingsRequest` の生成
3. **行76**: timeout の設定
4. **行77**: `preserve_existing` パラメータの設定
5. **行78-81**: cluster_manager_timeout と非推奨 master_timeout の処理
6. **行82**: IndicesOptions の設定
7. **行83**: リクエストボディの解析（`fromXContent`）

#### Step 3: トランスポート層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportUpdateSettingsAction.java | `server/src/main/java/org/opensearch/action/admin/indices/settings/put/TransportUpdateSettingsAction.java` | クラスタマネージャノードでの設定更新処理 |

### プログラム呼び出し階層図

```
RestUpdateSettingsAction.prepareRequest() [行74-86]
    │
    ├─ UpdateSettingsRequest構築 [行75]
    │      ├─ .timeout() [行76]
    │      ├─ .setPreserveExisting() [行77]
    │      ├─ .clusterManagerNodeTimeout() [行78-79]
    │      ├─ .indicesOptions() [行82]
    │      └─ .fromXContent() [行83]
    │
    └─ NodeClient.admin().indices().updateSettings() [行85]
           │
           └─ TransportUpdateSettingsAction.masterOperation()
                  │
                  └─ MetadataUpdateSettingsService.updateSettings()
```

### データフロー図

```
[入力]                       [処理]                              [出力]

PUT /{index}/_settings  ───▶ RestUpdateSettingsAction           ───▶ {"acknowledged": true}
  + Request Body              │
  (設定JSON)                  ├─ パラメータ解析
                              ├─ UpdateSettingsRequest生成
                              └─ TransportUpdateSettingsAction
                                    │
                                    └─ MetadataUpdateSettingsService
                                          │
                                          └─ クラスタ状態更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestUpdateSettingsAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestUpdateSettingsAction.java` | ソース | RESTエンドポイントハンドラ |
| TransportUpdateSettingsAction.java | `server/src/main/java/org/opensearch/action/admin/indices/settings/put/TransportUpdateSettingsAction.java` | ソース | トランスポートアクション |
| UpdateSettingsRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/settings/put/UpdateSettingsRequest.java` | ソース | リクエストモデル |
| MetadataUpdateSettingsService.java | `server/src/main/java/org/opensearch/cluster/metadata/MetadataUpdateSettingsService.java` | ソース | 設定更新サービス |
| indices.put_settings.json | `rest-api-spec/src/main/resources/rest-api-spec/api/indices.put_settings.json` | 設定 | REST API仕様定義 |
