# 画面設計書 55-アナライズ

## 概要

本ドキュメントは、OpenSearchのAnalyze API（`GET/POST /{index}/_analyze`）に関する画面設計書である。テキストに対して解析プロセスを実行しトークン分解結果を返すREST APIエンドポイントの仕様を定義する。

### 本画面の処理概要

本APIは、指定されたテキストに対してアナライザ（トークナイザ＋トークンフィルタ＋文字フィルタ）を適用し、トークン分解結果を返すエンドポイントである。

**業務上の目的・背景**：全文検索の品質はアナライザの設定に大きく依存する。本APIを利用することで、テキストがどのようにトークン化されるかを事前に確認でき、アナライザの設定が期待通りに動作するかを検証できる。日本語テキストのトークン化、シノニム辞書の適用確認、カスタムアナライザのデバッグなど、検索品質チューニングにおいて不可欠なツールである。

**画面へのアクセス方法**：REST APIクライアントから `GET /_analyze`、`POST /_analyze`、`GET /{index}/_analyze`、または `POST /{index}/_analyze` エンドポイントにリクエストを送信する。

**主要な操作・処理内容**：
1. 指定されたテキストにアナライザを適用し、トークン分解結果を返却する
2. 組み込みアナライザまたはインデックスに定義されたカスタムアナライザを使用可能
3. アナライザの代わりにトークナイザ、フィルタ、文字フィルタを個別に指定して組み合わせ可能
4. `explain` オプションで各トークンの詳細情報（位置、属性）を取得可能
5. ノーマライザの適用も可能

**画面遷移**：インデックス作成（No.38）やマッピング更新（No.51）でアナライザを設定した後、その動作確認のために呼び出される。検索（No.21）のクエリ設計時にも使用される。

**権限による表示制御**：Security Pluginが有効な場合、インデックス指定時はそのインデックスへの `indices:admin/analyze` アクション権限が必要である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 70 | 共通アナライザ | 主機能 | テキストに対して解析プロセスを実行しトークン分解を返す処理 |

## 画面種別

API実行（参照系）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_analyze` | グローバルアナライザでテキストを解析 |
| POST | `/_analyze` | グローバルアナライザでテキストを解析 |
| GET | `/{index}/_analyze` | インデックスのアナライザでテキストを解析 |
| POST | `/{index}/_analyze` | インデックスのアナライザでテキストを解析 |

## 入出力項目

### パスパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|------|------|------|
| index | string | No | 対象インデックス名（指定時はそのインデックスのアナライザを使用） |

### リクエストボディ

| 項目 | 型 | 必須 | 説明 |
|------|------|------|------|
| analyzer | string | No | 使用するアナライザ名 |
| text | string/array | No | 解析対象テキスト（文字列または文字列配列） |
| field | string | No | マッピングからアナライザを導出するためのフィールド名 |
| tokenizer | string/object | No | 使用するトークナイザ |
| filter | array | No | 使用するトークンフィルタのリスト |
| char_filter | array | No | 使用する文字フィルタのリスト |
| explain | boolean | No | 詳細情報を含めるか |
| attributes | array | No | explain時に出力するトークン属性のフィルタ |
| normalizer | string | No | 使用するノーマライザ名 |

## 表示項目

### レスポンスボディ（通常モード）

| 項目 | 型 | 説明 |
|------|------|------|
| tokens | array | トークンの配列 |
| tokens[].token | string | トークン文字列 |
| tokens[].start_offset | integer | テキスト内の開始オフセット |
| tokens[].end_offset | integer | テキスト内の終了オフセット |
| tokens[].type | string | トークンタイプ |
| tokens[].position | integer | トークンの位置 |

### レスポンスボディ（explainモード）

| 項目 | 型 | 説明 |
|------|------|------|
| detail | object | 詳細解析結果 |
| detail.custom_analyzer | boolean | カスタムアナライザかどうか |
| detail.charfilters | array | 文字フィルタの適用結果 |
| detail.tokenizer | object | トークナイザの適用結果 |
| detail.tokenfilters | array | トークンフィルタの適用結果 |

## イベント仕様

### 1-アナライズリクエスト

1. クライアントがGET/POSTリクエストを送信
2. `RestAnalyzeAction.prepareRequest()` がリクエストボディを解析
3. `AnalyzeAction.Request.fromXContent()` でリクエストオブジェクトを構築
4. インデックス指定の有無に応じて適切なアナライザを選択
5. `TransportAnalyzeAction` がテキストの解析を実行
6. トークン分解結果をJSON形式で返却

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| アナライズリクエスト | なし | - | データの参照・更新は発生しない（テキスト解析のみ） |

### テーブル別更新項目詳細

本APIはテキスト解析のみを行い、データの更新は発生しない。

## メッセージ仕様

| メッセージ種別 | HTTPステータス | メッセージ内容 | 発生条件 |
|-------------|--------------|--------------|---------|
| 成功 | 200 | トークン分解結果のJSON | 解析が正常に完了 |
| エラー | 400 | `Unknown analyzer type` | 存在しないアナライザを指定した場合 |
| エラー | 404 | `no such index` | 指定インデックスが存在しない場合 |

## 例外処理

| 例外 | 条件 | 動作 |
|------|------|------|
| IndexNotFoundException | 指定したインデックスが存在しない | 404エラーを返却 |
| IllegalArgumentException | 不正なアナライザ指定、パラメータ不正 | 400エラーを返却 |

## 備考

- インデックスを指定しない場合は組み込みアナライザのみ使用可能。
- `text` を省略した場合はリクエストボディ全体がテキストとして扱われる。
- `field` を指定すると、そのフィールドのマッピングに定義されたアナライザが使用される。
- カスタムのトークナイザ・フィルタ・文字フィルタをインラインで定義して組み合わせ解析が可能。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AnalyzeAction.java | `server/src/main/java/org/opensearch/action/admin/indices/analyze/AnalyzeAction.java` | Request内部クラスのフィールド（analyzer、text、field、tokenizer、filter、char_filter、explain、attributes、normalizer）を確認 |

**読解のコツ**: `AnalyzeAction.Request` は `fromXContent()` でリクエストボディを解析する。`RestAnalyzeAction.Fields` に定義された `ParseField` とマッピングされている。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestAnalyzeAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestAnalyzeAction.java` | RESTリクエストの解析 |

**主要処理フロー**:
1. **行62-72**: `Fields` 内部クラスでリクエストボディのフィールド名定義（ANALYZER、TEXT、FIELD、TOKENIZER、TOKEN_FILTERS、CHAR_FILTERS、EXPLAIN、ATTRIBUTES、NORMALIZER）
2. **行76-83**: ルーティング定義（GET/POST `/_analyze` および `/{index}/_analyze`）
3. **行92-96**: リクエストボディ解析。`contentOrSourceParamParser()` でパーサを取得し、`AnalyzeAction.Request.fromXContent()` でリクエストを構築
4. **行95**: `client.admin().indices().analyze()` でトランスポートアクションを呼び出し

#### Step 3: トランスポート層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportAnalyzeAction.java | `server/src/main/java/org/opensearch/action/admin/indices/analyze/TransportAnalyzeAction.java` | テキスト解析の実行処理。アナライザの選択とトークン化処理 |

### プログラム呼び出し階層図

```
RestAnalyzeAction.prepareRequest() [行92-97]
    │
    ├─ request.contentOrSourceParamParser() [行93]
    │
    ├─ AnalyzeAction.Request.fromXContent() [行94]
    │
    └─ NodeClient.admin().indices().analyze() [行95]
           │
           └─ TransportAnalyzeAction.shardOperation()
                  │
                  ├─ AnalysisRegistry.buildAnalyzer() - アナライザの構築
                  │
                  └─ Analyzer.tokenStream() - テキストのトークン化
                         │
                         └─ トークン属性の収集と結果構築
```

### データフロー図

```
[入力]                        [処理]                              [出力]

POST /{index}/_analyze   ───▶ RestAnalyzeAction                 ───▶ tokens配列JSON
  + Request Body               │                                     または
  (analyzer, text等)           ├─ リクエストボディ解析                detail(explain)
                               └─ TransportAnalyzeAction
                                     │
                                     ├─ アナライザ選択/構築
                                     └─ テキスト解析
                                           │
                                           └─ トークン収集
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestAnalyzeAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestAnalyzeAction.java` | ソース | RESTエンドポイントハンドラ |
| TransportAnalyzeAction.java | `server/src/main/java/org/opensearch/action/admin/indices/analyze/TransportAnalyzeAction.java` | ソース | トランスポートアクション |
| AnalyzeAction.java | `server/src/main/java/org/opensearch/action/admin/indices/analyze/AnalyzeAction.java` | ソース | リクエスト・レスポンスモデル |
| AnalysisRegistry.java | `server/src/main/java/org/opensearch/index/analysis/AnalysisRegistry.java` | ソース | アナライザレジストリ |
| indices.analyze.json | `rest-api-spec/src/main/resources/rest-api-spec/api/indices.analyze.json` | 設定 | REST API仕様定義 |
