# 画面設計書 56-エイリアス取得

## 概要

本ドキュメントは、OpenSearchのGet Alias API（`GET /{index}/_alias/{name}`）に関する画面設計書である。インデックスエイリアスの情報を取得するためのREST APIエンドポイントの仕様を定義する。

### 本画面の処理概要

本APIは、インデックスに設定されたエイリアスの情報を返すエンドポイントである。

**業務上の目的・背景**：エイリアスはインデックスに対する仮想的な名前であり、アプリケーションが物理的なインデックス名を意識せずにデータにアクセスするために使用される。ローリングインデックス運用、フィルタ付きビュー、書き込み先の切り替えなどの機能を提供する。本APIはこれらのエイリアス設定の現状確認、運用監視、トラブルシューティングに使用される。

**画面へのアクセス方法**：REST APIクライアントから `GET /_alias`、`GET /_alias/{name}`、`GET /{index}/_alias`、または `GET /{index}/_alias/{name}` エンドポイントにリクエストを送信する。

**主要な操作・処理内容**：
1. 指定されたエイリアスの設定情報（フィルタ、ルーティング、書き込みインデックス等）を返却する
2. インデックス名とエイリアス名の両方でフィルタリング可能
3. ワイルドカードを使用した一括取得が可能
4. 存在しないエイリアスを指定した場合は404エラーとともに不足エイリアス名を返却する

**画面遷移**：エイリアス作成・更新（No.57）後に設定確認のために呼び出される。エイリアス一括更新（No.60）の前後確認にも使用される。インデックス情報取得（No.40）でも一部エイリアス情報を確認可能。

**権限による表示制御**：Security Pluginが有効な場合、対象インデックスへの `indices:admin/aliases/get` アクション権限が必要である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | インデックスエイリアス | 主機能 | エイリアスの情報を返す処理 |

## 画面種別

API実行（参照系）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_alias` | 全エイリアスを取得 |
| GET | `/_aliases` | 全エイリアスを取得（複数形パス） |
| GET | `/_alias/{name}` | 指定名のエイリアスを取得 |
| GET | `/{index}/_alias` | 指定インデックスのエイリアスを取得 |
| GET | `/{index}/_alias/{name}` | 指定インデックスの指定エイリアスを取得 |

## 入出力項目

### パスパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|------|------|------|
| index | list(string) | No | 対象インデックス名（カンマ区切りリスト） |
| name | list(string) | No | 対象エイリアス名（カンマ区切りリスト） |

### クエリパラメータ

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
|-------------|------|------|-----------|------|
| ignore_unavailable | boolean | No | false | 利用不可なインデックスを無視するか |
| allow_no_indices | boolean | No | false | ワイルドカードが何にもマッチしない場合にエラーにしないか |
| expand_wildcards | enum | No | all | ワイルドカード展開対象（open/closed/hidden/none/all） |
| local | boolean | No | false | ローカルノードの情報のみを返すか |

## 表示項目

### レスポンスボディ

| 項目 | 型 | 説明 |
|------|------|------|
| {index_name} | object | インデックス名をキーとしたエイリアス情報 |
| {index_name}.aliases | object | エイリアス名をキーとした設定情報 |
| {index_name}.aliases.{alias_name} | object | エイリアスの設定 |
| {index_name}.aliases.{alias_name}.filter | object | フィルタ定義（設定されている場合） |
| {index_name}.aliases.{alias_name}.index_routing | string | インデックスルーティング値 |
| {index_name}.aliases.{alias_name}.search_routing | string | 検索ルーティング値 |
| {index_name}.aliases.{alias_name}.is_write_index | boolean | 書き込みインデックスかどうか |
| {index_name}.aliases.{alias_name}.is_hidden | boolean | 隠しエイリアスかどうか |

## イベント仕様

### 1-エイリアス取得リクエスト

1. クライアントがGETリクエストを送信
2. `RestGetAliasesAction.prepareRequest()` がリクエストを解析し、`GetAliasesRequest` オブジェクトを生成
3. エイリアス名とインデックス名をパラメータから取得
4. `TransportGetAliasesAction` がクラスタ状態からエイリアス情報を取得
5. `buildRestResponse()` でレスポンスを構築
6. 明示的に要求されたエイリアスが見つからない場合は404ステータスとともに不足エイリアス名を返却

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| エイリアス取得 | クラスタメタデータ（AliasMetadata） | SELECT | インデックスのエイリアス情報を取得 |

### テーブル別更新項目詳細

本APIは参照系のため、データの更新は発生しない。

## メッセージ仕様

| メッセージ種別 | HTTPステータス | メッセージ内容 | 発生条件 |
|-------------|--------------|--------------|---------|
| 成功 | 200 | エイリアス情報のJSON | 要求されたエイリアスがすべて見つかった場合 |
| 部分成功 | 404 | `{"error": "alias [name] missing", ...}` + エイリアス情報 | 明示的に要求されたエイリアスの一部が見つからない場合 |
| エラー | 404 | `{"error": "aliases [name1,name2] missing", ...}` | 複数の明示的に要求されたエイリアスが見つからない場合 |

## 例外処理

| 例外 | 条件 | 動作 |
|------|------|------|
| IndexNotFoundException | 指定したインデックスが存在しない | 404エラーを返却 |
| AliasNotFound | 明示的に指定したエイリアスが存在しない | 404ステータスでエラーメッセージ付きレスポンスを返却 |

## 備考

- `expand_wildcards` のデフォルト値は `all`。
- ワイルドカードパターンでのエイリアス名指定が可能。
- HEAD メソッドでのエイリアス存在確認（No.59）も同じハンドラ（`RestGetAliasesAction`）で処理される。
- 不足エイリアスの検出ロジックでは、ワイルドカードパターンや除外パターン（`-alias_name`）は不足エイリアスとしてカウントされない。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AliasMetadata.java | `server/src/main/java/org/opensearch/cluster/metadata/AliasMetadata.java` | エイリアスのメタデータモデル。alias、filter、indexRouting、searchRouting、writeIndex、isHiddenフィールドを確認 |
| 1-2 | GetAliasesRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/alias/get/GetAliasesRequest.java` | リクエストモデル |
| 1-3 | GetAliasesResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/alias/get/GetAliasesResponse.java` | レスポンスモデル |

**読解のコツ**: `AliasMetadata` はクラスタ状態の `IndexMetadata` 内に保持される。エイリアスのフィルタは `CompressedXContent` として格納される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestGetAliasesAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestGetAliasesAction.java` | RESTリクエストの解析とレスポンス構築 |

**主要処理フロー**:
1. **行74-86**: ルーティング定義（GET/HEADの8パス）
2. **行193-194**: エイリアス名の有無判定とリクエスト構築
3. **行195-198**: `GetAliasesRequest` の構築（aliases、indices、indicesOptions、local）
4. **行203-208**: レスポンス構築コールバック
5. **行94-185**: `buildRestResponse()` 静的メソッド - 不足エイリアスの検出と404ステータスの決定

#### Step 3: 不足エイリアス検出ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | RestGetAliasesAction.java（行94-185） | 同上 | `buildRestResponse()` メソッドの不足エイリアス検出ロジック |

**主要処理フロー**:
- **行100-110**: エイリアスが明示的に要求された場合のみ、インデックスを表示対象に追加
- **行112-148**: ワイルドカードと除外パターンを考慮した不足エイリアスの検出
- **行150-165**: 不足エイリアスがある場合は404ステータス、ない場合は200ステータス

### プログラム呼び出し階層図

```
RestGetAliasesAction.prepareRequest() [行188-209]
    │
    ├─ GetAliasesRequest構築 [行195-199]
    │
    └─ NodeClient.admin().indices().getAliases() [行203]
           │
           └─ TransportGetAliasesAction.masterOperation()
                  │
                  └─ ClusterState.metadata().findAliases()
                         │
                         └─ RestGetAliasesAction.buildRestResponse() [行94-185]
                                │
                                ├─ 不足エイリアス検出
                                └─ レスポンスJSON構築
```

### データフロー図

```
[入力]                          [処理]                              [出力]

GET /{index}/_alias/{name} ───▶ RestGetAliasesAction              ───▶ エイリアス情報JSON
                                  │                                    (200 or 404)
                                  ├─ パラメータ解析
                                  └─ TransportGetAliasesAction
                                        │
                                        └─ クラスタ状態から
                                           エイリアス情報を検索
                                              │
                                              └─ buildRestResponse()
                                                    不足エイリアス検出
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestGetAliasesAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestGetAliasesAction.java` | ソース | RESTエンドポイントハンドラ（GET/HEAD両方） |
| TransportGetAliasesAction.java | `server/src/main/java/org/opensearch/action/admin/indices/alias/get/TransportGetAliasesAction.java` | ソース | トランスポートアクション |
| GetAliasesRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/alias/get/GetAliasesRequest.java` | ソース | リクエストモデル |
| GetAliasesResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/alias/get/GetAliasesResponse.java` | ソース | レスポンスモデル |
| AliasMetadata.java | `server/src/main/java/org/opensearch/cluster/metadata/AliasMetadata.java` | ソース | エイリアスメタデータモデル |
| indices.get_alias.json | `rest-api-spec/src/main/resources/rest-api-spec/api/indices.get_alias.json` | 設定 | REST API仕様定義 |
