# 画面設計書 57-エイリアス作成・更新

## 概要

本ドキュメントは、OpenSearchのPut Alias API（`PUT /{index}/_alias/{name}`）に関する画面設計書である。インデックスエイリアスを作成または更新するためのREST APIエンドポイントの仕様を定義する。

### 本画面の処理概要

本APIは、特定のインデックスに対してエイリアスを作成または更新するエンドポイントである。

**業務上の目的・背景**：エイリアスを使用することで、アプリケーションが物理的なインデックス名を意識せずにデータにアクセスできるようになる。ローリングインデックス運用（日次・月次インデックスの切り替え）、フィルタ付きビュー（テナント別データアクセス）、書き込み先インデックスの切り替えなど、柔軟な運用を実現する。本APIは個別のエイリアスを追加する際に使用される。

**画面へのアクセス方法**：REST APIクライアントから `PUT /{index}/_alias/{name}` または `POST /{index}/_alias/{name}` エンドポイントにリクエストを送信する。

**主要な操作・処理内容**：
1. 指定したインデックスに対してエイリアスを追加する
2. フィルタ条件を設定して、特定のドキュメントのみが見えるエイリアスを作成可能
3. ルーティング値を設定して、特定シャードへのアクセスを制御可能
4. 書き込みインデックス（is_write_index）と隠しエイリアス（is_hidden）の設定が可能
5. リクエストボディまたはパスパラメータでインデックスとエイリアス名を指定可能

**画面遷移**：インデックス作成（No.38）後にエイリアスを設定する場合に呼び出される。設定後はエイリアス取得（No.56）で確認する。複数のエイリアス操作を一括で行う場合はエイリアス一括更新（No.60）を使用する。

**権限による表示制御**：Security Pluginが有効な場合、対象インデックスへの `indices:admin/aliases` アクション権限が必要である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | インデックスエイリアス | 主機能 | エイリアスを作成または更新する処理 |

## 画面種別

API実行（更新系）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| PUT | `/{index}/_alias/{name}` | エイリアスを作成・更新 |
| POST | `/{index}/_alias/{name}` | エイリアスを作成・更新 |
| PUT | `/{index}/_aliases/{name}` | エイリアスを作成・更新（複数形パス） |
| POST | `/{index}/_aliases/{name}` | エイリアスを作成・更新（複数形パス） |
| PUT | `/_alias/{name}` | 全インデックスに対してエイリアスを作成・更新 |
| POST | `/_alias/{name}` | 全インデックスに対してエイリアスを作成・更新 |
| PUT | `/_aliases/{name}` | 全インデックスに対してエイリアスを作成・更新（複数形） |
| POST | `/_aliases/{name}` | 全インデックスに対してエイリアスを作成・更新（複数形） |
| PUT | `/{index}/_alias` | エイリアスを作成（名前はボディで指定） |
| PUT | `/{index}/_aliases` | エイリアスを作成（名前はボディで指定、複数形） |
| PUT | `/_alias` | エイリアスを作成（インデックスと名前はボディで指定） |

## 入出力項目

### パスパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|------|------|------|
| index | list(string) | No | 対象インデックス名（カンマ区切り、ワイルドカード対応） |
| name | string | No | エイリアス名 |

### クエリパラメータ

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
|-------------|------|------|-----------|------|
| timeout | time | No | 30s | 操作タイムアウト |
| cluster_manager_timeout | time | No | 30s | クラスタマネージャノードへの接続タイムアウト |
| master_timeout | time | No | 30s | クラスタマネージャノードへの接続タイムアウト（非推奨） |

### リクエストボディ

| 項目 | 型 | 必須 | 説明 |
|------|------|------|------|
| index | string | No | 対象インデックス名（パスパラメータの代替） |
| alias | string | No | エイリアス名（パスパラメータの代替） |
| filter | object | No | エイリアスに適用するフィルタ（クエリDSL） |
| routing | string | No | インデックスと検索の両方に適用するルーティング値 |
| index_routing | string | No | インデックス操作に適用するルーティング値 |
| search_routing | string | No | 検索操作に適用するルーティング値 |
| is_write_index | boolean | No | このインデックスを書き込みインデックスとして設定するか |
| is_hidden | boolean | No | エイリアスを隠すか |

## 表示項目

### レスポンスボディ

| 項目 | 型 | 説明 |
|------|------|------|
| acknowledged | boolean | リクエストが受理されたか |

## イベント仕様

### 1-エイリアス作成・更新リクエスト

1. クライアントがPUT/POSTリクエストを送信
2. `RestIndexPutAliasAction.prepareRequest()` がリクエストを解析
3. パスパラメータとリクエストボディの両方からindex、alias（name）、filter、routing、indexRouting、searchRouting、writeIndex、isHiddenを取得
4. `IndicesAliasesRequest` にadd操作として `AliasActions` を追加
5. `TransportIndicesAliasesAction` がクラスタマネージャノードにリクエストを転送
6. クラスタ状態が更新され、成功レスポンスを返却

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| エイリアス作成・更新 | クラスタメタデータ（IndexMetadata.aliases） | INSERT/UPDATE | エイリアスのメタデータをインデックスに追加/更新 |

### テーブル別更新項目詳細

#### クラスタメタデータ（IndexMetadata.aliases）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | AliasMetadata | エイリアス名、フィルタ、ルーティング、writeIndex、isHidden | 既存エイリアスは上書き |

## メッセージ仕様

| メッセージ種別 | HTTPステータス | メッセージ内容 | 発生条件 |
|-------------|--------------|--------------|---------|
| 成功 | 200 | `{"acknowledged": true}` | エイリアス作成・更新が正常に完了 |
| エラー | 400 | `No index alias is specified` | エイリアスの指定がない場合 |
| エラー | 400 | `unknown field [x]` | 不明なフィールドがリクエストボディに含まれる場合 |
| エラー | 404 | `no such index` | 指定インデックスが存在しない場合 |

## 例外処理

| 例外 | 条件 | 動作 |
|------|------|------|
| IndexNotFoundException | 指定したインデックスが存在しない | 404エラーを返却 |
| IllegalArgumentException | エイリアス未指定、不明フィールド | 400エラーを返却 |
| ClusterManagerNotDiscoveredException | クラスタマネージャノードに接続不可 | 503エラーを返却 |

## 備考

- 内部的には `IndicesAliasesRequest` にadd操作を1つ追加して `TransportIndicesAliasesAction` を呼び出す形式。
- エイリアス一括更新（No.60）と同じトランスポートアクションを使用している。
- `routing` を指定すると、`index_routing` と `search_routing` の両方に設定される。
- `master_timeout` パラメータはバージョン2.0.0で非推奨。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | IndicesAliasesRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/alias/IndicesAliasesRequest.java` | リクエストモデル。AliasActions内部クラスのadd/remove/removeIndex操作タイプを確認 |
| 1-2 | AliasMetadata.java | `server/src/main/java/org/opensearch/cluster/metadata/AliasMetadata.java` | エイリアスのメタデータモデル |

**読解のコツ**: `RestIndexPutAliasAction` は内部的に `IndicesAliasesRequest` を使用し、`AliasActions.add()` として操作を構築する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestIndexPutAliasAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestIndexPutAliasAction.java` | RESTリクエストの解析 |

**主要処理フロー**:
1. **行63-78**: ルーティング定義（11パス）
2. **行88-89**: パスパラメータからindex、nameを取得
3. **行97-137**: リクエストボディのパース。filter、routing、indexRouting、searchRouting、writeIndex、isHiddenを取得
4. **行140-145**: `IndicesAliasesRequest` の構築とタイムアウト設定
5. **行147-165**: `AliasActions.add()` にすべてのパラメータを設定
6. **行166-167**: `IndicesAliasesRequest` にアクションを追加し、トランスポートアクションを呼び出し

#### Step 3: トランスポート層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportIndicesAliasesAction.java | `server/src/main/java/org/opensearch/action/admin/indices/alias/TransportIndicesAliasesAction.java` | クラスタマネージャノードでのエイリアス更新処理 |

### プログラム呼び出し階層図

```
RestIndexPutAliasAction.prepareRequest() [行87-168]
    │
    ├─ パスパラメータ取得 [行88-89]
    │
    ├─ リクエストボディパース [行97-137]
    │      ├─ filter [行130-131]
    │      ├─ routing [行113]
    │      ├─ index_routing [行116]
    │      ├─ search_routing [行121]
    │      ├─ is_write_index [行123]
    │      └─ is_hidden [行125]
    │
    ├─ IndicesAliasesRequest構築 [行140-145]
    │
    ├─ AliasActions.add()構築 [行147-165]
    │
    └─ NodeClient.admin().indices().aliases() [行167]
           │
           └─ TransportIndicesAliasesAction.masterOperation()
                  │
                  └─ MetadataIndexAliasesService.innerExecute()
```

### データフロー図

```
[入力]                           [処理]                              [出力]

PUT /{index}/_alias/{name}  ───▶ RestIndexPutAliasAction           ───▶ {"acknowledged": true}
  + Request Body                  │
  (filter, routing等)            ├─ パスパラメータ解析
                                  ├─ ボディパース
                                  ├─ AliasActions.add()構築
                                  └─ TransportIndicesAliasesAction
                                        │
                                        └─ クラスタ状態更新
                                              (エイリアス追加)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestIndexPutAliasAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestIndexPutAliasAction.java` | ソース | RESTエンドポイントハンドラ |
| TransportIndicesAliasesAction.java | `server/src/main/java/org/opensearch/action/admin/indices/alias/TransportIndicesAliasesAction.java` | ソース | トランスポートアクション |
| IndicesAliasesRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/alias/IndicesAliasesRequest.java` | ソース | リクエストモデル |
| AliasMetadata.java | `server/src/main/java/org/opensearch/cluster/metadata/AliasMetadata.java` | ソース | エイリアスメタデータモデル |
| MetadataIndexAliasesService.java | `server/src/main/java/org/opensearch/cluster/metadata/MetadataIndexAliasesService.java` | ソース | エイリアス管理サービス |
| indices.put_alias.json | `rest-api-spec/src/main/resources/rest-api-spec/api/indices.put_alias.json` | 設定 | REST API仕様定義 |
