# 画面設計書 58-エイリアス削除

## 概要

本ドキュメントは、OpenSearchのDelete Alias API（`DELETE /{index}/_alias/{name}`）に関する画面設計書である。インデックスエイリアスを削除するためのREST APIエンドポイントの仕様を定義する。

### 本画面の処理概要

本APIは、指定されたインデックスからエイリアスを削除するエンドポイントである。

**業務上の目的・背景**：不要になったエイリアスの整理、インデックス再構成時のエイリアス解除、テスト環境のクリーンアップなどに使用する。エイリアスの追加はNo.57のPut Alias APIで行い、削除は本APIで行う。複数のエイリアス操作を一括で行う場合はNo.60のエイリアス一括更新APIも利用可能である。

**画面へのアクセス方法**：REST APIクライアントから `DELETE /{index}/_alias/{name}` または `DELETE /{index}/_aliases/{name}` エンドポイントにリクエストを送信する。

**主要な操作・処理内容**：
1. 指定されたインデックスから指定されたエイリアスを削除する
2. カンマ区切りで複数のインデックスやエイリアスを一括指定可能
3. ワイルドカードを使用したエイリアスの一括削除が可能
4. `_all` を指定して指定インデックスの全エイリアスを削除可能

**画面遷移**：エイリアス取得（No.56）でエイリアスの現状を確認した後に呼び出される。削除後はエイリアス取得（No.56）で結果を確認する。

**権限による表示制御**：Security Pluginが有効な場合、対象インデックスへの `indices:admin/aliases` アクション権限が必要である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | インデックスエイリアス | 主機能 | エイリアスを削除する処理 |

## 画面種別

API実行（削除系）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| DELETE | `/{index}/_alias/{name}` | エイリアスを削除 |
| DELETE | `/{index}/_aliases/{name}` | エイリアスを削除（複数形パス） |

## 入出力項目

### パスパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|------|------|------|
| index | list(string) | Yes | 対象インデックス名（カンマ区切り、ワイルドカード対応、`_all`で全インデックス） |
| name | list(string) | Yes | 削除するエイリアス名（カンマ区切り、ワイルドカード対応、`_all`で全エイリアス） |

### クエリパラメータ

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
|-------------|------|------|-----------|------|
| timeout | time | No | 30s | 操作タイムアウト |
| cluster_manager_timeout | time | No | 30s | クラスタマネージャノードへの接続タイムアウト |
| master_timeout | time | No | 30s | クラスタマネージャノードへの接続タイムアウト（非推奨） |

## 表示項目

### レスポンスボディ

| 項目 | 型 | 説明 |
|------|------|------|
| acknowledged | boolean | リクエストが受理されたか |

## イベント仕様

### 1-エイリアス削除リクエスト

1. クライアントがDELETEリクエストを送信
2. `RestIndexDeleteAliasesAction.prepareRequest()` がリクエストを解析
3. パスパラメータからindex、nameをカンマ区切りで分割
4. `IndicesAliasesRequest` にremove操作として `AliasActions` を追加
5. `TransportIndicesAliasesAction` がクラスタマネージャノードにリクエストを転送
6. クラスタ状態からエイリアスが削除され、成功レスポンスを返却

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| エイリアス削除 | クラスタメタデータ（IndexMetadata.aliases） | DELETE | インデックスからエイリアスのメタデータを削除 |

### テーブル別更新項目詳細

#### クラスタメタデータ（IndexMetadata.aliases）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | AliasMetadata | 指定されたエイリアス名に一致するエントリを削除 | ワイルドカードによる一括削除に対応 |

## メッセージ仕様

| メッセージ種別 | HTTPステータス | メッセージ内容 | 発生条件 |
|-------------|--------------|--------------|---------|
| 成功 | 200 | `{"acknowledged": true}` | エイリアス削除が正常に完了 |
| エラー | 404 | `aliases [name] missing` | 指定エイリアスが存在しない場合 |
| エラー | 404 | `no such index` | 指定インデックスが存在しない場合 |

## 例外処理

| 例外 | 条件 | 動作 |
|------|------|------|
| IndexNotFoundException | 指定したインデックスが存在しない | 404エラーを返却 |
| AliasesNotFoundException | 指定したエイリアスが存在しない | 404エラーを返却 |
| ClusterManagerNotDiscoveredException | クラスタマネージャノードに接続不可 | 503エラーを返却 |

## 備考

- 内部的には `IndicesAliasesRequest` にremove操作を1つ追加して `TransportIndicesAliasesAction` を呼び出す形式。
- エイリアス作成・更新（No.57）やエイリアス一括更新（No.60）と同じトランスポートアクションを使用している。
- `master_timeout` パラメータはバージョン2.0.0で非推奨。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | IndicesAliasesRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/alias/IndicesAliasesRequest.java` | AliasActionsのremove操作タイプを確認 |

**読解のコツ**: `AliasActions.remove()` はインデックスからエイリアスを削除する操作を表す。`indices` と `aliases` の両方が必須。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestIndexDeleteAliasesAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestIndexDeleteAliasesAction.java` | RESTリクエストの解析 |

**主要処理フロー**:
1. **行61**: ルーティング定義（DELETE `/{index}/_alias/{name}` および `/{index}/_aliases/{name}`）
2. **行71-72**: パスパラメータからindex、nameをカンマ区切りで分割
3. **行73**: `IndicesAliasesRequest` の構築
4. **行74**: timeout の設定
5. **行75**: `AliasActions.remove()` で削除操作を追加
6. **行76-79**: cluster_manager_timeout と非推奨 master_timeout の処理
7. **行81**: `client.admin().indices().aliases()` でトランスポートアクションを呼び出し

#### Step 3: トランスポート層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportIndicesAliasesAction.java | `server/src/main/java/org/opensearch/action/admin/indices/alias/TransportIndicesAliasesAction.java` | クラスタマネージャノードでのエイリアス削除処理 |

### プログラム呼び出し階層図

```
RestIndexDeleteAliasesAction.prepareRequest() [行70-82]
    │
    ├─ Strings.splitStringByCommaToArray() [行71-72] - index、nameの分割
    │
    ├─ IndicesAliasesRequest構築 [行73-74]
    │
    ├─ AliasActions.remove().indices().aliases() [行75]
    │
    └─ NodeClient.admin().indices().aliases() [行81]
           │
           └─ TransportIndicesAliasesAction.masterOperation()
                  │
                  └─ MetadataIndexAliasesService.innerExecute()
                         │
                         └─ クラスタ状態からエイリアス削除
```

### データフロー図

```
[入力]                             [処理]                              [出力]

DELETE /{index}/_alias/{name} ───▶ RestIndexDeleteAliasesAction       ───▶ {"acknowledged": true}
                                    │
                                    ├─ パスパラメータ解析
                                    ├─ AliasActions.remove()構築
                                    └─ TransportIndicesAliasesAction
                                          │
                                          └─ クラスタ状態更新
                                                (エイリアス削除)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestIndexDeleteAliasesAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestIndexDeleteAliasesAction.java` | ソース | RESTエンドポイントハンドラ |
| TransportIndicesAliasesAction.java | `server/src/main/java/org/opensearch/action/admin/indices/alias/TransportIndicesAliasesAction.java` | ソース | トランスポートアクション |
| IndicesAliasesRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/alias/IndicesAliasesRequest.java` | ソース | リクエストモデル |
| MetadataIndexAliasesService.java | `server/src/main/java/org/opensearch/cluster/metadata/MetadataIndexAliasesService.java` | ソース | エイリアス管理サービス |
| indices.delete_alias.json | `rest-api-spec/src/main/resources/rest-api-spec/api/indices.delete_alias.json` | 設定 | REST API仕様定義 |
