# 画面設計書 59-エイリアス存在確認

## 概要

本ドキュメントは、OpenSearchのAlias Exists API（`HEAD /{index}/_alias/{name}`）に関する画面設計書である。エイリアスが存在するかどうかを確認するためのREST APIエンドポイントの仕様を定義する。

### 本画面の処理概要

本APIは、指定されたエイリアスが存在するかどうかをHEADリクエストで確認するエンドポイントである。

**業務上の目的・背景**：エイリアスの存在確認は、アプリケーションの初期化処理やデプロイスクリプトにおいて、エイリアスが正しく設定されているかを検証する際に使用する。GETリクエスト（No.56）と異なり、レスポンスボディを返さないためオーバーヘッドが少なく、存在確認のみが必要な場合に効率的である。ヘルスチェックやモニタリングにも活用される。

**画面へのアクセス方法**：REST APIクライアントから `HEAD /_alias/{name}` または `HEAD /{index}/_alias/{name}` エンドポイントにリクエストを送信する。

**主要な操作・処理内容**：
1. 指定されたエイリアスがクラスタ内に存在するかを確認する
2. 存在する場合は200ステータス、存在しない場合は404ステータスを返却する
3. レスポンスボディは返却されない（HEADリクエスト）
4. インデックスを指定して、特定インデックスにおけるエイリアスの存在を確認可能

**画面遷移**：エイリアス作成・更新（No.57）やエイリアス一括更新（No.60）の後に存在確認のために呼び出される。エイリアス削除（No.58）の前に対象エイリアスの存在を確認する用途もある。

**権限による表示制御**：Security Pluginが有効な場合、対象インデックスへの `indices:admin/aliases/get` アクション権限が必要である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | インデックスエイリアス | 主機能 | エイリアスが存在するかを確認する処理 |

## 画面種別

API実行（参照系）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| HEAD | `/_alias/{name}` | 指定名のエイリアスの存在確認 |
| HEAD | `/{index}/_alias/{name}` | 指定インデックスにおける指定エイリアスの存在確認 |

## 入出力項目

### パスパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|------|------|------|
| index | list(string) | No | 対象インデックス名（カンマ区切りリスト） |
| name | list(string) | Yes | 確認するエイリアス名（カンマ区切りリスト） |

### クエリパラメータ

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
|-------------|------|------|-----------|------|
| ignore_unavailable | boolean | No | false | 利用不可なインデックスを無視するか |
| allow_no_indices | boolean | No | false | ワイルドカードが何にもマッチしない場合にエラーにしないか |
| expand_wildcards | enum | No | all | ワイルドカード展開対象（open/closed/hidden/none/all） |
| local | boolean | No | false | ローカルノードの情報のみを返すか |

## 表示項目

### レスポンス

HEADリクエストのため、レスポンスボディは返却されない。HTTPステータスコードのみで結果を示す。

| HTTPステータス | 意味 |
|--------------|------|
| 200 | エイリアスが存在する |
| 404 | エイリアスが存在しない |

## イベント仕様

### 1-エイリアス存在確認リクエスト

1. クライアントがHEADリクエストを送信
2. `RestGetAliasesAction.prepareRequest()` がリクエストを解析（GET/HEADの共通ハンドラ）
3. `GetAliasesRequest` を構築し、`TransportGetAliasesAction` を呼び出す
4. `buildRestResponse()` でエイリアスの存在を確認
5. エイリアスが見つかった場合は200、見つからない場合は404ステータスを返却
6. HEADリクエストのため、レスポンスボディは自動的に省略される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| エイリアス存在確認 | クラスタメタデータ（AliasMetadata） | SELECT | エイリアスの存在確認 |

### テーブル別更新項目詳細

本APIは参照系のため、データの更新は発生しない。

## メッセージ仕様

| メッセージ種別 | HTTPステータス | メッセージ内容 | 発生条件 |
|-------------|--------------|--------------|---------|
| 存在 | 200 | （ボディなし） | エイリアスが存在する場合 |
| 不在 | 404 | （ボディなし） | エイリアスが存在しない場合 |

## 例外処理

| 例外 | 条件 | 動作 |
|------|------|------|
| IndexNotFoundException | 指定したインデックスが存在しない | 404ステータスを返却 |

## 備考

- `RestGetAliasesAction` がGETとHEADの両方を処理する共通ハンドラである。
- HEADリクエストではレスポンスボディが自動的に省略されるが、内部的にはGETリクエストと同じ処理が実行される。
- `expand_wildcards` のデフォルト値は `all`。
- 複数のエイリアス名をカンマ区切りで指定した場合、すべてのエイリアスが存在する場合のみ200が返却される。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | GetAliasesRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/alias/get/GetAliasesRequest.java` | リクエストモデル（GETと共通） |

**読解のコツ**: エイリアス存在確認はエイリアス取得（No.56）と同じリクエスト・レスポンスモデルを使用する。HEADメソッドによりレスポンスボディが省略されるだけの違い。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestGetAliasesAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestGetAliasesAction.java` | GET/HEADの共通RESTハンドラ |

**主要処理フロー**:
1. **行80**: `HEAD /_alias/{name}` のルーティング定義
2. **行82**: `HEAD /{index}/_alias` のルーティング定義
3. **行84**: `HEAD /{index}/_alias/{name}` のルーティング定義
4. **行188-209**: `prepareRequest()` - GET/HEAD共通処理
5. **行94-185**: `buildRestResponse()` - 不足エイリアス検出と200/404ステータス決定

### プログラム呼び出し階層図

```
RestGetAliasesAction.prepareRequest() [行188-209]
    │ (HEADリクエストもGETと同じ処理)
    │
    ├─ GetAliasesRequest構築 [行195-199]
    │
    └─ NodeClient.admin().indices().getAliases() [行203]
           │
           └─ TransportGetAliasesAction.masterOperation()
                  │
                  └─ ClusterState.metadata().findAliases()
                         │
                         └─ RestGetAliasesAction.buildRestResponse() [行94-185]
                                │
                                ├─ 不足エイリアス検出
                                └─ 200 or 404ステータス決定
                                       │
                                       └─ HEADリクエストのためボディ省略
```

### データフロー図

```
[入力]                             [処理]                              [出力]

HEAD /{index}/_alias/{name}   ───▶ RestGetAliasesAction              ───▶ 200 (存在)
                                    │                                     or
                                    ├─ パラメータ解析                      404 (不在)
                                    └─ TransportGetAliasesAction         (ボディなし)
                                          │
                                          └─ クラスタ状態から
                                             エイリアス存在確認
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestGetAliasesAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestGetAliasesAction.java` | ソース | RESTエンドポイントハンドラ（GET/HEAD共通） |
| TransportGetAliasesAction.java | `server/src/main/java/org/opensearch/action/admin/indices/alias/get/TransportGetAliasesAction.java` | ソース | トランスポートアクション |
| GetAliasesRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/alias/get/GetAliasesRequest.java` | ソース | リクエストモデル |
| indices.exists_alias.json | `rest-api-spec/src/main/resources/rest-api-spec/api/indices.exists_alias.json` | 設定 | REST API仕様定義 |
