# 画面設計書 60-エイリアス一括更新

## 概要

本ドキュメントは、OpenSearchのUpdate Aliases API（`POST /_aliases`）に関する画面設計書である。複数のエイリアス操作（追加、削除、インデックス削除）を一括で実行するためのREST APIエンドポイントの仕様を定義する。

### 本画面の処理概要

本APIは、複数のエイリアス操作をアトミック（不可分）に一括実行するエンドポイントである。

**業務上の目的・背景**：ローリングインデックス運用において、古いインデックスからエイリアスを外し、新しいインデックスにエイリアスを付け替える操作をアトミックに実行する必要がある。個別のAPIでは操作間に中間状態が発生するが、本APIを使用することで、複数のadd/remove操作が1つのクラスタ状態更新として適用される。これにより、切り替え中のダウンタイムやデータ不整合を防止できる。テナント別エイリアスの一括設定やA/Bテスト用インデックス切り替えなど、複雑なエイリアス管理シナリオに不可欠である。

**画面へのアクセス方法**：REST APIクライアントから `POST /_aliases` エンドポイントにリクエストを送信する。

**主要な操作・処理内容**：
1. リクエストボディに含まれるactions配列の各操作を順番に実行する
2. add操作：インデックスにエイリアスを追加（フィルタ、ルーティング、write_index、is_hidden設定可能）
3. remove操作：インデックスからエイリアスを削除
4. remove_index操作：インデックスそのものを削除
5. すべての操作がアトミックに実行される（1つの操作が失敗すると全体がロールバック）

**画面遷移**：エイリアス取得（No.56）で現状を確認した後に呼び出される。実行後はエイリアス取得（No.56）で結果を確認する。個別のエイリアス追加はNo.57、削除はNo.58でも可能。

**権限による表示制御**：Security Pluginが有効な場合、操作対象の全インデックスに対する `indices:admin/aliases` アクション権限が必要である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | インデックスエイリアス | 主機能 | インデックスエイリアスを一括で更新する処理 |

## 画面種別

API実行（更新系）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| POST | `/_aliases` | エイリアスの一括更新 |

## 入出力項目

### クエリパラメータ

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
|-------------|------|------|-----------|------|
| timeout | time | No | 30s | 操作タイムアウト |
| cluster_manager_timeout | time | No | 30s | クラスタマネージャノードへの接続タイムアウト |
| master_timeout | time | No | 30s | クラスタマネージャノードへの接続タイムアウト（非推奨） |

### リクエストボディ

| 項目 | 型 | 必須 | 説明 |
|------|------|------|------|
| actions | array | Yes | エイリアス操作の配列 |

#### actions配列の各要素

**add操作：**

| 項目 | 型 | 必須 | 説明 |
|------|------|------|------|
| add.index | string | Yes | 対象インデックス名（ワイルドカード可） |
| add.alias | string | Yes | エイリアス名 |
| add.filter | object | No | エイリアスに適用するフィルタ（クエリDSL） |
| add.routing | string | No | ルーティング値 |
| add.index_routing | string | No | インデックス操作用ルーティング値 |
| add.search_routing | string | No | 検索操作用ルーティング値 |
| add.is_write_index | boolean | No | 書き込みインデックスとして設定するか |
| add.is_hidden | boolean | No | 隠しエイリアスとするか |

**remove操作：**

| 項目 | 型 | 必須 | 説明 |
|------|------|------|------|
| remove.index | string | Yes | 対象インデックス名 |
| remove.alias | string | Yes | 削除するエイリアス名 |

**remove_index操作：**

| 項目 | 型 | 必須 | 説明 |
|------|------|------|------|
| remove_index.index | string | Yes | 削除するインデックス名 |

## 表示項目

### レスポンスボディ

| 項目 | 型 | 説明 |
|------|------|------|
| acknowledged | boolean | リクエストが受理されたか |

## イベント仕様

### 1-エイリアス一括更新リクエスト

1. クライアントがPOSTリクエストを送信
2. `RestIndicesAliasesAction.prepareRequest()` がリクエストを解析
3. `IndicesAliasesRequest.PARSER` でリクエストボディのactions配列をパース
4. actions配列が空の場合は `IllegalArgumentException` をスロー
5. `TransportIndicesAliasesAction` がクラスタマネージャノードにリクエストを転送
6. `MetadataIndexAliasesService.innerExecute()` がすべての操作をアトミックに実行
7. クラスタ状態が更新され、成功レスポンスを返却

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| add操作 | クラスタメタデータ（IndexMetadata.aliases） | INSERT/UPDATE | エイリアスを追加/更新 |
| remove操作 | クラスタメタデータ（IndexMetadata.aliases） | DELETE | エイリアスを削除 |
| remove_index操作 | クラスタメタデータ（IndexMetadata） | DELETE | インデックスそのものを削除 |

### テーブル別更新項目詳細

#### クラスタメタデータ（IndexMetadata.aliases）- add操作

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | AliasMetadata | actions配列のadd要素で指定されたエイリアス情報 | フィルタ、ルーティング、writeIndex、isHiddenを含む |

#### クラスタメタデータ（IndexMetadata.aliases）- remove操作

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | AliasMetadata | actions配列のremove要素で指定されたエイリアス | - |

## メッセージ仕様

| メッセージ種別 | HTTPステータス | メッセージ内容 | 発生条件 |
|-------------|--------------|--------------|---------|
| 成功 | 200 | `{"acknowledged": true}` | エイリアス一括更新が正常に完了 |
| エラー | 400 | `No action specified` | actions配列が空の場合 |
| エラー | 400 | 不正なアクション形式 | actionsの構文が不正な場合 |
| エラー | 404 | `no such index` | 操作対象のインデックスが存在しない場合 |
| エラー | 404 | `aliases [name] missing` | remove対象のエイリアスが存在しない場合 |

## 例外処理

| 例外 | 条件 | 動作 |
|------|------|------|
| IllegalArgumentException | actions配列が空 | 400エラーを返却 |
| IndexNotFoundException | 操作対象のインデックスが存在しない | 404エラーを返却（全操作がロールバック） |
| AliasesNotFoundException | remove対象のエイリアスが存在しない | 404エラーを返却 |
| ClusterManagerNotDiscoveredException | クラスタマネージャノードに接続不可 | 503エラーを返却 |

## 備考

- すべての操作がアトミックに実行される。1つの操作が失敗した場合は全体がロールバックされる。
- `IndicesAliasesRequest.PARSER` によりリクエストボディが解析される。
- `master_timeout` パラメータはバージョン2.0.0で非推奨。
- エイリアス作成・更新（No.57）およびエイリアス削除（No.58）の内部処理と同じ `TransportIndicesAliasesAction` を使用する。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | IndicesAliasesRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/alias/IndicesAliasesRequest.java` | リクエストモデル。PARSER定義、AliasActions内部クラスのadd/remove/removeIndex操作タイプ、actions配列を確認 |

**読解のコツ**: `IndicesAliasesRequest.PARSER` は `ObjectParser` を使用してリクエストボディの `actions` 配列をパースする。各アクションは `AliasActions` のサブクラス（add/remove/remove_index）として構築される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestIndicesAliasesAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestIndicesAliasesAction.java` | RESTリクエストの解析 |

**主要処理フロー**:
1. **行65**: ルーティング定義（POST `/_aliases`）
2. **行70**: `IndicesAliasesRequest` の構築
3. **行71-74**: cluster_manager_timeout と非推奨 master_timeout の処理
4. **行75**: timeout の設定
5. **行76-78**: `IndicesAliasesRequest.PARSER.parse()` でリクエストボディを解析
6. **行79-81**: actions配列が空でないことを検証
7. **行82**: `client.admin().indices().aliases()` でトランスポートアクションを呼び出し

#### Step 3: トランスポート層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportIndicesAliasesAction.java | `server/src/main/java/org/opensearch/action/admin/indices/alias/TransportIndicesAliasesAction.java` | クラスタマネージャノードでのエイリアス一括更新処理 |

### プログラム呼び出し階層図

```
RestIndicesAliasesAction.prepareRequest() [行69-83]
    │
    ├─ IndicesAliasesRequest構築 [行70]
    │
    ├─ cluster_manager_timeout設定 [行71-74]
    │
    ├─ timeout設定 [行75]
    │
    ├─ IndicesAliasesRequest.PARSER.parse() [行76-78]
    │      │
    │      └─ actions配列のパース
    │            ├─ AliasActions.add()
    │            ├─ AliasActions.remove()
    │            └─ AliasActions.removeIndex()
    │
    ├─ actions空チェック [行79-81]
    │
    └─ NodeClient.admin().indices().aliases() [行82]
           │
           └─ TransportIndicesAliasesAction.masterOperation()
                  │
                  └─ MetadataIndexAliasesService.innerExecute()
                         │
                         └─ アトミックなクラスタ状態更新
                               ├─ add操作の適用
                               ├─ remove操作の適用
                               └─ remove_index操作の適用
```

### データフロー図

```
[入力]                    [処理]                              [出力]

POST /_aliases       ───▶ RestIndicesAliasesAction           ───▶ {"acknowledged": true}
  + Request Body          │
  (actions配列)           ├─ PARSER.parse()
                          │      └─ actions配列を
                          │         AliasActionsに変換
                          ├─ 空チェック
                          └─ TransportIndicesAliasesAction
                                │
                                └─ MetadataIndexAliasesService
                                      │
                                      └─ アトミックなクラスタ状態更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestIndicesAliasesAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestIndicesAliasesAction.java` | ソース | RESTエンドポイントハンドラ |
| TransportIndicesAliasesAction.java | `server/src/main/java/org/opensearch/action/admin/indices/alias/TransportIndicesAliasesAction.java` | ソース | トランスポートアクション |
| IndicesAliasesRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/alias/IndicesAliasesRequest.java` | ソース | リクエストモデル（PARSER定義含む） |
| MetadataIndexAliasesService.java | `server/src/main/java/org/opensearch/cluster/metadata/MetadataIndexAliasesService.java` | ソース | エイリアス管理サービス |
| AliasMetadata.java | `server/src/main/java/org/opensearch/cluster/metadata/AliasMetadata.java` | ソース | エイリアスメタデータモデル |
| indices.update_aliases.json | `rest-api-spec/src/main/resources/rest-api-spec/api/indices.update_aliases.json` | 設定 | REST API仕様定義 |
