# 画面設計書 61-インデックステンプレート取得（レガシー）

## 概要

本ドキュメントは、OpenSearchのレガシーインデックステンプレート取得API（`GET /_template/{name}`）の画面設計書である。クラスタ状態に保存されたレガシーインデックステンプレートの定義情報を取得するREST APIエンドポイントについて、入出力仕様・処理フロー・エラーハンドリングを定義する。

### 本画面の処理概要

**業務上の目的・背景**：インデックステンプレートは、新しいインデックスが作成される際に自動的に適用される設定・マッピング・エイリアスの定義をまとめたものである。運用管理者がテンプレートの現在の定義内容を確認し、意図した設定が適用されているかを検証するために、テンプレート取得APIが必要である。本APIはレガシーテンプレート（`_template`エンドポイント）であり、新規利用にはComposableインデックステンプレート（`_index_template`）が推奨される。

**画面へのアクセス方法**：HTTPクライアント（curl、OpenSearch Dashboards Dev Tools等）から `GET /_template` または `GET /_template/{name}` へリクエストを送信する。HEAD メソッドによる存在確認も同一エンドポイントで処理される（No.64参照）。

**主要な操作・処理内容**：
1. クライアントからGETリクエストを受信し、テンプレート名パラメータを解析する
2. カンマ区切りで複数テンプレート名を指定可能であり、名前未指定時は全テンプレートを返却する
3. クラスタ状態からテンプレートメタデータを取得し、JSON形式でレスポンスを返却する
4. テンプレートが見つからない場合、名前指定時は404、名前未指定時は200（空配列）を返す

**画面遷移**：本APIは単独で動作する参照系APIである。取得したテンプレートの内容を基に、テンプレート作成・更新API（No.62）やテンプレート削除API（No.63）を呼び出す運用フローが一般的である。インデックス作成API（No.38）実行時にテンプレートが自動適用される。

**権限による表示制御**：クラスタレベルのメタデータ読み取り権限が必要である。セキュリティプラグイン有効時はインデックステンプレートの読み取り権限が求められる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 7 | インデックステンプレート | 主機能 | レガシーインデックステンプレートを返す処理 |

## 画面種別

参照（テンプレート定義の取得・一覧表示）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_template` | 全テンプレートを取得 |
| GET | `/_template/{name}` | 指定名のテンプレートを取得（カンマ区切りで複数指定可） |
| HEAD | `/_template/{name}` | テンプレートの存在確認（No.64で詳述） |

## 入出力項目

### パスパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|------|------|------|
| name | list (string) | 任意 | テンプレート名（カンマ区切りで複数指定可、ワイルドカード対応） |

### クエリパラメータ

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
|-------------|------|------|-----------|------|
| flat_settings | boolean | 任意 | false | 設定をフラット形式で返すかどうか |
| cluster_manager_timeout | time | 任意 | 30s | クラスタマネージャノードへの接続タイムアウト |
| master_timeout | time | 任意 | 30s | 非推奨（v2.0.0）。cluster_manager_timeoutを使用すること |
| local | boolean | 任意 | false | ローカルノードの情報のみを返すかどうか |

## 表示項目

### レスポンスボディ

| 項目名 | 型 | 説明 |
|--------|------|------|
| {template_name} | object | テンプレート名をキーとするオブジェクト |
| {template_name}.order | integer | テンプレートの優先順位（大きい値が後から適用） |
| {template_name}.version | integer | テンプレートのバージョン番号 |
| {template_name}.index_patterns | array[string] | 適用対象のインデックスパターン |
| {template_name}.settings | object | インデックス設定 |
| {template_name}.mappings | object | マッピング定義 |
| {template_name}.aliases | object | エイリアス定義 |

## イベント仕様

### 1-テンプレート取得リクエスト

1. クライアントがGETリクエストを送信する
2. `RestGetIndexTemplateAction.prepareRequest()`がリクエストを解析し、`GetIndexTemplatesRequest`を生成する
3. `name`パラメータをカンマで分割し、テンプレート名の配列を設定する
4. `local`パラメータでローカルノードのみから取得するか判定する
5. `client.admin().indices().getTemplates()`でクラスタ状態からテンプレートを取得する
6. レスポンスのテンプレートリストが空かつ名前指定ありの場合、HTTPステータス404を返す
7. テンプレートが存在する場合またはimplicitAll（名前未指定）の場合、HTTPステータス200を返す

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| テンプレート取得 | ClusterState（メモリ上） | SELECT | クラスタ状態のメタデータからテンプレート定義を読み取る |

### テーブル別更新項目詳細

#### ClusterState.Metadata.templates

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | IndexTemplateMetadata | nameパラメータに一致するテンプレートを取得 | ワイルドカードマッチング対応 |

## メッセージ仕様

| メッセージID | 種別 | HTTPステータス | メッセージ内容 | 発生条件 |
|-------------|------|---------------|---------------|---------|
| - | 成功 | 200 OK | テンプレート定義のJSON | テンプレートが見つかった場合、または名前未指定の場合 |
| - | エラー | 404 Not Found | テンプレートが見つからない | 名前指定でテンプレートが存在しない場合 |

## 例外処理

| 例外 | HTTPステータス | 説明 |
|------|---------------|------|
| テンプレート未存在 | 404 | 指定名のテンプレートがクラスタ状態に存在しない |
| タイムアウト | 408/500 | クラスタマネージャノードへの接続がタイムアウトした |
| 権限不足 | 403 | セキュリティプラグイン有効時にテンプレート読み取り権限がない |

## 備考

- 本APIはレガシーテンプレートAPIであり、OpenSearch 2.x以降ではComposableインデックステンプレート（`_index_template`）の使用が推奨される。
- `master_timeout`パラメータはv2.0.0で非推奨となり、`cluster_manager_timeout`に置き換えられた。
- HEAD メソッドによる存在確認も`RestGetIndexTemplateAction`で処理される（routes()にHEADが含まれる）。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、レガシーインデックステンプレートのデータモデルを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | IndexTemplateMetadata.java | `server/src/main/java/org/opensearch/cluster/metadata/IndexTemplateMetadata.java` | テンプレートのデータ構造（patterns, settings, mappings, aliases, order, version）を理解する |
| 1-2 | GetIndexTemplatesResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/template/get/GetIndexTemplatesResponse.java` | レスポンスの構造とシリアライゼーション形式を理解する |

**読解のコツ**: `IndexTemplateMetadata`は`ToXContentCustom`を実装しており、`toXContent()`メソッドでJSON出力形式が決まる。

#### Step 2: エントリーポイントを理解する

REST APIのリクエスト受信からアクション呼び出しまでの流れを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestGetIndexTemplateAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestGetIndexTemplateAction.java` | RESTリクエストの受信とパラメータ解析ロジック |

**主要処理フロー**:
1. **67-71行目**: `routes()`でGET `/_template`, GET `/_template/{name}`, HEAD `/_template/{name}`のルートを登録
2. **79-80行目**: `prepareRequest()`でnameパラメータをカンマ区切りで分割し`GetIndexTemplatesRequest`を生成
3. **83-87行目**: local, cluster_manager_timeout, master_timeout（非推奨）パラメータを設定
4. **89行目**: 名前未指定の場合`implicitAll = true`に設定
5. **91-99行目**: テンプレート取得を実行し、結果に応じてOK/NOT_FOUNDステータスを返却

#### Step 3: トランスポートアクション層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | GetIndexTemplatesRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/template/get/GetIndexTemplatesRequest.java` | リクエストのバリデーションとシリアライゼーション |
| 3-2 | MetadataIndexTemplateService.java | `server/src/main/java/org/opensearch/cluster/metadata/MetadataIndexTemplateService.java` | テンプレート管理の中核サービス。クラスタ状態からのテンプレート検索ロジック |

### プログラム呼び出し階層図

```
RestGetIndexTemplateAction.prepareRequest()
    |
    +-- Strings.splitStringByCommaToArray(name)
    |
    +-- new GetIndexTemplatesRequest(names)
    |
    +-- client.admin().indices().getTemplates()
            |
            +-- TransportGetIndexTemplatesAction.clusterManagerOperation()
                    |
                    +-- ClusterState.metadata().templates()
                    |
                    +-- GetIndexTemplatesResponse(filteredTemplates)
```

### データフロー図

```
[入力]                          [処理]                                     [出力]

GET /_template/{name}  --> RestGetIndexTemplateAction.prepareRequest()
                                |
                       nameをカンマ分割
                                |
                       GetIndexTemplatesRequest生成
                                |
                       TransportGetIndexTemplatesAction実行  --> GetIndexTemplatesResponse
                                |                                       |
                       ClusterState.metadata().templates()       JSON形式でレスポンス返却
                       から一致テンプレートをフィルタ            (200 OK / 404 Not Found)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestGetIndexTemplateAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestGetIndexTemplateAction.java` | ソース | RESTエンドポイントハンドラ |
| GetIndexTemplatesRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/template/get/GetIndexTemplatesRequest.java` | ソース | リクエストオブジェクト |
| GetIndexTemplatesResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/template/get/GetIndexTemplatesResponse.java` | ソース | レスポンスオブジェクト |
| IndexTemplateMetadata.java | `server/src/main/java/org/opensearch/cluster/metadata/IndexTemplateMetadata.java` | ソース | テンプレートメタデータモデル |
| MetadataIndexTemplateService.java | `server/src/main/java/org/opensearch/cluster/metadata/MetadataIndexTemplateService.java` | ソース | テンプレート管理サービス |
| indices.get_template.json | `rest-api-spec/src/main/resources/rest-api-spec/api/indices.get_template.json` | API定義 | REST API仕様定義 |
