# 画面設計書 64-インデックステンプレート存在確認（レガシー）

## 概要

本ドキュメントは、OpenSearchのレガシーインデックステンプレート存在確認API（`HEAD /_template/{name}`）の画面設計書である。指定されたレガシーインデックステンプレートがクラスタ状態に存在するかどうかをHEADリクエストで確認するREST APIエンドポイントについて、入出力仕様・処理フロー・エラーハンドリングを定義する。

### 本画面の処理概要

**業務上の目的・背景**：テンプレートの存在確認は、テンプレートの作成・更新・削除操作を行う前の事前チェックとして利用される。HEADメソッドを使用するため、レスポンスボディを返さず、HTTPステータスコードのみで存在の有無を判定できるため、帯域幅を節約しつつ効率的な存在確認が可能である。

**画面へのアクセス方法**：HTTPクライアント（curl、OpenSearch Dashboards Dev Tools等）から `HEAD /_template/{name}` へリクエストを送信する。

**主要な操作・処理内容**：
1. クライアントからHEADリクエストを受信し、テンプレート名を解析する
2. クラスタ状態のメタデータから一致するテンプレートを検索する
3. テンプレートが存在する場合は200 OK、存在しない場合は404 Not Foundを返す
4. HEADリクエストのためレスポンスボディは返却しない

**画面遷移**：テンプレート作成API（No.62）の前にテンプレートの存在を確認し、重複作成を防ぐ用途で使用される。テンプレート削除API（No.63）の前に削除対象の存在を確認する用途でも使用可能である。

**権限による表示制御**：クラスタレベルのメタデータ読み取り権限が必要である。テンプレート取得API（No.61）と同じ権限モデルが適用される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 7 | インデックステンプレート | 主機能 | レガシーインデックステンプレートの存在を確認する処理 |

## 画面種別

参照（テンプレート存在確認）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| HEAD | `/_template/{name}` | テンプレートの存在を確認 |

## 入出力項目

### パスパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|------|------|------|
| name | list (string) | 必須 | テンプレート名（カンマ区切りで複数指定可） |

### クエリパラメータ

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
|-------------|------|------|-----------|------|
| flat_settings | boolean | 任意 | false | 設定をフラット形式で返すかどうか |
| master_timeout | time | 任意 | 30s | クラスタマネージャノードへの接続タイムアウト |
| local | boolean | 任意 | false | ローカルノードの情報のみを返すかどうか |

## 表示項目

HEADリクエストのためレスポンスボディは返却されない。HTTPステータスコードのみで結果を表現する。

| HTTPステータス | 意味 |
|---------------|------|
| 200 OK | テンプレートが存在する |
| 404 Not Found | テンプレートが存在しない |

## イベント仕様

### 1-テンプレート存在確認リクエスト

1. クライアントがHEADリクエストを送信する
2. `RestGetIndexTemplateAction.prepareRequest()`がリクエストを解析する（HEADもGETと同じハンドラで処理）
3. `name`パラメータをカンマで分割し、テンプレート名の配列を設定する
4. クラスタ状態からテンプレートを検索する
5. テンプレートが存在する場合は200 OK、存在しない場合は404 Not Foundを返す
6. HEADメソッドのためレスポンスボディは含めない

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| テンプレート存在確認 | ClusterState（メモリ上） | SELECT | クラスタ状態のメタデータからテンプレートの存在を確認 |

### テーブル別更新項目詳細

#### ClusterState.Metadata.templates

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | IndexTemplateMetadata | nameパラメータに一致するテンプレートの存在を確認 | データの更新は行わない |

## メッセージ仕様

| メッセージID | 種別 | HTTPステータス | メッセージ内容 | 発生条件 |
|-------------|------|---------------|---------------|---------|
| - | 成功 | 200 OK | （ボディなし） | テンプレートが存在する場合 |
| - | 不存在 | 404 Not Found | （ボディなし） | テンプレートが存在しない場合 |

## 例外処理

| 例外 | HTTPステータス | 説明 |
|------|---------------|------|
| テンプレート未存在 | 404 | 指定名のテンプレートが存在しない（正常な不存在レスポンス） |
| タイムアウト | 408/500 | クラスタマネージャノードへの接続がタイムアウトした |
| 権限不足 | 403 | テンプレートの読み取り権限がない |

## 備考

- 本APIは`RestGetIndexTemplateAction`のroutes()にHEAD `/_template/{name}`として登録されており、GETと同じハンドラで処理される（69行目）。
- HEADリクエストではレスポンスボディが自動的に抑制される。
- `exists_template` REST API specでは`flat_settings`, `master_timeout`, `local`パラメータが定義されている。
- `cluster_manager_timeout`はexists_template specには明示的に定義されていないが、実装上は`RestGetIndexTemplateAction`でサポートされている。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | GetIndexTemplatesRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/template/get/GetIndexTemplatesRequest.java` | 存在確認もGETと同じリクエストオブジェクトを使用する点を理解する |
| 1-2 | GetIndexTemplatesResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/template/get/GetIndexTemplatesResponse.java` | レスポンスのテンプレートリストが空かどうかで存在判定する仕組みを理解する |

**読解のコツ**: 存在確認APIは独自のRequest/Responseクラスを持たず、GET APIのハンドラ内でHEADメソッドを処理する設計パターンに注目する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestGetIndexTemplateAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestGetIndexTemplateAction.java` | HEAD /_template/{name}がGETと同じハンドラで処理される仕組み |

**主要処理フロー**:
1. **69行目**: `routes()`にHEAD `/_template/{name}`が登録されている
2. **89行目**: HEADの場合、name必須のため`implicitAll = false`となる
3. **95-97行目**: テンプレートが空の場合NOT_FOUND、存在する場合OKを返す
4. HEADメソッドのためレスポンスボディは自動的に除外される

### プログラム呼び出し階層図

```
RestGetIndexTemplateAction.prepareRequest()  [HEAD /_template/{name}]
    |
    +-- Strings.splitStringByCommaToArray(name)
    |
    +-- new GetIndexTemplatesRequest(names)
    |
    +-- client.admin().indices().getTemplates()
            |
            +-- TransportGetIndexTemplatesAction.clusterManagerOperation()
                    |
                    +-- ClusterState.metadata().templates()
                    |
                    +-- GetIndexTemplatesResponse(filteredTemplates)
                            |
                            +-- getStatus() -> OK or NOT_FOUND (ボディなし)
```

### データフロー図

```
[入力]                          [処理]                                    [出力]

HEAD /_template/{name}  --> RestGetIndexTemplateAction.prepareRequest()
                                |
                       GetIndexTemplatesRequest生成
                                |
                       クラスタ状態からテンプレート検索
                                |
                       テンプレート存在判定              --> 200 OK（存在）
                                                        --> 404 Not Found（不存在）
                                                        （レスポンスボディなし）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestGetIndexTemplateAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestGetIndexTemplateAction.java` | ソース | RESTエンドポイントハンドラ（GET/HEAD共用） |
| GetIndexTemplatesRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/template/get/GetIndexTemplatesRequest.java` | ソース | リクエストオブジェクト |
| GetIndexTemplatesResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/template/get/GetIndexTemplatesResponse.java` | ソース | レスポンスオブジェクト |
| IndexTemplateMetadata.java | `server/src/main/java/org/opensearch/cluster/metadata/IndexTemplateMetadata.java` | ソース | テンプレートメタデータモデル |
| indices.exists_template.json | `rest-api-spec/src/main/resources/rest-api-spec/api/indices.exists_template.json` | API定義 | REST API仕様定義 |
