# 画面設計書 65-Composableインデックステンプレート取得

## 概要

本ドキュメントは、OpenSearchのComposableインデックステンプレート取得API（`GET /_index_template/{name}`）の画面設計書である。Composableインデックステンプレートの定義情報を取得するREST APIエンドポイントについて、入出力仕様・処理フロー・エラーハンドリングを定義する。

### 本画面の処理概要

**業務上の目的・背景**：Composableインデックステンプレートは、レガシーテンプレートの後継機能であり、コンポーネントテンプレートを組み合わせてモジュール化された形でインデックス設定を管理できる。運用管理者がテンプレートの定義内容を確認し、どのコンポーネントテンプレートが組み合わされているか、どのインデックスパターンに適用されるかを検証するために本APIが使用される。レガシーテンプレート（`_template`）よりもComposableテンプレートの使用が推奨される。

**画面へのアクセス方法**：HTTPクライアント（curl、OpenSearch Dashboards Dev Tools等）から `GET /_index_template` または `GET /_index_template/{name}` へリクエストを送信する。HEAD メソッドによる存在確認も同一エンドポイントで処理される（No.68参照）。

**主要な操作・処理内容**：
1. クライアントからGETリクエストを受信し、テンプレート名パラメータを解析する
2. 名前未指定時は全Composableインデックステンプレートを返却する
3. クラスタ状態のメタデータから`ComposableIndexTemplate`を取得し、JSON形式で返却する
4. テンプレートが見つからない場合、名前指定時は404、名前未指定時は200を返す

**画面遷移**：テンプレート作成API（No.66）で作成したテンプレートの確認に使用される。コンポーネントテンプレート取得API（No.69）で構成要素の詳細を確認する運用フローが一般的である。テンプレートシミュレーションAPI（No.73, No.74）と組み合わせてテンプレートの適用結果を事前検証できる。

**権限による表示制御**：クラスタレベルのメタデータ読み取り権限が必要である。セキュリティプラグイン有効時はインデックステンプレートの読み取り権限が求められる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 7 | インデックステンプレート | 主機能 | Composableインデックステンプレートを返す処理 |

## 画面種別

参照（Composableテンプレート定義の取得・一覧表示）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_index_template` | 全Composableテンプレートを取得 |
| GET | `/_index_template/{name}` | 指定名のComposableテンプレートを取得 |
| HEAD | `/_index_template/{name}` | テンプレートの存在確認（No.68で詳述） |

## 入出力項目

### パスパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|------|------|------|
| name | list (string) | 任意 | テンプレート名（カンマ区切りで複数指定可、ワイルドカード対応） |

### クエリパラメータ

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
|-------------|------|------|-----------|------|
| flat_settings | boolean | 任意 | false | 設定をフラット形式で返すかどうか |
| cluster_manager_timeout | time | 任意 | 30s | クラスタマネージャノードへの接続タイムアウト |
| master_timeout | time | 任意 | 30s | 非推奨（v2.0.0）。cluster_manager_timeoutを使用すること |
| local | boolean | 任意 | false | ローカルノードの情報のみを返すかどうか |

## 表示項目

### レスポンスボディ

| 項目名 | 型 | 説明 |
|--------|------|------|
| index_templates | array | テンプレート情報の配列 |
| index_templates[].name | string | テンプレート名 |
| index_templates[].index_template | object | テンプレート定義 |
| index_templates[].index_template.index_patterns | array[string] | 適用対象のインデックスパターン |
| index_templates[].index_template.composed_of | array[string] | 組み合わせるコンポーネントテンプレート名の配列 |
| index_templates[].index_template.priority | integer | テンプレートの優先順位（大きい値が優先） |
| index_templates[].index_template.version | integer | テンプレートのバージョン番号 |
| index_templates[].index_template.template | object | テンプレートのインライン設定 |
| index_templates[].index_template.template.settings | object | インデックス設定 |
| index_templates[].index_template.template.mappings | object | マッピング定義 |
| index_templates[].index_template.template.aliases | object | エイリアス定義 |
| index_templates[].index_template.data_stream | object | データストリーム設定（該当時） |
| index_templates[].index_template._meta | object | ユーザー定義メタデータ |

## イベント仕様

### 1-Composableテンプレート取得リクエスト

1. クライアントがGETリクエストを送信する
2. `RestGetComposableIndexTemplateAction.prepareRequest()`がリクエストを解析する
3. `name`パラメータから`GetComposableIndexTemplateAction.Request`を生成する（79行目）
4. `local`, `cluster_manager_timeout`パラメータを設定する（81-83行目）
5. `implicitAll`を判定する（name未指定の場合true）（85行目）
6. `client.execute(GetComposableIndexTemplateAction.INSTANCE, getRequest)`でテンプレート取得を実行する（87-88行目）
7. テンプレートが存在するか判定し、OK/NOT_FOUNDステータスを返す（92-94行目）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| テンプレート取得 | ClusterState（メモリ上） | SELECT | クラスタ状態のメタデータからComposableテンプレートを読み取る |

### テーブル別更新項目詳細

#### ClusterState.Metadata.indexTemplates（ComposableIndexTemplateMetadata）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | ComposableIndexTemplate | nameパラメータに一致するテンプレートを取得 | ワイルドカードマッチング対応 |

## メッセージ仕様

| メッセージID | 種別 | HTTPステータス | メッセージ内容 | 発生条件 |
|-------------|------|---------------|---------------|---------|
| - | 成功 | 200 OK | テンプレート定義のJSON | テンプレートが見つかった場合、または名前未指定の場合 |
| - | エラー | 404 Not Found | テンプレートが見つからない | 名前指定でテンプレートが存在しない場合 |

## 例外処理

| 例外 | HTTPステータス | 説明 |
|------|---------------|------|
| テンプレート未存在 | 404 | 指定名のテンプレートがクラスタ状態に存在しない |
| タイムアウト | 408/500 | クラスタマネージャノードへの接続がタイムアウトした |
| 権限不足 | 403 | テンプレート読み取り権限がない |

## 備考

- 本APIはexperimental安定性レベルで提供されている（REST API specのstability: experimental）。
- Composableテンプレートはレガシーテンプレートの後継であり、コンポーネントテンプレート（`_component_template`）を組み合わせて再利用可能なテンプレート構成を実現する。
- レスポンス形式はレガシーテンプレート（`_template`）とは異なり、`index_templates`配列として返される。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ComposableIndexTemplate.java | `server/src/main/java/org/opensearch/cluster/metadata/ComposableIndexTemplate.java` | Composableテンプレートのデータ構造（indexPatterns, composedOf, priority, template, dataStreamTemplate等）を理解する |
| 1-2 | ComposableIndexTemplateMetadata.java | `server/src/main/java/org/opensearch/cluster/metadata/ComposableIndexTemplateMetadata.java` | クラスタ状態内でのテンプレートの格納形式を理解する |

**読解のコツ**: `ComposableIndexTemplate`の`composedOf`フィールドがコンポーネントテンプレート名のリストであることが、レガシーテンプレートとの最大の差異である。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestGetComposableIndexTemplateAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestGetComposableIndexTemplateAction.java` | RESTリクエストの受信からアクション実行までの流れ |

**主要処理フロー**:
1. **64-69行目**: `routes()`でGET/HEAD `/_index_template`と`/_index_template/{name}`を登録
2. **79行目**: `name`パラメータから`GetComposableIndexTemplateAction.Request`を生成
3. **81-83行目**: local, cluster_manager_timeout, master_timeout（非推奨）パラメータを設定
4. **85行目**: `implicitAll = getRequest.name() == null`で全件取得か判定
5. **87-97行目**: アクション実行とステータスコード判定

#### Step 3: トランスポートアクション層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | GetComposableIndexTemplateAction.java | `server/src/main/java/org/opensearch/action/admin/indices/template/get/GetComposableIndexTemplateAction.java` | アクション定義とRequest/Responseの内部クラス |
| 3-2 | MetadataIndexTemplateService.java | `server/src/main/java/org/opensearch/cluster/metadata/MetadataIndexTemplateService.java` | テンプレート管理の中核サービス |

### プログラム呼び出し階層図

```
RestGetComposableIndexTemplateAction.prepareRequest()
    |
    +-- new GetComposableIndexTemplateAction.Request(name)
    |
    +-- client.execute(GetComposableIndexTemplateAction.INSTANCE, getRequest)
            |
            +-- TransportGetComposableIndexTemplateAction.clusterManagerOperation()
                    |
                    +-- ClusterState.metadata().templatesV2()
                    |
                    +-- GetComposableIndexTemplateAction.Response(filteredTemplates)
```

### データフロー図

```
[入力]                              [処理]                                         [出力]

GET /_index_template/{name}  --> RestGetComposableIndexTemplateAction.prepareRequest()
                                       |
                              GetComposableIndexTemplateAction.Request生成
                                       |
                              TransportGetComposableIndexTemplateAction実行
                                       |
                              ClusterState.metadata().templatesV2()        --> index_templates配列
                              から一致テンプレートをフィルタ                    (200 OK / 404 Not Found)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestGetComposableIndexTemplateAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestGetComposableIndexTemplateAction.java` | ソース | RESTエンドポイントハンドラ |
| GetComposableIndexTemplateAction.java | `server/src/main/java/org/opensearch/action/admin/indices/template/get/GetComposableIndexTemplateAction.java` | ソース | アクション定義（Request/Response含む） |
| ComposableIndexTemplate.java | `server/src/main/java/org/opensearch/cluster/metadata/ComposableIndexTemplate.java` | ソース | テンプレートデータモデル |
| ComposableIndexTemplateMetadata.java | `server/src/main/java/org/opensearch/cluster/metadata/ComposableIndexTemplateMetadata.java` | ソース | テンプレートメタデータ |
| MetadataIndexTemplateService.java | `server/src/main/java/org/opensearch/cluster/metadata/MetadataIndexTemplateService.java` | ソース | テンプレート管理サービス |
| indices.get_index_template.json | `rest-api-spec/src/main/resources/rest-api-spec/api/indices.get_index_template.json` | API定義 | REST API仕様定義 |
