# 画面設計書 66-Composableインデックステンプレート作成

## 概要

本ドキュメントは、OpenSearchのComposableインデックステンプレート作成・更新API（`PUT/POST /_index_template/{name}`）の画面設計書である。Composableインデックステンプレートの新規作成および既存テンプレートの更新を行うREST APIエンドポイントについて、入出力仕様・処理フロー・エラーハンドリングを定義する。

### 本画面の処理概要

**業務上の目的・背景**：Composableインデックステンプレートは、コンポーネントテンプレートを組み合わせてモジュール化された形でインデックス設定を定義する仕組みである。レガシーテンプレートの後継として推奨される方式であり、設定の再利用性・保守性が向上する。`composed_of`フィールドでコンポーネントテンプレートを参照し、`priority`で複数テンプレートの適用優先順位を制御する。データストリームの作成にも使用される。

**画面へのアクセス方法**：HTTPクライアント（curl、OpenSearch Dashboards Dev Tools等）から `PUT /_index_template/{name}` または `POST /_index_template/{name}` へリクエストボディ付きでリクエストを送信する。

**主要な操作・処理内容**：
1. クライアントからPUT/POSTリクエストを受信し、テンプレート名とリクエストボディを解析する
2. リクエストボディをComposableIndexTemplateとしてパースする
3. `create`パラメータがtrueの場合、既存テンプレートが存在するとエラーを返す
4. `cause`パラメータで作成・更新理由を記録する（デフォルト: "api"）
5. クラスタ状態を更新し、テンプレート定義を永続化する

**画面遷移**：コンポーネントテンプレート作成API（No.70）でコンポーネントテンプレートを作成した後に本APIで参照する構成が一般的である。作成されたテンプレートはインデックス作成API（No.38）実行時やデータストリーム作成API（No.75）で自動適用される。テンプレート取得API（No.65）で定義を確認できる。

**権限による表示制御**：クラスタレベルのメタデータ書き込み権限が必要である。セキュリティプラグイン有効時はインデックステンプレートの作成・更新権限が求められる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 7 | インデックステンプレート | 主機能 | Composableインデックステンプレートを作成または更新する処理 |

## 画面種別

登録・編集（Composableテンプレート定義の作成・更新）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| PUT | `/_index_template/{name}` | テンプレートを作成または更新 |
| POST | `/_index_template/{name}` | テンプレートを作成または更新 |

## 入出力項目

### パスパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|------|------|------|
| name | string | 必須 | テンプレート名 |

### クエリパラメータ

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
|-------------|------|------|-----------|------|
| create | boolean | 任意 | false | trueの場合、テンプレートが既に存在する場合にエラーを返す |
| cause | string | 任意 | "api" | テンプレート作成・更新の理由 |
| cluster_manager_timeout | time | 任意 | 30s | クラスタマネージャノードへの接続タイムアウト |
| master_timeout | time | 任意 | 30s | 非推奨（v2.0.0）。cluster_manager_timeoutを使用すること |

### リクエストボディ（必須）

| 項目名 | 型 | 必須 | 説明 |
|--------|------|------|------|
| index_patterns | array[string] | 必須 | テンプレートを適用するインデックスパターン |
| composed_of | array[string] | 任意 | 組み合わせるコンポーネントテンプレート名の配列 |
| priority | integer | 任意 | テンプレートの優先順位（大きい値が優先、デフォルト: 0） |
| version | integer | 任意 | テンプレートのバージョン番号 |
| template | object | 任意 | インライン設定 |
| template.settings | object | 任意 | インデックス設定 |
| template.mappings | object | 任意 | マッピング定義 |
| template.aliases | object | 任意 | エイリアス定義 |
| data_stream | object | 任意 | データストリーム設定 |
| _meta | object | 任意 | ユーザー定義メタデータ |

## 表示項目

### レスポンスボディ

| 項目名 | 型 | 説明 |
|--------|------|------|
| acknowledged | boolean | リクエストが正常に処理されたかどうか |

## イベント仕様

### 1-Composableテンプレート作成・更新リクエスト

1. クライアントがPUT/POSTリクエストをリクエストボディ付きで送信する
2. `RestPutComposableIndexTemplateAction.prepareRequest()`がリクエストを解析する
3. `name`パスパラメータから`PutComposableIndexTemplateAction.Request`を生成する（72行目）
4. `cluster_manager_timeout`, `create`, `cause`パラメータを設定する（73-76行目）
5. リクエストボディを`ComposableIndexTemplate.parse()`でパースする（77行目）
6. `client.execute(PutComposableIndexTemplateAction.INSTANCE, putRequest)`でテンプレート作成を実行する（79行目）
7. クラスタマネージャノードでMetadataIndexTemplateServiceがテンプレートを検証・保存する

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| テンプレート作成 | ClusterState（メモリ上） | INSERT | クラスタ状態のメタデータに新規Composableテンプレートを追加 |
| テンプレート更新 | ClusterState（メモリ上） | UPDATE | クラスタ状態のメタデータの既存Composableテンプレートを置換 |

### テーブル別更新項目詳細

#### ClusterState.Metadata.indexTemplates（ComposableIndexTemplateMetadata）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | ComposableIndexTemplate | リクエストボディの内容をパースしたComposableIndexTemplateオブジェクト | create=trueの場合、既存テンプレートが存在するとエラー |

## メッセージ仕様

| メッセージID | 種別 | HTTPステータス | メッセージ内容 | 発生条件 |
|-------------|------|---------------|---------------|---------|
| - | 成功 | 200 OK | {"acknowledged": true} | テンプレートが正常に作成・更新された場合 |
| - | エラー | 400 Bad Request | バリデーションエラー | index_patternsが未指定、参照するコンポーネントテンプレートが存在しない等 |
| - | エラー | 400 Bad Request | テンプレート既存エラー | create=trueで既存テンプレートが存在する場合 |

## 例外処理

| 例外 | HTTPステータス | 説明 |
|------|---------------|------|
| index_patterns未指定 | 400 | テンプレートのインデックスパターンが指定されていない |
| コンポーネントテンプレート未存在 | 400 | composed_ofで参照するコンポーネントテンプレートが存在しない |
| マッピング不正 | 400 | マッピング定義の構文が不正 |
| テンプレート既存（create=true） | 400 | create=trueで既にテンプレートが存在する |
| タイムアウト | 408/500 | クラスタマネージャノードへの接続がタイムアウトした |
| 権限不足 | 403 | テンプレートの作成・更新権限がない |

## 備考

- 本APIはexperimental安定性レベルで提供されている。
- Composableテンプレートの`composed_of`で指定したコンポーネントテンプレートが存在しない場合、テンプレートの作成は成功するが警告が出力される場合がある。
- `priority`で複数テンプレートの適用優先順位を制御する。同一priorityの場合はインデックスパターンの具体性で判断される。
- `data_stream`を設定することで、データストリーム用テンプレートとして使用できる。
- `cause`パラメータのデフォルト値は"api"である（ソースコード76行目）。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ComposableIndexTemplate.java | `server/src/main/java/org/opensearch/cluster/metadata/ComposableIndexTemplate.java` | テンプレートのデータ構造（indexPatterns, composedOf, priority, template, dataStreamTemplate, metadata）とparse()メソッドを理解する |
| 1-2 | PutComposableIndexTemplateAction.java | `server/src/main/java/org/opensearch/action/admin/indices/template/put/PutComposableIndexTemplateAction.java` | リクエスト/レスポンスの内部クラス構造を理解する |

**読解のコツ**: `ComposableIndexTemplate.parse()`がリクエストボディのJSONをどのようにパースするかに注目する。`PARSER`フィールドのObjectParser定義がフィールド名と型のマッピングを示す。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestPutComposableIndexTemplateAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestPutComposableIndexTemplateAction.java` | RESTリクエストの受信・パラメータ解析・ボディパース |

**主要処理フロー**:
1. **60-61行目**: `routes()`でPOSTとPUTの`/_index_template/{name}`ルートを登録
2. **72行目**: テンプレート名からPutComposableIndexTemplateAction.Requestを生成
3. **73-76行目**: cluster_manager_timeout, create, causeパラメータを設定
4. **77行目**: `ComposableIndexTemplate.parse(request.contentParser())`でリクエストボディをパース
5. **79行目**: `client.execute()`でテンプレート作成を実行

#### Step 3: テンプレート管理サービスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | MetadataIndexTemplateService.java | `server/src/main/java/org/opensearch/cluster/metadata/MetadataIndexTemplateService.java` | addIndexTemplateV2()メソッドでComposableテンプレートを検証・保存するロジック |

### プログラム呼び出し階層図

```
RestPutComposableIndexTemplateAction.prepareRequest()
    |
    +-- new PutComposableIndexTemplateAction.Request(name)
    |
    +-- ComposableIndexTemplate.parse(contentParser)
    |
    +-- client.execute(PutComposableIndexTemplateAction.INSTANCE, putRequest)
            |
            +-- TransportPutComposableIndexTemplateAction.clusterManagerOperation()
                    |
                    +-- MetadataIndexTemplateService.addIndexTemplateV2()
                            |
                            +-- validate(template)
                            |
                            +-- ClusterState.builder().metadata(updated).build()
```

### データフロー図

```
[入力]                                  [処理]                                        [出力]

PUT /_index_template/{name}    --> RestPutComposableIndexTemplateAction.prepareRequest()
  + JSON body                           |
                                ComposableIndexTemplate.parse(body)
                                        |
                                PutComposableIndexTemplateAction.Request生成
                                        |
                                TransportPutComposableIndexTemplateAction実行
                                        |
                                MetadataIndexTemplateService.addIndexTemplateV2()  --> {"acknowledged": true}
                                        |
                                ClusterState更新（テンプレート追加/置換）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestPutComposableIndexTemplateAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestPutComposableIndexTemplateAction.java` | ソース | RESTエンドポイントハンドラ |
| PutComposableIndexTemplateAction.java | `server/src/main/java/org/opensearch/action/admin/indices/template/put/PutComposableIndexTemplateAction.java` | ソース | アクション定義 |
| ComposableIndexTemplate.java | `server/src/main/java/org/opensearch/cluster/metadata/ComposableIndexTemplate.java` | ソース | テンプレートデータモデル |
| MetadataIndexTemplateService.java | `server/src/main/java/org/opensearch/cluster/metadata/MetadataIndexTemplateService.java` | ソース | テンプレート管理サービス |
| indices.put_index_template.json | `rest-api-spec/src/main/resources/rest-api-spec/api/indices.put_index_template.json` | API定義 | REST API仕様定義 |
