# 画面設計書 67-Composableインデックステンプレート削除

## 概要

本ドキュメントは、OpenSearchのComposableインデックステンプレート削除API（`DELETE /_index_template/{name}`）の画面設計書である。クラスタ状態からComposableインデックステンプレートの定義を削除するREST APIエンドポイントについて、入出力仕様・処理フロー・エラーハンドリングを定義する。

### 本画面の処理概要

**業務上の目的・背景**：不要となったComposableインデックステンプレートを削除することで、クラスタメタデータの肥大化を防ぎ、意図しないテンプレートの自動適用を回避する。テンプレートの削除は新しいインデックスの作成時に当該テンプレートが適用されなくなることを意味し、既存のインデックスには影響しない。Composableテンプレートが参照するコンポーネントテンプレートは削除されない。

**画面へのアクセス方法**：HTTPクライアント（curl、OpenSearch Dashboards Dev Tools等）から `DELETE /_index_template/{name}` へリクエストを送信する。

**主要な操作・処理内容**：
1. クライアントからDELETEリクエストを受信し、削除対象のテンプレート名を取得する
2. クラスタマネージャノードに削除リクエストを転送する
3. クラスタ状態のメタデータからComposableテンプレートを削除し、新しいクラスタ状態を確定する
4. 削除結果（acknowledged）をレスポンスとして返す

**画面遷移**：テンプレート取得API（No.65）で既存テンプレートを確認した後、本APIで不要なテンプレートを削除する運用フローが想定される。テンプレート存在確認API（No.68）で事前に存在確認を行うことも可能である。

**権限による表示制御**：クラスタレベルのメタデータ書き込み権限が必要である。セキュリティプラグイン有効時はインデックステンプレートの削除権限が求められる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 7 | インデックステンプレート | 主機能 | Composableインデックステンプレートを削除する処理 |

## 画面種別

削除（Composableテンプレート定義の削除）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| DELETE | `/_index_template/{name}` | 指定名のComposableテンプレートを削除 |

## 入出力項目

### パスパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|------|------|------|
| name | string | 必須 | 削除対象のテンプレート名 |

### クエリパラメータ

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
|-------------|------|------|-----------|------|
| timeout | time | 任意 | 30s | 操作タイムアウト |
| cluster_manager_timeout | time | 任意 | 30s | クラスタマネージャノードへの接続タイムアウト |
| master_timeout | time | 任意 | 30s | 非推奨（v2.0.0）。cluster_manager_timeoutを使用すること |

## 表示項目

### レスポンスボディ

| 項目名 | 型 | 説明 |
|--------|------|------|
| acknowledged | boolean | リクエストが正常に処理されたかどうか |

## イベント仕様

### 1-Composableテンプレート削除リクエスト

1. クライアントがDELETEリクエストを送信する
2. `RestDeleteComposableIndexTemplateAction.prepareRequest()`がリクエストを解析する
3. `name`パスパラメータから`DeleteComposableIndexTemplateAction.Request`を生成する（70行目）
4. `cluster_manager_timeout`パラメータを設定する（71行目）
5. `master_timeout`パラメータが指定された場合は非推奨警告を出力する（72行目）
6. `client.execute(DeleteComposableIndexTemplateAction.INSTANCE, deleteReq)`でテンプレート削除を実行する（74行目）
7. クラスタマネージャノードでクラスタ状態のメタデータからテンプレートを削除する

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| テンプレート削除 | ClusterState（メモリ上） | DELETE | クラスタ状態のメタデータから指定Composableテンプレートを削除 |

### テーブル別更新項目詳細

#### ClusterState.Metadata.indexTemplates（ComposableIndexTemplateMetadata）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | ComposableIndexTemplate | nameに一致するテンプレートを削除 | テンプレートが存在しない場合はエラー |

## メッセージ仕様

| メッセージID | 種別 | HTTPステータス | メッセージ内容 | 発生条件 |
|-------------|------|---------------|---------------|---------|
| - | 成功 | 200 OK | {"acknowledged": true} | テンプレートが正常に削除された場合 |
| - | エラー | 404 Not Found | index_template_missing_exception | 指定テンプレートが存在しない場合 |

## 例外処理

| 例外 | HTTPステータス | 説明 |
|------|---------------|------|
| テンプレート未存在 | 404 | 指定名のComposableテンプレートが存在しない |
| タイムアウト | 408/500 | クラスタマネージャノードへの接続がタイムアウトした |
| 権限不足 | 403 | テンプレートの削除権限がない |

## 備考

- 本APIはexperimental安定性レベルで提供されている。
- Composableテンプレートを削除しても、テンプレートが参照していたコンポーネントテンプレートは削除されない。
- 既存のインデックスには影響しない。新しいインデックスの作成時にのみ影響する。
- ワイルドカードによる一括削除は`name`パラメータがstring型のため直接サポートされない。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DeleteComposableIndexTemplateAction.java | `server/src/main/java/org/opensearch/action/admin/indices/template/delete/DeleteComposableIndexTemplateAction.java` | 削除リクエストの構造（nameフィールド）を理解する |

**読解のコツ**: `DeleteComposableIndexTemplateAction`はActionType定義とRequest内部クラスを含むシンプルな構造である。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestDeleteComposableIndexTemplateAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestDeleteComposableIndexTemplateAction.java` | RESTリクエストの受信・パラメータ解析 |

**主要処理フロー**:
1. **58-59行目**: `routes()`でDELETE `/_index_template/{name}`ルートを登録
2. **70行目**: `name`パスパラメータから`DeleteComposableIndexTemplateAction.Request`を生成
3. **71-72行目**: cluster_manager_timeout, master_timeout（非推奨）を設定
4. **74行目**: `client.execute(DeleteComposableIndexTemplateAction.INSTANCE, deleteReq)`で削除実行

#### Step 3: テンプレート管理サービスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | MetadataIndexTemplateService.java | `server/src/main/java/org/opensearch/cluster/metadata/MetadataIndexTemplateService.java` | removeIndexTemplateV2()メソッドでクラスタ状態からComposableテンプレートを削除するロジック |

### プログラム呼び出し階層図

```
RestDeleteComposableIndexTemplateAction.prepareRequest()
    |
    +-- new DeleteComposableIndexTemplateAction.Request(name)
    |
    +-- client.execute(DeleteComposableIndexTemplateAction.INSTANCE, deleteReq)
            |
            +-- TransportDeleteComposableIndexTemplateAction.clusterManagerOperation()
                    |
                    +-- MetadataIndexTemplateService.removeIndexTemplateV2()
                            |
                            +-- ClusterState.builder().metadata(updated).build()
```

### データフロー図

```
[入力]                                  [処理]                                        [出力]

DELETE /_index_template/{name}  --> RestDeleteComposableIndexTemplateAction.prepareRequest()
                                         |
                                DeleteComposableIndexTemplateAction.Request生成
                                         |
                                TransportDeleteComposableIndexTemplateAction実行
                                         |
                                MetadataIndexTemplateService.removeIndexTemplateV2()  --> {"acknowledged": true}
                                         |                                                (200 OK / 404 Not Found)
                                ClusterState更新（テンプレート削除）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestDeleteComposableIndexTemplateAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestDeleteComposableIndexTemplateAction.java` | ソース | RESTエンドポイントハンドラ |
| DeleteComposableIndexTemplateAction.java | `server/src/main/java/org/opensearch/action/admin/indices/template/delete/DeleteComposableIndexTemplateAction.java` | ソース | アクション定義 |
| MetadataIndexTemplateService.java | `server/src/main/java/org/opensearch/cluster/metadata/MetadataIndexTemplateService.java` | ソース | テンプレート管理サービス |
| indices.delete_index_template.json | `rest-api-spec/src/main/resources/rest-api-spec/api/indices.delete_index_template.json` | API定義 | REST API仕様定義 |
