# 画面設計書 69-コンポーネントテンプレート取得

## 概要

本ドキュメントは、OpenSearchのコンポーネントテンプレート取得API（`GET /_component_template/{name}`）の画面設計書である。コンポーネントテンプレートの定義情報を取得するREST APIエンドポイントについて、入出力仕様・処理フロー・エラーハンドリングを定義する。

### 本画面の処理概要

**業務上の目的・背景**：コンポーネントテンプレートは、Composableインデックステンプレートの構成要素として使用される再利用可能な設定・マッピング・エイリアスの定義ブロックである。複数のComposableテンプレートで共通する設定を一元管理するために使用される。運用管理者がコンポーネントテンプレートの現在の定義内容を確認し、どのような設定が含まれているかを検証するために本APIが使用される。

**画面へのアクセス方法**：HTTPクライアント（curl、OpenSearch Dashboards Dev Tools等）から `GET /_component_template` または `GET /_component_template/{name}` へリクエストを送信する。HEADメソッドによる存在確認も同一エンドポイントで処理される。

**主要な操作・処理内容**：
1. クライアントからGETリクエストを受信し、テンプレート名パラメータを解析する
2. 名前未指定時は全コンポーネントテンプレートを返却する
3. クラスタ状態のメタデータから`ComponentTemplate`を取得し、JSON形式で返却する
4. テンプレートが見つからない場合、名前指定時は404、名前未指定時は200を返す

**画面遷移**：コンポーネントテンプレート作成API（No.70）で作成したテンプレートの確認に使用される。Composableインデックステンプレート作成API（No.66）の`composed_of`で参照する前にコンポーネントテンプレートの内容を確認する運用フローが一般的である。

**権限による表示制御**：クラスタレベルのメタデータ読み取り権限が必要である。セキュリティプラグイン有効時はコンポーネントテンプレートの読み取り権限が求められる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 7 | インデックステンプレート | 主機能 | コンポーネントテンプレートを返す処理 |

## 画面種別

参照（コンポーネントテンプレート定義の取得・一覧表示）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_component_template` | 全コンポーネントテンプレートを取得 |
| GET | `/_component_template/{name}` | 指定名のコンポーネントテンプレートを取得 |
| HEAD | `/_component_template/{name}` | テンプレートの存在確認 |

## 入出力項目

### パスパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|------|------|------|
| name | list (string) | 任意 | テンプレート名（カンマ区切りで複数指定可、ワイルドカード対応） |

### クエリパラメータ

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
|-------------|------|------|-----------|------|
| cluster_manager_timeout | time | 任意 | 30s | クラスタマネージャノードへの接続タイムアウト |
| master_timeout | time | 任意 | 30s | 非推奨（v2.0.0）。cluster_manager_timeoutを使用すること |
| local | boolean | 任意 | false | ローカルノードの情報のみを返すかどうか |

## 表示項目

### レスポンスボディ

| 項目名 | 型 | 説明 |
|--------|------|------|
| component_templates | array | コンポーネントテンプレート情報の配列 |
| component_templates[].name | string | テンプレート名 |
| component_templates[].component_template | object | テンプレート定義 |
| component_templates[].component_template.template | object | テンプレート設定 |
| component_templates[].component_template.template.settings | object | インデックス設定 |
| component_templates[].component_template.template.mappings | object | マッピング定義 |
| component_templates[].component_template.template.aliases | object | エイリアス定義 |
| component_templates[].component_template.version | integer | テンプレートのバージョン番号 |
| component_templates[].component_template._meta | object | ユーザー定義メタデータ |

## イベント仕様

### 1-コンポーネントテンプレート取得リクエスト

1. クライアントがGETリクエストを送信する
2. `RestGetComponentTemplateAction.prepareRequest()`がリクエストを解析する
3. `name`パラメータから`GetComponentTemplateAction.Request`を生成する（80行目）
4. `local`, `cluster_manager_timeout`パラメータを設定する（82-84行目）
5. `implicitAll`を判定する（name未指定の場合true）（86行目）
6. `client.execute(GetComponentTemplateAction.INSTANCE, getRequest)`でテンプレート取得を実行する（88-89行目）
7. テンプレートが存在するか判定し、OK/NOT_FOUNDステータスを返す（93-95行目）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| テンプレート取得 | ClusterState（メモリ上） | SELECT | クラスタ状態のメタデータからコンポーネントテンプレートを読み取る |

### テーブル別更新項目詳細

#### ClusterState.Metadata.componentTemplates（ComponentTemplateMetadata）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | ComponentTemplate | nameパラメータに一致するテンプレートを取得 | ワイルドカードマッチング対応 |

## メッセージ仕様

| メッセージID | 種別 | HTTPステータス | メッセージ内容 | 発生条件 |
|-------------|------|---------------|---------------|---------|
| - | 成功 | 200 OK | テンプレート定義のJSON | テンプレートが見つかった場合、または名前未指定の場合 |
| - | エラー | 404 Not Found | テンプレートが見つからない | 名前指定でテンプレートが存在しない場合 |

## 例外処理

| 例外 | HTTPステータス | 説明 |
|------|---------------|------|
| テンプレート未存在 | 404 | 指定名のコンポーネントテンプレートが存在しない |
| タイムアウト | 408/500 | クラスタマネージャノードへの接続がタイムアウトした |
| 権限不足 | 403 | テンプレートの読み取り権限がない |

## 備考

- 本APIはexperimental安定性レベルで提供されている（REST API specのstability: experimental）。
- コンポーネントテンプレートは単体では直接インデックスに適用されない。Composableインデックステンプレートの`composed_of`フィールドで参照されることで間接的に適用される。
- HEADメソッドによる存在確認も`RestGetComponentTemplateAction`で処理される（routes()にHEADが含まれる：68行目）。
- レスポンスは`component_templates`配列形式で返される。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ComponentTemplate.java | `server/src/main/java/org/opensearch/cluster/metadata/ComponentTemplate.java` | コンポーネントテンプレートのデータ構造（template, version, metadata）を理解する |
| 1-2 | ComponentTemplateMetadata.java | `server/src/main/java/org/opensearch/cluster/metadata/ComponentTemplateMetadata.java` | クラスタ状態内でのテンプレートの格納形式を理解する |

**読解のコツ**: `ComponentTemplate`はComposableIndexTemplateより単純な構造で、`template`（Template クラス）にsettings/mappings/aliasesが含まれる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestGetComponentTemplateAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestGetComponentTemplateAction.java` | RESTリクエストの受信からアクション実行までの流れ |

**主要処理フロー**:
1. **64-69行目**: `routes()`でGET/HEAD `/_component_template`と`/_component_template/{name}`を登録
2. **80行目**: `name`パラメータから`GetComponentTemplateAction.Request`を生成
3. **82-84行目**: local, cluster_manager_timeout, master_timeout（非推奨）パラメータを設定
4. **86行目**: `implicitAll = getRequest.name() == null`で全件取得か判定
5. **88-98行目**: アクション実行とステータスコード判定（空リストかつimplicitAll=falseの場合NOT_FOUND）

#### Step 3: トランスポートアクション層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | GetComponentTemplateAction.java | `server/src/main/java/org/opensearch/action/admin/indices/template/get/GetComponentTemplateAction.java` | アクション定義とRequest/Responseの内部クラス |

### プログラム呼び出し階層図

```
RestGetComponentTemplateAction.prepareRequest()
    |
    +-- new GetComponentTemplateAction.Request(name)
    |
    +-- client.execute(GetComponentTemplateAction.INSTANCE, getRequest)
            |
            +-- TransportGetComponentTemplateAction.clusterManagerOperation()
                    |
                    +-- ClusterState.metadata().componentTemplates()
                    |
                    +-- GetComponentTemplateAction.Response(filteredTemplates)
```

### データフロー図

```
[入力]                                  [処理]                                         [出力]

GET /_component_template/{name}  --> RestGetComponentTemplateAction.prepareRequest()
                                          |
                                 GetComponentTemplateAction.Request生成
                                          |
                                 TransportGetComponentTemplateAction実行
                                          |
                                 ClusterState.metadata().componentTemplates()  --> component_templates配列
                                 から一致テンプレートをフィルタ                     (200 OK / 404 Not Found)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestGetComponentTemplateAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestGetComponentTemplateAction.java` | ソース | RESTエンドポイントハンドラ |
| GetComponentTemplateAction.java | `server/src/main/java/org/opensearch/action/admin/indices/template/get/GetComponentTemplateAction.java` | ソース | アクション定義（Request/Response含む） |
| ComponentTemplate.java | `server/src/main/java/org/opensearch/cluster/metadata/ComponentTemplate.java` | ソース | テンプレートデータモデル |
| ComponentTemplateMetadata.java | `server/src/main/java/org/opensearch/cluster/metadata/ComponentTemplateMetadata.java` | ソース | テンプレートメタデータ |
| MetadataIndexTemplateService.java | `server/src/main/java/org/opensearch/cluster/metadata/MetadataIndexTemplateService.java` | ソース | テンプレート管理サービス |
| cluster.get_component_template.json | `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.get_component_template.json` | API定義 | REST API仕様定義 |
