# 画面設計書 71-コンポーネントテンプレート削除

## 概要

本ドキュメントは、OpenSearchのコンポーネントテンプレート削除API（DELETE /_component_template/{name}）の画面設計書である。コンポーネントテンプレートをクラスタメタデータから削除するREST APIエンドポイントの仕様を定義する。

### 本画面の処理概要

本APIエンドポイントは、指定された名前のコンポーネントテンプレートをOpenSearchクラスタから削除する処理を提供する。

**業務上の目的・背景**：コンポーネントテンプレートは、Composableインデックステンプレートの構成要素として使用される再利用可能なテンプレート部品である。不要になったコンポーネントテンプレートを削除することで、テンプレート管理の整理・クリーンアップを行い、メタデータの肥大化を防止する。テンプレート構成の変更やリファクタリング時に必要となる操作である。

**画面へのアクセス方法**：RESTクライアント（curl、OpenSearch Dashboards Dev Toolsなど）から `DELETE /_component_template/{name}` エンドポイントにHTTP DELETEリクエストを送信する。

**主要な操作・処理内容**：
1. クライアントから削除対象のコンポーネントテンプレート名を受け取る
2. クラスタマネージャノードへリクエストを転送する
3. クラスタメタデータからコンポーネントテンプレートを削除する
4. 削除結果（acknowledged）をクライアントに返却する

**画面遷移**：本APIは単独で使用される削除操作である。事前にコンポーネントテンプレート取得API（GET /_component_template/{name}）で存在確認を行い、その後本APIで削除する運用フローが一般的である。削除後はComposableインデックステンプレート作成APIでテンプレート構成を再構築する場合がある。

**権限による表示制御**：クラスタレベルのMETADATA_WRITE権限が必要である。権限がない場合はセキュリティプラグインにより403エラーが返却される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 7 | インデックステンプレート | 主機能 | コンポーネントテンプレートを削除する処理 |

## 画面種別

API実行（削除操作）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| DELETE | `/_component_template/{name}` | 指定名のコンポーネントテンプレートを削除 |

## 入出力項目

### パスパラメータ

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| name | string | Yes | 削除対象のコンポーネントテンプレート名 |

### クエリパラメータ

| 項目名 | 型 | 必須 | デフォルト | 説明 |
|--------|-----|------|-----------|------|
| timeout | time | No | 30s | 操作のタイムアウト時間 |
| cluster_manager_timeout | time | No | 30s | クラスタマネージャノードへの接続タイムアウト |
| master_timeout | time | No | 30s | (非推奨) cluster_manager_timeoutを使用すること |

## 表示項目

### レスポンスボディ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| acknowledged | boolean | クラスタ状態の更新が全ノードに反映されたかどうか |

## イベント仕様

### 1-コンポーネントテンプレート削除リクエスト

1. クライアントがDELETEリクエストを送信する
2. `RestDeleteComponentTemplateAction.prepareRequest()`でリクエストパラメータをパースする（行番号68-74）
3. `DeleteComponentTemplateAction.Request`オブジェクトを生成し、テンプレート名とタイムアウト値を設定する
4. クラスタマネージャノードへリクエストを転送する
5. `TransportDeleteComponentTemplateAction.clusterManagerOperation()`でクラスタブロックを確認後、`MetadataIndexTemplateService.removeComponentTemplate()`を呼び出す（行番号105-111）
6. クラスタ状態からコンポーネントテンプレートを削除し、結果を返却する

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| DELETE実行 | ClusterState.Metadata.componentTemplates | DELETE | クラスタメタデータからコンポーネントテンプレートを削除 |

### テーブル別更新項目詳細

#### ClusterState.Metadata.componentTemplates

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | componentTemplates[name] | パスパラメータのnameで指定されたテンプレートを削除 | 存在しない場合は例外をスロー |

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 発生条件 |
|-------------|------|-----------|---------|
| - | 成功 | `{"acknowledged": true}` | テンプレート削除成功時 |
| - | エラー | `component_template [xxx] missing` | 指定名のテンプレートが存在しない場合 |
| - | エラー | `timeout` | クラスタマネージャノードへの接続タイムアウト時 |

## 例外処理

| 例外 | HTTPステータス | 説明 |
|------|---------------|------|
| テンプレート未検出 | 404 Not Found | 指定されたコンポーネントテンプレートが存在しない |
| クラスタブロック | 403 Forbidden | クラスタがメタデータ書き込みブロック中 |
| タイムアウト | 408 Request Timeout | クラスタマネージャノードへの接続がタイムアウト |
| 権限不足 | 403 Forbidden | METADATA_WRITE権限がない場合 |
| テンプレート使用中 | 400 Bad Request | 他のComposableテンプレートが参照している場合（実装による） |

## 備考

- 本APIのstabilityは「experimental」である
- `master_timeout`パラメータはバージョン2.0.0で非推奨となり、`cluster_manager_timeout`に置き換えられた
- 削除対象のコンポーネントテンプレートが他のComposableインデックステンプレートから参照されている場合、削除が拒否される可能性がある

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、コンポーネントテンプレートの削除リクエスト・レスポンスのデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DeleteComponentTemplateAction.java | `server/src/main/java/org/opensearch/action/admin/indices/template/delete/DeleteComponentTemplateAction.java` | Requestクラスの構造（nameフィールド）、アクション名定義を確認 |
| 1-2 | AcknowledgedResponse.java | `server/src/main/java/org/opensearch/action/support/clustermanager/AcknowledgedResponse.java` | レスポンスのacknowledgedフィールドの構造を確認 |

**読解のコツ**: `DeleteComponentTemplateAction`はアクション定義とRequest内部クラスを含む。`TransportClusterManagerNodeAction`のパターンを理解しておくと、クラスタマネージャへの転送フローが把握しやすい。

#### Step 2: エントリーポイントを理解する

RESTリクエストの受信からTransportActionへの橋渡し部分を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestDeleteComponentTemplateAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestDeleteComponentTemplateAction.java` | routes()でDELETEメソッドとパスの定義、prepareRequest()でパラメータ解析を確認 |

**主要処理フロー**:
1. **行59**: `routes()`でDELETEメソッドと`/_component_template/{name}`パスを定義
2. **行68-74**: `prepareRequest()`でリクエストパラメータをパースし、`DeleteComponentTemplateAction.Request`を構築
3. **行70**: パスパラメータからテンプレート名を取得
4. **行71**: `cluster_manager_timeout`パラメータを設定
5. **行72**: 非推奨の`master_timeout`パラメータを処理
6. **行74**: `NodeClient.execute()`でTransportActionに処理を委譲

#### Step 3: Transport層の処理を理解する

クラスタマネージャノードでの実際の削除処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportDeleteComponentTemplateAction.java | `server/src/main/java/org/opensearch/action/admin/indices/template/delete/TransportDeleteComponentTemplateAction.java` | clusterManagerOperation()でMetadataIndexTemplateServiceへの委譲を確認 |

**主要処理フロー**:
- **行100-102**: `checkBlock()`でMETADATA_WRITEレベルのクラスタブロックを確認
- **行105-111**: `clusterManagerOperation()`で`MetadataIndexTemplateService.removeComponentTemplate()`を呼び出し

#### Step 4: メタデータサービス層を理解する

実際のクラスタ状態更新ロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | MetadataIndexTemplateService.java | `server/src/main/java/org/opensearch/cluster/metadata/MetadataIndexTemplateService.java` | removeComponentTemplate()メソッドで実際の削除ロジックを確認 |

### プログラム呼び出し階層図

```
RestDeleteComponentTemplateAction.prepareRequest()
    |
    +-- DeleteComponentTemplateAction.Request(name)
    |
    +-- NodeClient.execute()
            |
            +-- TransportDeleteComponentTemplateAction.clusterManagerOperation()
                    |
                    +-- checkBlock() [ClusterBlockLevel.METADATA_WRITE]
                    |
                    +-- MetadataIndexTemplateService.removeComponentTemplate()
                            |
                            +-- ClusterState更新（コンポーネントテンプレート削除）
```

### データフロー図

```
[入力]                          [処理]                                    [出力]

DELETE                     RestDeleteComponentTemplateAction          AcknowledgedResponse
/_component_template/{name}  --> .prepareRequest()                     {"acknowledged": true}
+ timeout                       |
+ cluster_manager_timeout       v
                           TransportDeleteComponentTemplateAction
                               .clusterManagerOperation()
                               |
                               v
                           MetadataIndexTemplateService
                               .removeComponentTemplate()
                               |
                               v
                           ClusterState更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestDeleteComponentTemplateAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestDeleteComponentTemplateAction.java` | ソース | RESTエンドポイント定義・リクエスト処理 |
| DeleteComponentTemplateAction.java | `server/src/main/java/org/opensearch/action/admin/indices/template/delete/DeleteComponentTemplateAction.java` | ソース | アクション定義・リクエストクラス |
| TransportDeleteComponentTemplateAction.java | `server/src/main/java/org/opensearch/action/admin/indices/template/delete/TransportDeleteComponentTemplateAction.java` | ソース | Transport層の削除処理実装 |
| MetadataIndexTemplateService.java | `server/src/main/java/org/opensearch/cluster/metadata/MetadataIndexTemplateService.java` | ソース | テンプレートメタデータの管理サービス |
| cluster.delete_component_template.json | `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.delete_component_template.json` | API定義 | REST API仕様定義 |
| ActionModule.java | `server/src/main/java/org/opensearch/action/ActionModule.java` | ソース | アクション・RESTハンドラの登録 |
