# 画面設計書 72-コンポーネントテンプレート存在確認

## 概要

本ドキュメントは、OpenSearchのコンポーネントテンプレート存在確認API（HEAD /_component_template/{name}）の画面設計書である。指定された名前のコンポーネントテンプレートが存在するかどうかをHTTPステータスコードで返すREST APIエンドポイントの仕様を定義する。

### 本画面の処理概要

本APIエンドポイントは、指定されたコンポーネントテンプレートの存在有無を確認する軽量な処理を提供する。

**業務上の目的・背景**：コンポーネントテンプレートの存在確認は、テンプレート管理ワークフローにおいて重要な事前チェック操作である。テンプレートの作成・更新・削除の前に存在確認を行うことで、冪等な操作やエラーハンドリングの改善が可能になる。HEADリクエストであるためレスポンスボディを含まず、ネットワーク帯域の消費が少ない効率的な確認手段を提供する。

**画面へのアクセス方法**：RESTクライアントから `HEAD /_component_template/{name}` エンドポイントにHTTP HEADリクエストを送信する。

**主要な操作・処理内容**：
1. クライアントから確認対象のコンポーネントテンプレート名を受け取る
2. クラスタメタデータからコンポーネントテンプレートの存在を検索する
3. 存在する場合は200 OK、存在しない場合は404 Not Foundをステータスコードとして返却する

**画面遷移**：本APIはテンプレート管理の事前確認操作として使用される。テンプレート作成API（PUT /_component_template/{name}）の前に存在確認を行い、既存テンプレートの上書きを防止する運用フローや、削除API（DELETE /_component_template/{name}）の前の事前チェックとして使用される。

**権限による表示制御**：クラスタメタデータの読み取り権限が必要である。セキュリティプラグインにより権限制御が行われる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 7 | インデックステンプレート | 主機能 | コンポーネントテンプレートの存在を確認する処理 |

## 画面種別

API実行（存在確認・参照操作）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| HEAD | `/_component_template/{name}` | 指定名のコンポーネントテンプレートの存在確認 |

## 入出力項目

### パスパラメータ

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| name | string | Yes | 確認対象のコンポーネントテンプレート名 |

### クエリパラメータ

| 項目名 | 型 | 必須 | デフォルト | 説明 |
|--------|-----|------|-----------|------|
| master_timeout | time | No | 30s | クラスタマネージャノードへの接続タイムアウト |
| local | boolean | No | false | trueの場合、ローカルノードのメタデータから情報を返す（クラスタマネージャノードへの問い合わせを行わない） |

## 表示項目

HEADリクエストのため、レスポンスボディは返却されない。結果はHTTPステータスコードで示される。

| HTTPステータス | 意味 |
|---------------|------|
| 200 OK | コンポーネントテンプレートが存在する |
| 404 Not Found | コンポーネントテンプレートが存在しない |

## イベント仕様

### 1-コンポーネントテンプレート存在確認リクエスト

1. クライアントがHEADリクエストを送信する
2. `RestGetComponentTemplateAction`がHEADリクエストを受け付ける（行番号68にてHEADルートが定義されている）
3. `GetComponentTemplateAction.Request`オブジェクトを生成し、テンプレート名を設定する（行番号80）
4. `local`パラメータに基づき、ローカルまたはクラスタマネージャノードからメタデータを取得する（行番号82）
5. レスポンスのテンプレートリストが空かどうかで存在判定を行い、HTTPステータスコードを決定する（行番号93-95）
6. テンプレートが存在すれば200 OK、存在しなければ404 Not Foundを返却する

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| HEAD実行 | ClusterState.Metadata.componentTemplates | SELECT | クラスタメタデータからコンポーネントテンプレートの存在を確認（読み取りのみ） |

### テーブル別更新項目詳細

本APIは参照のみの操作であり、データの更新は行わない。

## メッセージ仕様

HEADリクエストであるため、レスポンスボディにメッセージは含まれない。

| 種別 | HTTPステータス | 発生条件 |
|------|---------------|---------|
| 成功 | 200 OK | テンプレートが存在する場合 |
| 未検出 | 404 Not Found | テンプレートが存在しない場合 |

## 例外処理

| 例外 | HTTPステータス | 説明 |
|------|---------------|------|
| タイムアウト | 408 Request Timeout | クラスタマネージャノードへの接続がタイムアウト |
| 権限不足 | 403 Forbidden | メタデータ読み取り権限がない場合 |

## 備考

- 本APIのstabilityは「experimental」である
- `RestGetComponentTemplateAction`がGET/HEADの両メソッドを処理する共通のREST handlerである
- `local`パラメータをtrueに設定すると、クラスタマネージャノードへの問い合わせを省略し、ローカルノードのメタデータから即座に結果を返す（パフォーマンス向上に有効だが、最新の状態でない可能性がある）
- HEADリクエストであるためレスポンスボディは空であり、結果はHTTPステータスコードのみで判断する

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、コンポーネントテンプレート取得リクエスト・レスポンスのデータ構造を理解する。存在確認はGET APIと同じアクションを使用する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | GetComponentTemplateAction.java | `server/src/main/java/org/opensearch/action/admin/indices/template/get/GetComponentTemplateAction.java` | Requestクラスのnameフィールド、Responseクラスのテンプレートマップ構造を確認 |

**読解のコツ**: 存在確認（HEAD）と取得（GET）は同じ`RestGetComponentTemplateAction`で処理される。HEADリクエストの場合はレスポンスボディがストリップされ、ステータスコードのみが返却される。

#### Step 2: エントリーポイントを理解する

RESTリクエストの受信からTransportActionへの橋渡し部分を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestGetComponentTemplateAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestGetComponentTemplateAction.java` | routes()でHEADメソッドの定義（行68）、getStatus()でステータスコード判定ロジック（行93-95）を確認 |

**主要処理フロー**:
1. **行64-69**: `routes()`でGETとHEADの両メソッドとパスを定義
2. **行80**: パスパラメータからテンプレート名を取得し`GetComponentTemplateAction.Request`を構築
3. **行82**: `local`パラメータの設定
4. **行83-84**: `cluster_manager_timeout`パラメータの設定
5. **行86**: 名前未指定時の暗黙的な全取得フラグを設定
6. **行93-95**: レスポンスのテンプレートリストが空でなければOK、空であれば（暗黙的全取得でない場合）NOT_FOUNDを返却

#### Step 3: Transport層の処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | GetComponentTemplateAction.java | `server/src/main/java/org/opensearch/action/admin/indices/template/get/GetComponentTemplateAction.java` | クラスタ状態からコンポーネントテンプレートを取得するロジック |

### プログラム呼び出し階層図

```
RestGetComponentTemplateAction.prepareRequest()
    |
    +-- GetComponentTemplateAction.Request(name)
    |       +-- local=true/false
    |       +-- cluster_manager_timeout
    |
    +-- NodeClient.execute()
            |
            +-- GetComponentTemplateAction (Transport)
                    |
                    +-- ClusterState.metadata().componentTemplates()
                    |
                    +-- Response (テンプレートマップ)
                            |
                            +-- getStatus() 判定
                                +-- 空でない → 200 OK
                                +-- 空 → 404 NOT_FOUND
```

### データフロー図

```
[入力]                          [処理]                                    [出力]

HEAD                       RestGetComponentTemplateAction            HTTPステータスコード
/_component_template/{name}  --> .prepareRequest()                     200 OK or
+ master_timeout                |                                      404 Not Found
+ local                         v
                           GetComponentTemplateAction (Transport)
                               |
                               v
                           ClusterState.metadata()
                               .componentTemplates()
                               |
                               v
                           存在判定 → ステータスコード返却
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestGetComponentTemplateAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestGetComponentTemplateAction.java` | ソース | RESTエンドポイント定義（GET/HEAD共用） |
| GetComponentTemplateAction.java | `server/src/main/java/org/opensearch/action/admin/indices/template/get/GetComponentTemplateAction.java` | ソース | アクション定義・リクエスト/レスポンスクラス |
| cluster.exists_component_template.json | `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.exists_component_template.json` | API定義 | REST API仕様定義 |
| ActionModule.java | `server/src/main/java/org/opensearch/action/ActionModule.java` | ソース | アクション・RESTハンドラの登録 |
