# 画面設計書 73-インデックステンプレートシミュレーション

## 概要

本ドキュメントは、OpenSearchのインデックステンプレートシミュレーションAPI（POST /_index_template/_simulate_index/{name}）の画面設計書である。指定したインデックス名がシステム内のインデックステンプレートに一致するかをシミュレーションし、適用される設定・マッピング・エイリアスを返すREST APIエンドポイントの仕様を定義する。

### 本画面の処理概要

本APIエンドポイントは、インデックス名を指定して、そのインデックスが作成された場合にどのテンプレートが適用され、結果としてどのような設定・マッピング・エイリアスが構成されるかをドライランでシミュレーションする。

**業務上の目的・背景**：Composableインデックステンプレートの運用において、テンプレートの適用結果を事前に確認することは非常に重要である。複数のComposableテンプレートとコンポーネントテンプレートが組み合わさって最終的なインデックス設定が決定されるため、実際にインデックスを作成する前にシミュレーションで結果を確認することで、設定ミスの防止やデバッグが容易になる。

**画面へのアクセス方法**：RESTクライアントから `POST /_index_template/_simulate_index/{name}` エンドポイントにHTTP POSTリクエストを送信する。オプションでリクエストボディにテンプレート定義を含めることができる。

**主要な操作・処理内容**：
1. クライアントからシミュレーション対象のインデックス名を受け取る
2. オプションでリクエストボディから仮想的なテンプレート定義を受け取る
3. クラスタ内の既存テンプレートとボディのテンプレートを組み合わせてマッチングをシミュレーションする
4. 適用されるテンプレート名、最終的な設定・マッピング・エイリアスを返却する

**画面遷移**：テンプレート作成API（PUT /_index_template/{name}）の前にシミュレーションで結果を確認し、期待通りの設定が適用されることを検証する運用フローが一般的である。コンポーネントテンプレート作成API（PUT /_component_template/{name}）との連携でも使用される。

**権限による表示制御**：クラスタメタデータの読み取り権限が必要である。ボディでテンプレート定義を送信する場合でも、実際のクラスタ状態は変更されない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 7 | インデックステンプレート | 主機能 | 指定インデックス名がテンプレートに一致するかシミュレーションする処理 |

## 画面種別

API実行（シミュレーション・参照操作）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| POST | `/_index_template/_simulate_index/{name}` | 指定インデックス名に対するテンプレート適用シミュレーション |

## 入出力項目

### パスパラメータ

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| name | string | Yes | シミュレーション対象のインデックス名（具体的なインデックス名である必要がある） |

### クエリパラメータ

| 項目名 | 型 | 必須 | デフォルト | 説明 |
|--------|-----|------|-----------|------|
| create | boolean | No | false | ボディで定義したテンプレートを新規追加のみとしてシミュレーションするか |
| cause | string | No | - | シミュレーション目的のユーザ定義の理由 |
| cluster_manager_timeout | time | No | 30s | クラスタマネージャノードへの接続タイムアウト |
| master_timeout | time | No | 30s | (非推奨) cluster_manager_timeoutを使用すること |

### リクエストボディ（オプション）

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| (テンプレート定義) | object | No | シミュレーションに含める仮想テンプレート定義（ComposableIndexTemplate形式） |

## 表示項目

### レスポンスボディ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| template | object | シミュレーションにより解決されたテンプレート設定 |
| template.settings | object | 適用されるインデックス設定 |
| template.mappings | object | 適用されるマッピング定義 |
| template.aliases | object | 適用されるエイリアス定義 |
| overlapping | array | 重複するテンプレートの情報 |

## イベント仕様

### 1-インデックステンプレートシミュレーションリクエスト

1. クライアントがPOSTリクエストを送信する
2. `RestSimulateIndexTemplateAction.prepareRequest()`でリクエストをパースする（行番号70-92）
3. `SimulateIndexTemplateRequest`オブジェクトを生成し、インデックス名を設定する（行番号71）
4. リクエストボディが存在する場合、`ComposableIndexTemplate.parse()`でテンプレート定義をパースし、`PutComposableIndexTemplateAction.Request`にラップする（行番号76-84）
5. `SimulateIndexTemplateAction.INSTANCE`を通じてTransport層に処理を委譲する（行番号87-91）
6. クラスタマネージャノードで既存テンプレートとのマッチング・解決を実行する
7. 解決結果（settings, mappings, aliases）をレスポンスとして返却する

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| POST実行 | ClusterState.Metadata | SELECT | クラスタメタデータのテンプレート情報を参照（読み取りのみ、変更なし） |

### テーブル別更新項目詳細

本APIはシミュレーション（ドライラン）のみの操作であり、クラスタ状態の更新は行わない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 発生条件 |
|-------------|------|-----------|---------|
| - | 成功 | テンプレート解決結果（JSON） | シミュレーション成功時 |
| - | エラー | `index_not_found_exception` | 不正なインデックス名の場合 |
| - | エラー | `invalid_index_template_exception` | ボディのテンプレート定義が不正な場合 |

## 例外処理

| 例外 | HTTPステータス | 説明 |
|------|---------------|------|
| 不正なインデックス名 | 400 Bad Request | 指定されたインデックス名が不正な場合 |
| テンプレート定義不正 | 400 Bad Request | ボディのテンプレート定義のパースに失敗した場合 |
| タイムアウト | 408 Request Timeout | クラスタマネージャノードへの接続がタイムアウト |
| 権限不足 | 403 Forbidden | メタデータ参照権限がない場合 |

## 備考

- 本APIのstabilityは「experimental」である
- `master_timeout`パラメータはバージョン2.0.0で非推奨
- リクエストボディは任意であり、ボディを省略した場合は既存のテンプレートのみでシミュレーションが実行される
- ボディでテンプレート定義を含めた場合、そのテンプレートが既にシステムに存在するかのように扱われてシミュレーションが実行されるが、実際のクラスタ状態は変更されない

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

シミュレーションリクエストとレスポンスのデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SimulateIndexTemplateRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/template/post/SimulateIndexTemplateRequest.java` | indexName、indexTemplateRequestフィールドの構造を確認 |
| 1-2 | SimulateIndexTemplateResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/template/post/SimulateIndexTemplateResponse.java` | resolvedTemplate、overlappingTemplatesの構造を確認 |
| 1-3 | ComposableIndexTemplate.java | `server/src/main/java/org/opensearch/cluster/metadata/ComposableIndexTemplate.java` | テンプレート定義のparse()メソッドの構造を確認 |

**読解のコツ**: `SimulateIndexTemplateRequest`はオプションで`PutComposableIndexTemplateAction.Request`を内包する。これにより仮想テンプレートを含めたシミュレーションが可能になる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestSimulateIndexTemplateAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestSimulateIndexTemplateAction.java` | routes()でPOSTメソッドとパスの定義、prepareRequest()でボディのパース処理を確認 |

**主要処理フロー**:
1. **行61**: `routes()`でPOSTメソッドと`/_index_template/_simulate_index/{name}`パスを定義
2. **行71**: パスパラメータからインデックス名を取得し`SimulateIndexTemplateRequest`を構築
3. **行72-74**: `cluster_manager_timeout`パラメータを設定
4. **行76-84**: リクエストボディがある場合、`ComposableIndexTemplate.parse()`でパースし`PutComposableIndexTemplateAction.Request`にラップ
5. **行81**: `create`パラメータの処理
6. **行82**: `cause`パラメータの処理（デフォルト値は"api"）
7. **行87-91**: `SimulateIndexTemplateAction.INSTANCE`を通じてTransport層に委譲

#### Step 3: Transport層の処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportSimulateIndexTemplateAction.java | `server/src/main/java/org/opensearch/action/admin/indices/template/post/TransportSimulateIndexTemplateAction.java` | クラスタマネージャノードでのテンプレート解決ロジックを確認 |

### プログラム呼び出し階層図

```
RestSimulateIndexTemplateAction.prepareRequest()
    |
    +-- SimulateIndexTemplateRequest(indexName)
    |       +-- [optional] PutComposableIndexTemplateAction.Request
    |               +-- ComposableIndexTemplate.parse(body)
    |
    +-- NodeClient.execute()
            |
            +-- TransportSimulateIndexTemplateAction.clusterManagerOperation()
                    |
                    +-- MetadataIndexTemplateService.resolveTemplate()
                    |
                    +-- SimulateIndexTemplateResponse
                            +-- resolvedTemplate (settings, mappings, aliases)
                            +-- overlappingTemplates
```

### データフロー図

```
[入力]                              [処理]                                    [出力]

POST                            RestSimulateIndexTemplateAction          SimulateIndexTemplateResponse
/_index_template/                  --> .prepareRequest()                   {
  _simulate_index/{name}              |                                     "template": {
+ create                              v                                       "settings": {...},
+ cause                          TransportSimulateIndexTemplateAction          "mappings": {...},
+ cluster_manager_timeout            .clusterManagerOperation()                "aliases": {...}
+ [body: テンプレート定義]              |                                     },
                                      v                                     "overlapping": [...]
                                 MetadataIndexTemplateService              }
                                    .resolveTemplate()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestSimulateIndexTemplateAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestSimulateIndexTemplateAction.java` | ソース | RESTエンドポイント定義・リクエスト処理 |
| SimulateIndexTemplateAction.java | `server/src/main/java/org/opensearch/action/admin/indices/template/post/SimulateIndexTemplateAction.java` | ソース | アクション定義 |
| SimulateIndexTemplateRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/template/post/SimulateIndexTemplateRequest.java` | ソース | リクエストクラス |
| TransportSimulateIndexTemplateAction.java | `server/src/main/java/org/opensearch/action/admin/indices/template/post/TransportSimulateIndexTemplateAction.java` | ソース | Transport層のシミュレーション処理実装 |
| ComposableIndexTemplate.java | `server/src/main/java/org/opensearch/cluster/metadata/ComposableIndexTemplate.java` | ソース | Composableテンプレートのデータモデル |
| MetadataIndexTemplateService.java | `server/src/main/java/org/opensearch/cluster/metadata/MetadataIndexTemplateService.java` | ソース | テンプレート解決サービス |
| indices.simulate_index_template.json | `rest-api-spec/src/main/resources/rest-api-spec/api/indices.simulate_index_template.json` | API定義 | REST API仕様定義 |
