# 画面設計書 74-テンプレートシミュレーション

## 概要

本ドキュメントは、OpenSearchのテンプレートシミュレーションAPI（POST /_index_template/_simulate, POST /_index_template/_simulate/{name}）の画面設計書である。テンプレート名またはリクエストボディで指定したテンプレート定義の解決結果をシミュレーションするREST APIエンドポイントの仕様を定義する。

### 本画面の処理概要

本APIエンドポイントは、指定されたテンプレート名またはリクエストボディのテンプレート定義が解決された場合に、どのようなインデックス設定・マッピング・エイリアスが生成されるかをドライランでシミュレーションする。

**業務上の目的・背景**：Composableインデックステンプレートは、複数のコンポーネントテンプレートを組み合わせて最終的なインデックス設定を構築する仕組みである。テンプレートの組み合わせ結果を事前に確認することで、設定の競合やオーバーライドの結果を把握できる。No.73のインデックステンプレートシミュレーションがインデックス名ベースでの確認であるのに対し、本APIはテンプレート自体の解決結果を確認する点で異なる。

**画面へのアクセス方法**：RESTクライアントから `POST /_index_template/_simulate` または `POST /_index_template/_simulate/{name}` エンドポイントにHTTP POSTリクエストを送信する。

**主要な操作・処理内容**：
1. テンプレート名指定の場合：既存テンプレートの解決結果をシミュレーション
2. ボディ指定の場合：仮想テンプレート定義の解決結果をシミュレーション
3. 両方指定の場合：仮想テンプレートを既存テンプレートとして扱いシミュレーション
4. コンポーネントテンプレートの組み合わせ解決結果を返却する

**画面遷移**：テンプレート作成API（PUT /_index_template/{name}）の前にシミュレーションで結果を確認する運用フローが一般的である。インデックステンプレートシミュレーション（No.73）と併用して、テンプレート単位・インデックス名単位の両方で検証を行うことができる。

**権限による表示制御**：クラスタメタデータの読み取り権限が必要。クラスタ状態は変更されない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 7 | インデックステンプレート | 主機能 | テンプレート名またはボディの解決をシミュレーションする処理 |

## 画面種別

API実行（シミュレーション・参照操作）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| POST | `/_index_template/_simulate` | ボディで指定したテンプレートの解決シミュレーション |
| POST | `/_index_template/_simulate/{name}` | 指定名のテンプレートの解決シミュレーション |

## 入出力項目

### パスパラメータ

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| name | string | No | シミュレーション対象のインデックステンプレート名 |

### クエリパラメータ

| 項目名 | 型 | 必須 | デフォルト | 説明 |
|--------|-----|------|-----------|------|
| create | boolean | No | false | ボディで定義したテンプレートを新規追加のみとしてシミュレーションするか |
| cause | string | No | - | シミュレーション目的のユーザ定義の理由 |
| cluster_manager_timeout | time | No | 30s | クラスタマネージャノードへの接続タイムアウト |
| master_timeout | time | No | 30s | (非推奨) cluster_manager_timeoutを使用すること |

### リクエストボディ（オプション）

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| (テンプレート定義) | object | No | シミュレーション対象のテンプレート定義（名前未指定時に使用） |

## 表示項目

### レスポンスボディ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| template | object | シミュレーションにより解決されたテンプレート設定 |
| template.settings | object | 適用されるインデックス設定 |
| template.mappings | object | 適用されるマッピング定義 |
| template.aliases | object | 適用されるエイリアス定義 |
| overlapping | array | 重複するテンプレートの情報 |

## イベント仕様

### 1-テンプレートシミュレーションリクエスト

1. クライアントがPOSTリクエストを送信する
2. `RestSimulateTemplateAction.prepareRequest()`でリクエストをパースする（行番号69-88）
3. `SimulateTemplateAction.Request`オブジェクトを生成する（行番号70）
4. パスパラメータからテンプレート名を取得する（行番号71）
5. リクエストボディが存在する場合、`ComposableIndexTemplate.parse()`でテンプレート定義をパースし、`PutComposableIndexTemplateAction.Request`にラップする（行番号72-81）
6. `cluster_manager_timeout`パラメータを設定する（行番号82-84）
7. `SimulateTemplateAction.INSTANCE`を通じてTransport層に処理を委譲する（行番号87）
8. クラスタマネージャノードでテンプレート解決を実行し、結果を返却する

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| POST実行 | ClusterState.Metadata | SELECT | クラスタメタデータのテンプレート情報を参照（読み取りのみ、変更なし） |

### テーブル別更新項目詳細

本APIはシミュレーション（ドライラン）のみの操作であり、クラスタ状態の更新は行わない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 発生条件 |
|-------------|------|-----------|---------|
| - | 成功 | テンプレート解決結果（JSON） | シミュレーション成功時 |
| - | エラー | `index_template_missing_exception` | 指定テンプレートが存在しない場合 |
| - | エラー | `invalid_index_template_exception` | ボディのテンプレート定義が不正な場合 |

## 例外処理

| 例外 | HTTPステータス | 説明 |
|------|---------------|------|
| テンプレート未検出 | 404 Not Found | 指定されたテンプレートが存在しない（名前指定時） |
| テンプレート定義不正 | 400 Bad Request | ボディのテンプレート定義のパースに失敗 |
| タイムアウト | 408 Request Timeout | クラスタマネージャノードへの接続がタイムアウト |
| 権限不足 | 403 Forbidden | メタデータ参照権限がない場合 |

## 備考

- 本APIのstabilityは「experimental」である
- `master_timeout`パラメータはバージョン2.0.0で非推奨
- 名前とボディの両方を省略した場合の動作はエラーとなる可能性がある
- No.73のインデックステンプレートシミュレーションとの違い：本APIはテンプレート自体の解決結果を返すのに対し、No.73は特定インデックス名に対してどのテンプレートが適用されるかを返す

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SimulateTemplateAction.java | `server/src/main/java/org/opensearch/action/admin/indices/template/post/SimulateTemplateAction.java` | Request内部クラスのtemplateName、indexTemplateRequestフィールドを確認 |
| 1-2 | ComposableIndexTemplate.java | `server/src/main/java/org/opensearch/cluster/metadata/ComposableIndexTemplate.java` | テンプレート定義のparse()メソッドを確認 |

**読解のコツ**: `SimulateTemplateAction`と`SimulateIndexTemplateAction`（No.73）は類似しているが、前者はテンプレート名ベース、後者はインデックス名ベースである点に注意。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestSimulateTemplateAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestSimulateTemplateAction.java` | 2つのルート定義（名前あり/なし）、ボディのパース処理を確認 |

**主要処理フロー**:
1. **行59-60**: `routes()`で2つのPOSTルートを定義（名前なし`/_index_template/_simulate`、名前あり`/_index_template/_simulate/{name}`）
2. **行70**: `SimulateTemplateAction.Request`を構築
3. **行71**: パスパラメータからテンプレート名を取得（オプション）
4. **行72-81**: リクエストボディがある場合、テンプレート定義をパース
5. **行77**: `create`パラメータの処理
6. **行78**: `cause`パラメータの処理（デフォルト"api"）
7. **行82-85**: `cluster_manager_timeout`パラメータ処理
8. **行87**: `SimulateTemplateAction.INSTANCE`でTransport層に委譲

#### Step 3: Transport層の処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportSimulateTemplateAction.java | `server/src/main/java/org/opensearch/action/admin/indices/template/post/TransportSimulateTemplateAction.java` | テンプレート解決ロジック、MetadataIndexTemplateServiceとの連携を確認 |

### プログラム呼び出し階層図

```
RestSimulateTemplateAction.prepareRequest()
    |
    +-- SimulateTemplateAction.Request()
    |       +-- templateName (optional)
    |       +-- [optional] PutComposableIndexTemplateAction.Request
    |               +-- ComposableIndexTemplate.parse(body)
    |
    +-- NodeClient.execute()
            |
            +-- TransportSimulateTemplateAction.clusterManagerOperation()
                    |
                    +-- MetadataIndexTemplateService.resolveTemplate()
                    |
                    +-- SimulateTemplateResponse
```

### データフロー図

```
[入力]                              [処理]                                    [出力]

POST                            RestSimulateTemplateAction              SimulateTemplateResponse
/_index_template/_simulate         --> .prepareRequest()                  {
  [/{name}]                            |                                   "template": {
+ create                               v                                     "settings": {...},
+ cause                           TransportSimulateTemplateAction             "mappings": {...},
+ cluster_manager_timeout             .clusterManagerOperation()              "aliases": {...}
+ [body: テンプレート定義]               |                                   },
                                       v                                   "overlapping": [...]
                                  MetadataIndexTemplateService             }
                                     .resolveTemplate()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestSimulateTemplateAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestSimulateTemplateAction.java` | ソース | RESTエンドポイント定義・リクエスト処理 |
| SimulateTemplateAction.java | `server/src/main/java/org/opensearch/action/admin/indices/template/post/SimulateTemplateAction.java` | ソース | アクション定義・リクエストクラス |
| TransportSimulateTemplateAction.java | `server/src/main/java/org/opensearch/action/admin/indices/template/post/TransportSimulateTemplateAction.java` | ソース | Transport層のシミュレーション処理実装 |
| ComposableIndexTemplate.java | `server/src/main/java/org/opensearch/cluster/metadata/ComposableIndexTemplate.java` | ソース | Composableテンプレートのデータモデル |
| MetadataIndexTemplateService.java | `server/src/main/java/org/opensearch/cluster/metadata/MetadataIndexTemplateService.java` | ソース | テンプレート解決サービス |
| indices.simulate_template.json | `rest-api-spec/src/main/resources/rest-api-spec/api/indices.simulate_template.json` | API定義 | REST API仕様定義 |
