# 画面設計書 75-データストリーム作成

## 概要

本ドキュメントは、OpenSearchのデータストリーム作成API（PUT /_data_stream/{name}）の画面設計書である。時系列データを効率的に管理するためのデータストリームを作成するREST APIエンドポイントの仕様を定義する。

### 本画面の処理概要

本APIエンドポイントは、指定された名前でデータストリームを作成する処理を提供する。データストリームはログ、メトリクス、イベントなどの時系列データを自動的にローリングインデックスで管理する仕組みである。

**業務上の目的・背景**：データストリームは、append-onlyの時系列データ（ログ、メトリクスなど）を効率的に管理するための抽象化レイヤーである。データストリームを使用することで、バックエンドインデックスの自動ロールオーバー、統一的な書き込みエンドポイント、ILM（Index Lifecycle Management）との連携が可能になる。個別インデックスの手動管理を不要にし、運用負荷を大幅に軽減する。

**画面へのアクセス方法**：RESTクライアントから `PUT /_data_stream/{name}` エンドポイントにHTTP PUTリクエストを送信する。事前に対応するインデックステンプレート（data_stream対応）が作成されている必要がある。

**主要な操作・処理内容**：
1. クライアントからデータストリーム名を受け取る
2. 対応するインデックステンプレートの存在を確認する
3. バッキングインデックス（最初のインデックス）を自動作成する
4. データストリームメタデータをクラスタ状態に登録する

**画面遷移**：データストリーム作成の前に、Composableインデックステンプレート作成API（PUT /_index_template/{name}）でdata_stream対応のテンプレートを作成する必要がある。作成後は、ドキュメント登録API（POST /{data_stream}/_doc）でデータを投入し、検索API（GET /{data_stream}/_search）でデータを検索する運用フローとなる。

**権限による表示制御**：インデックス作成権限が必要。セキュリティプラグインによりアクセス制御される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 8 | データストリーム | 主機能 | データストリームを作成する処理 |

## 画面種別

API実行（作成操作）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| PUT | `/_data_stream/{name}` | データストリームを作成する |

## 入出力項目

### パスパラメータ

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| name | string | Yes | 作成するデータストリームの名前 |

### クエリパラメータ

本APIにはクエリパラメータの定義はない。

### リクエストボディ（オプション）

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| (データストリーム定義) | object | No | データストリームの定義 |

## 表示項目

### レスポンスボディ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| acknowledged | boolean | データストリームの作成が成功したかどうか |

## イベント仕様

### 1-データストリーム作成リクエスト

1. クライアントがPUTリクエストを送信する
2. `RestCreateDataStreamAction.prepareRequest()`でリクエストパラメータをパースする（行番号62-65）
3. `CreateDataStreamAction.Request`オブジェクトを生成し、データストリーム名を設定する（行番号63）
4. `client.admin().indices().createDataStream()`でTransport層に処理を委譲する（行番号64）
5. 対応するインデックステンプレート（data_stream設定あり）の存在を確認する
6. バッキングインデックス（最初のインデックス）を自動作成する
7. クラスタ状態にデータストリームメタデータを登録する
8. 作成結果（acknowledged）をクライアントに返却する

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| PUT実行 | ClusterState.Metadata.dataStreams | INSERT | データストリームメタデータを追加 |
| PUT実行 | ClusterState.Metadata.indices | INSERT | バッキングインデックスを自動作成 |

### テーブル別更新項目詳細

#### ClusterState.Metadata.dataStreams

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | dataStreams[name] | パスパラメータのnameで指定されたデータストリームを登録 | 同名が既存の場合はエラー |

#### ClusterState.Metadata.indices（バッキングインデックス）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | indices[.ds-{name}-000001] | バッキングインデックスを自動作成 | テンプレートの設定・マッピングが適用される |

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 発生条件 |
|-------------|------|-----------|---------|
| - | 成功 | `{"acknowledged": true}` | データストリーム作成成功時 |
| - | エラー | `resource_already_exists_exception` | 同名のデータストリームが既に存在する場合 |
| - | エラー | `illegal_argument_exception` | 対応するインデックステンプレートが存在しない場合 |

## 例外処理

| 例外 | HTTPステータス | 説明 |
|------|---------------|------|
| リソース重複 | 400 Bad Request | 同名のデータストリームが既に存在する |
| テンプレート未検出 | 400 Bad Request | 対応するdata_stream対応のインデックステンプレートが存在しない |
| 不正な名前 | 400 Bad Request | データストリーム名が命名規則に違反する場合 |
| 権限不足 | 403 Forbidden | インデックス作成権限がない場合 |

## 備考

- 本APIのstabilityは「experimental」である
- データストリーム作成前に、`data_stream`オブジェクトを含むComposableインデックステンプレートが必要
- データストリームの名前はインデックスの命名規則に準ずる
- バッキングインデックスは`.ds-{data_stream_name}-{generation_number}`の形式で自動命名される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CreateDataStreamAction.java | `server/src/main/java/org/opensearch/action/admin/indices/datastream/CreateDataStreamAction.java` | Request内部クラスのnameフィールド、アクション定義を確認 |
| 1-2 | DataStream.java | `server/src/main/java/org/opensearch/cluster/metadata/DataStream.java` | データストリームのメタデータ構造（name, indices, generation等）を確認 |

**読解のコツ**: `CreateDataStreamAction`はAction/Request/Responseとバリデーションロジックを含む包括的なクラスである。データストリームの前提条件（テンプレート要件）を理解するにはこのクラスが重要。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestCreateDataStreamAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestCreateDataStreamAction.java` | routes()でPUTメソッドとパスの定義、prepareRequest()のシンプルな構造を確認 |

**主要処理フロー**:
1. **行57-58**: `routes()`でPUTメソッドと`/_data_stream/{name}`パスを定義
2. **行62-65**: `prepareRequest()`でパスパラメータからデータストリーム名を取得し`CreateDataStreamAction.Request`を構築
3. **行64**: `client.admin().indices().createDataStream()`でTransport層に委譲

#### Step 3: Transport層の処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CreateDataStreamAction.java | `server/src/main/java/org/opensearch/action/admin/indices/datastream/CreateDataStreamAction.java` | TransportAction内部クラスでの実際の作成ロジックを確認 |

### プログラム呼び出し階層図

```
RestCreateDataStreamAction.prepareRequest()
    |
    +-- CreateDataStreamAction.Request(name)
    |
    +-- client.admin().indices().createDataStream()
            |
            +-- CreateDataStreamAction.TransportAction
                    |
                    +-- テンプレート存在確認
                    |
                    +-- バッキングインデックス作成
                    |
                    +-- ClusterState更新（データストリーム登録）
```

### データフロー図

```
[入力]                    [処理]                                    [出力]

PUT                   RestCreateDataStreamAction              AcknowledgedResponse
/_data_stream/{name}    --> .prepareRequest()                   {"acknowledged": true}
                            |
                            v
                       CreateDataStreamAction.TransportAction
                            |
                            +-- テンプレート確認
                            +-- バッキングインデックス作成
                            +-- データストリーム登録
                            |
                            v
                       ClusterState更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestCreateDataStreamAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestCreateDataStreamAction.java` | ソース | RESTエンドポイント定義・リクエスト処理 |
| CreateDataStreamAction.java | `server/src/main/java/org/opensearch/action/admin/indices/datastream/CreateDataStreamAction.java` | ソース | アクション定義・Transport処理実装 |
| DataStream.java | `server/src/main/java/org/opensearch/cluster/metadata/DataStream.java` | ソース | データストリームのメタデータモデル |
| indices.create_data_stream.json | `rest-api-spec/src/main/resources/rest-api-spec/api/indices.create_data_stream.json` | API定義 | REST API仕様定義 |
| ActionModule.java | `server/src/main/java/org/opensearch/action/ActionModule.java` | ソース | アクション・RESTハンドラの登録 |
