# 画面設計書 76-データストリーム取得

## 概要

本ドキュメントは、OpenSearchのデータストリーム取得API（GET /_data_stream, GET /_data_stream/{name}）の画面設計書である。データストリームの情報を返すREST APIエンドポイントの仕様を定義する。

### 本画面の処理概要

本APIエンドポイントは、クラスタ内のデータストリームの情報を取得する処理を提供する。全データストリームの一覧取得、または指定した名前のデータストリームの詳細取得が可能である。

**業務上の目的・背景**：データストリームの管理・監視において、現在のデータストリームの構成情報（バッキングインデックス一覧、世代番号、テンプレート情報など）を確認することは運用上必要不可欠である。障害調査、容量計画、ロールオーバー状況の確認などに使用される。

**画面へのアクセス方法**：RESTクライアントから `GET /_data_stream` または `GET /_data_stream/{name}` エンドポイントにHTTP GETリクエストを送信する。

**主要な操作・処理内容**：
1. 名前指定なしの場合：全データストリームの一覧を取得する
2. 名前指定ありの場合：指定したデータストリーム（カンマ区切りで複数指定可、ワイルドカード使用可）の情報を取得する
3. 各データストリームのバッキングインデックス一覧、世代番号、テンプレート名などの情報を返却する

**画面遷移**：データストリーム作成API（PUT /_data_stream/{name}）でデータストリームを作成した後、本APIで構成情報を確認する。データストリーム統計API（GET /_data_stream/_stats）と併用して詳細な運用情報を取得することが多い。

**権限による表示制御**：クラスタメタデータの読み取り権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 8 | データストリーム | 主機能 | データストリームの情報を返す処理 |

## 画面種別

API実行（参照・一覧操作）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_data_stream` | 全データストリーム一覧を取得 |
| GET | `/_data_stream/{name}` | 指定データストリームの情報を取得 |

## 入出力項目

### パスパラメータ

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| name | list | No | 取得対象のデータストリーム名（カンマ区切りリスト、`*`で全取得） |

### クエリパラメータ

本APIにはクエリパラメータの定義はない。

## 表示項目

### レスポンスボディ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| data_streams | array | データストリーム情報の配列 |
| data_streams[].name | string | データストリーム名 |
| data_streams[].timestamp_field | object | タイムスタンプフィールド情報 |
| data_streams[].indices | array | バッキングインデックスの一覧 |
| data_streams[].generation | integer | 現在の世代番号 |
| data_streams[].status | string | データストリームのヘルスステータス |
| data_streams[].template | string | 関連するインデックステンプレート名 |

## イベント仕様

### 1-データストリーム取得リクエスト

1. クライアントがGETリクエストを送信する
2. `RestGetDataStreamsAction.prepareRequest()`でリクエストパラメータをパースする（行番号62-67）
3. パスパラメータ`name`をカンマ区切りで分割し、`GetDataStreamAction.Request`オブジェクトを生成する（行番号63-65）
4. `client.admin().indices().getDataStreams()`でTransport層に処理を委譲する（行番号66）
5. クラスタ状態からデータストリーム情報を取得する
6. データストリーム情報をレスポンスとして返却する

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| GET実行 | ClusterState.Metadata.dataStreams | SELECT | データストリームメタデータを参照（読み取りのみ） |

### テーブル別更新項目詳細

本APIは参照のみの操作であり、データの更新は行わない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 発生条件 |
|-------------|------|-----------|---------|
| - | 成功 | データストリーム情報（JSON配列） | データストリーム取得成功時 |
| - | エラー | `resource_not_found_exception` | 指定名のデータストリームが存在しない場合 |

## 例外処理

| 例外 | HTTPステータス | 説明 |
|------|---------------|------|
| リソース未検出 | 404 Not Found | 指定されたデータストリームが存在しない |
| 権限不足 | 403 Forbidden | メタデータ読み取り権限がない場合 |

## 備考

- 本APIのstabilityは「experimental」である
- 名前パラメータはカンマ区切りリストで複数指定可能
- ワイルドカード（`*`）を使用して全データストリームを取得可能
- 名前パラメータを省略した場合も全データストリームが返却される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | GetDataStreamAction.java | `server/src/main/java/org/opensearch/action/admin/indices/datastream/GetDataStreamAction.java` | Request（names配列）、Response（DataStreamInfo配列）の構造を確認 |
| 1-2 | DataStream.java | `server/src/main/java/org/opensearch/cluster/metadata/DataStream.java` | データストリームのメタデータ構造を確認 |

**読解のコツ**: `GetDataStreamAction`のResponseはDataStreamInfoのリストを含む。DataStreamInfoは名前、ステータス、テンプレート名などを保持する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestGetDataStreamsAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestGetDataStreamsAction.java` | 2つのGETルート定義、nameパラメータのカンマ区切り分割処理を確認 |

**主要処理フロー**:
1. **行57-58**: `routes()`でGETメソッドと2つのパス（名前あり/なし）を定義
2. **行62-67**: `prepareRequest()`でパスパラメータを取得
3. **行63-65**: `Strings.splitStringByCommaToArray()`でnameをカンマ区切り分割し`GetDataStreamAction.Request`を構築
4. **行66**: `client.admin().indices().getDataStreams()`でTransport層に委譲

### プログラム呼び出し階層図

```
RestGetDataStreamsAction.prepareRequest()
    |
    +-- Strings.splitStringByCommaToArray(name)
    |
    +-- GetDataStreamAction.Request(names[])
    |
    +-- client.admin().indices().getDataStreams()
            |
            +-- GetDataStreamAction.TransportAction
                    |
                    +-- ClusterState.metadata().dataStreams()
                    |
                    +-- GetDataStreamAction.Response (DataStreamInfo[])
```

### データフロー図

```
[入力]                          [処理]                                    [出力]

GET                         RestGetDataStreamsAction              GetDataStreamAction.Response
/_data_stream[/{name}]        --> .prepareRequest()                {
                                   |                                 "data_streams": [
                                   v                                   {
                              GetDataStreamAction.TransportAction         "name": "...",
                                   |                                     "indices": [...],
                                   v                                     "generation": N,
                              ClusterState.metadata()                    "template": "..."
                                  .dataStreams()                        }
                                                                     ]
                                                                   }
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestGetDataStreamsAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestGetDataStreamsAction.java` | ソース | RESTエンドポイント定義・リクエスト処理 |
| GetDataStreamAction.java | `server/src/main/java/org/opensearch/action/admin/indices/datastream/GetDataStreamAction.java` | ソース | アクション定義・Transport処理実装 |
| DataStream.java | `server/src/main/java/org/opensearch/cluster/metadata/DataStream.java` | ソース | データストリームのメタデータモデル |
| indices.get_data_stream.json | `rest-api-spec/src/main/resources/rest-api-spec/api/indices.get_data_stream.json` | API定義 | REST API仕様定義 |
