# 画面設計書 77-データストリーム削除

## 概要

本ドキュメントは、OpenSearchのデータストリーム削除API（DELETE /_data_stream/{name}）の画面設計書である。データストリームとそのバッキングインデックスを削除するREST APIエンドポイントの仕様を定義する。

### 本画面の処理概要

本APIエンドポイントは、指定されたデータストリームとその配下の全バッキングインデックスを削除する処理を提供する。

**業務上の目的・背景**：不要になったデータストリームやテスト用データストリームを削除し、クラスタリソースを解放するために使用される。データストリームを削除すると、関連する全てのバッキングインデックスも同時に削除されるため、個別のインデックス削除を行う必要がない。データのライフサイクル管理やクリーンアップの重要な操作である。

**画面へのアクセス方法**：RESTクライアントから `DELETE /_data_stream/{name}` エンドポイントにHTTP DELETEリクエストを送信する。

**主要な操作・処理内容**：
1. クライアントから削除対象のデータストリーム名を受け取る（カンマ区切りで複数指定可）
2. 指定されたデータストリームの全バッキングインデックスを特定する
3. バッキングインデックスを削除する
4. クラスタ状態からデータストリームメタデータを削除する
5. 削除結果（acknowledged）をクライアントに返却する

**画面遷移**：データストリーム取得API（GET /_data_stream/{name}）で存在確認・構成確認を行った後、本APIで削除する運用フローが一般的である。データストリーム統計API（GET /_data_stream/_stats）で統計情報を確認してから削除判断を行うこともある。

**権限による表示制御**：インデックス削除権限が必要。データストリームとバッキングインデックスの両方の削除権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 8 | データストリーム | 主機能 | データストリームを削除する処理 |

## 画面種別

API実行（削除操作）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| DELETE | `/_data_stream/{name}` | 指定データストリームを削除 |

## 入出力項目

### パスパラメータ

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| name | list | Yes | 削除対象のデータストリーム名（カンマ区切りリスト、`*`で全削除） |

### クエリパラメータ

本APIにはクエリパラメータの定義はない。

## 表示項目

### レスポンスボディ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| acknowledged | boolean | データストリームの削除が成功したかどうか |

## イベント仕様

### 1-データストリーム削除リクエスト

1. クライアントがDELETEリクエストを送信する
2. `RestDeleteDataStreamAction.prepareRequest()`でリクエストパラメータをパースする（行番号63-68）
3. パスパラメータ`name`をカンマ区切りで分割し、`DeleteDataStreamAction.Request`オブジェクトを生成する（行番号64-66）
4. `client.admin().indices().deleteDataStream()`でTransport層に処理を委譲する（行番号67）
5. クラスタ状態からデータストリームメタデータを削除する
6. 関連する全バッキングインデックスを削除する
7. 削除結果（acknowledged）をクライアントに返却する

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| DELETE実行 | ClusterState.Metadata.dataStreams | DELETE | データストリームメタデータを削除 |
| DELETE実行 | ClusterState.Metadata.indices | DELETE | 全バッキングインデックスを削除 |

### テーブル別更新項目詳細

#### ClusterState.Metadata.dataStreams

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | dataStreams[name] | パスパラメータのnameで指定されたデータストリームを削除 | 存在しない場合はエラー |

#### ClusterState.Metadata.indices（バッキングインデックス）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | indices[.ds-{name}-*] | データストリームに紐づく全バッキングインデックスを削除 | データストリーム削除に連動 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 発生条件 |
|-------------|------|-----------|---------|
| - | 成功 | `{"acknowledged": true}` | データストリーム削除成功時 |
| - | エラー | `resource_not_found_exception` | 指定名のデータストリームが存在しない場合 |

## 例外処理

| 例外 | HTTPステータス | 説明 |
|------|---------------|------|
| リソース未検出 | 404 Not Found | 指定されたデータストリームが存在しない |
| 権限不足 | 403 Forbidden | データストリーム・インデックス削除権限がない場合 |

## 備考

- 本APIのstabilityは「experimental」である
- データストリームを削除すると、全バッキングインデックスも連動して削除される
- ワイルドカード（`*`）で全データストリームを一括削除可能
- カンマ区切りで複数のデータストリーム名を同時に指定できる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DeleteDataStreamAction.java | `server/src/main/java/org/opensearch/action/admin/indices/datastream/DeleteDataStreamAction.java` | Requestのnames配列、アクション定義を確認 |

**読解のコツ**: 削除リクエストはnames配列を受け取る。カンマ区切りの分割はRESTレイヤーで行われる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestDeleteDataStreamAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestDeleteDataStreamAction.java` | routes()でDELETEメソッドの定義、prepareRequest()でnameのカンマ区切り分割を確認 |

**主要処理フロー**:
1. **行58-59**: `routes()`でDELETEメソッドと`/_data_stream/{name}`パスを定義
2. **行63-68**: `prepareRequest()`でパスパラメータを取得
3. **行64-66**: `Strings.splitStringByCommaToArray()`でnameを分割し`DeleteDataStreamAction.Request`を構築
4. **行67**: `client.admin().indices().deleteDataStream()`でTransport層に委譲

### プログラム呼び出し階層図

```
RestDeleteDataStreamAction.prepareRequest()
    |
    +-- Strings.splitStringByCommaToArray(name)
    |
    +-- DeleteDataStreamAction.Request(names[])
    |
    +-- client.admin().indices().deleteDataStream()
            |
            +-- DeleteDataStreamAction.TransportAction
                    |
                    +-- バッキングインデックス特定・削除
                    |
                    +-- ClusterState更新（データストリーム削除）
```

### データフロー図

```
[入力]                          [処理]                                    [出力]

DELETE                      RestDeleteDataStreamAction              AcknowledgedResponse
/_data_stream/{name}          --> .prepareRequest()                   {"acknowledged": true}
                                   |
                                   v
                              DeleteDataStreamAction.TransportAction
                                   |
                                   +-- バッキングインデックス削除
                                   +-- データストリームメタデータ削除
                                   |
                                   v
                              ClusterState更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestDeleteDataStreamAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestDeleteDataStreamAction.java` | ソース | RESTエンドポイント定義・リクエスト処理 |
| DeleteDataStreamAction.java | `server/src/main/java/org/opensearch/action/admin/indices/datastream/DeleteDataStreamAction.java` | ソース | アクション定義・Transport処理実装 |
| DataStream.java | `server/src/main/java/org/opensearch/cluster/metadata/DataStream.java` | ソース | データストリームのメタデータモデル |
| indices.delete_data_stream.json | `rest-api-spec/src/main/resources/rest-api-spec/api/indices.delete_data_stream.json` | API定義 | REST API仕様定義 |
