# 画面設計書 78-データストリーム統計

## 概要

本ドキュメントは、OpenSearchのデータストリーム統計API（GET /_data_stream/_stats, GET /_data_stream/{name}/_stats）の画面設計書である。データストリームの操作統計情報を返すREST APIエンドポイントの仕様を定義する。

### 本画面の処理概要

本APIエンドポイントは、データストリームに関する操作統計情報（ドキュメント数、ストアサイズ、バッキングインデックス数など）を返す処理を提供する。

**業務上の目的・背景**：データストリームの運用において、各データストリームのサイズ、ドキュメント数、バッキングインデックス数などの統計情報は、容量計画やパフォーマンスチューニング、ロールオーバー戦略の策定に不可欠である。本APIにより、データストリーム単位での統計情報を効率的に取得でき、運用監視やアラート設定の基礎データとして活用できる。

**画面へのアクセス方法**：RESTクライアントから `GET /_data_stream/_stats` または `GET /_data_stream/{name}/_stats` エンドポイントにHTTP GETリクエストを送信する。

**主要な操作・処理内容**：
1. 名前指定なしの場合：全データストリームの統計を取得する
2. 名前指定ありの場合：指定したデータストリーム（カンマ区切りで複数指定可）の統計を取得する
3. 配下のバッキングインデックスの統計を集約して返却する

**画面遷移**：データストリーム取得API（GET /_data_stream/{name}）で構成情報を確認した後、本APIで統計情報を取得する運用フローが一般的である。インデックス統計API（GET /{index}/_stats）と併用してバッキングインデックスレベルの詳細統計を取得することも可能。

**権限による表示制御**：インデックス統計の読み取り権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 8 | データストリーム | 主機能 | データストリームの操作統計を提供する処理 |
| 105 | インデックス統計 | 補助機能 | データストリーム配下のインデックス統計取得処理 |

## 画面種別

API実行（参照・統計操作）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_data_stream/_stats` | 全データストリームの統計を取得 |
| GET | `/_data_stream/{name}/_stats` | 指定データストリームの統計を取得 |

## 入出力項目

### パスパラメータ

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| name | list | No | 取得対象のデータストリーム名（カンマ区切りリスト、`_all`で全データストリーム） |

### クエリパラメータ

| 項目名 | 型 | 必須 | デフォルト | 説明 |
|--------|-----|------|-----------|------|
| forbid_closed_indices | boolean | No | true | クローズされたインデックスを除外するかどうか（内部パラメータ） |
| ignore_unavailable | boolean | No | - | 利用不可のインデックスを無視するか |
| allow_no_indices | boolean | No | - | ワイルドカードがインデックスに一致しない場合に許可するか |
| expand_wildcards | enum | No | open | ワイルドカードの展開方法（open/closed/hidden/none/all） |

## 表示項目

### レスポンスボディ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| _shards | object | シャードの成功/失敗情報 |
| _shards.total | integer | 総シャード数 |
| _shards.successful | integer | 成功したシャード数 |
| _shards.failed | integer | 失敗したシャード数 |
| data_stream_count | integer | データストリーム数 |
| backing_indices | integer | バッキングインデックスの総数 |
| total_store_size_bytes | long | 全データストリームの総ストアサイズ（バイト） |
| data_streams | array | 個別データストリームの統計情報 |
| data_streams[].data_stream | string | データストリーム名 |
| data_streams[].backing_indices | integer | バッキングインデックス数 |
| data_streams[].store_size_bytes | long | ストアサイズ（バイト） |
| data_streams[].maximum_timestamp | long | 最大タイムスタンプ |

## イベント仕様

### 1-データストリーム統計取得リクエスト

1. クライアントがGETリクエストを送信する
2. `RestDataStreamsStatsAction.prepareRequest()`でリクエストパラメータをパースする（行番号67-78）
3. `DataStreamsStatsAction.Request`オブジェクトを生成する（行番号68）
4. `forbid_closed_indices`パラメータに基づきIndicesOptionsを設定する（行番号69-75）
5. パスパラメータ`name`をカンマ区切りで分割しindicesに設定する（行番号76）
6. `DataStreamsStatsAction.INSTANCE`を通じてTransport層に処理を委譲する（行番号77）
7. 各バッキングインデックスのシャード統計を集約する
8. データストリーム単位の統計をレスポンスとして返却する

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| GET実行 | ClusterState.Metadata.dataStreams | SELECT | データストリームメタデータを参照 |
| GET実行 | インデックスシャード統計 | SELECT | バッキングインデックスの統計を集約取得 |

### テーブル別更新項目詳細

本APIは参照のみの操作であり、データの更新は行わない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 発生条件 |
|-------------|------|-----------|---------|
| - | 成功 | 統計情報（JSON） | 統計取得成功時 |
| - | エラー | シャード失敗情報 | 一部シャードの統計取得に失敗した場合（部分的な結果は返却される） |

## 例外処理

| 例外 | HTTPステータス | 説明 |
|------|---------------|------|
| リソース未検出 | 404 Not Found | 指定されたデータストリームが存在しない |
| 権限不足 | 403 Forbidden | 統計参照権限がない場合 |

## 備考

- 本APIのstabilityは「experimental」である
- デフォルトのIndicesOptionsは`strictExpandOpenAndForbidClosed`であり、クローズされたインデックスは除外される
- `forbid_closed_indices`パラメータをfalseに設定すると、IndicesOptionsが`strictExpandOpen`に変更される
- ブロードキャストアクションとして各シャードに対して統計収集を実行するため、大規模クラスタでは応答時間が長くなる可能性がある

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DataStreamsStatsAction.java | `server/src/main/java/org/opensearch/action/admin/indices/datastream/DataStreamsStatsAction.java` | Request（IndicesOptions）、Response（統計情報）の構造を確認 |

**読解のコツ**: `DataStreamsStatsAction`はBroadcastAction系のアクションであり、各シャードに対して統計収集を実行する。IndicesOptionsの扱いが特に重要。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestDataStreamsStatsAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestDataStreamsStatsAction.java` | 2つのGETルート定義、IndicesOptionsの設定ロジックを確認 |

**主要処理フロー**:
1. **行59-63**: `routes()`で2つのGETルート（名前あり/なし）を定義
2. **行68**: `DataStreamsStatsAction.Request`を構築
3. **行69-75**: `forbid_closed_indices`パラメータに基づきIndicesOptionsを設定
4. **行73**: デフォルトのIndicesOptionsが`strictExpandOpenAndForbidClosed`であることをアサーション
5. **行75**: `IndicesOptions.fromRequest()`でリクエストからIndicesOptionsを構築
6. **行76**: パスパラメータ`name`を分割しindicesに設定
7. **行77**: `DataStreamsStatsAction.INSTANCE`でTransport層に委譲

### プログラム呼び出し階層図

```
RestDataStreamsStatsAction.prepareRequest()
    |
    +-- DataStreamsStatsAction.Request()
    |       +-- indicesOptions (forbid_closed_indices based)
    |       +-- indices[] (from name param)
    |
    +-- NodeClient.execute()
            |
            +-- DataStreamsStatsAction.TransportAction
                    |
                    +-- 各シャードへのブロードキャスト
                    |       +-- ShardStats収集
                    |
                    +-- DataStreamsStatsAction.Response
                            +-- data_stream_count
                            +-- backing_indices
                            +-- total_store_size_bytes
                            +-- data_streams[]
```

### データフロー図

```
[入力]                              [処理]                                    [出力]

GET                             RestDataStreamsStatsAction            DataStreamsStatsAction.Response
/_data_stream[/{name}]/_stats     --> .prepareRequest()                {
+ forbid_closed_indices                |                                 "data_stream_count": N,
+ ignore_unavailable                   v                                 "backing_indices": N,
+ expand_wildcards              DataStreamsStatsAction.TransportAction    "total_store_size_bytes": N,
                                       |                                 "data_streams": [...]
                                       +-- シャードブロードキャスト        }
                                       +-- 統計集約
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestDataStreamsStatsAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestDataStreamsStatsAction.java` | ソース | RESTエンドポイント定義・リクエスト処理 |
| DataStreamsStatsAction.java | `server/src/main/java/org/opensearch/action/admin/indices/datastream/DataStreamsStatsAction.java` | ソース | アクション定義・Transport処理実装 |
| DataStream.java | `server/src/main/java/org/opensearch/cluster/metadata/DataStream.java` | ソース | データストリームのメタデータモデル |
| indices.data_streams_stats.json | `rest-api-spec/src/main/resources/rest-api-spec/api/indices.data_streams_stats.json` | API定義 | REST API仕様定義 |
| IndicesOptions.java | `server/src/main/java/org/opensearch/action/support/IndicesOptions.java` | ソース | インデックスオプションの定義 |
