# 画面設計書 79-リフレッシュ

## 概要

本ドキュメントは、OpenSearchのリフレッシュAPI（POST/GET /_refresh, POST/GET /{index}/_refresh）の画面設計書である。インデックスのリフレッシュ操作を実行し、最新のドキュメント変更を検索可能にするREST APIエンドポイントの仕様を定義する。

### 本画面の処理概要

本APIエンドポイントは、1つ以上のインデックスでリフレッシュ操作を実行する処理を提供する。リフレッシュ操作により、インデックスバッファ内のデータが新しいLuceneセグメントとして公開され、検索可能な状態になる。

**業務上の目的・背景**：OpenSearchでは、ドキュメントの登録・更新後、そのデータが検索結果に反映されるまでにはリフレッシュ間隔（デフォルト1秒）の遅延がある。テスト時やリアルタイム性が求められるユースケースにおいて、明示的にリフレッシュを実行することで、直前の変更を即座に検索可能にする。通常の運用では自動リフレッシュに依存するが、バルクインデックス後の検索確認やテスト時に手動リフレッシュが利用される。

**画面へのアクセス方法**：RESTクライアントから `POST /_refresh` または `POST /{index}/_refresh` エンドポイントにHTTP POSTまたはGETリクエストを送信する。

**主要な操作・処理内容**：
1. 対象インデックスを指定する（省略時は全インデックス）
2. 各シャードでリフレッシュ操作を実行する
3. インデックスバッファのデータを新しいLuceneセグメントとして公開する
4. リフレッシュ結果（成功/失敗シャード数）を返却する

**画面遷移**：ドキュメント登録API（PUT /{index}/_doc/{id}）やバルクAPI（POST /_bulk）でデータを投入した後、本APIでリフレッシュを実行し、検索API（GET /{index}/_search）で最新データを検索する運用フローが一般的である。

**権限による表示制御**：対象インデックスへのリフレッシュ権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 119 | リフレッシュ | 主機能 | 1つ以上のインデックスでリフレッシュ操作を実行する処理 |

## 画面種別

API実行（インデックス運用操作）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| POST | `/_refresh` | 全インデックスでリフレッシュを実行 |
| GET | `/_refresh` | 全インデックスでリフレッシュを実行 |
| POST | `/{index}/_refresh` | 指定インデックスでリフレッシュを実行 |
| GET | `/{index}/_refresh` | 指定インデックスでリフレッシュを実行 |

## 入出力項目

### パスパラメータ

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| index | list | No | 対象インデックス名（カンマ区切りリスト、`_all`で全インデックス） |

### クエリパラメータ

| 項目名 | 型 | 必須 | デフォルト | 説明 |
|--------|-----|------|-----------|------|
| ignore_unavailable | boolean | No | false | 利用不可の具体的インデックスを無視するか |
| allow_no_indices | boolean | No | true | ワイルドカードがインデックスに一致しない場合に許可するか |
| expand_wildcards | enum | No | open | ワイルドカードの展開方法（open/closed/hidden/none/all） |

## 表示項目

### レスポンスボディ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| _shards | object | シャードの成功/失敗情報 |
| _shards.total | integer | 総シャード数 |
| _shards.successful | integer | 成功したシャード数 |
| _shards.failed | integer | 失敗したシャード数 |

## イベント仕様

### 1-リフレッシュリクエスト

1. クライアントがPOST/GETリクエストを送信する
2. `RestRefreshAction.prepareRequest()`でリクエストパラメータをパースする（行番号78-87）
3. パスパラメータ`index`をカンマ区切りで分割し、`RefreshRequest`オブジェクトを生成する（行番号79）
4. `IndicesOptions.fromRequest()`でインデックスオプションを設定する（行番号80）
5. `client.admin().indices().refresh()`でTransport層に処理を委譲する（行番号81）
6. 各シャードでリフレッシュ操作を実行する
7. `RefreshResponse`からステータスを取得し（行番号83-85）、レスポンスとして返却する

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| POST/GET実行 | Luceneインデックスバッファ | FLUSH/COMMIT | インデックスバッファの内容を新しいセグメントとして公開 |

### テーブル別更新項目詳細

#### Luceneセグメント

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| COMMIT | 新規セグメント | インデックスバッファ内のドキュメントデータ | 新しいセグメントが作成され検索可能になる |
| UPDATE | SearcherManager | 新しいセグメントを含むSearcherに切り替え | 次回の検索で新しいデータが反映される |

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 発生条件 |
|-------------|------|-----------|---------|
| - | 成功 | `{"_shards": {"total": N, "successful": N, "failed": 0}}` | リフレッシュ成功時 |
| - | 部分成功 | `{"_shards": {"total": N, "successful": M, "failed": K}}` | 一部シャードのリフレッシュが失敗した場合 |

## 例外処理

| 例外 | HTTPステータス | 説明 |
|------|---------------|------|
| インデックス未検出 | 404 Not Found | 指定されたインデックスが存在しない（ignore_unavailable=false時） |
| インデックスクローズ | 400 Bad Request | クローズされたインデックスに対するリフレッシュ（expand_wildcards設定による） |
| 権限不足 | 403 Forbidden | リフレッシュ権限がない場合 |

## 備考

- 本APIのstabilityは「stable」である
- GET/POST両メソッドで同一の処理が実行される
- 頻繁な手動リフレッシュはパフォーマンスに悪影響を与える可能性がある
- 自動リフレッシュ間隔は`index.refresh_interval`設定で制御可能（デフォルト1秒）
- リフレッシュはディスクへの永続化（fsync）を保証しない。永続化にはフラッシュAPI（No.80）を使用する
- レスポンスのHTTPステータスコードは`RefreshResponse.getStatus()`に基づいて決定される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | RefreshRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/refresh/RefreshRequest.java` | indicesとIndicesOptionsフィールドの構造を確認 |
| 1-2 | RefreshResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/refresh/RefreshResponse.java` | _shardsフィールドの構造、getStatus()メソッドを確認 |

**読解のコツ**: `RefreshRequest`は`BroadcastRequest`を継承しており、複数インデックスに対する一括操作のパターンを理解するとよい。`RefreshResponse`の`getStatus()`はシャードの失敗数に基づいてHTTPステータスコードを決定する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestRefreshAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestRefreshAction.java` | 4つのルート定義（GET/POST x 名前あり/なし）、getStatus()のオーバーライドを確認 |

**主要処理フロー**:
1. **行61-68**: `routes()`で4つのルート（GET/POST x `/_refresh`/`/{index}/_refresh`）を定義
2. **行79**: `RefreshRequest`を構築、パスパラメータをカンマ区切り分割
3. **行80**: `IndicesOptions.fromRequest()`でインデックスオプションを設定
4. **行81-86**: `client.admin().indices().refresh()`で委譲、`RestToXContentListener`でレスポンスを返却
5. **行83-85**: `getStatus()`をオーバーライドし、`RefreshResponse.getStatus()`でHTTPステータスを決定

### プログラム呼び出し階層図

```
RestRefreshAction.prepareRequest()
    |
    +-- RefreshRequest(indices[])
    |       +-- IndicesOptions.fromRequest()
    |
    +-- client.admin().indices().refresh()
            |
            +-- TransportRefreshAction
                    |
                    +-- 各シャードへのブロードキャスト
                    |       +-- InternalEngine.refresh()
                    |               +-- SearcherManager.maybeRefresh()
                    |
                    +-- RefreshResponse
                            +-- _shards (total, successful, failed)
                            +-- getStatus()
```

### データフロー図

```
[入力]                          [処理]                                    [出力]

POST/GET                    RestRefreshAction                    RefreshResponse
/_refresh                     --> .prepareRequest()                {
/{index}/_refresh                  |                                 "_shards": {
+ ignore_unavailable               v                                   "total": N,
+ allow_no_indices             TransportRefreshAction                   "successful": N,
+ expand_wildcards                  |                                   "failed": 0
                                    +-- 各シャードリフレッシュ            }
                                    |       +-- Luceneセグメント公開    }
                                    |
                                    v
                               RefreshResponse集約
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestRefreshAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestRefreshAction.java` | ソース | RESTエンドポイント定義・リクエスト処理 |
| RefreshRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/refresh/RefreshRequest.java` | ソース | リクエストクラス |
| RefreshResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/refresh/RefreshResponse.java` | ソース | レスポンスクラス |
| TransportRefreshAction.java | `server/src/main/java/org/opensearch/action/admin/indices/refresh/TransportRefreshAction.java` | ソース | Transport層のリフレッシュ処理実装 |
| IndicesOptions.java | `server/src/main/java/org/opensearch/action/support/IndicesOptions.java` | ソース | インデックスオプションの定義 |
| indices.refresh.json | `rest-api-spec/src/main/resources/rest-api-spec/api/indices.refresh.json` | API定義 | REST API仕様定義 |
