# 画面設計書 80-フラッシュ

## 概要

本ドキュメントは、OpenSearchのフラッシュAPI（POST/GET /_flush, POST/GET /{index}/_flush）の画面設計書である。インデックスのフラッシュ操作を実行し、トランザクションログの内容をLuceneインデックスに永続化するREST APIエンドポイントの仕様を定義する。

### 本画面の処理概要

本APIエンドポイントは、1つ以上のインデックスでフラッシュ操作を実行する処理を提供する。フラッシュ操作により、メモリ内のインデックスデータがディスクに永続化（fsync）され、トランザクションログがクリアされる。

**業務上の目的・背景**：OpenSearchでは、ドキュメントの変更はまずトランザクションログ（translog）に記録され、定期的にLuceneインデックスにコミットされる。フラッシュ操作は、このトランザクションログの内容をLuceneインデックスに確実に永続化し、translogをクリアする。これにより、ノード再起動時のリカバリ時間が短縮される。通常は自動的に実行されるが、計画的なメンテナンスやノード停止の前に手動実行することでデータの安全性を高める。

**画面へのアクセス方法**：RESTクライアントから `POST /_flush` または `POST /{index}/_flush` エンドポイントにHTTP POSTまたはGETリクエストを送信する。

**主要な操作・処理内容**：
1. 対象インデックスを指定する（省略時は全インデックス）
2. 各シャードでフラッシュ操作を実行する
3. メモリ内データをLuceneインデックスにコミットする（fsync）
4. トランザクションログをクリアする
5. フラッシュ結果（成功/失敗シャード数）を返却する

**画面遷移**：大量のドキュメント登録・更新操作の後、またはノード停止やシャード再配置の前に手動フラッシュを実行する。リフレッシュAPI（No.79）と併用されることが多いが、フラッシュはリフレッシュよりも重い操作であり、データの永続化を保証する点で異なる。

**権限による表示制御**：対象インデックスへのフラッシュ権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 118 | フラッシュ | 主機能 | 1つ以上のインデックスでフラッシュ操作を実行する処理 |

## 画面種別

API実行（インデックス運用操作）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| POST | `/_flush` | 全インデックスでフラッシュを実行 |
| GET | `/_flush` | 全インデックスでフラッシュを実行 |
| POST | `/{index}/_flush` | 指定インデックスでフラッシュを実行 |
| GET | `/{index}/_flush` | 指定インデックスでフラッシュを実行 |

## 入出力項目

### パスパラメータ

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| index | list | No | 対象インデックス名（カンマ区切りリスト、`_all`で全インデックス） |

### クエリパラメータ

| 項目名 | 型 | 必須 | デフォルト | 説明 |
|--------|-----|------|-----------|------|
| force | boolean | No | false | 変更がない場合でも強制的にフラッシュを実行するか。内部的なパラメータであり、translog IDのインクリメントに使用される |
| wait_if_ongoing | boolean | No | true | 他のフラッシュ操作が実行中の場合に待機するか。falseの場合、実行中のフラッシュがあるとスキップされる |
| ignore_unavailable | boolean | No | false | 利用不可の具体的インデックスを無視するか |
| allow_no_indices | boolean | No | true | ワイルドカードがインデックスに一致しない場合に許可するか |
| expand_wildcards | enum | No | open | ワイルドカードの展開方法（open/closed/hidden/none/all） |

## 表示項目

### レスポンスボディ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| _shards | object | シャードの成功/失敗情報 |
| _shards.total | integer | 総シャード数 |
| _shards.successful | integer | 成功したシャード数 |
| _shards.failed | integer | 失敗したシャード数 |

## イベント仕様

### 1-フラッシュリクエスト

1. クライアントがPOST/GETリクエストを送信する
2. `RestFlushAction.prepareRequest()`でリクエストパラメータをパースする（行番号76-82）
3. パスパラメータ`index`をカンマ区切りで分割し、`FlushRequest`オブジェクトを生成する（行番号77）
4. `IndicesOptions.fromRequest()`でインデックスオプションを設定する（行番号78）
5. `force`パラメータを設定する（行番号79）
6. `wait_if_ongoing`パラメータを設定する（行番号80）
7. `client.admin().indices().flush()`でTransport層に処理を委譲する（行番号81）
8. 各シャードでフラッシュ操作（Luceneコミット + translogクリア）を実行する
9. フラッシュ結果をレスポンスとして返却する

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| POST/GET実行 | Luceneインデックス | COMMIT | メモリ内データをディスクに永続化（fsync） |
| POST/GET実行 | トランザクションログ | DELETE/TRUNCATE | translogをクリア |

### テーブル別更新項目詳細

#### Luceneインデックス

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| COMMIT | Luceneセグメント | メモリ内のインデックスデータをfsyncでディスクに永続化 | コミットポイントが更新される |

#### トランザクションログ

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| TRUNCATE | translog | フラッシュ済みの操作ログをクリア | リカバリ時に不要なデータを削除 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 発生条件 |
|-------------|------|-----------|---------|
| - | 成功 | `{"_shards": {"total": N, "successful": N, "failed": 0}}` | フラッシュ成功時 |
| - | 部分成功 | `{"_shards": {"total": N, "successful": M, "failed": K}}` | 一部シャードのフラッシュが失敗した場合 |

## 例外処理

| 例外 | HTTPステータス | 説明 |
|------|---------------|------|
| インデックス未検出 | 404 Not Found | 指定されたインデックスが存在しない（ignore_unavailable=false時） |
| インデックスクローズ | 400 Bad Request | クローズされたインデックスに対するフラッシュ |
| 権限不足 | 403 Forbidden | フラッシュ権限がない場合 |

## 備考

- 本APIのstabilityは「stable」である
- GET/POST両メソッドで同一の処理が実行される
- `force`パラメータは内部的なパラメータであり、通常のユースケースでは使用しない
- `wait_if_ongoing`パラメータのデフォルトはtrueであり、並行フラッシュの完了を待機する
- リフレッシュ（No.79）はデータを検索可能にするが永続化は保証しない。フラッシュはディスクへの永続化（fsync）を保証する
- フラッシュはリフレッシュよりも重い操作であり、頻繁な手動実行は推奨されない
- OpenSearchは自動フラッシュを行うため、通常はメンテナンス時や計画停止前に手動実行する

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | FlushRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/flush/FlushRequest.java` | indices、force、waitIfOngoing、IndicesOptionsフィールドの構造を確認 |
| 1-2 | FlushResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/flush/FlushResponse.java` | _shardsフィールドの構造を確認 |

**読解のコツ**: `FlushRequest`は`BroadcastRequest`を継承しており、`force`と`waitIfOngoing`の2つの独自パラメータを持つ。これらのパラメータの意味と効果を理解することが重要。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestFlushAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestFlushAction.java` | 4つのルート定義、force/waitIfOngoingパラメータの処理を確認 |

**主要処理フロー**:
1. **行59-66**: `routes()`で4つのルート（GET/POST x `/_flush`/`/{index}/_flush`）を定義
2. **行77**: `FlushRequest`を構築、パスパラメータをカンマ区切り分割
3. **行78**: `IndicesOptions.fromRequest()`でインデックスオプションを設定
4. **行79**: `force`パラメータを`FlushRequest`に設定（デフォルトは`flushRequest.force()`の値を使用）
5. **行80**: `wait_if_ongoing`パラメータを設定（デフォルトは`flushRequest.waitIfOngoing()`の値を使用）
6. **行81**: `client.admin().indices().flush()`でTransport層に委譲

#### Step 3: Transport層の処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportFlushAction.java | `server/src/main/java/org/opensearch/action/admin/indices/flush/TransportFlushAction.java` | ブロードキャストアクションとしてのフラッシュ処理を確認 |

### プログラム呼び出し階層図

```
RestFlushAction.prepareRequest()
    |
    +-- FlushRequest(indices[])
    |       +-- IndicesOptions.fromRequest()
    |       +-- force (boolean)
    |       +-- waitIfOngoing (boolean)
    |
    +-- client.admin().indices().flush()
            |
            +-- TransportFlushAction
                    |
                    +-- 各シャードへのブロードキャスト
                    |       +-- InternalEngine.flush()
                    |               +-- Lucene IndexWriter.commit()
                    |               +-- Translog.trimUnreferencedReaders()
                    |
                    +-- FlushResponse
                            +-- _shards (total, successful, failed)
```

### データフロー図

```
[入力]                          [処理]                                    [出力]

POST/GET                    RestFlushAction                      FlushResponse
/_flush                       --> .prepareRequest()                {
/{index}/_flush                    |                                 "_shards": {
+ force                            v                                   "total": N,
+ wait_if_ongoing             TransportFlushAction                     "successful": N,
+ ignore_unavailable               |                                   "failed": 0
+ allow_no_indices                  +-- 各シャードフラッシュ             }
+ expand_wildcards                  |       +-- Luceneコミット        }
                                    |       +-- Translogクリア
                                    v
                               FlushResponse集約
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestFlushAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestFlushAction.java` | ソース | RESTエンドポイント定義・リクエスト処理 |
| FlushRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/flush/FlushRequest.java` | ソース | リクエストクラス |
| FlushResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/flush/FlushResponse.java` | ソース | レスポンスクラス |
| TransportFlushAction.java | `server/src/main/java/org/opensearch/action/admin/indices/flush/TransportFlushAction.java` | ソース | Transport層のフラッシュ処理実装 |
| IndicesOptions.java | `server/src/main/java/org/opensearch/action/support/IndicesOptions.java` | ソース | インデックスオプションの定義 |
| indices.flush.json | `rest-api-spec/src/main/resources/rest-api-spec/api/indices.flush.json` | API定義 | REST API仕様定義 |
