# 画面設計書 81-同期フラッシュ（非推奨）

## 概要

本ドキュメントは、OpenSearchの同期フラッシュ（Synced Flush）REST APIエンドポイントの画面設計書である。このAPIは非推奨であり、通常のフラッシュAPI（`indices.flush`）に統合されている。

### 本画面の処理概要

同期フラッシュは、インデックスの各シャード間でフラッシュの同期ポイントを設定し、シャードリカバリの高速化を実現するためのAPIであった。現在は非推奨APIとして位置付けられており、通常のフラッシュAPI（No.80 フラッシュ）と同一のAPI仕様ファイル `indices.flush.json` を共有している。

**業務上の目的・背景**：同期フラッシュは、シャードの再割り当て（リロケーション）やノード再起動後のリカバリ時間を短縮するために設計された。通常のフラッシュ操作では各シャードが個別にフラッシュを実行するが、同期フラッシュではすべてのシャードコピーが同じコミットポイントを共有することで、リカバリ時にファイルの差分コピーを最小化できた。しかし、OpenSearchでは通常のフラッシュ操作に同期フラッシュの機能が統合されたため、本APIは非推奨となった。

**画面へのアクセス方法**：HTTPクライアントから `POST /{index}/_flush` または `POST /_flush` エンドポイントへリクエストを送信する。同期フラッシュとしての独立したエンドポイントは存在せず、通常のフラッシュAPIと同一のエンドポイントを使用する。

**主要な操作・処理内容**：
1. フラッシュ対象のインデックスを指定してリクエストを送信する
2. トランザクションログのデータをLuceneインデックスにコミットする
3. フラッシュ完了後、各シャードの同期IDが付与される（内部的に自動実行）

**画面遷移**：インデックス作成（No.38）後のインデックス運用フローの一部として利用される。フラッシュ後はリフレッシュ（No.79）やリカバリ情報（No.84）の確認に遷移することがある。

**権限による表示制御**：インデックスの管理権限（`indices:admin/flush`）が必要である。権限がない場合は403エラーが返される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 118 | フラッシュ | 主機能 | 同期フラッシュ操作を実行する処理（非推奨API） |

## 画面種別

操作実行（APIエンドポイント）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| POST/GET | `/_flush` | 全インデックスに対してフラッシュを実行 |
| POST/GET | `/{index}/_flush` | 指定インデックスに対してフラッシュを実行 |

## 入出力項目

### パスパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|------|------|------|
| index | list | 任意 | カンマ区切りのインデックス名。`_all`または空文字で全インデックス対象 |

### クエリパラメータ

| パラメータ名 | 型 | デフォルト | 説明 |
|-------------|------|-----------|------|
| force | boolean | false | 変更がなくてもフラッシュを強制実行するか。トランザクションログIDのインクリメントに使用 |
| wait_if_ongoing | boolean | true | 別のフラッシュが実行中の場合にブロックして待機するか。falseの場合はスキップされる |
| ignore_unavailable | boolean | false | 利用不可のインデックスを無視するか |
| allow_no_indices | boolean | true | ワイルドカードが具体的なインデックスに解決されない場合に無視するか |
| expand_wildcards | enum | open | ワイルドカード展開の対象（open/closed/hidden/none/all） |

## 表示項目

### レスポンス

| フィールド | 型 | 説明 |
|-----------|------|------|
| _shards.total | integer | フラッシュ対象の総シャード数 |
| _shards.successful | integer | フラッシュ成功のシャード数 |
| _shards.failed | integer | フラッシュ失敗のシャード数 |

## イベント仕様

### 1-フラッシュ実行

クライアントがフラッシュリクエストを送信すると、`RestFlushAction.prepareRequest()`（56行目）で`FlushRequest`が構築され、`client.admin().indices().flush()`を通じてトランスポートアクションが実行される。各シャードでLuceneのコミットが行われ、トランザクションログがクリアされる。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| フラッシュ実行 | Lucene Index（各シャード） | COMMIT | トランザクションログの内容をLuceneセグメントにコミット |
| フラッシュ実行 | Translog | CLEAR | コミット済みのトランザクションログをクリア |

### テーブル別更新項目詳細

#### Lucene Index

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| COMMIT | セグメントファイル | トランザクションログの未コミットデータをセグメントに書き込み | フラッシュ操作により新しいコミットポイントが生成される |

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 発生条件 |
|-------------|------|-----------|---------|
| - | 成功 | `{"_shards":{"total":N,"successful":N,"failed":0}}` | フラッシュ正常完了 |
| - | エラー | `{"error":{"type":"index_not_found_exception",...}}` | 指定インデックスが存在しない |
| - | 警告 | 非推奨API使用の警告ヘッダ | 本APIは非推奨のため |

## 例外処理

| 例外 | HTTPステータス | 説明 |
|------|--------------|------|
| IndexNotFoundException | 404 | 指定したインデックスが存在しない場合 |
| ClusterBlockException | 403 | インデックスがブロックされている場合 |
| SecurityException | 403 | フラッシュ権限がない場合 |

## 備考

- 本APIは非推奨である。通常のフラッシュAPI（No.80）を使用すること。
- OpenSearchでは同期フラッシュの機能が通常フラッシュに統合されている。
- REST API仕様ファイルは通常フラッシュ（`indices.flush.json`）と共有している。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、フラッシュリクエスト・レスポンスのデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | indices.flush.json | `rest-api-spec/src/main/resources/rest-api-spec/api/indices.flush.json` | REST APIの仕様定義。パスパラメータとクエリパラメータの全量を把握する |
| 1-2 | FlushRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/flush/FlushRequest.java` | フラッシュリクエストのデータ構造。force, waitIfOngoing等のフィールドを確認 |

**読解のコツ**: `FlushRequest`は`BroadcastRequest`を継承しており、各シャードに対してブロードキャストされるリクエストパターンである。

#### Step 2: エントリーポイントを理解する

RESTリクエストを受け付けるハンドラクラスを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestFlushAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestFlushAction.java` | RESTリクエストのエントリーポイント。ルーティング定義とリクエスト構築ロジック |

**主要処理フロー**:
1. **59-68行目**: `routes()`メソッドで`GET/POST /_flush`と`GET/POST /{index}/_flush`の4つのルートを登録
2. **76-82行目**: `prepareRequest()`でリクエストパラメータを解析し`FlushRequest`を構築、`client.admin().indices().flush()`を呼び出し

#### Step 3: トランスポート層を理解する

フラッシュアクションの実行ロジックを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportFlushAction.java | `server/src/main/java/org/opensearch/action/admin/indices/flush/TransportFlushAction.java` | フラッシュアクションのトランスポート層実装 |

### プログラム呼び出し階層図

```
RestFlushAction.prepareRequest() [L76-82]
    |
    +-- FlushRequest() [リクエスト構築]
    |       +-- IndicesOptions.fromRequest() [インデックスオプション解析]
    |
    +-- client.admin().indices().flush()
            |
            +-- TransportFlushAction.execute()
                    |
                    +-- ShardFlushRequest [各シャードへブロードキャスト]
                            +-- Lucene IndexWriter.commit()
```

### データフロー図

```
[入力]                      [処理]                         [出力]

HTTP POST /{index}/_flush   RestFlushAction                FlushResponse
  +-- index (path)     ---> .prepareRequest() [L76]   ---> {_shards: {total,
  +-- force (query)         FlushRequest [構築]              successful, failed}}
  +-- wait_if_ongoing       TransportFlushAction
                            Lucene IndexWriter.commit()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| indices.flush.json | `rest-api-spec/src/main/resources/rest-api-spec/api/indices.flush.json` | API仕様 | REST APIの仕様定義 |
| RestFlushAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestFlushAction.java` | ソース | RESTハンドラ |
| FlushRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/flush/FlushRequest.java` | ソース | リクエストデータ構造 |
| TransportFlushAction.java | `server/src/main/java/org/opensearch/action/admin/indices/flush/TransportFlushAction.java` | ソース | トランスポートアクション |
