# 画面設計書 83-キャッシュクリア

## 概要

本ドキュメントは、OpenSearchのインデックスキャッシュクリア（Clear Cache）REST APIエンドポイントの画面設計書である。1つ以上のインデックスに対して、クエリキャッシュ・フィールドデータキャッシュ・リクエストキャッシュ・ファイルキャッシュを選択的にクリアするAPIである。

### 本画面の処理概要

キャッシュクリアAPIは、インデックスに蓄積された各種キャッシュを明示的にクリアするための操作を提供する。OpenSearchはクエリパフォーマンスの向上のために複数種類のキャッシュを利用しており、本APIにより特定のキャッシュまたは全キャッシュをクリアできる。

**業務上の目的・背景**：OpenSearchは検索パフォーマンス最適化のためにフィールドデータキャッシュ、クエリキャッシュ、リクエストキャッシュ、ファイルキャッシュなど複数のキャッシュを保持する。マッピング変更後やメモリ圧迫時など、これらのキャッシュを手動でクリアする必要がある場合がある。特にフィールドデータキャッシュはヒープメモリを大量に消費する可能性があるため、運用上キャッシュクリアは重要な管理操作である。

**画面へのアクセス方法**：HTTPクライアントから `POST /{index}/_cache/clear` または `POST /_cache/clear` エンドポイントへリクエストを送信する。

**主要な操作・処理内容**：
1. 全キャッシュをクリアする（パラメータ指定なし）
2. `fielddata=true`でフィールドデータキャッシュのみをクリアする
3. `query=true`でクエリキャッシュのみをクリアする
4. `request=true`でリクエストキャッシュのみをクリアする
5. `file=true`でファイルキャッシュのみをクリアする
6. `fields`パラメータで特定フィールドのフィールドデータキャッシュのみをクリアする

**画面遷移**：インデックス運用の一環として、マッピング更新（No.51）後やインデックス統計（No.87）の確認後に使用されることが多い。Cat Fielddata（No.150）でメモリ使用量を確認してからキャッシュクリアを実行する運用フローが一般的。

**権限による表示制御**：インデックスの管理権限が必要である。権限がない場合は403エラーが返される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 122 | キャッシュクリア | 主機能 | 1つ以上のインデックスのキャッシュをクリアする処理 |

## 画面種別

操作実行（APIエンドポイント）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| POST | `/_cache/clear` | 全インデックスのキャッシュをクリア |
| POST | `/{index}/_cache/clear` | 指定インデックスのキャッシュをクリア |

## 入出力項目

### パスパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|------|------|------|
| index | list | 任意 | カンマ区切りのインデックス名 |

### クエリパラメータ

| パラメータ名 | 型 | デフォルト | 説明 |
|-------------|------|-----------|------|
| fielddata | boolean | false | フィールドデータキャッシュをクリアするか |
| fields | list | all | fielddataパラメータ使用時にクリア対象のフィールドをカンマ区切りで指定 |
| query | boolean | false | クエリキャッシュをクリアするか |
| request | boolean | false | リクエストキャッシュをクリアするか |
| file | boolean | false | ファイルキャッシュをクリアするか |
| ignore_unavailable | boolean | false | 利用不可のインデックスを無視するか |
| allow_no_indices | boolean | true | ワイルドカードが具体的なインデックスに解決されない場合に無視するか |
| expand_wildcards | enum | open | ワイルドカード展開の対象（open/closed/hidden/none/all） |
| index | list | - | クリア対象インデックス名（クエリパラメータとしても指定可能） |

## 表示項目

### レスポンス

| フィールド | 型 | 説明 |
|-----------|------|------|
| _shards.total | integer | 対象の総シャード数 |
| _shards.successful | integer | キャッシュクリア成功のシャード数 |
| _shards.failed | integer | キャッシュクリア失敗のシャード数 |

## イベント仕様

### 1-キャッシュクリア実行

クライアントがリクエストを送信すると、`RestClearIndicesCacheAction.prepareRequest()`（68行目）で`ClearIndicesCacheRequest`が構築される。73行目の`fromRequest()`メソッドで各キャッシュ種別のフラグ（query, request, fielddata, file）が設定される。その後、`client.admin().indices().clearCache()`を通じてトランスポートアクションが実行される。

### 2-サーキットブレーカー制御

本アクションは`canTripCircuitBreaker()`が`false`を返す（78-80行目）ため、サーキットブレーカーをトリップさせない。キャッシュクリアはメモリを解放する操作であるため、メモリ圧迫時でも実行可能である。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| キャッシュクリア | インメモリキャッシュ | CLEAR | 指定されたキャッシュ種別のデータを解放 |

### テーブル別更新項目詳細

#### インメモリキャッシュ

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| CLEAR | Field Data Cache | 全エントリまたは指定フィールドのエントリを削除 | fieldsパラメータで対象フィールドを限定可能 |
| CLEAR | Query Cache | 全エントリを削除 | query=trueの場合 |
| CLEAR | Request Cache | 全エントリを削除 | request=trueの場合 |
| CLEAR | File Cache | 全エントリを削除 | file=trueの場合 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 発生条件 |
|-------------|------|-----------|---------|
| - | 成功 | `{"_shards":{"total":N,"successful":N,"failed":0}}` | キャッシュクリア正常完了 |
| - | エラー | `{"error":{"type":"index_not_found_exception",...}}` | 指定インデックスが存在しない |

## 例外処理

| 例外 | HTTPステータス | 説明 |
|------|--------------|------|
| IndexNotFoundException | 404 | 指定したインデックスが存在しない場合 |
| ClusterBlockException | 403 | インデックスがブロックされている場合 |

## 備考

- パラメータを何も指定しない場合、全種類のキャッシュがクリアされる。
- キャッシュクリア直後は検索パフォーマンスが一時的に低下する可能性がある。
- 本APIはサーキットブレーカーをトリップさせないため、メモリ圧迫時にも実行可能。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | indices.clear_cache.json | `rest-api-spec/src/main/resources/rest-api-spec/api/indices.clear_cache.json` | REST APIの仕様定義。fielddata, query, request, file等の全パラメータを把握 |
| 1-2 | ClearIndicesCacheRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/cache/clear/ClearIndicesCacheRequest.java` | リクエストデータ構造。各キャッシュフラグのフィールドを確認 |

**読解のコツ**: `ClearIndicesCacheRequest`は`BroadcastRequest`を継承し、全シャードに対してブロードキャストされる。各キャッシュフラグ（queryCache, requestCache, fieldDataCache, fileCache）の初期値に注意。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestClearIndicesCacheAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestClearIndicesCacheAction.java` | RESTハンドラ。fromRequest()メソッド（82-89行目）でキャッシュフラグの設定ロジックを確認 |

**主要処理フロー**:
1. **59行目**: `routes()`で`POST /_cache/clear`と`POST /{index}/_cache/clear`を登録
2. **68-75行目**: `prepareRequest()`でリクエスト構築と`clearCache()`呼び出し
3. **82-89行目**: `fromRequest()`で各キャッシュフラグ（query, request, fielddata, file, fields）をパラメータから設定
4. **78-80行目**: `canTripCircuitBreaker()`でfalseを返し、サーキットブレーカーをトリップさせない

### プログラム呼び出し階層図

```
RestClearIndicesCacheAction.prepareRequest() [L68-75]
    |
    +-- ClearIndicesCacheRequest() [リクエスト構築]
    |       +-- IndicesOptions.fromRequest()
    |
    +-- fromRequest() [L82-89]
    |       +-- queryCache(), requestCache(), fieldDataCache(), fileCache(), fields() 設定
    |
    +-- client.admin().indices().clearCache() [L74]
            |
            +-- TransportClearIndicesCacheAction.execute()
                    +-- 各ノードでキャッシュクリア実行
```

### データフロー図

```
[入力]                          [処理]                              [出力]

HTTP POST /{index}/_cache/clear RestClearIndicesCacheAction         ClearIndicesCacheResponse
  +-- index (path)         ---> .prepareRequest() [L68]        ---> {_shards: {total,
  +-- fielddata (query)         .fromRequest() [L82]                 successful, failed}}
  +-- query (query)             ClearIndicesCacheRequest [構築]
  +-- request (query)           TransportClearIndicesCacheAction
  +-- file (query)              各ノードのキャッシュマネージャ
  +-- fields (query)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| indices.clear_cache.json | `rest-api-spec/src/main/resources/rest-api-spec/api/indices.clear_cache.json` | API仕様 | REST APIの仕様定義 |
| RestClearIndicesCacheAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestClearIndicesCacheAction.java` | ソース | RESTハンドラ |
| ClearIndicesCacheRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/cache/clear/ClearIndicesCacheRequest.java` | ソース | リクエストデータ構造 |
| TransportClearIndicesCacheAction.java | `server/src/main/java/org/opensearch/action/admin/indices/cache/clear/TransportClearIndicesCacheAction.java` | ソース | トランスポートアクション |
| RestClearIndicesCacheActionTests.java | `server/src/test/java/org/opensearch/rest/action/admin/indices/RestClearIndicesCacheActionTests.java` | テスト | RESTハンドラのテスト |
