# 画面設計書 85-セグメント情報

## 概要

本ドキュメントは、OpenSearchのインデックスセグメント情報（Segments）REST APIエンドポイントの画面設計書である。Luceneインデックスの低レベルなセグメント情報を取得するAPIである。

### 本画面の処理概要

セグメント情報APIは、1つ以上のインデックスに対してLuceneセグメントの詳細情報を返す。セグメント数、ドキュメント数、サイズ、マージ状態などの低レベル情報を取得できる。

**業務上の目的・背景**：OpenSearchのインデックスはLuceneセグメントで構成されており、セグメントの断片化状況を把握することはパフォーマンスチューニングにおいて重要である。セグメント数が多すぎると検索パフォーマンスが低下し、メモリ消費も増大する。本APIにより、強制マージ（No.82）の実行判断や、インデックスの健全性評価を行うための基礎情報を取得できる。また、verbose=trueオプションでLuceneの詳細なメモリ使用量も確認可能である。

**画面へのアクセス方法**：HTTPクライアントから `GET /{index}/_segments` または `GET /_segments` エンドポイントへリクエストを送信する。

**主要な操作・処理内容**：
1. 全インデックスまたは特定インデックスのセグメント情報を取得する
2. `verbose=true`でLuceneの詳細なメモリ使用量情報を含める

**画面遷移**：強制マージ（No.82）の実行前後にセグメント数の確認に使用される。Cat セグメント（No.160）はテーブル形式の簡潔な表示を提供する。インデックス統計（No.87）と組み合わせて総合的なインデックス状態を把握する。

**権限による表示制御**：インデックスの監視権限が必要である。権限がない場合は403エラーが返される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 121 | セグメント情報 | 主機能 | Luceneインデックスのセグメント情報を返す処理 |

## 画面種別

情報取得（APIエンドポイント）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_segments` | 全インデックスのセグメント情報を取得 |
| GET | `/{index}/_segments` | 指定インデックスのセグメント情報を取得 |

## 入出力項目

### パスパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|------|------|------|
| index | list | 任意 | カンマ区切りのインデックス名。`_all`または空文字で全インデックス対象 |

### クエリパラメータ

| パラメータ名 | 型 | デフォルト | 説明 |
|-------------|------|-----------|------|
| verbose | boolean | false | Luceneの詳細なメモリ使用量を含めるか |
| ignore_unavailable | boolean | false | 利用不可のインデックスを無視するか |
| allow_no_indices | boolean | true | ワイルドカードが具体的なインデックスに解決されない場合に無視するか |
| expand_wildcards | enum | open | ワイルドカード展開の対象（open/closed/hidden/none/all） |

## 表示項目

### レスポンス

| フィールド | 型 | 説明 |
|-----------|------|------|
| _shards.total | integer | 対象の総シャード数 |
| _shards.successful | integer | 成功のシャード数 |
| _shards.failed | integer | 失敗のシャード数 |
| indices.{index}.shards.{shard_id}[].routing | object | シャードルーティング情報 |
| indices.{index}.shards.{shard_id}[].num_committed_segments | integer | コミット済みセグメント数 |
| indices.{index}.shards.{shard_id}[].num_search_segments | integer | 検索可能セグメント数 |
| indices.{index}.shards.{shard_id}[].segments.{segment_name} | object | 各セグメントの詳細情報 |
| segments.{segment_name}.generation | long | セグメント世代番号 |
| segments.{segment_name}.num_docs | long | セグメント内のドキュメント数 |
| segments.{segment_name}.deleted_docs | long | 削除済みドキュメント数 |
| segments.{segment_name}.size_in_bytes | long | セグメントサイズ（バイト） |
| segments.{segment_name}.committed | boolean | コミット済みかどうか |
| segments.{segment_name}.search | boolean | 検索可能かどうか |
| segments.{segment_name}.version | string | Luceneバージョン |
| segments.{segment_name}.compound | boolean | 複合ファイル形式かどうか |

## イベント仕様

### 1-セグメント情報取得

クライアントがリクエストを送信すると、`RestIndicesSegmentsAction.prepareRequest()`（68行目）で`IndicesSegmentsRequest`が構築される。`verbose`パラメータが設定され（72行目）、`client.admin().indices().segments()`を通じてトランスポートアクションが実行される。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| セグメント情報取得 | - | SELECT | 読み取り専用。データ更新なし |

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 発生条件 |
|-------------|------|-----------|---------|
| - | 成功 | `{"_shards":{...},"indices":{...}}` | セグメント情報正常取得 |
| - | エラー | `{"error":{"type":"index_not_found_exception",...}}` | 指定インデックスが存在しない |

## 例外処理

| 例外 | HTTPステータス | 説明 |
|------|--------------|------|
| IndexNotFoundException | 404 | 指定したインデックスが存在しない場合 |

## 備考

- `verbose=true`は詳細なメモリ使用量情報を含むため、多数のセグメントを持つインデックスではレスポンスサイズが大きくなる。
- セグメント数が多い場合は強制マージ（No.82）の実行を検討すること。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | indices.segments.json | `rest-api-spec/src/main/resources/rest-api-spec/api/indices.segments.json` | REST APIの仕様定義。verboseパラメータを把握 |
| 1-2 | IndicesSegmentsRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/segments/IndicesSegmentsRequest.java` | リクエストデータ構造 |

**読解のコツ**: `IndicesSegmentsRequest`は`BroadcastRequest`を継承している。verboseフラグにより詳細なメモリ情報が付加される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestIndicesSegmentsAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestIndicesSegmentsAction.java` | RESTハンドラ。シンプルなリクエスト構築ロジック |

**主要処理フロー**:
1. **59行目**: `routes()`で`GET /_segments`と`GET /{index}/_segments`を登録
2. **68-75行目**: `prepareRequest()`でIndicesSegmentsRequestを構築
3. **72行目**: `verbose`パラメータを設定
4. **74行目**: `client.admin().indices().segments()`で実行

### プログラム呼び出し階層図

```
RestIndicesSegmentsAction.prepareRequest() [L68-75]
    |
    +-- IndicesSegmentsRequest() [リクエスト構築]
    |       +-- verbose(false) [L72]
    |       +-- IndicesOptions.fromRequest() [L73]
    |
    +-- client.admin().indices().segments() [L74]
            |
            +-- TransportIndicesSegmentsAction.execute()
                    +-- 各ノードからセグメント情報を収集
```

### データフロー図

```
[入力]                       [処理]                            [出力]

HTTP GET /{index}/_segments  RestIndicesSegmentsAction         IndicesSegmentResponse
  +-- index (path)      ---> .prepareRequest() [L68]      ---> {_shards: {...},
  +-- verbose (query)        IndicesSegmentsRequest [構築]       indices: {...}}
                             TransportIndicesSegmentsAction
                             各ノードのLuceneセグメント情報収集
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| indices.segments.json | `rest-api-spec/src/main/resources/rest-api-spec/api/indices.segments.json` | API仕様 | REST APIの仕様定義 |
| RestIndicesSegmentsAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestIndicesSegmentsAction.java` | ソース | RESTハンドラ |
| IndicesSegmentsRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/segments/IndicesSegmentsRequest.java` | ソース | リクエストデータ構造 |
| TransportIndicesSegmentsAction.java | `server/src/main/java/org/opensearch/action/admin/indices/segments/TransportIndicesSegmentsAction.java` | ソース | トランスポートアクション |
