# 画面設計書 86-シャードストア情報

## 概要

本ドキュメントは、OpenSearchのシャードストア情報（Shard Stores）REST APIエンドポイントの画面設計書である。インデックスのシャードコピーに関するストア情報を取得するAPIである。

### 本画面の処理概要

シャードストア情報APIは、インデックスのシャードコピーがどのノードに格納されているか、各コピーのアロケーション状態やストアの例外情報を返す。シャードの割り当て状況や障害診断に使用される。

**業務上の目的・背景**：クラスタ内でシャードが正常に割り当てられない場合（unassigned状態）、その原因を特定するために各シャードコピーのストア情報を確認する必要がある。ノード障害やディスク障害が発生した際に、どのノードにシャードデータが残存しているかを把握し、手動でのシャード再割り当て（クラスタ再ルーティング No.96）やデータ復旧の判断材料とする。また、statusパラメータでgreen/yellow/redのフィルタリングが可能であり、問題のあるシャードに絞り込んだ調査が可能である。

**画面へのアクセス方法**：HTTPクライアントから `GET /{index}/_shard_stores` または `GET /_shard_stores` エンドポイントへリクエストを送信する。

**主要な操作・処理内容**：
1. 全インデックスまたは特定インデックスのシャードストア情報を取得する
2. `status`パラメータでシャードのヘルス状態（green/yellow/red/all）によるフィルタリングを行う

**画面遷移**：クラスタヘルス（No.90）でyellow/redを検出した場合にシャードストア情報を確認する。アロケーション説明（No.95）と組み合わせてシャード割り当て問題を診断する。Cat シャード（No.161）でシャードの概要を確認した後、詳細調査として本APIを使用する。

**権限による表示制御**：インデックスの監視権限が必要である。本APIは`allowSystemIndexAccessByDefault()`が`true`を返すため、システムインデックスへのアクセスがデフォルトで許可されている。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 56 | シャードアロケーション | 主機能 | シャードコピーのストア情報を返す処理 |

## 画面種別

情報取得（APIエンドポイント）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_shard_stores` | 全インデックスのシャードストア情報を取得 |
| GET | `/{index}/_shard_stores` | 指定インデックスのシャードストア情報を取得 |

## 入出力項目

### パスパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|------|------|------|
| index | list | 任意 | カンマ区切りのインデックス名 |

### クエリパラメータ

| パラメータ名 | 型 | デフォルト | 説明 |
|-------------|------|-----------|------|
| status | list | - | フィルタ対象のシャードステータス（green/yellow/red/all） |
| ignore_unavailable | boolean | false | 利用不可のインデックスを無視するか |
| allow_no_indices | boolean | true | ワイルドカードが具体的なインデックスに解決されない場合に無視するか |
| expand_wildcards | enum | open | ワイルドカード展開の対象（open/closed/hidden/none/all） |

## 表示項目

### レスポンス

| フィールド | 型 | 説明 |
|-----------|------|------|
| indices.{index}.shards.{shard_id}.stores[] | array | シャードストア情報の配列 |
| stores[].allocation_id | string | アロケーションID |
| stores[].allocation | string | アロケーション状態（primary/replica/unused） |
| stores[].store_exception | object | ストアの例外情報（存在する場合） |
| stores[].{node_id} | object | ノード情報 |

## イベント仕様

### 1-シャードストア情報取得

クライアントがリクエストを送信すると、`RestIndicesShardStoresAction.prepareRequest()`（79行目）で`IndicesShardStoresRequest`が構築される。`status`パラメータがある場合は83-85行目でシャードステータスフィルタが設定される。レスポンスは`RestBuilderListener`を使用してカスタムXContent形式で構築される（87-98行目）。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| シャードストア情報取得 | - | SELECT | 読み取り専用。データ更新なし |

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 発生条件 |
|-------------|------|-----------|---------|
| - | 成功 | `{"indices":{...}}` | シャードストア情報正常取得 |
| - | エラー | `{"error":{"type":"index_not_found_exception",...}}` | 指定インデックスが存在しない |

## 例外処理

| 例外 | HTTPステータス | 説明 |
|------|--------------|------|
| IndexNotFoundException | 404 | 指定したインデックスが存在しない場合 |

## 備考

- `status`パラメータを指定しない場合、すべてのステータスのシャード情報が返される。
- `store_exception`フィールドはストア破損が発生している場合にのみ含まれる。
- システムインデックスへのアクセスがデフォルトで許可されている。
- レスポンス構築に`RestBuilderListener`を使用する（`RestToXContentListener`ではない）点が他のAPIとの相違点。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | indices.shard_stores.json | `rest-api-spec/src/main/resources/rest-api-spec/api/indices.shard_stores.json` | REST APIの仕様定義。statusパラメータの選択肢を把握 |
| 1-2 | IndicesShardStoresRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/shards/IndicesShardStoresRequest.java` | リクエストデータ構造。shardStatusesフィールドを確認 |
| 1-3 | IndicesShardStoresResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/shards/IndicesShardStoresResponse.java` | レスポンスデータ構造。toXContent()でレスポンス形式を確認 |

**読解のコツ**: `IndicesShardStoresResponse`のtoXContent()メソッドでレスポンスのJSON構造を理解できる。`RestBuilderListener`を使用したカスタムレスポンス構築パターンに注意。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestIndicesShardStoresAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestIndicesShardStoresAction.java` | RESTハンドラ。RestBuilderListenerを使用したカスタムレスポンス構築 |

**主要処理フロー**:
1. **65行目**: `routes()`で`GET /_shard_stores`と`GET /{index}/_shard_stores`を登録
2. **74-76行目**: `allowSystemIndexAccessByDefault()`がtrueを返す
3. **79-86行目**: `prepareRequest()`でリクエスト構築。statusパラメータがある場合のフィルタ設定
4. **87-98行目**: `RestBuilderListener`でカスタムレスポンス構築。`response.toXContent()`を呼び出し

### プログラム呼び出し階層図

```
RestIndicesShardStoresAction.prepareRequest() [L79-98]
    |
    +-- IndicesShardStoresRequest() [リクエスト構築]
    |       +-- shardStatuses() [L84] (statusパラメータ存在時)
    |       +-- IndicesOptions.fromRequest() [L86]
    |
    +-- client.admin().indices().shardStores() [L87-88]
            |
            +-- IndicesShardStoresAction.execute()
            |
            +-- RestBuilderListener<IndicesShardStoresResponse> [L89]
                    +-- buildResponse() [L91-96]
                            +-- response.toXContent()
```

### データフロー図

```
[入力]                            [処理]                              [出力]

HTTP GET /{index}/_shard_stores   RestIndicesShardStoresAction        IndicesShardStoresResponse
  +-- index (path)           ---> .prepareRequest() [L79]        ---> {indices: {
  +-- status (query)              IndicesShardStoresRequest [構築]       "{index}": {
                                  IndicesShardStoresAction                 shards: {...}
                                  RestBuilderListener [レスポンス構築]    }}}
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| indices.shard_stores.json | `rest-api-spec/src/main/resources/rest-api-spec/api/indices.shard_stores.json` | API仕様 | REST APIの仕様定義 |
| RestIndicesShardStoresAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestIndicesShardStoresAction.java` | ソース | RESTハンドラ |
| IndicesShardStoresRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/shards/IndicesShardStoresRequest.java` | ソース | リクエストデータ構造 |
| IndicesShardStoresResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/shards/IndicesShardStoresResponse.java` | ソース | レスポンスデータ構造 |
| IndicesShardStoresAction.java | `server/src/main/java/org/opensearch/action/admin/indices/shards/IndicesShardStoresAction.java` | ソース | アクション定義 |
