# 画面設計書 87-インデックス統計

## 概要

本ドキュメントは、OpenSearchのインデックス統計（Index Stats）REST APIエンドポイントの画面設計書である。インデックスに対する各種操作の統計情報を取得するAPIである。

### 本画面の処理概要

インデックス統計APIは、インデックスに対して行われた各種操作（検索、インデキシング、マージ、フラッシュ等）の統計情報を返す。メトリクスを選択的に取得でき、集計レベル（クラスタ/インデックス/シャード）も指定可能である。

**業務上の目的・背景**：クラスタの運用監視およびパフォーマンスチューニングにおいて、インデックスレベルの統計情報は最も基本的な指標である。ドキュメント数、ストアサイズ、検索回数、インデキシング回数、マージ回数、キャッシュヒット率など、インデックスの健全性とパフォーマンスを評価するための包括的な統計を提供する。本APIは監視ツール（Prometheus、Grafana等）からの定期的なポーリング対象としても重要であり、異常検知やキャパシティプランニングの基盤データとなる。

**画面へのアクセス方法**：HTTPクライアントから `GET /{index}/_stats` または `GET /_stats` エンドポイントへリクエストを送信する。特定メトリクスのみを取得する場合は `GET /{index}/_stats/{metric}` を使用する。

**主要な操作・処理内容**：
1. 全メトリクスまたは特定メトリクス（docs, store, indexing, search, merge等）の統計情報を取得する
2. `level`パラメータで集計レベル（cluster/indices/shards）を指定する
3. `fields`パラメータでフィールドデータやcompletion統計の対象フィールドを指定する
4. `groups`パラメータで検索グループ別の統計を取得する
5. `include_segment_file_sizes`でセグメントファイルサイズの詳細を含める

**画面遷移**：Cat インデックス（No.152）はテーブル形式で統計の概要を返す。データストリーム統計（No.78）はデータストリーム配下のインデックス統計を提供する。セグメント情報（No.85）と組み合わせて総合的なインデックス分析を行う。

**権限による表示制御**：インデックスの監視権限が必要である。本APIは`allowSystemIndexAccessByDefault()`が`true`を返すため、システムインデックスへのアクセスがデフォルトで許可されている。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 105 | インデックス統計 | 主機能 | インデックスの操作統計（ドキュメント数、ストアサイズ等）を提供する処理 |

## 画面種別

情報取得（APIエンドポイント）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_stats` | 全インデックスの全メトリクスを取得 |
| GET | `/_stats/{metric}` | 全インデックスの指定メトリクスを取得 |
| GET | `/{index}/_stats` | 指定インデックスの全メトリクスを取得 |
| GET | `/{index}/_stats/{metric}` | 指定インデックスの指定メトリクスを取得 |

## 入出力項目

### パスパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|------|------|------|
| index | list | 任意 | カンマ区切りのインデックス名。`_all`または空文字で全インデックス対象 |
| metric | list | 任意 | 取得するメトリクス（_all/completion/docs/fielddata/query_cache/flush/get/indexing/merge/request_cache/refresh/search/segments/store/warmer/suggest） |

### クエリパラメータ

| パラメータ名 | 型 | デフォルト | 説明 |
|-------------|------|-----------|------|
| level | enum | indices | 統計の集計レベル（cluster/indices/shards） |
| completion_fields | list | - | completionメトリクスの対象フィールド（ワイルドカード対応） |
| fielddata_fields | list | - | fielddataメトリクスの対象フィールド（ワイルドカード対応） |
| fields | list | - | fielddataおよびcompletionの対象フィールド（ワイルドカード対応） |
| groups | list | - | 検索グループ別統計の対象グループ |
| include_segment_file_sizes | boolean | false | Luceneセグメントファイルのディスク使用量を含めるか |
| include_unloaded_segments | boolean | false | メモリにロードされていないセグメントの統計も含めるか |
| expand_wildcards | enum | open | ワイルドカード展開の対象（open/closed/hidden/none/all） |
| forbid_closed_indices | boolean | true | クローズされたインデックスの統計収集を禁止するか |

## 表示項目

### レスポンス

| フィールド | 型 | 説明 |
|-----------|------|------|
| _shards.total | integer | 対象の総シャード数 |
| _shards.successful | integer | 成功のシャード数 |
| _all.primaries | object | 全インデックスのプライマリシャード統計 |
| _all.total | object | 全インデックスの全シャード統計 |
| indices.{index}.primaries | object | 個別インデックスのプライマリシャード統計 |
| indices.{index}.total | object | 個別インデックスの全シャード統計 |
| primaries/total.docs.count | long | ドキュメント数 |
| primaries/total.docs.deleted | long | 削除済みドキュメント数 |
| primaries/total.store.size_in_bytes | long | ストアサイズ（バイト） |
| primaries/total.indexing | object | インデキシング統計 |
| primaries/total.search | object | 検索統計 |
| primaries/total.merge | object | マージ統計 |
| primaries/total.refresh | object | リフレッシュ統計 |
| primaries/total.flush | object | フラッシュ統計 |
| primaries/total.query_cache | object | クエリキャッシュ統計 |
| primaries/total.fielddata | object | フィールドデータ統計 |
| primaries/total.segments | object | セグメント統計 |

## イベント仕様

### 1-インデックス統計取得

クライアントがリクエストを送信すると、`RestIndicesStatsAction.prepareRequest()`（99行目）で`IndicesStatsRequest`が構築される。metricパラメータに基づいて`METRICS`マップ（88-96行目）からフラグが設定される。`_all`指定時は全メトリクスが有効化され（113-114行目）、個別指定時は`clear()`後に選択的にフラグを設定する（125-140行目）。

### 2-サーキットブレーカー制御

本アクションは`canTripCircuitBreaker()`が`false`を返す（167-169行目）ため、サーキットブレーカーをトリップさせない。統計情報の取得はモニタリング用途であり、メモリ圧迫時でも実行可能である。

### 3-レスポンスレベル制御

`level`パラメータは`responseParams()`（174-176行目）で定義されており、レスポンスの集計レベルを制御する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| インデックス統計取得 | - | SELECT | 読み取り専用。データ更新なし |

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 発生条件 |
|-------------|------|-----------|---------|
| - | 成功 | `{"_shards":{...},"_all":{...},"indices":{...}}` | 統計情報正常取得 |
| - | エラー | `_allと個別メトリクスの同時指定エラー` | metricに_allと個別メトリクスを同時に指定した場合 |
| - | エラー | 認識されないメトリクス名のエラー | 無効なメトリクス名が指定された場合 |

## 例外処理

| 例外 | HTTPステータス | 説明 |
|------|--------------|------|
| IllegalArgumentException | 400 | _allと個別メトリクスの同時指定、または認識されないメトリクス名 |
| IndexNotFoundException | 404 | 指定したインデックスが存在しない場合 |

## 備考

- `_all`と個別メトリクスを同時に指定するとエラーとなる。
- `forbid_closed_indices=false`を指定するとクローズされたインデックスの統計も収集される。
- メトリクス名はCommonStatsFlags.Flag列挙値のrestNameに基づく。
- 本APIはサーキットブレーカーをトリップさせないため、メモリ圧迫時にも実行可能。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | indices.stats.json | `rest-api-spec/src/main/resources/rest-api-spec/api/indices.stats.json` | REST APIの仕様定義。metricの選択肢一覧とパスパターンを把握 |
| 1-2 | CommonStatsFlags.java | `server/src/main/java/org/opensearch/action/admin/indices/stats/CommonStatsFlags.java` | Flag列挙値。各メトリクスのフラグ定義とrestNameの対応を確認 |
| 1-3 | IndicesStatsRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/stats/IndicesStatsRequest.java` | リクエストデータ構造。フラグとフィールド指定の関係を確認 |

**読解のコツ**: `CommonStatsFlags.Flag`列挙値が全メトリクスの定義元であり、`RestIndicesStatsAction`の`METRICS`マップ（88-96行目）で各Flag値に対応するコンシューマが動的に構築される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestIndicesStatsAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestIndicesStatsAction.java` | RESTハンドラ。METRICSマップの初期化（88-96行目）とメトリクス解析ロジック（111-140行目）が核心 |

**主要処理フロー**:
1. **67-76行目**: `routes()`で4つのGETルートを登録（全体/メトリクス指定/インデックス指定/両方指定）
2. **88-96行目**: `METRICS`マップの静的初期化。CommonStatsFlags.Flag.values()から動的にマップを構築
3. **99-163行目**: `prepareRequest()`でリクエスト構築。metricsパラメータの解析とバリデーション
4. **111-140行目**: `_all`指定、`_all`+個別の同時指定エラー、個別メトリクスの設定、無効メトリクスの検出
5. **146-161行目**: completion/fielddata/segmentsのサブフィールド設定

### プログラム呼び出し階層図

```
RestIndicesStatsAction.prepareRequest() [L99-163]
    |
    +-- IndicesStatsRequest() [リクエスト構築]
    |       +-- timeout() [L101]
    |       +-- indicesOptions() [L108]
    |       +-- indices() [L109]
    |
    +-- metrics解析 [L111-140]
    |       +-- "_all" -> indicesStatsRequest.all() [L114]
    |       +-- "_all" + 個別 -> IllegalArgumentException [L116-123]
    |       +-- 個別 -> METRICS.get(metric).accept() [L128-131]
    |       +-- 無効 -> IllegalArgumentException [L137-139]
    |
    +-- サブフィールド設定 [L142-161]
    |       +-- groups() [L143]
    |       +-- completionFields() [L146-150]
    |       +-- fieldDataFields() [L152-156]
    |       +-- includeSegmentFileSizes() [L159]
    |       +-- includeUnloadedSegments() [L160]
    |
    +-- client.admin().indices().stats() [L163]
```

### データフロー図

```
[入力]                              [処理]                           [出力]

HTTP GET /{index}/_stats/{metric}   RestIndicesStatsAction           IndicesStatsResponse
  +-- index (path)             ---> .prepareRequest() [L99]     ---> {_shards: {...},
  +-- metric (path)                 METRICS解析 [L111-140]            _all: {primaries,
  +-- level (query)                 IndicesStatsRequest [構築]         total},
  +-- fields (query)                TransportIndicesStatsAction        indices: {...}}
  +-- groups (query)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| indices.stats.json | `rest-api-spec/src/main/resources/rest-api-spec/api/indices.stats.json` | API仕様 | REST APIの仕様定義 |
| RestIndicesStatsAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestIndicesStatsAction.java` | ソース | RESTハンドラ（メトリクス解析ロジック） |
| IndicesStatsRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/stats/IndicesStatsRequest.java` | ソース | リクエストデータ構造 |
| CommonStatsFlags.java | `server/src/main/java/org/opensearch/action/admin/indices/stats/CommonStatsFlags.java` | ソース | メトリクスフラグ定義 |
| TransportIndicesStatsAction.java | `server/src/main/java/org/opensearch/action/admin/indices/stats/TransportIndicesStatsAction.java` | ソース | トランスポートアクション |
| RestIndicesStatsActionTests.java | `server/src/test/java/org/opensearch/rest/action/admin/indices/RestIndicesStatsActionTests.java` | テスト | RESTハンドラのテスト |
