# 画面設計書 88-アップグレード（非推奨）

## 概要

本ドキュメントは、OpenSearchのインデックスアップグレード（Upgrade）REST APIエンドポイントの画面設計書である。本APIは非推奨であり、将来のバージョンで削除される予定である。

### 本画面の処理概要

アップグレードAPIは、インデックスのLuceneセグメントを最新のLuceneフォーマットにアップグレードするためのAPIであった。古いバージョンのLuceneで作成されたセグメントを新しいフォーマットに変換する目的で使用されていた。

**業務上の目的・背景**：Elasticsearchからの移行期において、古いバージョンで作成されたインデックスのLuceneセグメントを新しいフォーマットにアップグレードする必要があった。しかし、OpenSearchでは本APIは既に有用ではなくなっており、将来のバージョンで削除される予定である。REST API仕様においても「The _upgrade API is no longer useful and will be removed」と明記されている。

**画面へのアクセス方法**：HTTPクライアントから `POST /{index}/_upgrade` または `POST /_upgrade` エンドポイントへリクエストを送信する。

**主要な操作・処理内容**：
1. 指定インデックスのLuceneセグメントをアップグレードする
2. `only_ancient_segments=true`で古いLuceneメジャーリリースのセグメントのみをアップグレードする
3. `wait_for_completion`でリクエストのブロッキング動作を制御する

**画面遷移**：アップグレードステータス（No.89）で進捗を確認する。

**権限による表示制御**：インデックスの管理権限が必要である。権限がない場合は403エラーが返される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | インデックス作成 | 主機能 | インデックスアップグレード処理（非推奨API） |

## 画面種別

操作実行（APIエンドポイント）-- 非推奨

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| POST | `/_upgrade` | 全インデックスに対してアップグレードを実行 |
| POST | `/{index}/_upgrade` | 指定インデックスに対してアップグレードを実行 |

## 入出力項目

### パスパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|------|------|------|
| index | list | 任意 | カンマ区切りのインデックス名。`_all`または空文字で全インデックス対象 |

### クエリパラメータ

| パラメータ名 | 型 | デフォルト | 説明 |
|-------------|------|-----------|------|
| allow_no_indices | boolean | true | ワイルドカードが具体的なインデックスに解決されない場合に無視するか |
| expand_wildcards | enum | open | ワイルドカード展開の対象（open/closed/hidden/none/all） |
| ignore_unavailable | boolean | false | 利用不可のインデックスを無視するか |
| wait_for_completion | boolean | false | すべてのセグメントのアップグレードが完了するまでブロックするか |
| only_ancient_segments | boolean | false | 古いLuceneメジャーリリースのセグメントのみをアップグレードするか |

## 表示項目

### レスポンス

| フィールド | 型 | 説明 |
|-----------|------|------|
| _shards.total | integer | 対象の総シャード数 |
| _shards.successful | integer | アップグレード成功のシャード数 |
| _shards.failed | integer | アップグレード失敗のシャード数 |

## イベント仕様

### 1-アップグレード実行

クライアントがリクエストを送信すると、`RestUpgradeAction.prepareRequest()`（68行目）で`UpgradeRequest`が構築される。`only_ancient_segments`パラメータが設定され（71行目）、`client.admin().indices().upgrade()`を通じてトランスポートアクションが実行される。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| アップグレード実行 | Lucene Segments | UPDATE | セグメントフォーマットの変換・再書き込み |

### テーブル別更新項目詳細

#### Lucene Segments

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| UPDATE | セグメントファイル | 古いLuceneフォーマットのセグメントを新フォーマットに変換 | 非推奨操作 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 発生条件 |
|-------------|------|-----------|---------|
| - | 成功 | `{"_shards":{"total":N,"successful":N,"failed":0}}` | アップグレード正常完了 |
| - | 警告 | 非推奨API使用の警告 | 本APIは非推奨のため |
| - | エラー | `{"error":{"type":"index_not_found_exception",...}}` | 指定インデックスが存在しない |

## 例外処理

| 例外 | HTTPステータス | 説明 |
|------|--------------|------|
| IndexNotFoundException | 404 | 指定したインデックスが存在しない場合 |
| ClusterBlockException | 403 | インデックスがブロックされている場合 |

## 備考

- 本APIは非推奨であり、将来のバージョンで削除される予定である。
- REST API仕様に「The _upgrade API is no longer useful and will be removed」と明記されている。
- 通常のOpenSearch運用では本APIを使用する必要はない。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | indices.upgrade.json | `rest-api-spec/src/main/resources/rest-api-spec/api/indices.upgrade.json` | REST APIの仕様定義。非推奨であることがdescriptionに明記されている |
| 1-2 | UpgradeRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/upgrade/post/UpgradeRequest.java` | リクエストデータ構造 |

**読解のコツ**: `UpgradeRequest`は`BroadcastRequest`を継承している。`upgradeOnlyAncientSegments`フラグに注目。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestUpgradeAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestUpgradeAction.java` | RESTハンドラ。シンプルなリクエスト構築 |

**主要処理フロー**:
1. **59行目**: `routes()`で`POST /_upgrade`と`POST /{index}/_upgrade`を登録
2. **68-73行目**: `prepareRequest()`でUpgradeRequestを構築
3. **71行目**: `upgradeOnlyAncientSegments`パラメータを設定
4. **72行目**: `client.admin().indices().upgrade()`で実行

### プログラム呼び出し階層図

```
RestUpgradeAction.prepareRequest() [L68-73]
    |
    +-- UpgradeRequest() [リクエスト構築]
    |       +-- IndicesOptions.fromRequest() [L70]
    |       +-- upgradeOnlyAncientSegments(false) [L71]
    |
    +-- client.admin().indices().upgrade() [L72]
            |
            +-- TransportUpgradeAction.execute()
```

### データフロー図

```
[入力]                        [処理]                        [出力]

HTTP POST /{index}/_upgrade   RestUpgradeAction             UpgradeResponse
  +-- index (path)       ---> .prepareRequest() [L68]  ---> {_shards: {total,
  +-- only_ancient_segments   UpgradeRequest [構築]           successful, failed}}
                              TransportUpgradeAction
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| indices.upgrade.json | `rest-api-spec/src/main/resources/rest-api-spec/api/indices.upgrade.json` | API仕様 | REST APIの仕様定義（非推奨） |
| RestUpgradeAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestUpgradeAction.java` | ソース | RESTハンドラ |
| UpgradeRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/upgrade/post/UpgradeRequest.java` | ソース | リクエストデータ構造 |
